/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.ProvidesSearchTags;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.FormatBundle;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.preferences.AuditPreferences;
import oracle.jdevimpl.audit.profile.ProfileComboBox;
import oracle.jdevimpl.audit.profile.ProfileModel;

public class AuditPreferencesPanel
implements ActionListener,
ListSelectionListener,
Traversable,
ProvidesSearchTags {
    private ProfileModel profiles;
    private JComponent component;
    private AuditPreferences copy;
    private JCheckBox auditDuringCompile;
    private JLabel compileProfileLabel;
    private JComboBox compileProfile;
    private JCheckBox auditWhileEditing;
    private JCheckBox showCodeAssistanceInGutter;
    private JLabel editorDelayLabel;
    private NumberTextField editorDelay;
    private JLabel editorDelayUnits;
    private JLabel maximumFileSizeLabel;
    private NumberTextField maximumFileSize;
    private JLabel maximumFileSizeUnits;
    private JLabel editorProfileLabel;
    private JComboBox editorProfile;
    private static final FormatBundle bundle = new FormatBundle(AuditBundle.class);

    public AuditPreferencesPanel(ProfileModel profiles) {
        this.profiles = profiles;
    }

    public Component getComponent() {
        this.createComponents();
        return this.component;
    }

    private void createComponents() {
        if (this.component != null) {
            return;
        }
        this.component = new JPanel(new GridBagLayout());
        this.component.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.auditWhileEditing = new JCheckBox(bundle.get("preferences.audit-while-editing.label"), this.copy.isAuditWhileEditing());
        this.auditWhileEditing.setMnemonic(bundle.get("preferences.audit-while-editing.mnemonic").charAt(0));
        this.auditWhileEditing.setToolTipText(bundle.get("preferences.audit-while-editing.tip"));
        this.showCodeAssistanceInGutter = new JCheckBox(bundle.get("preferences.show-code-assistance-in-gutter.label"), this.copy.isShowCodeAssistanceInGutter());
        this.showCodeAssistanceInGutter.setMnemonic(bundle.get("preferences.show-code-assistance-in-gutter.mnemonic").charAt(0));
        this.showCodeAssistanceInGutter.setToolTipText(bundle.get("preferences.show-code-assistance-in-gutter.tip"));
        String editorProfileTip = bundle.get("preferences.editor-profile.tip");
        this.editorProfileLabel = new JLabel(bundle.get("preferences.editor-profile.label"));
        this.editorProfileLabel.setDisplayedMnemonic(bundle.get("preferences.editor-profile.mnemonic").charAt(0));
        this.editorProfileLabel.setToolTipText(editorProfileTip);
        this.editorProfile = new ProfileComboBox((ComboBoxModel)new DelegatingComboBoxModel(this.profiles));
        Profile profile = this.profiles.getProfile(this.copy.getAssistProfile(), "code-assist-rules");
        this.editorProfile.setSelectedItem(profile);
        this.editorProfile.setToolTipText(editorProfileTip);
        this.editorProfileLabel.setLabelFor(this.editorProfile);
        String editorDelayTip = bundle.get("preferences.editor-delay.tip");
        this.editorDelayLabel = new JLabel(bundle.get("preferences.editor-delay.label"));
        this.editorDelayLabel.setToolTipText(editorDelayTip);
        this.editorDelayLabel.setDisplayedMnemonic(bundle.get("preferences.editor-delay.mnemonic").charAt(0));
        this.editorDelay = new WholeNumberField(this.copy.getEditorDelay(), 6);
        this.editorDelay.setToolTipText(editorDelayTip);
        this.editorDelayLabel.setLabelFor((Component)this.editorDelay);
        this.editorDelayUnits = new JLabel("ms");
        this.editorDelayUnits.setToolTipText(editorDelayTip);
        Box editorDelayAndUnits = Box.createHorizontalBox();
        editorDelayAndUnits.add((Component)this.editorDelay);
        editorDelayAndUnits.add(Box.createHorizontalStrut(2));
        editorDelayAndUnits.add(this.editorDelayUnits);
        this.auditDuringCompile = new JCheckBox(bundle.get("preferences.audit-during-compile.label"), this.copy.isAuditDuringCompile());
        this.auditDuringCompile.setMnemonic(bundle.get("preferences.audit-during-compile.mnemonic").charAt(0));
        this.auditDuringCompile.setToolTipText(bundle.get("preferences.audit-during-compile.tip"));
        String compileProfileTip = bundle.get("preferences.compile-profile.tip");
        this.compileProfileLabel = new JLabel(bundle.get("preferences.compile-profile.label"));
        this.compileProfileLabel.setDisplayedMnemonic(bundle.get("preferences.compile-profile.mnemonic").charAt(0));
        this.compileProfileLabel.setToolTipText(compileProfileTip);
        this.compileProfile = new ProfileComboBox((ComboBoxModel)new DelegatingComboBoxModel(this.profiles));
        profile = ProfileRepository.getRepository().getProfile(this.copy.getCompileProfile(), "compile-rules");
        if (profile != null) {
            this.compileProfile.setSelectedItem(profile);
        } else {
            this.compileProfile.setSelectedIndex(0);
        }
        this.compileProfile.setToolTipText(compileProfileTip);
        this.compileProfileLabel.setLabelFor(this.compileProfile);
        String maximumFileSizeTip = bundle.get("preferences.maximum-file-size.tip");
        this.maximumFileSizeLabel = new JLabel(bundle.get("preferences.maximum-file-size.label"));
        this.maximumFileSizeLabel.setToolTipText(maximumFileSizeTip);
        this.maximumFileSizeLabel.setDisplayedMnemonic(bundle.get("preferences.maximum-file-size.mnemonic").charAt(0));
        this.maximumFileSize = new NumberTextField((Number)Float.valueOf(this.copy.getMaximumFileSize()), 3);
        this.maximumFileSize.setDataType(Float.class);
        this.maximumFileSize.setSigned(false);
        this.maximumFileSize.setDecimal(true, 1);
        this.maximumFileSize.setAlignmentX(1.0f);
        this.maximumFileSize.setToolTipText(maximumFileSizeTip);
        this.maximumFileSizeLabel.setLabelFor((Component)this.maximumFileSize);
        this.maximumFileSizeUnits = new JLabel("Mb");
        this.maximumFileSizeUnits.setToolTipText(maximumFileSizeTip);
        Box maximumFileSizeAndUnits = Box.createHorizontalBox();
        maximumFileSizeAndUnits.add((Component)this.maximumFileSize);
        maximumFileSizeAndUnits.add(Box.createHorizontalStrut(2));
        maximumFileSizeAndUnits.add(this.maximumFileSizeUnits);
        this.auditDuringCompile.addActionListener(this);
        this.auditWhileEditing.addActionListener(this);
        this.showCodeAssistanceInGutter.addActionListener(this);
        String text = this.auditDuringCompile.getText();
        this.auditDuringCompile.setText("");
        int CHECKBOX_TEXT_INSET = this.auditDuringCompile.getPreferredSize().width + this.auditDuringCompile.getIconTextGap() - this.auditDuringCompile.getInsets().right;
        this.auditDuringCompile.setText(text);
        GridBagConstraints column0 = new GridBagConstraints();
        column0.gridy = 0;
        column0.gridx = 0;
        column0.insets.top = 5;
        column0.insets.left = CHECKBOX_TEXT_INSET;
        column0.anchor = 17;
        GridBagConstraints column1 = new GridBagConstraints();
        column1.gridy = 0;
        column1.gridx = 1;
        column1.insets.top = 5;
        column1.insets.left = 6;
        column1.anchor = 17;
        column1.weightx = 1.0;
        GridBagConstraints column01 = new GridBagConstraints();
        column01.gridy = 0;
        column01.gridx = 0;
        column01.gridwidth = 2;
        column01.anchor = 17;
        column01.insets.top = 10;
        column01.insets.left = 0;
        this.component.add((Component)this.auditWhileEditing, column01);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        column01.insets.top = 5;
        column01.insets.left = CHECKBOX_TEXT_INSET;
        this.component.add((Component)this.showCodeAssistanceInGutter, column01);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        this.component.add((Component)this.editorProfileLabel, column0);
        this.component.add((Component)this.editorProfile, column1);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        column1.fill = 0;
        this.component.add((Component)this.editorDelayLabel, column0);
        this.component.add((Component)editorDelayAndUnits, column1);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        column01.insets.top = 10;
        column01.insets.left = 0;
        this.component.add((Component)this.auditDuringCompile, column01);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        this.component.add((Component)this.compileProfileLabel, column0);
        this.component.add((Component)this.compileProfile, column1);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        column0.insets.top = 10;
        column0.insets.left = 0;
        column1.insets.top = 10;
        column1.fill = 0;
        this.component.add((Component)this.maximumFileSizeLabel, column0);
        this.component.add((Component)maximumFileSizeAndUnits, column1);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        column01.insets.top = 0;
        column01.insets.left = 0;
        column01.weighty = 1.0;
        this.component.add(Box.createHorizontalGlue(), column01);
    }

    private void loadComponents() {
        this.auditDuringCompile.setSelected(this.copy.isAuditDuringCompile());
        Profile profile = ProfileRepository.getRepository().getProfile(this.copy.getCompileProfile(), "compile-rules");
        if (profile != null) {
            this.compileProfile.setSelectedItem(profile);
        } else {
            this.compileProfile.setSelectedIndex(0);
        }
        this.auditWhileEditing.setSelected(this.copy.isAuditWhileEditing());
        this.editorDelay.setNumber((Number)this.copy.getEditorDelay());
        this.maximumFileSize.setNumber((Number)Float.valueOf(this.copy.getMaximumFileSize()));
        profile = this.profiles.getProfile(this.copy.getAssistProfile(), "code-assist-rules");
        this.editorProfile.setSelectedItem(profile);
        this.showCodeAssistanceInGutter.setSelected(this.copy.isShowCodeAssistanceInGutter());
        this.synchronize();
    }

    private void synchronize() {
        boolean compiling = this.auditDuringCompile.isSelected();
        this.compileProfileLabel.setEnabled(compiling);
        if (compiling && this.compileProfile.getSelectedItem() == null) {
            this.compileProfile.setSelectedIndex(0);
        }
        this.compileProfile.setEnabled(compiling);
        boolean editing = this.auditWhileEditing.isSelected();
        this.editorDelayLabel.setEnabled(editing);
        this.editorDelay.setEnabled(editing);
        this.editorDelayUnits.setEnabled(editing);
        this.maximumFileSizeLabel.setEnabled(editing);
        this.maximumFileSize.setEnabled(editing);
        this.maximumFileSizeUnits.setEnabled(editing);
        this.editorProfileLabel.setEnabled(editing);
        if (editing && this.editorProfile.getSelectedItem() == null) {
            this.editorProfile.setSelectedIndex(0);
        }
        this.editorProfile.setEnabled(editing);
        this.showCodeAssistanceInGutter.setEnabled(editing);
    }

    private void unloadComponents() {
        this.copy.setAuditDuringCompile(this.auditDuringCompile.isSelected());
        Profile profile = (Profile)this.compileProfile.getSelectedItem();
        String profileName = "compile-rules".equals(profile.getKey()) ? null : profile.getName();
        this.copy.setCompileProfile(profileName);
        this.copy.setAuditWhileEditing(this.auditWhileEditing.isSelected());
        this.copy.setEditorDelay(this.editorDelay.getNumber().intValue());
        this.copy.setMaximumFileSize(this.maximumFileSize.getNumber().floatValue());
        profile = (Profile)this.editorProfile.getSelectedItem();
        profileName = "code-assist-rules".equals(profile.getKey()) ? null : profile.getName();
        this.copy.setAssistProfile(profileName);
        this.copy.setShowCodeAssistanceInGutter(this.showCodeAssistanceInGutter.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.synchronize();
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.synchronize();
        }
    }

    public void onEntry(TraversableContext context) {
        Copyable preferences = (Copyable)context.find("audit-preferences");
        this.copy = new AuditPreferences();
        preferences.copyTo((Object)this.copy);
        this.createComponents();
        this.loadComponents();
    }

    public void onExit(TraversableContext context) throws TraversalException {
        if (this.copy == null) {
            return;
        }
        this.unloadComponents();
        Copyable preferences = (Copyable)context.find("audit-preferences");
        this.copy.copyTo(preferences);
        this.copy = null;
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return bundle.get("preferences.audit.help");
    }

    public Collection<String> searchTags() {
        LinkedList<String> tags = new LinkedList<String>();
        tags.add(bundle.get("preferences.audit.search.tags.code.assist"));
        tags.add(bundle.get("preferences.audit.search.tags.compile.rules"));
        tags.add(bundle.get("preferences.audit.search.tags.audit"));
        return tags;
    }

    private class DelegatingComboBoxModel
    implements ComboBoxModel {
        private ComboBoxModel delegate;
        private Object selectedItem;

        public DelegatingComboBoxModel(ComboBoxModel delegate) {
            this.delegate = delegate;
        }

        @Override
        public int getSize() {
            return this.delegate.getSize();
        }

        @Override
        public Object getElementAt(int index) {
            return this.delegate.getElementAt(index);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object item) {
            this.selectedItem = item;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.delegate.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.delegate.removeListDataListener(l);
        }
    }
}

