/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.FileModelAdapter;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdevimpl.audit.core.CoreBundle;
import oracle.jdevimpl.audit.core.InternalCategory;
import oracle.jdevimpl.audit.util.EmptyIterator;

public class UnauditableFileModelAdapter
extends FileModelAdapter {
    public UnauditableElement root;
    private static final Log LOG = new Log("unauditable");

    public UnauditableFileModelAdapter(ModelFactory factory, ModelType model, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, Node node, URL url) {
        super(factory, model, workspace, project, directory, node, url);
        this.root = new UnauditableElement(node);
    }

    @Override
    public Iterator getContainedConstructs(Object construct) {
        return EmptyIterator.emptyIterator();
    }

    @Override
    public Location[] getElementLocations(Element element) {
        return null;
    }

    @Override
    public Location getLocation(Object construct) {
        if (construct == this.root) {
            return this.getLocation();
        }
        return null;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object label(Object construct) {
        if (construct == this.root) {
            return this.root.getShortLabel();
        }
        return null;
    }

    @Override
    public Object summary(Object construct) {
        if (construct == this.root) {
            return this.root.getLongLabel();
        }
        return null;
    }

    @Override
    public Icon icon(Object construct) {
        if (construct == this.root) {
            return this.root.getIcon();
        }
        return null;
    }

    @Override
    public void enter(AuditContext context) {
        Rule rule = new Rule("unauditable-file", new InternalCategory(), Severity.WARNING, Localizer.instance(CoreBundle.class));
        rule.setEnabled(true);
        ViolationReport report = context.report(rule, this.getLocation(0, 0));
        report.addParameter("name", this.root.getShortLabel());
        report.addParameter("size", URLFileSystem.getLength((URL)context.getUrl()));
        report.addParameter("maximumSize", Float.valueOf((float)context.getAuditor().getMaximumFileSize() / 1000000.0f));
    }

    static class UnauditableElement
    extends NodeListener
    implements Element {
        private Node node;

        public UnauditableElement(Node node) {
            this.node = node;
            if (LOG.isEnabled()) {
                node.addNodeListener((NodeListener)this);
                LOG.trace("created unauditable element for {1}, open {0}", node.isOpen(), (Object)node.getShortLabel());
            }
        }

        public void nodeOpened(NodeEvent e) {
            LOG.trace("node {0} opened: {1}", (Object)this.node.getShortLabel(), (Object)new Throwable("cause"));
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return ElementAttributes.EMPTY_ATTRIBUTES;
        }

        public Object getData() {
            return this;
        }

        public String getShortLabel() {
            return this.node.getShortLabel();
        }

        public String getLongLabel() {
            return this.node.getLongLabel();
        }

        public Icon getIcon() {
            return this.node.getIcon();
        }

        public String getToolTipText() {
            return this.node.getToolTipText();
        }
    }
}

