/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import java.util.Collection;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.ContentCache;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;

public class ProjectModelAdapter
extends ContainerModelAdapter {
    private final Project project;

    public ProjectModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, Project project) {
        super(factory, type, workspace, project);
        this.project = project;
    }

    @Override
    public URL getUrl() {
        return this.project.getURL();
    }

    @Override
    public ContainerModelAdapter getContainingAdapter() {
        return this.getWorkspaceAdapter();
    }

    @Override
    public ContentDirectory getDirectory() {
        return null;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public WorkingSet getWorkingSet() {
        return this.getFactory().getWorkingSet();
    }

    @Override
    public Object getRoot() {
        return this.project;
    }

    @Override
    public Location[] getElementLocations(Element element) {
        if (!this.getProject().equals((Object)element)) {
            return null;
        }
        return new Location[]{this.getLocation()};
    }

    @Override
    public Location getLocation(Object construct) {
        if (construct == this.getProject()) {
            return this.getLocation();
        }
        return null;
    }

    @Override
    public Object getConstruct(Location location) {
        if (!this.equals(location.getModel())) {
            return null;
        }
        return this.getProject();
    }

    @Override
    protected void createContainedModels(Object construct) {
        assert (this.getProject().equals(construct)) : this.getProject() + " != " + construct;
        ContentCache cache = this.getFactory().getContentSetCache(this.project, this.getWorkspace());
        Collection<ContentDirectory> roots = cache.getRootDirectories();
        for (ContentDirectory directory : roots) {
            Collection<ModelAdapter> models = this.getFactory().getContainedModelAdapters(directory, directory.getURL(), this);
            this.addContainedModels(models);
        }
    }

    @Override
    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        ModelAdapter model = (ModelAdapter)object;
        assert (this.getFactory() == model.getFactory()) : "generation mismatch: " + this + " - " + model;
        int comparison = ProjectModelAdapter.compareSiblings(this.getWorkspaceAdapter(), model.getWorkspaceAdapter());
        if (comparison != 0) {
            return comparison;
        }
        comparison = ProjectModelAdapter.compareSiblings(this, model.getProjectAdapter());
        if (comparison == 0) {
            comparison = -1;
        }
        return comparison;
    }

    @Override
    public boolean contains(ModelAdapter that) {
        assert (this.getFactory() == that.getFactory()) : "generation mismatch: " + this + " - " + that;
        return this.getWorkspaceAdapter() == that.getWorkspaceAdapter() && this == that.getProjectAdapter();
    }

    @Override
    public boolean contains(Object construct, Location location) {
        assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + this + " - " + location;
        assert (this.getProject().equals(construct));
        assert (this == location.getModel());
        return true;
    }

    @Override
    public Node getNode() {
        return this.project;
    }

    @Override
    public boolean isModifiable() {
        return !this.project.isReadOnly();
    }

    @Override
    public Object label(Object construct) {
        String text = ((Element)construct).getShortLabel();
        WorkingSet workingSet = this.getFactory().getWorkingSet();
        if (workingSet != null) {
            text = text + " (" + workingSet.getName() + ')';
        }
        return text;
    }

    @Override
    public Object summary(Object construct) {
        String text = ((Element)construct).getToolTipText();
        WorkingSet workingSet = this.getFactory().getWorkingSet();
        if (workingSet != null) {
            text = text + " (" + workingSet.getName() + ')';
        }
        return text;
    }

    @Override
    public Icon icon(Object construct) {
        return ((Element)construct).getIcon();
    }
}

