/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.service.AuditModelFilter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.util.Cache;
import oracle.jdevimpl.audit.util.Strings;

public class TypeFilter
extends AuditModelFilter {
    private Collection<ModelType> modelTypes;
    private Map<Class<?>, ModelType> modelTypeByPresentationType = new HashMap();
    private Map<Class<?>, Boolean> visibilityByPresentationType = new LinkedHashMap();
    private String key;
    private static final Log LOG = new Log("typefilter");

    public TypeFilter() {
        this(AuditManager.getAuditManager().getDefaultModelTypeFactory().getModelTypes());
    }

    public TypeFilter(String persistenceKey) {
        this(persistenceKey, AuditManager.getAuditManager().getDefaultModelTypeFactory().getModelTypes());
    }

    public TypeFilter(Collection<ModelType> modelTypes) {
        this(null, modelTypes);
    }

    public TypeFilter(String persistenceKey, Collection<ModelType> modelTypes) {
        this.key = persistenceKey;
        this.modelTypes = modelTypes;
        this.visibilityByPresentationType.put(Violation.class, Boolean.TRUE);
        for (ModelType modelType : this.modelTypes) {
            Collection visible;
            Collection<Class<?>> all = modelType.getPresentationTypes();
            if (this.key != null) {
                String adapterKey = this.getAdapterKey(modelType);
                visible = (Collection)Cache.get(adapterKey, modelType.getDefaultPresentationTypes());
                LOG.trace("read type filter cache for {0} as {1}", (Object)adapterKey, (Object)visible);
            } else {
                visible = modelType.getDefaultPresentationTypes();
            }
            if (all != null) {
                for (Class<?> type : all) {
                    this.visibilityByPresentationType.put(type, Boolean.FALSE);
                    this.modelTypeByPresentationType.put(type, modelType);
                }
            }
            if (visible == null) continue;
            for (Class<?> type : visible) {
                this.visibilityByPresentationType.put(type, Boolean.TRUE);
            }
        }
    }

    @Override
    public boolean isVisible(Object object) {
        return this.isVisible(this.getModel().getType(object));
    }

    public Collection<ModelType> getModelTypes() {
        return this.modelTypes;
    }

    public synchronized void setVisible(Class type, boolean visible) {
        assert (this.visibilityByPresentationType.containsKey(type));
        if (Violation.class.isAssignableFrom(type)) {
            return;
        }
        this.visibilityByPresentationType.put(type, visible);
        this.write(this.modelTypeByPresentationType.get(type));
        this.fireStateChanged();
    }

    public void setVisible(Class<?> ... types) {
        this.setVisible(Arrays.asList(types));
    }

    public synchronized void setVisible(List<Class<?>> types) {
        Boolean wasVisible;
        HashSet invisibleTypes = new HashSet(this.visibilityByPresentationType.keySet());
        invisibleTypes.remove(Violation.class);
        HashSet<ModelType> changedModelTypes = new HashSet<ModelType>();
        for (Class<?> clazz : types) {
            assert (this.visibilityByPresentationType.containsKey(clazz));
            invisibleTypes.remove(clazz);
            wasVisible = this.visibilityByPresentationType.put(clazz, Boolean.TRUE);
            if (wasVisible == Boolean.TRUE) continue;
            changedModelTypes.add(this.modelTypeByPresentationType.get(clazz));
        }
        for (Class clazz : invisibleTypes) {
            assert (this.visibilityByPresentationType.containsKey(clazz));
            wasVisible = this.visibilityByPresentationType.put(clazz, Boolean.FALSE);
            if (wasVisible == Boolean.FALSE) continue;
            changedModelTypes.add(this.modelTypeByPresentationType.get(clazz));
        }
        Iterator i = changedModelTypes.iterator();
        while (i.hasNext()) {
            this.write((ModelType)i.next());
        }
        if (!changedModelTypes.isEmpty()) {
            this.fireStateChanged();
        }
    }

    public synchronized boolean isVisible(Class type) {
        return this.visibilityByPresentationType.get(type) == Boolean.TRUE;
    }

    public ModelType getModelType(Class type) {
        return this.modelTypeByPresentationType.get(type);
    }

    public String getLabel(Class type) {
        return this.modelTypeByPresentationType.get(type).label(type);
    }

    public String getSummary(Class type) {
        return this.modelTypeByPresentationType.get(type).summary(type);
    }

    public Icon getIcon(Class type) {
        return this.modelTypeByPresentationType.get(type).icon(type);
    }

    private String getAdapterKey(ModelType view) {
        return this.key + "." + Strings.removeSuffix(Strings.lastToken(view.getClass().getName(), '.'), "TypeAdapter").toLowerCase();
    }

    private void write(ModelType adapter) {
        if (this.key == null) {
            return;
        }
        Collection<Class<?>> types = adapter.getPresentationTypes();
        ArrayList visibleTypes = new ArrayList();
        for (Class<?> type : types) {
            if (!this.isVisible(type)) continue;
            visibleTypes.add(type);
        }
        String adapterKey = this.getAdapterKey(adapter);
        Cache.put(adapterKey, visibleTypes);
        LOG.trace("wrote type filter cache {0} to {1}", (Object)adapterKey, visibleTypes);
    }
}

