/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.util.Comparator;
import java.util.List;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.AuditModelListener;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.CoreBundle;
import oracle.jdevimpl.audit.core.InternalCategory;

public class SeverityColumn
extends Metric
implements AuditModelListener {
    private int columnIndex = -1;
    private static final Comparator<Object> INVERTING_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o2).compareTo(o1);
        }
    };

    public SeverityColumn() {
        super("severity", new InternalCategory(), Severity.class, Localizer.instance(CoreBundle.class));
    }

    @Override
    public Comparator<Object> comparator() {
        return INVERTING_COMPARATOR;
    }

    @Override
    public void auditStarted(AuditModel model, List<Metric> columns, List<Location> locations, Object root, Class type) {
        this.columnIndex = model.getColumnIndex(this);
    }

    @Override
    public void auditStopped(AuditModel model, boolean cancelled) {
    }

    @Override
    public void rowsInserted(AuditModel model, List<?> rows, Object parent, int index) {
        for (Object row : rows) {
            if (!model.isViolation(row)) continue;
            model.setValue(row, this.columnIndex, model.getSeverity(row));
        }
    }

    @Override
    public void rowsRemoved(AuditModel model, List<?> rows, Object parent, int index) {
    }

    @Override
    public void rowsShown(AuditModel model, List<?> rows, Object visibleParent, int visibleIndex) {
    }

    @Override
    public void rowsHidden(AuditModel model, List<?> rows, Object visibleParent, int visibleIndex) {
    }

    @Override
    public void rowsRestructureBegin(AuditModel model, Object parent, Object visibleParent) {
    }

    @Override
    public void rowsRestructureEnd(AuditModel model, Object parent, Object visibleParent) {
    }

    @Override
    public void countChanged(AuditModel model, Object row, AuditModel.Count count, int oldValue, int newValue) {
        switch (count) {
            case VISIBLE_ADVISORIES: 
            case VISIBLE_INCOMPLETES: 
            case VISIBLE_WARNINGS: 
            case VISIBLE_ERRORS: {
                model.setValue(row, this.columnIndex, model.getSeverity(row));
            }
        }
    }

    @Override
    public void valueChanged(AuditModel model, Object row, int column, Object oldValue, Object newValue) {
    }

    @Override
    public void modelResorted(AuditModel model) {
    }

    @Override
    public void appliedTransformsChanged(AuditModel model, Object row, List<Transform> appliedTransforms) {
    }
}

