/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import oracle.javatools.util.FormatBundle;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.bean.BeanCustomizer;
import oracle.jdeveloper.audit.bean.PropertyField;
import oracle.jdevimpl.audit.core.AuditELContext;
import oracle.jdevimpl.audit.core.CoreBundle;
import oracle.jdevimpl.audit.core.DefaultTransformField;

public class RuleCustomizer
extends BeanCustomizer {
    private static final FormatBundle BUNDLE = new FormatBundle(CoreBundle.class);

    public Class getType() {
        return Rule.class;
    }

    @Override
    public Boolean visible(Object bean, String itemName) {
        if (itemName.equals("enabled")) {
            return Boolean.FALSE;
        }
        if (itemName.equals("defaultTransformName")) {
            return ((Rule)bean).getTransforms().length > 0;
        }
        return null;
    }

    @Override
    public PropertyField field(Object bean, String propertyName) {
        if (propertyName.equals("defaultTransformName")) {
            Rule rule = (Rule)bean;
            return new DefaultTransformField(new AuditELContext(), rule, rule.getTransforms());
        }
        return null;
    }

    @Override
    public String label(Object bean, String itemName) {
        if (itemName.equals("severity")) {
            return BUNDLE.get("rule.severity.label");
        }
        if (itemName.equals("style")) {
            return BUNDLE.get("rule.style.label");
        }
        if (itemName.equals("defaultTransformName")) {
            return BUNDLE.get("rule.default-transform-name.label");
        }
        return null;
    }
}

