/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.util.Log;
import oracle.javatools.util.Pair;
import oracle.javatools.util.WeakCache;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.AuditTaskContext;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.core.CoreBundle;
import oracle.jdevimpl.audit.core.DefaultAuditContext;
import oracle.jdevimpl.audit.core.InternalCategory;
import oracle.jdevimpl.audit.util.Strings;

public final class ProfileBinding {
    private Profile.Instances instances;
    private final Map<Class<?>, Invoker> invokersByConstruct = new HashMap();
    private Map<Class<?>, List<Pair<Class<? extends Analyzer>, Method>>> enterMethodsByConstruct;
    private Map<Class<?>, List<Pair<Class<? extends Analyzer>, Method>>> exitMethodsByConstruct;
    private List<Pair<Class<? extends Analyzer>, Method>> startTaskMethods;
    private static final long MILLISECONDS100 = TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS);
    private static final long MILLISECONDS10 = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MILLISECONDS);
    private static final long MILLISECONDS1 = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    private static final Log LOG = new Log("binding");
    private Profile profile;
    private static WeakCache<Class<? extends Analyzer>, List<Method>> methodsByAnalyzer = new WeakCache();

    public ProfileBinding(Profile profile) {
        this.profile = profile;
    }

    public Map<Analyzer, Collection<ExtensionBean>> createInstances() {
        this.introspectVisitorMethods(this.profile);
        this.instances = this.profile.createInstances();
        return this.instances.getBeansByAnalyzer();
    }

    public void cancelAnalyzers() {
        Profile.Instances instances = this.instances;
        if (instances != null) {
            for (Analyzer analyzer : instances.getAnalyzers()) {
                if (analyzer == null) continue;
                analyzer.cancel();
            }
        }
    }

    public Collection<ExtensionBean> getBeans() {
        return this.instances.getBeans();
    }

    public Collection<Analyzer> getAnalyzers() {
        return this.instances.getAnalyzers();
    }

    public Analyzer getAnalyzer(Class<? extends Analyzer> analyzerClass) {
        return this.instances.getAnalyzer(analyzerClass);
    }

    public Invoker getInvoker(Class<?> constructType) {
        Invoker invoker = this.invokersByConstruct.get(constructType);
        if (invoker == null) {
            invoker = new Invoker(constructType, this.instances);
            this.invokersByConstruct.put(constructType, invoker);
        }
        return invoker;
    }

    public List<Pair<Class<? extends Analyzer>, Method>> getStartTaskMethods() {
        return this.startTaskMethods;
    }

    public void clear() {
        this.invokersByConstruct.clear();
        this.instances = null;
    }

    public synchronized void introspectVisitorMethods(Profile profile) {
        if (this.enterMethodsByConstruct != null) {
            return;
        }
        LOG.trace("introspecting visitor methods");
        this.enterMethodsByConstruct = new HashMap();
        this.exitMethodsByConstruct = new HashMap();
        this.startTaskMethods = new ArrayList<Pair<Class<? extends Analyzer>, Method>>();
        for (Class<? extends Analyzer> analyzerClass : profile.getAnalyzerClasses()) {
            LOG.trace("loading methods for {0}", analyzerClass);
            assert (analyzerClass != null);
            if (Analyzer.class.isAssignableFrom(analyzerClass)) {
                ArrayList<Method> list = (ArrayList<Method>)methodsByAnalyzer.get(analyzerClass);
                if (list == null) {
                    list = new ArrayList<Method>();
                    methodsByAnalyzer.put(analyzerClass, list);
                    for (Method method : analyzerClass.getMethods()) {
                        Class<?>[] signature;
                        String name = method.getName();
                        if (name.startsWith("enter") || name.startsWith("exit")) {
                            signature = method.getParameterTypes();
                            if (signature.length != 2) {
                                AuditLogger.error("Method {0} ignored because it does not have exactly 2 parameters", method);
                                continue;
                            }
                            if (!AuditContext.class.equals(signature[0])) {
                                AuditLogger.error("Method {0} ignored because type of first parameter is not AuditContext", method);
                                continue;
                            }
                            list.add(method);
                            continue;
                        }
                        if (!name.equals("startTask") || method.getDeclaringClass().equals(Analyzer.class) || (signature = method.getParameterTypes()).length != 1 || !AuditTaskContext.class.equals(signature[0])) continue;
                        list.add(method);
                    }
                }
                for (Method method : list) {
                    List<Pair<Class<? extends Analyzer>, Method>> methods;
                    Class<?> constructType;
                    String name = method.getName();
                    Pair pair = new Pair(analyzerClass, (Object)method);
                    if ("startTask".equals(name)) {
                        this.startTaskMethods.add((Pair<Class<? extends Analyzer>, Method>)pair);
                        continue;
                    }
                    if (name.startsWith("enter")) {
                        constructType = method.getParameterTypes()[1];
                        methods = this.enterMethodsByConstruct.get(constructType);
                        if (methods == null) {
                            methods = new ArrayList<Pair<Class<? extends Analyzer>, Method>>();
                            this.enterMethodsByConstruct.put(constructType, methods);
                        }
                        methods.add((Pair<Class<? extends Analyzer>, Method>)pair);
                        continue;
                    }
                    constructType = method.getParameterTypes()[1];
                    methods = this.exitMethodsByConstruct.get(constructType);
                    if (methods == null) {
                        methods = new ArrayList<Pair<Class<? extends Analyzer>, Method>>();
                        this.exitMethodsByConstruct.put(constructType, methods);
                    }
                    methods.add((Pair<Class<? extends Analyzer>, Method>)pair);
                }
                continue;
            }
            AuditLogger.error("Analyzer {0} ignored because it does not extend Analyzer", analyzerClass);
        }
    }

    public String statistics() {
        HashMap<BoundMethod, BoundMethod> methods = new HashMap<BoundMethod, BoundMethod>();
        for (Invoker invoker : this.invokersByConstruct.values()) {
            BoundMethod successor;
            BoundMethod predecessor;
            for (BoundMethod method : invoker.boundEntryMethods) {
                predecessor = methods.put(method, method);
                assert (predecessor != method);
                if (predecessor == null) continue;
                successor = new BoundMethod(method.analyzer, method.method);
                successor.count = predecessor.count + method.count;
                successor.count1 = predecessor.count1 + method.count1;
                successor.count10 = predecessor.count10 + method.count10;
                successor.count100 = predecessor.count100 + method.count100;
                successor.total = predecessor.total + method.total;
                successor.longest = Math.max(predecessor.longest, method.longest);
                methods.put(successor, successor);
            }
            for (BoundMethod method : invoker.boundExitMethods) {
                predecessor = methods.put(method, method);
                assert (predecessor != method);
                if (predecessor == null) continue;
                successor = new BoundMethod(method.analyzer, method.method);
                successor.count = predecessor.count + method.count;
                successor.count1 = predecessor.count1 + method.count1;
                successor.count10 = predecessor.count10 + method.count10;
                successor.count100 = predecessor.count100 + method.count100;
                successor.total = predecessor.total + method.total;
                successor.longest = Math.max(predecessor.longest, method.longest);
                methods.put(successor, successor);
            }
        }
        ArrayList sortedMethods = new ArrayList(methods.keySet());
        Collections.sort(sortedMethods);
        String EOL = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        int nameWidth = "StatementsAnalyzer.enter(SourceSimpleNameExpression)".length();
        for (BoundMethod method : sortedMethods) {
            if (method.count == 0 || method.total < MILLISECONDS1) continue;
            int outlierCount = method.count100 + method.count10 + method.count1;
            builder.append("  ");
            int nameStart = builder.length();
            builder.append(method.analyzer.getClass().getSimpleName());
            builder.append(".");
            builder.append(method.method.getName());
            builder.append("(");
            builder.append(method.method.getParameterTypes()[1].getSimpleName());
            builder.append(")");
            for (int i = builder.length(); i < nameStart + nameWidth; ++i) {
                builder.append(' ');
            }
            String total = String.valueOf(TimeUnit.MILLISECONDS.convert(method.total, TimeUnit.NANOSECONDS));
            for (int i = total.length(); i < 7; ++i) {
                builder.append(' ');
            }
            builder.append(total);
            builder.append("ms total [0-1ms: ");
            builder.append(method.count - outlierCount);
            builder.append(", 1-10ms: ");
            builder.append(method.count1);
            builder.append(", 10-100ms: ");
            builder.append(method.count10);
            builder.append(", 100-");
            builder.append(TimeUnit.MILLISECONDS.convert(method.longest, TimeUnit.NANOSECONDS));
            builder.append("ms: ");
            builder.append(method.count100);
            builder.append(", mean: ");
            builder.append(TimeUnit.MILLISECONDS.convert(method.total / (long)method.count, TimeUnit.NANOSECONDS));
            builder.append("ms]");
            builder.append(EOL);
        }
        return builder.toString();
    }

    public class Invoker {
        private List<BoundMethod> boundEntryMethods = new ArrayList<BoundMethod>();
        private List<BoundMethod> boundExitMethods = new ArrayList<BoundMethod>();
        private Rule exceptionRule;
        private Rule rulesDisabledRule;
        private Rule metricsDisabledRule;

        private Invoker(Class constructType, Profile.Instances instances) {
            LinkedHashSet types = new LinkedHashSet();
            for (Class type = constructType; type != null; type = type.getSuperclass()) {
                types.add(type);
                this.addInterfaces(types, type.getInterfaces());
            }
            HashSet<Class<? extends Analyzer>> boundEntryClasses = new HashSet<Class<? extends Analyzer>>();
            HashSet<Class<? extends Analyzer>> boundExitClasses = new HashSet<Class<? extends Analyzer>>();
            for (Class clazz : types) {
                this.bindMethods(instances, (List)ProfileBinding.this.enterMethodsByConstruct.get(clazz), boundEntryClasses, this.boundEntryMethods);
                this.bindMethods(instances, (List)ProfileBinding.this.exitMethodsByConstruct.get(clazz), boundExitClasses, this.boundExitMethods);
            }
        }

        private void addInterfaces(Set<Class<?>> types, Class[] interfaces) {
            for (Class type : interfaces) {
                types.add(type);
                this.addInterfaces(types, type.getInterfaces());
            }
        }

        private void bindMethods(Profile.Instances instances, List<Pair<Class<? extends Analyzer>, Method>> unboundMethods, Set<Class<? extends Analyzer>> boundClasses, List<BoundMethod> boundMethods) {
            if (unboundMethods == null) {
                return;
            }
            for (Pair<Class<? extends Analyzer>, Method> pair : unboundMethods) {
                Analyzer analyzer;
                Class analyzerClass = (Class)pair.getFirst();
                if (!boundClasses.add(analyzerClass) || (analyzer = instances.getAnalyzer(analyzerClass)) == null) continue;
                Method method = (Method)pair.getSecond();
                boundMethods.add(new BoundMethod(analyzer, method));
            }
        }

        public void enter(DefaultAuditContext context) {
            List<Analyzer> disabledAnalyzers = context.getDisabledAnalyzers();
            if (context.enteringApplicationContent()) {
                for (Analyzer analyzer : ProfileBinding.this.instances.getAnalyzers()) {
                    if (analyzer.isApplicationContentSupported() || !analyzer.isEnabled()) continue;
                    analyzer.setEnabled(false);
                    disabledAnalyzers.add(analyzer);
                }
            }
            this.invoke(context, this.boundEntryMethods, disabledAnalyzers);
        }

        public void exit(DefaultAuditContext context) {
            this.invoke(context, this.boundExitMethods, null);
            for (Analyzer analyzer : context.getDisabledAnalyzers()) {
                analyzer.setEnabled(true);
            }
        }

        private void invoke(DefaultAuditContext context, List<BoundMethod> boundMethods, List<Analyzer> disabledAnalyzers) {
            Object[] arguments = context.getArguments();
            for (BoundMethod boundMethod : boundMethods) {
                Analyzer analyzer = boundMethod.analyzer;
                if (!analyzer.isEnabled()) continue;
                Method method = boundMethod.method;
                LOG.trace("invoking {0} on {1}", (Object)method, (Object)arguments);
                try {
                    context.throwIfCancelled();
                    context.beginVisit();
                    long start = System.nanoTime();
                    method.invoke((Object)analyzer, arguments);
                    boundMethod.count += 1;
                    long duration = System.nanoTime() - start;
                    boundMethod.total += duration;
                    if (duration > boundMethod.longest) {
                        boundMethod.longest = duration;
                    }
                    if (duration > MILLISECONDS1) {
                        if (duration < MILLISECONDS10) {
                            boundMethod.count1 += 1;
                        } else if (duration < MILLISECONDS100) {
                            boundMethod.count10 += 1;
                        } else {
                            boundMethod.count100 += 1;
                        }
                    }
                    if (!analyzer.isEnabled()) {
                        disabledAnalyzers.add(analyzer);
                    }
                    context.endVisit();
                    if (!PerformanceLogger.isAboveGlobalThreshold((long)duration)) continue;
                    String className = analyzer.getClass().getSimpleName();
                    String constructName = method.getParameterTypes()[1].getSimpleName();
                    PerformanceLogger.get().log("ProfileBinding.Invoker.invoke()", className + "." + method.getName() + "(" + constructName + ")", duration);
                }
                catch (ExpiredTextBufferException e) {
                    context.cancelReport();
                    throw e;
                }
                catch (CancellationException e) {
                    context.cancelReport();
                    throw e;
                }
                catch (OutOfMemoryError e) {
                    context.cancelReport();
                    throw e;
                }
                catch (InvocationTargetException e) {
                    context.cancelReport();
                    Throwable cause = e.getCause();
                    if (cause instanceof ExpiredTextBufferException) {
                        throw (ExpiredTextBufferException)cause;
                    }
                    if (cause instanceof CancellationException) {
                        throw (CancellationException)cause;
                    }
                    if (cause instanceof OutOfMemoryError) {
                        throw (OutOfMemoryError)cause;
                    }
                    this.report(context, analyzer, method, arguments[1], e);
                }
                catch (Throwable e) {
                    context.cancelReport();
                    this.report(context, analyzer, method, arguments[1], e);
                }
            }
        }

        private void report(DefaultAuditContext context, Analyzer analyzer, Method method, Object construct, Throwable exception) {
            if (exception instanceof InvocationTargetException) {
                exception = exception.getCause();
            }
            if (this.exceptionRule == null) {
                InternalCategory category = new InternalCategory();
                Localizer localizer = Localizer.instance(CoreBundle.class);
                this.exceptionRule = new Rule("visitor-exception", category, Severity.ERROR, localizer);
                this.exceptionRule.setEnabled(true);
                this.rulesDisabledRule = new Rule("rules-disabled", category, Severity.ERROR, localizer);
                this.rulesDisabledRule.setEnabled(true);
                this.metricsDisabledRule = new Rule("metrics-disabled", category, Severity.ERROR, localizer);
                this.metricsDisabledRule.setEnabled(true);
            }
            Location location = context.getLocation();
            AuditLogger.error("exception visiting {0}{1}{2}", exception, construct, Strings.LINE_SEPARATOR, location.getModel().contextDescription(location));
            ViolationReport report = context.report(this.exceptionRule, location);
            report.addParameter("exception", exception.getClass().getSimpleName());
            StackTraceElement[] trace = exception.getStackTrace();
            if (trace.length > 0) {
                report.addParameter("method", Strings.lastToken(trace[0].getClassName(), ".") + '.' + trace[0].getMethodName() + ':' + trace[0].getLineNumber());
            } else {
                report.addParameter("method", "?");
            }
            report.addParameter("analyzerClass", analyzer.getClass().getSimpleName());
            report.addParameter("analyzerMethod", method.getName());
            report.addParameter("analyzerArgument", construct.getClass().getSimpleName());
            context.endReport();
            analyzer.setEnabled(false);
            StringBuilder rules = new StringBuilder();
            StringBuilder metrics = new StringBuilder();
            for (ExtensionBean bean : ProfileBinding.this.instances.getBeansByAnalyzer().get(analyzer)) {
                Metric metric;
                if (bean instanceof Rule) {
                    Rule rule = (Rule)bean;
                    if (!rule.isEnabled()) continue;
                    if (rules.length() == 0) {
                        rules.append(", ");
                    }
                    rules.append(rule.labelOrId());
                    continue;
                }
                if (!(bean instanceof Metric) || !(metric = (Metric)bean).isEnabled()) continue;
                if (metrics.length() == 0) {
                    metrics.append(", ");
                }
                metrics.append(metric.labelOrId());
            }
            if (rules.length() > 0 || metrics.length() > 0) {
                AuditContext parent;
                DefaultAuditContext root = context;
                while (!root.isRoot() && (parent = root.getEnclosingContext()) != null) {
                    root = (DefaultAuditContext)parent;
                }
                if (rules.length() > 0) {
                    AuditLogger.error("disabling analyzer {0}; rules {1}", analyzer.getClass(), rules);
                    report = context.report(this.rulesDisabledRule, root.getLocation());
                    report.addParameter("analyzerClass", analyzer.getClass());
                    report.addParameter("rules", rules);
                    context.endReport();
                }
                if (metrics.length() > 0) {
                    AuditLogger.error("disabling analyzer {0}; metrics {1}", analyzer.getClass(), rules);
                    report = context.report(this.metricsDisabledRule, root.getLocation());
                    report.addParameter("analyzerClass", analyzer.getClass());
                    report.addParameter("metrics", metrics);
                    context.endReport();
                }
            }
        }
    }

    private static class BoundMethod
    implements Comparable<BoundMethod> {
        private Analyzer analyzer;
        private Method method;
        private int count;
        private int count1;
        private int count10;
        private int count100;
        private long longest;
        private long total;

        public BoundMethod(Analyzer analyzer, Method method) {
            this.analyzer = analyzer;
            this.method = method;
        }

        public boolean equals(Object object) {
            if (object instanceof BoundMethod) {
                BoundMethod that = (BoundMethod)object;
                return this.analyzer.equals(that.analyzer) && this.method.equals(that.method);
            }
            return false;
        }

        public int hashCode() {
            return this.analyzer.hashCode() * 37 + this.method.hashCode();
        }

        @Override
        public int compareTo(BoundMethod that) {
            return -(this.total < that.total ? -1 : (this.total == that.total ? 0 : 1));
        }
    }
}

