/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.javatools.util.FormatBundle;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.bean.AbstractEnumerationField;
import oracle.jdeveloper.audit.extension.DeferredExpression;
import oracle.jdeveloper.audit.extension.DeferredSetter;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.AuditELContext;
import oracle.jdevimpl.audit.core.CoreBundle;
import oracle.jdevimpl.audit.core.PropertyDeferredException;

public class DefaultTransformField
extends AbstractEnumerationField
implements PropertyChangeListener {
    private AuditELContext expressionContext;
    private Rule rule;
    private List<String> labels;
    private List<Transform> values;
    private static final String NONE = new FormatBundle(CoreBundle.class).get("default.transform.none.label");

    public DefaultTransformField(AuditELContext context, Rule rule, Transform[] transforms) {
        this.rule = rule;
        this.expressionContext = context;
        this.setTransforms(transforms);
        rule.addPropertyChangeListener(this);
    }

    public void setTransforms(Transform[] transforms) {
        this.values = new ArrayList<Transform>(transforms.length + 1);
        this.labels = new ArrayList<String>(this.values.size());
        for (Transform transform : transforms) {
            this.expressionContext.setBean(transform, this.rule);
            Map<String, DeferredSetter> setters = transform.setters();
            if (setters != null) {
                for (DeferredSetter setter : setters.values()) {
                    try {
                        setter.set(transform, this.expressionContext);
                    }
                    catch (PropertyDeferredException e) {
                    }
                    catch (Throwable e) {
                        setter.log("setter \"{0}\" failed: {1}", setter.getText(), e);
                        transform.setEnabled(false);
                        break;
                    }
                }
            }
            if (!this.isEnabled(transform)) continue;
            String label = transform.unboundLabel();
            if (label == null) {
                label = transform.id();
            }
            if (this.labels.indexOf(label) >= 0) continue;
            this.labels.add(label);
            this.values.add(transform);
        }
        this.labels.add(NONE);
        this.values.add(null);
        this.setEnumerals(this.labels.toArray(new String[this.labels.size()]));
    }

    private boolean isEnabled(Transform transform) {
        if (!transform.isEnabled()) {
            return false;
        }
        DeferredExpression condition = transform.condition();
        if (condition == null) {
            return true;
        }
        try {
            Object value = condition.evaluate(this.expressionContext);
            return Boolean.TRUE.equals(value);
        }
        catch (PropertyDeferredException e) {
            return true;
        }
        catch (Throwable e) {
            condition.log("condition \"{0}\" failed: {1}", condition.getText(), e);
            transform.setEnabled(false);
            return false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.setTransforms(this.rule.getTransforms());
    }

    @Override
    public String stringOf(Object value) {
        if (value == null) {
            return NONE;
        }
        for (int i = 0; i < this.values.size() - 1; ++i) {
            if (!this.values.get(i).id().equals(value)) continue;
            return this.labels.get(i);
        }
        return NONE;
    }

    @Override
    public Object valueOf(String text) {
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!this.labels.get(i).equals(text)) continue;
            Transform value = this.values.get(i);
            return value != null ? value.id() : null;
        }
        return null;
    }
}

