/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.Mutables;
import oracle.javatools.status.Issue;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.DefaultAuditor;
import oracle.jdevimpl.audit.model.WorkspaceModelAdapter;

public final class DefaultAuditContext
implements AuditContext {
    private DefaultAuditor auditor;
    private DefaultAuditContext enclosingContext;
    private int depth;
    private boolean applicationContextEntered;
    private List<Analyzer> disabledAnalyzers = new ArrayList<Analyzer>();
    private Object[] arguments = new Object[2];
    private ModelAdapter model;
    private Location location;
    private Object construct;
    private boolean isRoot;
    private Attributes attributes;
    private Map<Location, Attributes> childAttributes;
    private Mutables.Integer attributeCount;
    private Map<Object, AuditContext.Key> sharedAttributes;
    private static final Object NULL_VALUE = new Object();
    private static final Log LOG = new Log("keys");
    private static final ViolationReport NULL_REPORT = new ViolationReport(){

        @Override
        public void addParameter(String name, Object value) {
        }

        @Override
        public void addConstructParameter(String name, Object construct) {
        }

        @Override
        public void addConstructParameter(String name, ModelAdapter model, Object construct) {
        }

        @Override
        public void setFocusLocation(Object construct) {
        }

        @Override
        public void setFocusLocation(Location location) {
        }

        @Override
        public void setVariation(String name) {
        }

        @Override
        public void hideAllTransforms() {
        }

        @Override
        public void showTransform(Transform transform) {
        }

        @Override
        public void hideTransform(Transform transform) {
        }

        @Override
        public void setTransformFocusLocation(Transform transform, Object construct) {
        }

        @Override
        public void setTransformFocusLocation(Transform transform, Location location) {
        }

        @Override
        public void setDefaultTransform(Transform transform) {
        }
    };

    public DefaultAuditContext(DefaultAuditor auditor, DefaultAuditContext enclosingContext) {
        this.auditor = auditor;
        this.enclosingContext = enclosingContext;
        this.arguments[0] = this;
        if (enclosingContext == null) {
            this.depth = 0;
            this.attributeCount = new Mutables.Integer(0);
            this.sharedAttributes = new HashMap<Object, AuditContext.Key>();
        } else {
            this.depth = enclosingContext.depth + 1;
            this.attributeCount = enclosingContext.attributeCount;
            this.sharedAttributes = enclosingContext.sharedAttributes;
        }
    }

    public void setContext(ModelAdapter model, Location location, Object construct, boolean isRoot) {
        assert (this.enclosingContext == null || model != this.enclosingContext.model);
        boolean applicationContextEntered = this.enclosingContext != null && this.enclosingContext.model instanceof WorkspaceModelAdapter && model.getProject() == null;
        this.setContext(model, applicationContextEntered, location, construct, isRoot);
    }

    public void setContext(Location location, Object construct) {
        this.setContext(this.enclosingContext.model, false, location, construct, false);
    }

    private void setContext(ModelAdapter model, boolean applicationContextEntered, Location location, Object construct, boolean isRoot) {
        assert (model != null);
        assert (construct != null);
        assert (location == null || model == location.getModel());
        this.model = model;
        this.applicationContextEntered = applicationContextEntered;
        this.location = location;
        this.construct = construct;
        this.isRoot = isRoot;
        this.disabledAnalyzers.clear();
        this.arguments[1] = construct;
        if (this.enclosingContext != null && this.enclosingContext.childAttributes != null) {
            this.attributes = this.enclosingContext.childAttributes.get(this.getLocation());
        }
    }

    public void beginVisit() {
        if (this.model != null) {
            this.model.verifyReadTransaction();
        }
    }

    public void endVisit() {
        if (this.model != null) {
            this.model.verifyReadTransaction();
        }
        this.endReport();
    }

    public void clearContext() {
        this.model = null;
        this.location = null;
        this.construct = null;
        this.disabledAnalyzers.clear();
        this.arguments[1] = null;
        this.attributes = null;
        this.childAttributes = null;
    }

    public List<Analyzer> getDisabledAnalyzers() {
        return this.disabledAnalyzers;
    }

    public boolean enteringApplicationContent() {
        return this.applicationContextEntered;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public Auditor getAuditor() {
        return this.auditor;
    }

    @Override
    public AuditContext getEnclosingContext() {
        return this.enclosingContext;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public Workspace getWorkspace() {
        return this.model.getWorkspace();
    }

    @Override
    public Project getProject() {
        return this.model.getProject();
    }

    @Override
    public Context getIdeContext() {
        return this.model.getIdeContext();
    }

    @Override
    public URL getUrl() {
        return this.model.getUrl();
    }

    @Override
    public ModelAdapter getModel() {
        return this.model;
    }

    @Override
    public Location getLocation() {
        if (this.location == null) {
            this.location = this.model.getLocation(this.construct);
        }
        return this.location;
    }

    @Override
    public String getText() {
        Location location = this.getLocation();
        return this.model.getText(location.getOffset(), location.getLength());
    }

    @Override
    public int getLineOffset() {
        Location location = this.getLocation();
        return this.model.getLineOffset(location.getOffset());
    }

    @Override
    public int getOffset() {
        return this.getLocation().getOffset();
    }

    @Override
    public int getLength() {
        return this.getLocation().getLength();
    }

    @Override
    public boolean isCancelled() {
        return this.auditor.isCancelled();
    }

    @Override
    public void throwIfCancelled() {
        this.auditor.throwIfCancelled();
    }

    @Override
    public Location getLocation(Object construct) {
        Location location = construct instanceof ModelAdapter ? ((ModelAdapter)construct).getLocation() : (construct == null ? this.getLocation() : this.model.getLocation(construct));
        return location;
    }

    @Override
    public String getText(Object construct) {
        Location location = this.model.getLocation(construct);
        return this.model.getText(location.getOffset(), location.getLength());
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModel(Class<T> type, URL url, Project project, Workspace workspace) {
        return this.model.getFactory().getModelAdapter(type, url, project, workspace);
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModel(Class<T> type, URL url) {
        return this.getModel(type, url, this.getProject(), this.getWorkspace());
    }

    @Override
    public Analyzer getAnalyzer(Class<? extends Analyzer> analyzerClass) {
        return this.auditor.getBinding().getAnalyzer(analyzerClass);
    }

    @Override
    public AuditContext.Key key(Object object) {
        return new DefaultKey(object, this.attributeCount.postincrement());
    }

    @Override
    public AuditContext.Key sharedKey(Object object) {
        AuditContext.Key key = this.sharedAttributes.get(object);
        if (key != null) {
            return key;
        }
        key = new DefaultKey(object, this.attributeCount.postincrement());
        this.sharedAttributes.put(object, key);
        return key;
    }

    @Override
    public void setAttribute(AuditContext.Key key, Object value) {
        if (value == null) {
            value = NULL_VALUE;
        }
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.set(key.hashCode(), value);
    }

    @Override
    public void setAttribute(AuditContext.Key key, int value) {
        this.setAttribute(key, new Integer(value));
    }

    @Override
    public void setAttribute(AuditContext.Key key, float value) {
        this.setAttribute(key, new Float(value));
    }

    @Override
    public Object getAttribute(AuditContext.Key key) {
        int index = key.hashCode();
        DefaultAuditContext context = this;
        do {
            Object value;
            if (context.attributes == null || (value = context.attributes.get(index)) == null) continue;
            return value != NULL_VALUE ? value : null;
        } while ((context = context.enclosingContext) != null);
        return null;
    }

    @Override
    public int getAttribute(AuditContext.Key key, int defaultValue) {
        Object value = this.getAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).intValue();
    }

    @Override
    public float getAttribute(AuditContext.Key key, float defaultValue) {
        Object value = this.getAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).floatValue();
    }

    @Override
    public void setChildAttribute(Object child, AuditContext.Key key, Object value) {
        Attributes attributes;
        Location location = this.getLocation(child);
        int index = key.hashCode();
        if (this.childAttributes == null) {
            this.childAttributes = new HashMap<Location, Attributes>();
            attributes = new Attributes();
            this.childAttributes.put(location, attributes);
        } else {
            attributes = this.childAttributes.get(location);
            if (attributes == null) {
                attributes = new Attributes();
                this.childAttributes.put(location, attributes);
            }
        }
        if (value == null) {
            value = NULL_VALUE;
        }
        attributes.set(index, value);
    }

    @Override
    public void setParentAttribute(AuditContext.Key key, Object value) {
        if (this.enclosingContext != null) {
            this.enclosingContext.setAttribute(key, value);
        }
    }

    @Override
    public Object getChildAttribute(Object child, AuditContext.Key key) {
        Location location = this.getLocation(child);
        int index = key.hashCode();
        if (this.childAttributes == null) {
            return null;
        }
        Attributes attributes = this.childAttributes.get(location);
        if (attributes == null) {
            return null;
        }
        Object value = attributes.get(index);
        return value != NULL_VALUE ? value : null;
    }

    @Override
    public void enableGetChildAttribute() {
        if (this.enclosingContext == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        if (this.enclosingContext.childAttributes == null) {
            this.enclosingContext.childAttributes = new HashMap<Location, Attributes>();
        }
        this.enclosingContext.childAttributes.put(this.getLocation(), this.attributes);
    }

    @Override
    public void addDependency(Dependency dependency) {
        this.auditor.addDependency(dependency);
    }

    @Override
    public void addOptionalAnalysis(Issue issue) {
        this.auditor.addOptionalAnalysis(issue);
    }

    @Override
    public ViolationReport report(Rule rule) {
        if (!rule.isEnabled()) {
            return NULL_REPORT;
        }
        return this.auditor.report(this, rule, this.getLocation(), this.construct);
    }

    @Override
    public ViolationReport report(Rule rule, Object construct) {
        if (construct == null) {
            throw new IllegalArgumentException("construct == null");
        }
        if (!rule.isEnabled()) {
            return NULL_REPORT;
        }
        Location location = this.model.getLocation(construct);
        if (location == null) {
            throw new IllegalArgumentException("construct '" + construct + "' not in " + this.model + " while reporting " + rule.labelOrId());
        }
        return this.auditor.report(this, rule, location, construct);
    }

    @Override
    public ViolationReport report(Rule rule, ModelAdapter model, Object construct) {
        if (!rule.isEnabled()) {
            return NULL_REPORT;
        }
        if (model == null) {
            throw new IllegalArgumentException("model == null");
        }
        if (construct == null) {
            throw new IllegalArgumentException("construct == null");
        }
        return this.auditor.report(this, rule, model.getLocation(construct), construct);
    }

    @Override
    public ViolationReport report(Rule rule, Location location) {
        if (rule == null || !rule.isEnabled()) {
            return NULL_REPORT;
        }
        if (location == null) {
            location = this.getLocation();
        }
        return this.auditor.report(this, rule, location, null);
    }

    @Override
    public void report(Metric metric, Object measurement) {
        this.auditor.report(metric, this.getLocation(), measurement);
    }

    @Override
    public void report(Metric metric, int measurement) {
        this.report(metric, (Object)new Integer(measurement));
    }

    @Override
    public void report(Metric metric, float measurement) {
        this.report(metric, (Object)new Float(measurement));
    }

    public void endReport() {
        this.auditor.endReport();
    }

    public void cancelReport() {
        this.auditor.cancelReport();
    }

    @Override
    public void produceFragment(Class<? extends ModelType> fragmentType) {
        this.produceFragment(fragmentType, this.getLocation());
    }

    @Override
    public void produceFragment(Class<? extends ModelType> fragmentType, Object construct) {
        this.produceFragment(fragmentType, this.getLocation(construct));
    }

    @Override
    public void produceFragment(Class<? extends ModelType> fragmentType, Location location) {
        this.auditor.produceFragment(fragmentType, location);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[" + this.model.getShortLabel() + ", " + this.construct + ", depth " + this.depth + "]";
    }

    @Override
    public ModelAdapter getModelAdapter() {
        return this.getModel();
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModelAdapter(Class<T> type, URL url, Project project, Workspace workspace) {
        return this.getModel(type, url, project, workspace);
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModelAdapter(Class<T> type, URL url) {
        return this.getModel(type, url, this.getProject(), this.getWorkspace());
    }

    private class Attributes {
        private Object[] array;

        private Attributes() {
        }

        public void set(int index, Object value) {
            assert (index < DefaultAuditContext.this.attributeCount.intValue()) : "index " + index + " count " + DefaultAuditContext.access$100(DefaultAuditContext.this);
            if (this.array == null) {
                this.array = new Object[DefaultAuditContext.this.attributeCount.intValue()];
            } else if (index >= this.array.length) {
                Object[] old = this.array;
                this.array = new Object[DefaultAuditContext.this.attributeCount.intValue()];
                System.arraycopy(old, 0, this.array, 0, old.length);
            }
            this.array[index] = value;
        }

        public Object get(int index) {
            assert (index < DefaultAuditContext.this.attributeCount.intValue()) : "index " + index + " count " + DefaultAuditContext.access$100(DefaultAuditContext.this);
            if (this.array == null || index >= this.array.length) {
                return null;
            }
            return this.array[index];
        }

        public void clear() {
            this.array = null;
        }
    }

    private static class DefaultKey
    implements AuditContext.Key {
        private Object name;
        private int index;

        public DefaultKey(Object name, int index) {
            LOG.trace("created key {0}, {1}", index, name);
            this.name = name;
            this.index = index;
        }

        public boolean equals(Object object) {
            return object instanceof DefaultKey && this.index == ((DefaultKey)object).index;
        }

        public int hashCode() {
            return this.index;
        }

        public String toString() {
            return String.valueOf(this.name);
        }
    }
}

