/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.util.concurrent.CancellationException;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.log.AuditLogPage;
import oracle.jdevimpl.audit.profile.AuditDialog;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.util.Strings;

public class AuditController
implements Controller {
    private String baseLabel;
    private String singleSelectionLabel;
    private String multipleSelectionLabel;
    private ModelTypeFactory factory;
    private Context lastContext;
    private String lastLabel;
    private static final Log LOG = new Log("controller");
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);
    private static final Element[] NO_ELEMENTS = new Element[0];

    private AuditController(IdeAction action) {
        this.baseLabel = (String)action.getValue("Name");
        if (action.getValue("NoCtxName") == null) {
            action.putValue("NoCtxName", (Object)this.baseLabel);
        }
        action.addController((Controller)this);
    }

    public static AuditController createController(IdeAction action) {
        return new AuditController(action);
    }

    public String getBaseLabel() {
        return this.baseLabel;
    }

    public String getSingleSelectionLabel() {
        return this.singleSelectionLabel != null ? this.singleSelectionLabel : this.getBaseLabel();
    }

    public void setSingleSelectionLabel(String singleSelectionLabel) {
        this.singleSelectionLabel = singleSelectionLabel;
    }

    public String getMultipleSelectionLabel() {
        return this.multipleSelectionLabel != null ? this.multipleSelectionLabel : this.getBaseLabel();
    }

    public void setMultipleSelectionLabel(String multipleSelectionLabel) {
        this.multipleSelectionLabel = multipleSelectionLabel;
    }

    public ModelTypeFactory getFactory() {
        if (this.factory == null) {
            this.factory = AuditManager.getAuditManager().getDefaultModelTypeFactory();
        }
        return this.factory;
    }

    protected boolean isRunnable(String label) {
        return AuditLogPage.isReady(label);
    }

    public boolean update(IdeAction action, Context context) {
        ModelTypeFactory factory = this.getFactory();
        if (factory == null) {
            return false;
        }
        try {
            boolean enabled;
            Auditor auditor = AuditManager.getAuditManager().createAuditor(factory);
            Workspace workspace = context.getWorkspace();
            WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
            WorkingSet workingSet = workingSets.getCurrentWorkingSet();
            auditor.setWorkingSet(workingSet);
            Project project = context.getProject();
            Node node = context.getNode();
            Element[] selection = NO_ELEMENTS;
            if (!(context.getView() instanceof Editor)) {
                selection = context.getSelection();
            }
            LOG.trace("updating for {0}, selection {1}, {2}, {3}", (Object)node, (Object)selection, (Object)project, (Object)workspace);
            if (selection.length > 1) {
                this.lastContext = context;
                this.lastLabel = this.getMultipleSelectionLabel();
                enabled = this.isRunnable(this.lastLabel);
                if (enabled) {
                    for (Element element : selection) {
                        if (auditor.isAuditable(element, node, project, workspace)) continue;
                        enabled = false;
                        break;
                    }
                }
            } else if (selection.length == 1) {
                Element element = selection[0];
                if (element != null) {
                    this.lastContext = context;
                    this.lastLabel = element.getShortLabel();
                    enabled = this.isRunnable(this.lastLabel) && auditor.isAuditable(element, node, project, workspace);
                } else {
                    Log.error((String)"null element in selection");
                    enabled = false;
                }
            } else if (node != null) {
                this.lastContext = context;
                this.lastLabel = node.getShortLabel();
                enabled = this.isRunnable(this.lastLabel) && auditor.isAuditable((Element)node, node, project, workspace);
            } else {
                enabled = false;
            }
            LOG.trace("action enabled {0}, label {1}", enabled, (Object)this.lastLabel);
            action.setEnabled(enabled);
            String label = this.getBaseLabel();
            if (this.lastLabel != null && this.lastLabel.length() > 0) {
                label = Strings.toString(this.getSingleSelectionLabel(), new Object[]{this.lastLabel});
            }
            action.putValue("Name", (Object)label);
        }
        catch (AssertionError e) {
            AuditLogger.error("Exception updating audit action for {0}: {1}", (Throwable)((Object)e), context, e);
        }
        catch (Exception e) {
            AuditLogger.error("Exception updating audit action for {0}: {1}", e, context, e);
        }
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        context = this.lastContext;
        String label = this.lastLabel;
        try {
            Workspace workspace = context.getWorkspace();
            Project project = context.getProject();
            Node node = context.getNode();
            Element[] selection = NO_ELEMENTS;
            if (!(context.getView() instanceof Editor)) {
                selection = context.getSelection();
            }
            LOG.trace("handling event on {4} for {0}, selection {1}, {2}, {3}", (Object)node, (Object)selection, (Object)project, (Object)workspace, (Object)action);
            ModelTypeFactory factory = this.getFactory();
            if (factory == null) {
                return false;
            }
            AuditManager manager = AuditManager.getAuditManager();
            Auditor auditor = manager.createAuditor(factory);
            auditor.setIgnoreAssists(true);
            WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
            WorkingSet workingSet = workingSets.getCurrentWorkingSet();
            auditor.setWorkingSet(workingSet);
            boolean auditable = false;
            if (node == null) {
                for (Element element : selection) {
                    auditable |= auditor.addElement(element, node, project, workspace);
                }
            } else {
                auditable = selection.length == 0 ? auditor.addElement((Element)node, node, project, workspace) : auditor.addElements(selection, node, project, workspace);
            }
            if (!auditable) {
                MessageDialog dialog = new MessageDialog();
                dialog.setTitle(BUNDLE.get("audit.not-auditable.title"));
                String message = selection.length > 1 ? "audit.not-auditable.files.message" : "audit.not-auditable.file.message";
                dialog.setContent(BUNDLE.get(message, new Object[]{project.getShortLabel()}));
                dialog.setType(MessageDialog.WARNING);
                dialog.show();
                return true;
            }
            Profile profile = new AuditDialog(this.lastLabel).show();
            if (profile == null) {
                return true;
            }
            auditor.setProfile(profile);
            manager.runShowLogPage(auditor, label, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e instanceof CancellationException)) {
                        MessageDialog dialog = new MessageDialog();
                        dialog.setTitle(BUNDLE.get("audit.exception.title"));
                        dialog.setContent(BUNDLE.get("audit.exception.message", new Object[]{e}));
                        dialog.setType(MessageDialog.ERROR);
                        dialog.show();
                    }
                }
            });
        }
        catch (Throwable e) {
            Log.error((String)"Unexpected exception during audit: {1}", (Object)e);
            throw new UnexpectedExceptionError(e);
        }
        return true;
    }

    public String toString() {
        return "AuditController \"" + this.getBaseLabel() + "\"";
    }
}

