/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.bean;

import java.awt.event.ActionListener;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.bean.AbstractEnumerationField;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdeveloper.audit.service.TypeSafeEnumerationFactory;

public class TypeSafeEnumerationField
extends AbstractEnumerationField
implements ActionListener {
    private TypeSafeEnumerationFactory descriptor;
    private String[] labels;
    private Object[] values;
    private static final Log LOG = new Log("beanpanel");

    @Override
    public void setType(Class type) {
        assert (TypeSafeEnumeration.class.isAssignableFrom(type));
        super.setType(type);
        this.descriptor = TypeSafeEnumerationFactory.factory(type);
        String[] tags = this.descriptor.getTags();
        this.labels = new String[tags.length];
        this.values = new Object[tags.length];
        LOG.trace("setting type of {0} to {1}, tags {2}", (Object)this, (Object)type, (Object)tags);
        for (int i = 0; i < tags.length; ++i) {
            String tag = tags[i];
            this.values[i] = this.descriptor.value(tag);
            this.labels[i] = this.descriptor.label(this.values[i]);
        }
        this.setEnumerals(this.labels);
    }

    @Override
    public String stringOf(Object value) {
        String result = null;
        for (int i = 0; i < this.values.length; ++i) {
            if (value != this.values[i]) continue;
            result = this.labels[i];
            break;
        }
        LOG.trace("mapped {0} to {1}", value, result);
        assert (result != null);
        return result;
    }

    @Override
    public Object valueOf(String text) {
        assert (this.labels.length == this.values.length);
        Object result = null;
        for (int i = 0; i < this.labels.length; ++i) {
            if (text != this.labels[i]) continue;
            result = this.values[i];
            break;
        }
        LOG.trace("mapped {0} to {1}", (Object)text, result);
        return result;
    }
}

