/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.bean;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.util.ChangeSupport;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.bean.BeanCustomizer;
import oracle.jdeveloper.audit.bean.PropertyField;
import oracle.jdeveloper.audit.bean.PropertyFieldListener;
import oracle.jdeveloper.audit.bean.PropertyItem;
import oracle.jdevimpl.audit.bean.BeanFieldFactory;
import oracle.jdevimpl.audit.bean.ExceptionField;
import oracle.jdevimpl.audit.util.Strings;

public class BeanPanel
extends JPanel
implements Scrollable {
    private Map customizers;
    private Object bean;
    private BeanCustomizer customizer;
    private List<PropertyItem> items;
    private String reservedMnemonics = "";
    private boolean mnemonicAssignmentEnabled = false;
    private ChangeHandler handler = new ChangeHandler();
    private Dimension preferredScrollableViewportSize;
    private ChangeSupport support = new ChangeSupport((Object)this);
    private static final Log LOG = new Log("field");

    public BeanPanel(Map customizers) {
        super(new GridBagLayout());
        this.customizers = customizers;
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    public void setBean(Object bean) {
        LOG.trace("setting model to {0}", bean);
        this.flush();
        this.removeAll();
        this.items = new ArrayList<PropertyItem>();
        this.bean = bean;
        if (bean == null) {
            return;
        }
        this.customizer = this.getCustomizer(bean);
        try {
            int c;
            PropertyDescriptor[] descriptors = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors();
            Arrays.sort(descriptors, new Comparator<PropertyDescriptor>(){

                @Override
                public int compare(PropertyDescriptor p1, PropertyDescriptor p2) {
                    return p1.getName().compareTo(p2.getName());
                }
            });
            LinkedHashMap<String, PropertyDescriptor> map = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor descriptor : descriptors) {
                if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null) continue;
                map.put(descriptor.getName(), descriptor);
            }
            LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
            this.fillGroup(root, map, this.customizer);
            for (Map.Entry entry : map.entrySet()) {
                root.put((String)entry.getKey(), entry.getValue());
            }
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridy = 0;
            constraints.anchor = 18;
            constraints.fill = 2;
            constraints.insets.top = 5;
            constraints.insets.left = 5;
            constraints.insets.right = 5;
            char[] mnemonics = new char[128];
            for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
                mnemonics[c] = c;
                mnemonics[c - 97 + 65] = c;
            }
            for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
                mnemonics[c] = c;
            }
            for (int i = 0; i < this.reservedMnemonics.length(); ++i) {
                this.mnemonic(this.reservedMnemonics.charAt(i), mnemonics);
            }
            this.processGroup(root, constraints, mnemonics);
            for (PropertyItem item : this.items) {
                int mnemonic;
                if (item.getMnemonic() != 0 || (mnemonic = this.mnemonic(item.getLabelText(), mnemonics)) == 0) continue;
                item.setMnemonic(mnemonic);
            }
            constraints.gridx = 0;
            constraints.gridwidth = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            this.add(Box.createVerticalStrut(4), constraints);
        }
        catch (IntrospectionException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    private void processGroup(Map<String, Object> descriptors, GridBagConstraints constraints, char[] mnemonics) {
        for (Map.Entry<String, Object> entry : descriptors.entrySet()) {
            String name = entry.getKey();
            if (Boolean.FALSE.equals(this.customizer.visible(this.bean, name))) continue;
            if (entry.getValue() instanceof PropertyDescriptor) {
                PropertyField item = this.createField((PropertyDescriptor)entry.getValue(), this.bean);
                if (item == null) continue;
                this.items.add(item);
                item.setName(name);
                String labelText = this.customizer.label(this.bean, name);
                if (labelText == null) {
                    labelText = Strings.capitalizeAndSeparateAll(name);
                    item.setLabelText(labelText);
                } else {
                    int mnemonic = StringUtils.getMnemonicKeyCode((String)labelText);
                    int mnemonicIndex = StringUtils.getMnemonicIndex((String)labelText);
                    labelText = StringUtils.stripMnemonic((String)labelText);
                    item.setLabelText(labelText);
                    if (mnemonic > 0) {
                        item.setMnemonic(mnemonic);
                        item.setMnemonicIndex(mnemonicIndex);
                        this.mnemonic(mnemonic, mnemonics);
                    }
                }
                JLabel label = item.getLabel();
                boolean modifiable = !Boolean.FALSE.equals(this.customizer.modifiable(this.bean, name));
                constraints.gridx = 0;
                if (label == null) {
                    constraints.gridwidth = 2;
                } else {
                    label.setEnabled(modifiable);
                    constraints.gridwidth = 1;
                    constraints.weightx = 0.0;
                    this.add((Component)label, constraints);
                    constraints.gridx = 1;
                }
                constraints.weightx = 1.0;
                Component component = item.getComponent();
                component.setEnabled(modifiable);
                this.add(component, constraints);
                ++constraints.gridy;
                continue;
            }
            constraints.insets.left += 10;
            this.processGroup((Map)entry.getValue(), constraints, mnemonics);
            constraints.insets.left -= 10;
        }
    }

    private PropertyField createField(PropertyDescriptor descriptor, Object model) {
        PropertyField field;
        String name = descriptor.getName();
        Class<?> type = this.customizer.type(model, name);
        if (type == null) {
            type = descriptor.getPropertyType();
        }
        if ((field = this.customizer.field(model, name)) == null) {
            field = BeanFieldFactory.getField(type);
        }
        LOG.trace("got field {0} for {1} of {2}", (Object)field, (Object)name, type);
        if (field != null) {
            field.setDescriptor(descriptor);
            field.setType(type);
            try {
                field.load(model);
            }
            catch (Throwable e) {
                field = new ExceptionField(e);
            }
            field.addFieldListener(this.handler);
        }
        return field;
    }

    private void fillGroup(Map<String, Object> group, Map<String, PropertyDescriptor> descriptors, BeanCustomizer customizer) {
        String[] names = customizer.items(this.bean, null);
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (name == null) {
                    group.put(null, null);
                    continue;
                }
                PropertyDescriptor descriptor = descriptors.get(name);
                if (descriptor != null) {
                    group.put(name, descriptor);
                    continue;
                }
                LinkedHashMap<String, Object> nestedGroup = new LinkedHashMap<String, Object>();
                this.fillGroup(nestedGroup, descriptors, customizer);
                group.put(name, nestedGroup);
            }
        }
    }

    private int mnemonic(String text, char[] mnemonics) {
        char c = this.mnemonic(text.charAt(0), mnemonics);
        if (c != '\u0000') {
            return c;
        }
        List<String> words = Strings.tokens(text, ' ');
        for (String word : words) {
            c = this.mnemonic(word.charAt(0), mnemonics);
            if (c == '\u0000') continue;
            return c;
        }
        for (int i = 1; i < text.length(); ++i) {
            c = this.mnemonic(text.charAt(i), mnemonics);
            if (c == '\u0000') continue;
            return c;
        }
        return 0;
    }

    private char mnemonic(int c, char[] mnemonics) {
        if (c >= mnemonics.length) {
            return '\u0000';
        }
        char mnemonic = mnemonics[c];
        if (mnemonic != '\u0000') {
            mnemonics[mnemonic] = '\u0000';
            mnemonics[c] = '\u0000';
        }
        return mnemonic;
    }

    public boolean isMnemonicAssignmentEnabled() {
        return this.mnemonicAssignmentEnabled;
    }

    public void setMnemonicAssignmentEnabled(boolean mnemonicAssignmentEnabled) {
        this.mnemonicAssignmentEnabled = mnemonicAssignmentEnabled;
    }

    public String getReservedMnemonics() {
        return this.reservedMnemonics;
    }

    public void setReservedMnemonics(String reservedMnemonics) {
        this.reservedMnemonics = reservedMnemonics.toUpperCase();
    }

    public boolean flush() {
        return this.handler.flush();
    }

    protected String getLabel(Object model, String name, String label) {
        return label;
    }

    protected Class getType(Object model, String name, Class type) {
        return type;
    }

    private BeanCustomizer getCustomizer(Object bean) {
        Class<?> beanClass = bean.getClass();
        CompositeBeanCustomizer composite = new CompositeBeanCustomizer();
        do {
            BeanCustomizer customizer;
            if ((customizer = (BeanCustomizer)this.customizers.get(beanClass)) == null) continue;
            composite.add(customizer);
        } while ((beanClass = beanClass.getSuperclass()) != null);
        return composite;
    }

    public void setPreferredScrollableViewportSize(Dimension size) {
        this.preferredScrollableViewportSize = size;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredScrollableViewportSize != null ? this.preferredScrollableViewportSize : this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    private static class CompositeBeanCustomizer
    extends BeanCustomizer {
        private List<BeanCustomizer> customizers = new ArrayList<BeanCustomizer>();

        private CompositeBeanCustomizer() {
        }

        public void add(BeanCustomizer customizer) {
            assert (customizer != this);
            assert (!(customizer instanceof CompositeBeanCustomizer)) : customizer;
            this.customizers.add(customizer);
        }

        public Class getType() {
            return this.customizers.isEmpty() ? Object.class : this.customizers.get(0).getType();
        }

        @Override
        public Boolean visible(Object bean, String itemName) {
            for (int i = 0; i < this.customizers.size(); ++i) {
                BeanCustomizer customizer = this.customizers.get(i);
                assert (customizer != this);
                Boolean value = customizer.visible(bean, itemName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public String[] items(Object bean, String groupName) {
            for (int i = 0; i < this.customizers.size(); ++i) {
                BeanCustomizer customizer = this.customizers.get(i);
                assert (customizer != this);
                String[] value = customizer.items(bean, groupName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public Class type(Object bean, String propertyName) {
            for (int i = 0; i < this.customizers.size(); ++i) {
                BeanCustomizer customizer = this.customizers.get(i);
                assert (customizer != this);
                Class value = customizer.type(bean, propertyName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public String label(Object bean, String itemName) {
            for (int i = 0; i < this.customizers.size(); ++i) {
                BeanCustomizer customizer = this.customizers.get(i);
                assert (customizer != this);
                String value = customizer.label(bean, itemName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public PropertyField field(Object bean, String propertyName) {
            for (int i = 0; i < this.customizers.size(); ++i) {
                BeanCustomizer customizer = this.customizers.get(i);
                assert (customizer != this);
                PropertyField value = customizer.field(bean, propertyName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public Boolean modifiable(Object bean, String itemName) {
            for (int i = 0; i < this.customizers.size(); ++i) {
                BeanCustomizer customizer = this.customizers.get(i);
                assert (customizer != this);
                Boolean value = customizer.modifiable(bean, itemName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public String valid(Object bean) {
            for (int i = 0; i < this.customizers.size(); ++i) {
                BeanCustomizer customizer = this.customizers.get(i);
                String value = customizer.valid(bean);
                if (value == null) continue;
                return value;
            }
            return null;
        }
    }

    private class ChangeHandler
    implements PropertyFieldListener {
        private PropertyField lastFieldChanged = null;

        private ChangeHandler() {
        }

        public boolean flush() {
            if (BeanPanel.this.bean != null && this.lastFieldChanged != null) {
                try {
                    LOG.trace("flushing changes to {0}", (Object)this.lastFieldChanged);
                    this.lastFieldChanged.apply(BeanPanel.this.bean);
                    for (PropertyItem item : BeanPanel.this.items) {
                        String name = item.getName();
                        boolean modifiable = !Boolean.FALSE.equals(BeanPanel.this.customizer.modifiable(BeanPanel.this.bean, name));
                        JLabel label = item.getLabel();
                        if (label != null) {
                            label.setEnabled(modifiable);
                        }
                        item.getComponent().setEnabled(modifiable);
                    }
                    return true;
                }
                catch (Exception e) {
                    LOG.trace("handling exception for {0} : {1}", (Object)this.lastFieldChanged, (Object)e);
                    this.lastFieldChanged.handleException(e);
                    this.lastFieldChanged.getComponent().requestFocus();
                    return false;
                }
            }
            return true;
        }

        @Override
        public void fieldEntered(PropertyField field) {
            LOG.trace("field entered {0}", (Object)field);
            this.flush();
        }

        @Override
        public void fieldChanged(PropertyField field) {
            this.lastFieldChanged = field;
            LOG.trace("field changed {0}", (Object)this.lastFieldChanged);
            BeanPanel.this.support.fireStateChanged();
        }

        @Override
        public void fieldCommitted(PropertyField field) {
            LOG.trace("field committed {0}", (Object)field);
            this.flush();
        }

        @Override
        public void fieldExited(PropertyField field) {
            LOG.trace("field exited {0}", (Object)field);
        }
    }
}

