/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.bean;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.bean.PropertyField;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdevimpl.audit.bean.ArrayField;
import oracle.jdevimpl.audit.bean.BooleanField;
import oracle.jdevimpl.audit.bean.ByteField;
import oracle.jdevimpl.audit.bean.DoubleField;
import oracle.jdevimpl.audit.bean.ExceptionField;
import oracle.jdevimpl.audit.bean.FloatField;
import oracle.jdevimpl.audit.bean.IntegerField;
import oracle.jdevimpl.audit.bean.LongField;
import oracle.jdevimpl.audit.bean.PatternField;
import oracle.jdevimpl.audit.bean.ShortField;
import oracle.jdevimpl.audit.bean.StringField;
import oracle.jdevimpl.audit.bean.TypeSafeEnumerationField;

public class BeanFieldFactory {
    private static Map registry = new HashMap();
    private static final Log LOG = new Log("field");

    public static PropertyField getField(Class type) {
        PropertyField field;
        Class fieldClass = (Class<ArrayField>)registry.get(type);
        if (type.isArray()) {
            fieldClass = ArrayField.class;
            registry.put(type, fieldClass);
        } else if (fieldClass == null) {
            if (TypeSafeEnumeration.class.isAssignableFrom(type)) {
                fieldClass = TypeSafeEnumerationField.class;
                registry.put(type, fieldClass);
            } else {
                LOG.trace("no field found for {0}", (Object)type);
                return null;
            }
        }
        LOG.trace("found field {0} for {1}", fieldClass, (Object)type);
        try {
            field = (PropertyField)fieldClass.newInstance();
        }
        catch (Exception e) {
            field = new ExceptionField(e);
        }
        LOG.trace("returning field {0}", (Object)field);
        return field;
    }

    static {
        registry.put(Boolean.class, BooleanField.class);
        registry.put(Boolean.TYPE, BooleanField.class);
        registry.put(String.class, StringField.class);
        registry.put(Byte.class, ByteField.class);
        registry.put(Byte.TYPE, ByteField.class);
        registry.put(Short.class, ShortField.class);
        registry.put(Short.TYPE, ShortField.class);
        registry.put(Integer.class, IntegerField.class);
        registry.put(Integer.TYPE, IntegerField.class);
        registry.put(Long.class, LongField.class);
        registry.put(Long.TYPE, LongField.class);
        registry.put(Float.class, FloatField.class);
        registry.put(Float.TYPE, FloatField.class);
        registry.put(Double.class, DoubleField.class);
        registry.put(Double.TYPE, DoubleField.class);
        registry.put(Pattern.class, PatternField.class);
    }
}

