/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.transform.TransformSequenceContext;

public abstract class TransformAdapter {
    private List<Command> deferredCommands;
    private Region selectionRegion;
    private int selectionMargin;
    private int selectionEndMargin;
    private List<Region> highlights;
    private List<Region> removedHighlights;

    public abstract Class getContextClass();

    public abstract TransformContext createContext(Transform var1, Violation var2, Location var3);

    public boolean isTransformable(TransformContext context) {
        Node node = context.getNode();
        return !node.isReadOnly() || VCSManager.getVCSManager().isVersioned(node.getURL());
    }

    public Boolean makeTransformable(TransformContext context) throws Exception {
        return this.makeWritable(context.getNode(), context.getProject(), context.getWorkspace());
    }

    protected Boolean makeWritable(Node node, Project project, Workspace workspace) throws Exception {
        if (node.isReadOnly() && VCSManager.getVCSManager().isVersioned(node.getURL())) {
            String commandClass = VCSManager.getVCSManager().getCheckOutCommand(node);
            Command command = CommandProcessor.createCommand((String)commandClass, (Context)new Context(null, workspace, project, node));
            CommandProcessor.getInstance().invoke(command);
            return !node.isReadOnly();
        }
        return null;
    }

    public void beginTransformSequence(TransformSequenceContext sequenceContext) throws InterruptedException, Exception {
    }

    public abstract void beginTransform(TransformContext var1) throws Exception;

    public void beginTransform(TransformContext context, TransformSequenceContext sequenceContext) throws InterruptedException, Exception {
        this.beginTransform(context);
    }

    public abstract void endTransform(TransformContext var1) throws Exception;

    public abstract void cancelTransform(TransformContext var1) throws Exception;

    public void setPredecessorApplyData(TransformContext context, Object applyData) {
        context.setPredecessorApplyData(applyData);
    }

    public void endTransformSequence(TransformSequenceContext sequenceContext) throws Exception {
    }

    public void cancelTransformSequence(TransformSequenceContext sequenceContext) throws Exception {
    }

    public void invokeLater(Command command) {
        if (this.deferredCommands == null) {
            this.deferredCommands = new ArrayList<Command>();
        }
        this.deferredCommands.add(command);
    }

    public List getDeferredCommands() {
        List result = this.deferredCommands;
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        this.deferredCommands = null;
        return result;
    }

    public void setSelection(ModelAdapter model, Object construct, int margin, int endMargin) {
        if (model == null) {
            throw new IllegalArgumentException("model null");
        }
        if (construct == null) {
            throw new IllegalArgumentException("construct null");
        }
        this.selectionRegion = new ConstructRegion(model, construct);
        this.selectionMargin = margin;
        this.selectionEndMargin = endMargin;
    }

    public void setSelection(Location location, int margin, int endMargin) {
        if (location == null) {
            throw new IllegalArgumentException("model null");
        }
        this.selectionRegion = new LocationRegion(location);
        this.selectionMargin = margin;
        this.selectionEndMargin = endMargin;
    }

    public Location getSelection() {
        if (this.selectionRegion == null) {
            return null;
        }
        Location location = this.selectionRegion.getLocation();
        if (this.selectionMargin != 0 || this.selectionEndMargin != 0) {
            int offset = location.getOffset();
            int endOffset = location.getEndOffset();
            int width = endOffset - offset;
            this.selectionMargin = Math.min(this.selectionMargin, width);
            this.selectionEndMargin = Math.min(this.selectionEndMargin, width);
            int selectionOffset = offset + this.selectionMargin;
            int selectionEndOffset = endOffset - this.selectionEndMargin;
            if (selectionOffset > selectionEndOffset) {
                selectionOffset = selectionEndOffset;
            }
            location = location.getModel().getLocation(selectionOffset, selectionEndOffset - selectionOffset);
        }
        this.selectionRegion = null;
        return location;
    }

    public void addHighlight(ModelAdapter model, Object construct) {
        if (construct == null) {
            return;
        }
        if (this.highlights == null) {
            this.highlights = new ArrayList<Region>();
        }
        this.highlights.add(new ConstructRegion(model, construct));
    }

    public void addRemovedHighlight(ModelAdapter model, Object construct) {
        if (construct == null) {
            return;
        }
        if (this.removedHighlights == null) {
            this.removedHighlights = new ArrayList<Region>();
        }
        this.removedHighlights.add(new ConstructRegion(model, construct));
    }

    public Collection<Location> getHighlightRegions(TransformContext context) {
        ArrayList<Location> locations = new ArrayList<Location>();
        if (this.highlights != null) {
            for (Region region : this.highlights) {
                locations.addAll(region.getLocations());
            }
        }
        if (this.removedHighlights != null) {
            for (Region region : this.removedHighlights) {
                locations.addAll(region.getLocations());
            }
        }
        this.highlights = null;
        this.removedHighlights = null;
        return locations;
    }

    public class ConstructRegion
    extends Region {
        private ModelAdapter model;
        private List<Object> constructs;

        public ConstructRegion(ModelAdapter model, Object construct) {
            this.model = model;
            if (construct instanceof Object[]) {
                construct = Arrays.asList((Object[])construct);
            }
            if (construct instanceof List) {
                List<Object> list = construct;
                this.constructs = new ArrayList<Object>(list.size());
                this.constructs.addAll(list);
            } else {
                this.constructs = Collections.singletonList(construct);
            }
        }

        @Override
        public Location getLocation() {
            this.model.verifyReadTransaction();
            if (this.constructs.isEmpty()) {
                return null;
            }
            int offset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (Object construct : this.constructs) {
                if (construct == null) continue;
                Location elementLocation = this.model.getLocation(construct);
                offset = Math.min(offset, elementLocation.getOffset());
                endOffset = Math.max(endOffset, elementLocation.getEndOffset());
            }
            if (endOffset == Integer.MIN_VALUE) {
                return null;
            }
            Location location = this.model.getLocation(offset, endOffset - offset);
            return location;
        }

        @Override
        public List<Location> getLocations() {
            this.model.verifyReadTransaction();
            ArrayList<Location> locations = new ArrayList<Location>(this.constructs.size());
            for (Object construct : this.constructs) {
                if (construct == null) continue;
                locations.add(this.model.getLocation(construct));
            }
            return locations;
        }
    }

    public class LocationRegion
    extends Region {
        private Location location;

        public LocationRegion(Location location) {
            this.location = location;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public List<Location> getLocations() {
            return Collections.singletonList(this.location);
        }
    }

    public abstract class Region {
        public abstract Location getLocation();

        public abstract List<Location> getLocations();
    }
}

