/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.TextFileModelAdapter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.TextTransformContext;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;

public class TextTransformAdapter
extends TransformAdapter {
    private UndoableEditCommand command;
    private TextBuffer buffer;
    private Location selection;

    @Override
    public Class getContextClass() {
        return TextTransformContext.class;
    }

    @Override
    public TransformContext createContext(Transform transform, Violation violation, Location location) {
        return new TextTransformContext(this, transform, violation, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransform(TransformContext context) {
        TextFileModelAdapter model = (TextFileModelAdapter)context.getModel();
        this.buffer = model.getTextBuffer();
        int cid = this.buffer.getChangeId();
        model.endRead();
        try {
            this.buffer.writeLock();
        }
        finally {
            model.beginRead();
        }
        boolean succeeded = false;
        try {
            if (cid != this.buffer.getChangeId()) {
                throw new ExpiredTextBufferException();
            }
            this.command = this.createUndoableEditCommand((TextTransformContext)context);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.clearTransaction();
            }
        }
    }

    protected UndoableEditCommand createUndoableEditCommand(TextTransformContext context) {
        return new UndoableEditCommand(context.getTransform().boundLabel(context), context.getTextNode(), context.getProject(), context.getWorkspace());
    }

    protected TextBuffer getBuffer() {
        if (this.command == null) {
            throw new IllegalStateException("no transaction in progress");
        }
        return this.buffer;
    }

    @Override
    public void endTransform(TransformContext context) throws Exception {
        if (this.command == null) {
            throw new IllegalStateException("no transaction in progress");
        }
        List<UndoableEdit> edits = ((TextTransformContext)context).getEdits();
        if (!edits.isEmpty()) {
            this.command.addEdits(edits);
            Location selection = this.getSelection();
            if (selection != null) {
                this.command.setSelection(selection.getModel().getUrl(), selection.getOffset(), selection.getLength());
            }
            CommandProcessor.getInstance().invoke((Command)this.command);
        }
        this.clearTransaction();
    }

    @Override
    public void cancelTransform(TransformContext context) throws Exception {
        this.clearTransaction();
    }

    private void clearTransaction() {
        this.command = null;
        this.buffer.writeUnlock();
        this.buffer = null;
        this.selection = null;
    }
}

