/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideri.util.Product;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.service.DefaultProfile;
import oracle.jdeveloper.audit.service.Profile;

public class ProfileRepository {
    public static final String ALL_RULES = "all-rules";
    public static final String ALL_METRICS = "all-metrics";
    public static final String AUDIT_RULES = "audit-rules";
    public static final String CODE_ASSIST_RULES = "code-assist-rules";
    public static final String STATUS_RULES = "status-rules";
    public static final String COMPILE_RULES = "compile-rules";
    private URL directory = null;
    private Map<String, Profile> profilesByName;
    private Map<String, Profile> defaultProfilesById;
    private Profile fallbackProfile;
    private static final Log LOG = new Log("audit-initialization");
    private static ProfileRepository auditRepository;
    private boolean scanning = false;

    public static ProfileRepository getRepository() {
        if (auditRepository == null) {
            auditRepository = new ProfileRepository();
        }
        return auditRepository;
    }

    private ProfileRepository() {
        LOG.trace("creating profile repository");
    }

    public List<Profile> getProfiles() {
        this.scan();
        return new ArrayList<Profile>(this.profilesByName.values());
    }

    public boolean exists(String name) {
        this.scan();
        return this.profilesByName.containsKey(ProfileRepository.normalizeProfileName(name));
    }

    public Profile getProfile(String name) {
        if (name == null) {
            return null;
        }
        this.scan();
        return this.profilesByName.get(ProfileRepository.normalizeProfileName(name));
    }

    public Profile getProfile(String name, String id) {
        Profile profile;
        this.scan();
        if (name != null && (profile = this.profilesByName.get(ProfileRepository.normalizeProfileName(name))) != null) {
            return profile;
        }
        if (id != null) {
            Collection<Profile> profiles = this.profilesByName.values();
            for (Profile profile2 : profiles) {
                if (!id.equals(profile2.getKey())) continue;
                return profile2;
            }
        }
        return this.getFallbackProfile();
    }

    public Profile getDefaultProfile(String id) {
        if (id == null) {
            return null;
        }
        this.scan();
        return this.defaultProfilesById.get(id);
    }

    public void save(Profile profile) throws IOException {
        Profile oldProfile;
        String name = profile.getName();
        URL oldUrl = profile.getURL();
        if (oldUrl == null && (oldProfile = this.profilesByName.get(ProfileRepository.normalizeProfileName(name))) != null) {
            oldUrl = oldProfile.getURL();
        }
        URL url = this.getURL(this.directory, name, oldUrl);
        LOG.trace("saving profile {0} to {1}", (Object)profile, (Object)url);
        profile.save(url);
        this.profilesByName.put(ProfileRepository.normalizeProfileName(name), profile);
    }

    public void delete(Profile profile) {
        LOG.trace("deleting {0}", (Object)profile);
        URLFileSystem.delete((URL)profile.getURL());
        String name = profile.getName();
        this.profilesByName.remove(ProfileRepository.normalizeProfileName(name));
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scan() {
        if (this.directory != null) {
            return;
        }
        LOG.trace("scanning profile repository {0}", this.scanning);
        PerformanceLogger.get().startTiming("ProfileRepository.scan");
        this.scanning = true;
        boolean directoryExists = false;
        try {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            URL system = registry.getSystemDirectory(Product.getProductID());
            this.directory = ProfileRepository.profileDirectory(system);
            directoryExists = URLFileSystem.exists((URL)this.directory);
            HashMap<String, Profile> defaultProfilesByName = new HashMap<String, Profile>();
            this.defaultProfilesById = new LinkedHashMap<String, Profile>();
            LOG.trace("scanning predefined profiles");
            for (Profile profile : AuditManager.getAuditManager().getProfiles()) {
                String key = profile.getKey();
                if (key == null) {
                    Log.error((String)"profile {0} created with null creation key", (Object)profile);
                    continue;
                }
                if (this.defaultProfilesById.containsKey(key)) {
                    Log.error((String)"profile {0} duplicates profile {1}", (Object)profile, (Object)this.defaultProfilesById.get(key));
                    continue;
                }
                String name = profile.getName();
                String normalizedName = ProfileRepository.normalizeProfileName(name);
                if (defaultProfilesByName.containsKey(normalizedName)) {
                    Log.error((String)"profile {0} duplicates profile {1}", (Object)profile, (Object)this.defaultProfilesById.get(key));
                    continue;
                }
                this.defaultProfilesById.put(key, profile);
                defaultProfilesByName.put(normalizedName, profile);
            }
            LOG.trace("scanning {0}", (Object)this.directory);
            this.profilesByName = new LinkedHashMap<String, Profile>();
            HashSet<String> missingDefaultProfiles = new HashSet<String>(this.defaultProfilesById.keySet());
            if (URLFileSystem.mkdirs((URL)this.directory)) {
                URL[] files = URLFileSystem.list((URL)this.directory);
                if (files != null) {
                    DefaultProfile.NameScanner scanner = new DefaultProfile.NameScanner();
                    for (URL url : files) {
                        DefaultProfile profile;
                        Profile defaultProfile;
                        String fileName = URLFileSystem.getFileName((URL)url);
                        if (!fileName.endsWith(".xml")) continue;
                        scanner.scan(url);
                        if (!scanner.isValid()) continue;
                        String name = scanner.getName();
                        String normalizedName = ProfileRepository.normalizeProfileName(name);
                        String key = scanner.getKey();
                        if (key != null) {
                            defaultProfile = this.defaultProfilesById.get(key);
                            if (defaultProfile == null) continue;
                            name = defaultProfile.getName();
                            profile = new DefaultProfile(key, name, url);
                            missingDefaultProfiles.remove(key);
                        } else {
                            defaultProfile = (Profile)defaultProfilesByName.get(normalizedName);
                            if (defaultProfile != null) {
                                key = defaultProfile.getKey();
                                profile = new DefaultProfile(key, name, url);
                                missingDefaultProfiles.remove(key);
                            } else {
                                profile = new DefaultProfile(name, url);
                            }
                        }
                        this.profilesByName.put(normalizedName, profile);
                    }
                }
            } else {
                Log.error((String)"Audit profile directory {0} not created", (Object)URLFileSystem.getPlatformPathName((URL)this.directory));
            }
            for (String key : missingDefaultProfiles) {
                Profile defaultProfile = this.defaultProfilesById.get(key);
                LOG.trace("scanning predefined profile {0}", (Object)defaultProfile);
                String name = defaultProfile.getName();
                String normalizedName = ProfileRepository.normalizeProfileName(name);
                if (this.profilesByName.containsKey(normalizedName)) continue;
                try {
                    URL url;
                    url = this.getURL(this.directory, name);
                    LOG.trace("saving profile {0} to {1}", (Object)defaultProfile, (Object)url);
                    DefaultProfile profile = new DefaultProfile(defaultProfile);
                    ((Profile)profile).save(url);
                    this.profilesByName.put(normalizedName, profile);
                }
                catch (Throwable e) {
                    Log.error((String)"unexpected exception saving profile {0}: {1}", (Object)name, (Object)e);
                }
            }
            if (this.profilesByName.isEmpty()) {
                this.getFallbackProfile();
            }
            LOG.trace("loaded {0}", this.profilesByName);
            this.scanning = false;
        }
        catch (Throwable throwable) {
            this.scanning = false;
            PerformanceLogger.get().stopTiming("ProfileRepository.scan", directoryExists ? "Scanning existing Audit profile repository" : "Creating and populating Audit profile repository (one-time)", 50);
            throw throwable;
        }
        PerformanceLogger.get().stopTiming("ProfileRepository.scan", directoryExists ? "Scanning existing Audit profile repository" : "Creating and populating Audit profile repository (one-time)", 50);
    }

    private Profile getFallbackProfile() {
        if (this.fallbackProfile == null) {
            String name = "All";
            Log.error((String)"creating fallback profile {0}", (Object)name);
            this.fallbackProfile = new DefaultProfile(name);
            this.profilesByName.put(ProfileRepository.normalizeProfileName(name), this.fallbackProfile);
        }
        return this.fallbackProfile;
    }

    public static URL profileDirectory(URL system) {
        return URLFactory.newDirURL((URL)URLFactory.newDirURL((URL)system, (String)"audit"), (String)"profiles");
    }

    private URL getURL(URL directory, String name, URL oldURL) {
        URL oldDirectory;
        if (oldURL != null && URLFileSystem.equals((URL)directory, (URL)(oldDirectory = URLFileSystem.getParent((URL)oldURL)))) {
            return oldURL;
        }
        return this.getURL(directory, name);
    }

    private URL getURL(URL directory, String name) {
        String sanitizedName = ProfileRepository.sanitizeFileName(name);
        URL url = URLFactory.newURL((URL)directory, (String)(sanitizedName + ".xml"));
        if (URLFileSystem.exists((URL)url) || !URLFileSystem.canCreate((URL)url)) {
            url = URLFactory.newURL((URL)directory, (String)(sanitizedName + "-1.xml"));
            int i = 2;
            while (URLFileSystem.exists((URL)url)) {
                url = URLFactory.newURL((URL)directory, (String)(sanitizedName + "-" + i + ".xml"));
                ++i;
            }
        }
        return url;
    }

    public static String normalizeProfileName(String name) {
        int length = name.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (Character.isWhitespace(c)) continue;
            buffer.append(Character.toUpperCase(c));
        }
        return buffer.toString();
    }

    public static String sanitizeFileName(String name) {
        name = name.trim();
        StringBuffer buffer = new StringBuffer(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (c >= '0' && c <= '9') {
                    buffer.append(c);
                    continue;
                }
                if (c >= 'A' && c <= 'Z') {
                    buffer.append((char)(c - 65 + 97));
                    continue;
                }
                if (c >= 'a' && c <= 'z') {
                    buffer.append(c);
                    continue;
                }
                buffer.append(97 + c % 25);
                continue;
            }
            if (Character.isSpaceChar(c)) {
                buffer.append('-');
                continue;
            }
            buffer.append('_');
        }
        return buffer.toString();
    }
}

