/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.event.ChangeListener;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ChangeSupport;
import oracle.javatools.util.Log;
import oracle.javatools.util.Maps;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileTransaction;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdeveloper.audit.service.TypeSafeEnumerationFactory;
import oracle.jdevimpl.audit.util.Strings;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultProfile
extends Profile {
    public static final String FORMAT_PREFIX = "Audit Profile ";
    public static final String FORMAT_VERSION = "11.1.1-1";
    public static final String FORMAT = "Audit Profile 11.1.1-1";
    private String name;
    private URL url;
    private String key;
    private static final Set<Class<? extends Analyzer>> badClasses = new HashSet<Class<? extends Analyzer>>();
    private static Map<Class<? extends Analyzer>, List<Pair<Field, String>>> fieldsByAnalyzer = new Maps.SoftHashMap();
    private static Map<String, String> oversimplifiedNames;
    private Collection<Class<? extends Analyzer>> analyzerClasses;
    private Map<String, List<Profile.Setter>> settersByBean;
    private static final Log LOG;
    private static final Log LOG_DETAIL;
    private static final Log LOG_SEVERITY_STYLE;
    private ChangeSupport support = new ChangeSupport((Object)this);
    private Method ruleEnabledSetter = null;
    private Method metricEnabledSetter = null;

    public DefaultProfile(String name, URL url) {
        this.setName(name);
        this.setURL(url);
        if (!URLFileSystem.exists((URL)url)) {
            throw new IllegalArgumentException("File " + URLFileSystem.getPlatformPathName((URL)url) + " not found");
        }
    }

    public DefaultProfile(String key, String name, URL url) {
        this(name, url);
        if (key == null) {
            throw new NullPointerException("When using this constructor, the key cannot be null");
        }
        this.key = key;
    }

    public DefaultProfile(String name, Class<? extends Analyzer> ... analyzers) {
        this(name, Arrays.asList(analyzers));
    }

    public DefaultProfile(String name, List<Class<? extends Analyzer>> analyzers) {
        this.setName(name);
        this.analyzerClasses = analyzers;
        this.settersByBean = new LinkedHashMap<String, List<Profile.Setter>>();
        for (ExtensionBean bean : this.createInstances().getBeans()) {
            this.setEnabled(bean, true);
        }
    }

    public DefaultProfile(String name) {
        this.setName(name);
        this.settersByBean = new LinkedHashMap<String, List<Profile.Setter>>();
        for (ExtensionBean bean : this.createInstances().getBeans()) {
            this.setEnabled(bean, true);
        }
    }

    DefaultProfile(String name, Collection<ExtensionBean> beans) {
        this.setName(name);
        this.applyChanges(beans);
    }

    public DefaultProfile(Profile profile) {
        DefaultProfile p = (DefaultProfile)profile;
        this.name = p.name;
        this.key = p.key;
        this.url = p.url;
        this.analyzerClasses = p.analyzerClasses;
        this.settersByBean = p.settersByBean;
    }

    private void setEnabled(ExtensionBean bean, boolean enabled) {
        Metric metric;
        if (bean instanceof Rule) {
            Rule rule = (Rule)bean;
            if (rule.isEnabled() != enabled) {
                ArrayList<Profile.Setter> setters = new ArrayList<Profile.Setter>();
                setters.add(new Profile.Setter(this.getRuleEnabledSetter(), enabled));
                this.settersByBean.put(bean.id(), setters);
            }
        } else if (bean instanceof Metric && (metric = (Metric)bean).isEnabled() != enabled) {
            ArrayList<Profile.Setter> setters = new ArrayList<Profile.Setter>();
            setters.add(new Profile.Setter(this.getMetricEnabledSetter(), enabled));
            this.settersByBean.put(bean.id(), setters);
        }
    }

    private Method getRuleEnabledSetter() {
        if (this.ruleEnabledSetter == null) {
            try {
                this.ruleEnabledSetter = Rule.class.getMethod("setEnabled", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                Log.error((String)"Exception getting setEnabled method from Rule: {0}", (Object)e);
            }
        }
        return this.ruleEnabledSetter;
    }

    private Method getMetricEnabledSetter() {
        if (this.metricEnabledSetter == null) {
            try {
                this.metricEnabledSetter = Metric.class.getMethod("setEnabled", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                Log.error((String)"Exception getting setEnabled method from Metric: {0}", (Object)e);
            }
        }
        return this.metricEnabledSetter;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDefault() {
        return this.key != null;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    private void setURL(URL url) {
        if (url == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.url = url;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public synchronized Collection<Class<? extends Analyzer>> getAnalyzerClasses() {
        if (this.analyzerClasses == null) {
            AuditManager manager = AuditManager.getAuditManager();
            this.analyzerClasses = manager.getAnalyzers();
        }
        return this.analyzerClasses;
    }

    @Override
    public ProfileTransaction createTransaction() {
        return new ProfileTransaction(this);
    }

    synchronized void applyChanges(Collection<ExtensionBean> beans) {
        this.settersByBean = new HashMap<String, List<Profile.Setter>>();
        Profile.Instances instances = this.createDefaultInstances();
        for (ExtensionBean modifiedBean : beans) {
            List<Profile.Setter> setters;
            String id = modifiedBean.id();
            ExtensionBean defaultBean = instances.getBean(id);
            if (defaultBean == null || (setters = this.getSetters(defaultBean, modifiedBean)) == null) continue;
            this.settersByBean.put(id, setters);
        }
        this.support.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void save(URL url) throws IOException {
        LOG.trace("saving {0} to {1}", (Object)this, (Object)url);
        this.load();
        LOG_DETAIL.trace("saving setters {0}", this.settersByBean);
        BufferedOutputStream stream = new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url));
        AuditEncoder encoder = new AuditEncoder(stream);
        encoder.setExceptionListener(new EncoderListener(url));
        encoder.setPersistenceDelegate(Profile.Setter.class, new SetterPersistenceDelegate());
        try {
            encoder.writeObject(FORMAT);
            encoder.writeObject(this.name);
            encoder.writeObject(this.key != null ? this.key : "");
            encoder.writeObject(this.settersByBean);
            this.url = url;
        }
        finally {
            encoder.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        LOG.trace("loading {0}", (Object)this);
        if (this.settersByBean == null) {
            if (this.url == null) {
                throw new IllegalStateException("profile not reusable");
            }
            if (URLFileSystem.exists((URL)this.url)) {
                this.settersByBean = new LinkedHashMap<String, List<Profile.Setter>>();
                try {
                    InputStream stream = URLFileSystem.openInputStream((URL)this.url);
                    XMLDecoder decoder = new XMLDecoder(stream);
                    decoder.setExceptionListener(new DecoderListener(this.url));
                    try {
                        boolean oversimplifiedSetters;
                        boolean simplifiedSetters;
                        String formatOrName = (String)decoder.readObject();
                        if (formatOrName.startsWith(FORMAT_PREFIX)) {
                            String savedName = (String)decoder.readObject();
                            String savedKey = (String)decoder.readObject();
                            if (this.name == null) {
                                this.name = savedName;
                                this.key = savedKey != null && savedKey.trim().length() == 0 ? null : savedKey;
                            }
                            simplifiedSetters = formatOrName.indexOf("10.1.3") < 0;
                            oversimplifiedSetters = formatOrName.endsWith("11.1.1");
                            LOG.trace("loaded format {0}, name {1}, key {2}", (Object)formatOrName, (Object)savedName, (Object)savedKey);
                        } else {
                            Boolean predefined = (Boolean)decoder.readObject();
                            decoder.readObject();
                            if (this.name == null) {
                                this.name = formatOrName;
                                this.key = Boolean.TRUE.equals(predefined) ? DefaultProfile.inferKeyFromURL(this.url) : null;
                            }
                            oversimplifiedSetters = false;
                            simplifiedSetters = false;
                        }
                        if (simplifiedSetters) {
                            Map map = (Map)decoder.readObject();
                            if (oversimplifiedSetters) {
                                Map<String, String> qualifiedNameBySimpleName = this.getOversimplifiedNames();
                                for (Map.Entry entry : map.entrySet()) {
                                    String name = (String)entry.getKey();
                                    List setters = (List)entry.getValue();
                                    if (name.indexOf(".") <= 0) {
                                        String expansion = qualifiedNameBySimpleName.get(name);
                                        if (expansion == null) continue;
                                        if (name.equals("syntax-error")) {
                                            setters.add(new Profile.Setter(this.getRuleEnabledSetter(), true));
                                            this.settersByBean.put("java-errors.syntax-error", setters);
                                            this.settersByBean.put("css-category.syntax-error", setters);
                                            this.settersByBean.put("javascript-errors.syntax-error", setters);
                                            continue;
                                        }
                                        if (name.equals("semantic-error")) {
                                            setters.add(new Profile.Setter(this.getRuleEnabledSetter(), true));
                                            this.settersByBean.put("java-errors.semantic-error", setters);
                                            this.settersByBean.put("css-category.semantic-error", setters);
                                            continue;
                                        }
                                        this.settersByBean.put(expansion, setters);
                                        continue;
                                    }
                                    this.settersByBean.put(name, setters);
                                }
                            } else {
                                this.settersByBean = map;
                            }
                        } else {
                            for (Map setters : ((Map)decoder.readObject()).values()) {
                                this.settersByBean.putAll(setters);
                            }
                        }
                        LOG_DETAIL.trace("loaded setters {0}", this.settersByBean);
                    }
                    finally {
                        decoder.close();
                    }
                }
                catch (IOException e) {
                    AuditLogger.error("Unexpected exception loading profile {0}: {1}", e, this.url, e);
                }
            }
        }
    }

    private Map<String, String> getOversimplifiedNames() {
        if (oversimplifiedNames == null) {
            oversimplifiedNames = new HashMap<String, String>();
            for (ExtensionBean bean : this.createDefaultInstances().getBeans()) {
                if (bean.extensionId() != null) continue;
                String qualifiedName = bean.id();
                String simpleName = Strings.lastToken(qualifiedName, '.');
                oversimplifiedNames.put(simpleName, qualifiedName);
            }
        }
        return oversimplifiedNames;
    }

    @Override
    public synchronized Profile.Instances createInstances() {
        Profile.Instances instances = this.createDefaultInstances();
        this.load();
        for (Map.Entry<String, List<Profile.Setter>> entry : this.settersByBean.entrySet()) {
            ExtensionBean bean = instances.getBean(entry.getKey());
            if (bean == null) continue;
            for (Profile.Setter setter : entry.getValue()) {
                setter.invoke(bean);
            }
        }
        if (LOG_SEVERITY_STYLE.isEnabled()) {
            for (ExtensionBean bean : instances.getBeans()) {
                String style;
                Rule rule;
                String severity;
                if (!(bean instanceof Rule) || (severity = (rule = (Rule)bean).getSeverity().toString().toLowerCase()).equals(style = rule.getStyle().toString().toLowerCase()) || "unused".equals(style)) continue;
                LOG_SEVERITY_STYLE.trace("Rule {0} has severity {1} and style {2}", (Object)rule.id(), (Object)severity, (Object)style);
            }
        }
        return instances;
    }

    private Profile.Instances createDefaultInstances() {
        Collection<Class<? extends Analyzer>> analyzerClasses = this.getAnalyzerClasses();
        LinkedHashMap<Class<? extends Analyzer>, Analyzer> analyzers = new LinkedHashMap<Class<? extends Analyzer>, Analyzer>();
        for (Class<? extends Analyzer> analyzerClass : analyzerClasses) {
            try {
                Analyzer analyzer = analyzerClass.newInstance();
                analyzers.put(analyzerClass, analyzer);
            }
            catch (Throwable e) {
                if (!badClasses.add(analyzerClass)) continue;
                AuditLogger.error("Analyzer {0} ignored because it could not be created: {1}", e, analyzerClass, e);
            }
        }
        LinkedHashMap<String, ExtensionBean> beans = new LinkedHashMap<String, ExtensionBean>();
        HashMap<Analyzer, Collection<ExtensionBean>> beansPerAnalyzer = new HashMap<Analyzer, Collection<ExtensionBean>>();
        AuditManager manager = AuditManager.getAuditManager();
        Map<String, ExtensionBean> declarativeBeans = manager.getBeans();
        IdentityHashMap context = new IdentityHashMap();
        for (Analyzer analyzer : analyzers.values()) {
            Class<?> analyzerClass = analyzer.getClass();
            ArrayList<ExtensionBean> analyzerBeans = new ArrayList<ExtensionBean>();
            beansPerAnalyzer.put(analyzer, analyzerBeans);
            try {
                Metric[] metrics;
                for (Pair<Field, String> field : this.getFields(analyzerClass, declarativeBeans)) {
                    String id = (String)field.getSecond();
                    ExtensionBean copy = (ExtensionBean)beans.get(id);
                    if (copy == null) {
                        ExtensionBean bean = declarativeBeans.get(id);
                        copy = this.copy(bean, context);
                        if (copy == null) continue;
                        beans.put(id, copy);
                        Category category = copy instanceof Rule ? ((Rule)copy).category() : (copy instanceof Metric ? ((Metric)copy).getCategory() : (copy instanceof Category ? ((Category)copy).getCategory() : null));
                        this.addCategory(category, beans);
                    }
                    ((Field)field.getFirst()).set(analyzer, copy);
                    analyzerBeans.add(copy);
                }
                Rule[] rules = analyzer.getRules();
                if (rules != null) {
                    for (int k = 0; k < rules.length; ++k) {
                        Rule rule = rules[k];
                        ExtensionBean alreadyDefined = beans.put(rule.id(), rule);
                        if (alreadyDefined == null) {
                            analyzerBeans.add(rule);
                        } else {
                            beans.put(rule.id(), alreadyDefined);
                            rule.logError("Rule ''{0}'' already defined by extension ''{1}'': ignored", rule.id(), alreadyDefined.extensionId());
                        }
                        this.addCategory(rule.category(), beans);
                    }
                }
                if ((metrics = analyzer.getMetrics()) == null) continue;
                for (int k = 0; k < metrics.length; ++k) {
                    Metric metric = metrics[k];
                    ExtensionBean alreadyDefined = beans.put(metric.id(), metric);
                    if (alreadyDefined == null) {
                        analyzerBeans.add(metric);
                    } else {
                        beans.put(metric.id(), alreadyDefined);
                        metric.logError("Metric ''{0}'' already defined by extension ''{1}'': ignored", metric.id(), alreadyDefined.extensionId());
                    }
                    this.addCategory(metric.getCategory(), beans);
                }
            }
            catch (Throwable e) {
                if (!badClasses.add(analyzerClass)) continue;
                AuditLogger.error("Analyzer {0} ignored because it could not be created: {1}", e, analyzerClass, e);
            }
        }
        return new Profile.Instances(analyzers, beans, beansPerAnalyzer);
    }

    private void addCategory(Category category, Map<String, ExtensionBean> beans) {
        while (category != null) {
            String categoryId = category.id();
            ExtensionBean oldCategory = beans.put(categoryId, category);
            if (oldCategory != null) {
                if (oldCategory == category) break;
                beans.put(categoryId, oldCategory);
                break;
            }
            category = category.getCategory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<Field, String>> getFields(Class<? extends Analyzer> type, Map<String, ExtensionBean> declarativeBeans) {
        Map<Class<? extends Analyzer>, List<Pair<Field, String>>> map = fieldsByAnalyzer;
        synchronized (map) {
            List<Pair<Field, String>> fields = fieldsByAnalyzer.get(type);
            if (fields != null) {
                return fields;
            }
            fields = new ArrayList<Pair<Field, String>>();
            fieldsByAnalyzer.put(type, fields);
            for (Field field : type.getDeclaredFields()) {
                ExtensionResource annotation = field.getAnnotation(ExtensionResource.class);
                if (annotation == null) continue;
                field.setAccessible(true);
                String id = annotation.value();
                ExtensionBean bean = declarativeBeans.get(id);
                if (field.getType().isInstance(bean)) {
                    fields.add((Pair<Field, String>)new Pair((Object)field, (Object)id));
                    continue;
                }
                if (bean != null) {
                    bean.logError("Field ''{0}'' of analyzer ''{1}'' has type ''{2}'' but references bean ''{3}'' of type ''{4}''", field.getName(), type.getSimpleName(), field.getType().getSimpleName(), id, bean.getClass().getSimpleName());
                    continue;
                }
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log(Level.SEVERE, "Field ''{0}'' of analyzer ''{1}'' references undefined bean ''{2}''", new Object[]{field.getName(), type.getSimpleName(), id});
            }
            Class<? extends Analyzer> superType = type.getSuperclass();
            if (superType != Analyzer.class) {
                fields.addAll(this.getFields(superType, declarativeBeans));
            }
            return fields;
        }
    }

    private ExtensionBean copy(ExtensionBean bean, IdentityHashMap context) {
        if (bean == null) {
            return null;
        }
        try {
            return bean.createCopy(context);
        }
        catch (Throwable e) {
            bean.logError("exception copying bean '{0}' of class '{1}' from extension '{2}': {3}", e, bean.id(), bean.getClass(), bean.extensionId(), e);
            return null;
        }
    }

    private List<Profile.Setter> getSetters(ExtensionBean from, ExtensionBean to) {
        if (from == null) {
            return null;
        }
        assert (to.getClass() == from.getClass());
        PropertyDescriptor property = null;
        try {
            PropertyDescriptor[] properties = Introspector.getBeanInfo(to.getClass()).getPropertyDescriptors();
            ArrayList<Profile.Setter> list = null;
            for (int i = 0; i < properties.length; ++i) {
                Method getter;
                property = properties[i];
                if (property.getWriteMethod() == null || (getter = property.getReadMethod()) == null) continue;
                Object defaultValue = getter.invoke((Object)from, new Object[0]);
                Object value = getter.invoke((Object)to, new Object[0]);
                assert (value == null || defaultValue == null || value.getClass() == defaultValue.getClass());
                if (DefaultProfile.equal(value, defaultValue)) continue;
                if (list == null) {
                    list = new ArrayList<Profile.Setter>();
                }
                Profile.Setter setter = new Profile.Setter(property.getWriteMethod(), value);
                list.add(setter);
            }
            return list;
        }
        catch (Exception e) {
            Log.error((String)"introspection of {0} of {1} failed: {2}", property, (Object)to, (Object)e);
            return Collections.emptyList();
        }
    }

    private static boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o1 instanceof Object[])) {
            return o1.equals(o2);
        }
        if (!(o2 instanceof Object[])) {
            return false;
        }
        Object[] a1 = (Object[])o1;
        Object[] a2 = (Object[])o2;
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a2.length; ++i) {
            if (DefaultProfile.equal(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    private static String inferKeyFromURL(URL url) {
        String fileName = URLFileSystem.getName((URL)url);
        String key = "all-metrics".equals(fileName) ? DefaultProfile.key("oracle.jdeveloper.audit.service.ProfileRepository", "ALL_METRICS") : ("all-rules".equals(fileName) ? DefaultProfile.key("oracle.jdeveloper.audit.service.ProfileRepository", "ALL_RULES") : ("audit-rules".equals(fileName) ? DefaultProfile.key("oracle.jdeveloper.audit.service.ProfileRepository", "AUDIT_RULES") : ("code-assist-rules".equals(fileName) ? DefaultProfile.key("oracle.jdeveloper.audit.service.ProfileRepository", "CODE_ASSIST_RULES") : ("javadoc-rules".equals(fileName) ? DefaultProfile.key("oracle.jdevimpl.javadoc.audit.DocCommenter", "JAVADOC_RULES") : ("audit-metrics-profile".equals(fileName) ? DefaultProfile.key("oracle.jdeveloper.audit.service.ProfileRepository", "ALL_METRICS") : ("audit-all-profile".equals(fileName) ? DefaultProfile.key("oracle.jdeveloper.audit.service.ProfileRepository", "ALL_RULES") : ("audit-default-profile".equals(fileName) ? DefaultProfile.key("oracle.jdeveloper.audit.service.ProfileRepository", "AUDIT_RULES") : ("audit-assist-profile".equals(fileName) ? DefaultProfile.key("oracle.jdeveloper.audit.service.ProfileRepository", "CODE_ASSIST_RULES") : ("Javadoc".equals(fileName) ? DefaultProfile.key("oracle.jdevimpl.javadoc.audit.DocCommenter", "JAVADOC_RULES") : null)))))))));
        return key;
    }

    private static String key(String className, String fieldName) {
        try {
            Class<?> clas = Class.forName(className);
            Field field = clas.getField(fieldName);
            return (String)field.get(null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public boolean equals(Object object) {
        return object instanceof Profile && this.getName().equalsIgnoreCase(((Profile)object).getName());
    }

    public int hashCode() {
        return this.getName().toLowerCase().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("profile ");
        buffer.append(this.name);
        buffer.append("(key ");
        buffer.append(this.key);
        buffer.append(')');
        return buffer.toString();
    }

    static {
        LOG = new Log("profile", "profile-detail");
        LOG_DETAIL = new Log("profile-detail");
        LOG_SEVERITY_STYLE = new Log("severity-style");
    }

    private static class AuditEncoder
    extends XMLEncoder {
        private static PersistenceDelegate typeSafeEnumerationPersistenceDelegate;

        public AuditEncoder(OutputStream stream) {
            super(stream);
            if (typeSafeEnumerationPersistenceDelegate == null) {
                typeSafeEnumerationPersistenceDelegate = new TypeSafeEnumerationPersistenceDelegate();
            }
            AuditManager manager = AuditManager.getAuditManager();
            for (Map.Entry<Class<?>, PersistenceDelegate> binding : manager.getPersistenceDelegates().entrySet()) {
                this.setPersistenceDelegate(binding.getKey(), binding.getValue());
            }
        }

        public PersistenceDelegate getPersistenceDelegate(Class type) {
            if (type != null && TypeSafeEnumeration.class.isAssignableFrom(type)) {
                return typeSafeEnumerationPersistenceDelegate;
            }
            return super.getPersistenceDelegate(type);
        }

        public static class TypeSafeEnumerationPersistenceDelegate
        extends PersistenceDelegate {
            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                TypeSafeEnumeration value = (TypeSafeEnumeration)oldInstance;
                return new Expression(value, TypeSafeEnumerationFactory.class, "value", new Object[]{value.getClass(), value.toString()});
            }
        }
    }

    public static class NameScanner
    extends DefaultHandler {
        private SAXParser parser = new SAXParser();
        private URL url;
        private StringBuffer buffer;
        private boolean valid;
        private String name;
        private String key;
        private static final int FORMAT_OR_NAME = 0;
        private static final int PREDEFINED = 1;
        private static final int NAME = 2;
        private static final int KEY = 3;
        private int state;

        public NameScanner() {
            this.parser.setPreserveWhitespace(false);
            this.parser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
            this.parser.setPreserveWhitespace(false);
            this.parser.setContentHandler((ContentHandler)this);
        }

        public NameScanner(URL url) {
            this();
            this.scan(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scan(URL url) {
            LOG.trace("scanning {0} for name", (Object)url);
            this.url = url;
            this.valid = false;
            this.key = null;
            this.name = null;
            this.buffer = null;
            this.state = 0;
            InputStream stream = null;
            try {
                stream = URLFileSystem.openInputStream((URL)url);
                this.parser.parse(stream);
                LOG.trace("scanning completed");
            }
            catch (SAXException e) {
                String message = e.getMessage();
                if ("valid".equals(message) || "invalid".equals(message)) {
                    LOG.trace("scanning completed with SAXException {0}", (Object)message);
                } else {
                    LOG.trace("scanning completed with SAXException {0}", (Object)e);
                }
            }
            catch (Exception e) {
                LOG.trace("scanning completed with exception {0}", (Object)e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            block11: {
                block13: {
                    block12: {
                        block10: {
                            LOG.trace("starting element {0}, {1}, {2}", (Object)localName, (Object)qualifiedName, (Object)attributes);
                            if (!"string".equals(qualifiedName)) break block10;
                            switch (this.state) {
                                case 0: 
                                case 2: 
                                case 3: {
                                    this.buffer = new StringBuffer();
                                    break block11;
                                }
                                default: {
                                    throw new SAXException("invalid");
                                }
                            }
                        }
                        if (!"null".equals(qualifiedName)) break block12;
                        switch (this.state) {
                            case 3: {
                                this.buffer = new StringBuffer();
                                break block11;
                            }
                            default: {
                                throw new SAXException("invalid");
                            }
                        }
                    }
                    if (!"boolean".equals(qualifiedName)) break block13;
                    switch (this.state) {
                        case 1: {
                            this.buffer = new StringBuffer();
                            break block11;
                        }
                        default: {
                            throw new SAXException("invalid");
                        }
                    }
                }
                if (this.state != 0) {
                    throw new SAXException("invalid");
                }
            }
        }

        @Override
        public void characters(char[] characters, int offset, int length) {
            if (this.buffer != null) {
                this.buffer.append(characters, offset, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
            LOG.trace("starting element {0}, {1}, buffer {2}", (Object)localName, (Object)qualifiedName, (Object)this.buffer);
            if ("string".equals(qualifiedName)) {
                if (this.buffer == null) {
                    throw new SAXException("invalid");
                }
                switch (this.state) {
                    case 0: {
                        String format = this.buffer.toString().trim();
                        if (format.startsWith(DefaultProfile.FORMAT_PREFIX)) {
                            this.state = 2;
                            break;
                        }
                        this.name = format;
                        this.state = 1;
                        break;
                    }
                    case 2: {
                        this.name = this.buffer.toString().trim();
                        this.state = 3;
                        break;
                    }
                    case 3: {
                        this.key = this.buffer.toString().trim();
                        if (this.key.equals("")) {
                            this.key = null;
                        }
                        this.valid = true;
                        throw new SAXException("valid");
                    }
                    default: {
                        throw new SAXException("invalid");
                    }
                }
            } else {
                if ("null".equals(qualifiedName)) {
                    if (this.buffer == null) {
                        throw new SAXException("invalid");
                    }
                    switch (this.state) {
                        case 3: {
                            this.key = null;
                            this.valid = true;
                            throw new SAXException("valid");
                        }
                    }
                    throw new SAXException("invalid");
                }
                if ("boolean".equals(qualifiedName)) {
                    if (this.buffer == null) {
                        throw new SAXException("invalid");
                    }
                    switch (this.state) {
                        case 1: {
                            this.key = Boolean.valueOf(this.buffer.toString()) != false ? DefaultProfile.inferKeyFromURL(this.url) : null;
                            this.valid = true;
                            throw new SAXException("valid");
                        }
                    }
                    throw new SAXException("invalid");
                }
                if (this.state != 0) {
                    throw new SAXException("invalid");
                }
            }
        }
    }

    private static class DecoderListener
    implements ExceptionListener {
        private URL url;

        public DecoderListener(URL url) {
            this.url = url;
        }

        @Override
        public void exceptionThrown(Exception e) {
            LOG.trace("exception decoding {0}: {1}", (Object)this.url, (Object)e);
        }
    }

    private static class EncoderListener
    implements ExceptionListener {
        private URL url;

        public EncoderListener(URL url) {
            this.url = url;
        }

        @Override
        public void exceptionThrown(Exception e) {
            LOG.trace("exception encoding {0}: {1}", (Object)this.url, (Object)e);
        }
    }

    private static class SetterPersistenceDelegate
    extends PersistenceDelegate {
        private SetterPersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Profile.Setter setter = (Profile.Setter)oldInstance;
            return new Expression(oldInstance, Profile.Setter.class, "new", new Object[]{setter.getMethod(), setter.getValue()});
        }
    }
}

