/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextBufferTracker;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.FileModelAdapter;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.service.Editors;
import oracle.jdevimpl.audit.util.Strings;

public abstract class TextFileModelAdapter
extends FileModelAdapter {
    private int initialLength = Integer.MAX_VALUE;
    private TextBufferTracker tracker;
    private int initialVersion;
    private volatile TextBuffer buffer;
    private int activeCount;
    private static final Log LOG = new Log("buffer");
    private int[] offsetLength = new int[2];

    public TextFileModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, Node node, URL url) {
        super(factory, type, workspace, project, directory, node, url);
        assert (node instanceof TextNode);
        this.tracker = TextBufferTracker.getTracker((TextNode)((TextNode)node));
        this.initialVersion = this.tracker.getVersion();
    }

    public TextFileModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, Node node, URL url, String primaryCollationString) {
        super(factory, type, workspace, project, directory, node, url, primaryCollationString);
        assert (node instanceof TextNode);
        this.tracker = TextBufferTracker.getTracker((TextNode)((TextNode)node));
        this.initialVersion = this.tracker.getVersion();
    }

    public TextNode getTextNode() {
        return (TextNode)this.getNode();
    }

    @Override
    public boolean isModifiable() {
        return !this.getNode().isReadOnly();
    }

    @Override
    public boolean isModified() {
        return this.tracker.isModified(this.initialVersion);
    }

    @Override
    public boolean isModified(Location location) {
        int length;
        int offset = location.offset();
        if (offset == Integer.MAX_VALUE) {
            offset = this.initialLength;
        }
        if ((length = location.length()) == Integer.MAX_VALUE) {
            length = this.initialLength;
        }
        return this.tracker.isModified(offset, length, this.initialVersion);
    }

    @Override
    public int getInitialLength() {
        return this.initialLength;
    }

    @Override
    public Location getLocation(int offset, int length) {
        int version = this.tracker.getVersion();
        if (version == 0) {
            if (offset <= Short.MAX_VALUE && length <= Short.MAX_VALUE) {
                return new TextLocationShort0(this, (short)offset, (short)length);
            }
            return new TextLocationInt0(this, offset, length);
        }
        if (offset <= Short.MAX_VALUE && length <= Short.MAX_VALUE) {
            return new TextLocationShort(this, (short)offset, (short)length, version);
        }
        return new TextLocationInt(this, offset, length, version);
    }

    protected synchronized int getDeltaLength(int offset, int length, int version) {
        this.tracker.adjustOffsetLength(offset, length, version, this.offsetLength);
        return this.offsetLength[1] - length;
    }

    protected synchronized int getDeltaOffset(int offset, int version) {
        this.tracker.adjustOffsetLength(offset, 0, version, this.offsetLength);
        return this.offsetLength[0] - offset;
    }

    @Override
    protected boolean acquireReadLock(WriteLockRequestListener listener) {
        ReadWriteLock lock = this.getLock();
        lock.readLock();
        return listener != null && lock.addWriteLockRequestListener(listener);
    }

    @Override
    protected void releaseReadLock(WriteLockRequestListener listener) {
        ReadWriteLock lock = this.getLock();
        if (listener != null) {
            lock.removeWriteLockRequestListener(listener);
        }
        lock.readUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beginReadHook() {
        TextBuffer buffer = this.getTextNode().acquireTextBuffer();
        TextFileModelAdapter textFileModelAdapter = this;
        synchronized (textFileModelAdapter) {
            if (this.activeCount++ == 0) {
                assert (this.buffer == null);
                this.buffer = buffer;
                if (this.initialLength == Integer.MAX_VALUE) {
                    this.initialLength = buffer.getLength();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void endReadHook() {
        TextFileModelAdapter textFileModelAdapter = this;
        synchronized (textFileModelAdapter) {
            if (--this.activeCount == 0) {
                this.buffer = null;
            }
        }
    }

    @Override
    public char getCharacter(int offset) {
        this.verifyReadTransaction();
        assert (this.buffer != null) : "no read transaction active on " + this;
        return this.buffer.getChar(offset);
    }

    @Override
    public int getColumnOffset(int offset) {
        this.verifyReadTransaction();
        LineMap map = this.buffer.getLineMap();
        assert (this.buffer != null) : "no read transaction active on " + this;
        return offset - map.getLineStartOffset(map.getLineFromOffset(offset));
    }

    @Override
    public Location getFocusLocation(Location location) {
        this.verifyReadTransaction();
        assert (this.buffer != null) : "no read transaction active on " + this;
        int offset = location.getOffset();
        int endOffset = location.getEndOffset();
        int line = this.buffer.getLineMap().getLineFromOffset(offset);
        int lineEndOffset = this.buffer.getLineMap().getLineEndOffset(line);
        if (lineEndOffset < endOffset) {
            location = this.getLocation(offset, lineEndOffset - offset - 1);
        }
        return location;
    }

    @Override
    public String getLine(int offset) {
        this.verifyReadTransaction();
        assert (this.buffer != null) : "no read transaction active on " + this;
        LineMap map = this.buffer.getLineMap();
        int line = map.getLineFromOffset(offset);
        int start = map.getLineStartOffset(line);
        int end = map.getLineEndOffset(line);
        return this.buffer.getString(start, end - start);
    }

    @Override
    public int getLineOffset(int offset) {
        this.verifyReadTransaction();
        assert (this.buffer != null) : "no read transaction active on " + this;
        return this.buffer.getLineMap().getLineFromOffset(offset);
    }

    @Override
    public final Object getRoot() {
        LOG.trace("getting root of {0}", (Object)this);
        this.verifyReadTransaction();
        assert (this.buffer != null) : "no read transaction active on " + this;
        Object root = this.getRootImplementation();
        return root;
    }

    public abstract Object getRootImplementation();

    @Override
    public String getText(int offset, int length) {
        this.verifyReadTransaction();
        assert (this.buffer != null) : "no read transaction active on " + this;
        return this.buffer.getString(offset, length);
    }

    public TextBuffer getTextBuffer() {
        this.verifyReadTransaction();
        assert (this.buffer != null) : "no read transaction active on " + this;
        return this.buffer;
    }

    @Override
    public boolean isEditable(Location location) {
        return true;
    }

    @Override
    public boolean edit(Location location) {
        LOG.trace("opening {0} in editor", (Object)location);
        assert (location.getModel() == this);
        Node node = location.getModel().getNode();
        Project project = location.getProject();
        Workspace workspace = location.getWorkspace();
        int offset = location.getOffset();
        int length = location.getLength();
        return Editors.editNode(workspace, project, node, offset, length, false);
    }

    @Override
    public synchronized void release() {
        LOG.trace("releasing {0}", (Object)this);
        if (this.buffer != null) {
            LOG.trace("read transaction still active on {0}", (Object)this);
        }
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String contextDescription(Location location) {
        StringBuilder builder = new StringBuilder(location.toString());
        this.beginRead();
        try {
            int endLine;
            int startLine;
            LineMap map = this.buffer.getLineMap();
            int offset = Math.min(this.buffer.getLength(), location.getOffset());
            int endOffset = Math.min(this.buffer.getLength(), location.getEndOffset());
            int lastLine = map.getLineCount() - 1;
            if (offset >= 0 && endOffset >= offset) {
                startLine = map.getLineFromOffset(offset);
                endLine = map.getLineFromOffset(endOffset);
                int startColumn = offset - map.getLineStartOffset(startLine);
                int endColumn = endOffset - map.getLineStartOffset(endLine);
                builder.append(" [");
                builder.append(startLine + 1);
                builder.append(",");
                builder.append(startColumn);
                builder.append(":");
                builder.append(endLine + 1);
                builder.append(",");
                builder.append(endColumn);
                builder.append(")");
            } else {
                offset = Math.max(0, offset);
                endOffset = Math.max(offset, endOffset);
                startLine = map.getLineFromOffset(offset);
                endLine = map.getLineFromOffset(endOffset);
            }
            int contextStartLine = Math.max(0, startLine - 1);
            int contextEndLine = Math.min(lastLine, endLine + 2);
            int contextLength = contextEndLine - contextStartLine + 1;
            int width = String.valueOf(contextEndLine + 1).length();
            for (int line = contextStartLine; line <= contextEndLine; ++line) {
                builder.append(Strings.LINE_SEPARATOR);
                if (line == startLine + 3 && contextLength > 9) {
                    for (int i = 0; i < width; ++i) {
                        builder.append(' ');
                    }
                    builder.append("  ...");
                    line = endLine - 2;
                    continue;
                }
                String number = String.valueOf(line + 1);
                for (int i = number.length(); i < width; ++i) {
                    builder.append(' ');
                }
                builder.append(number);
                builder.append(": ");
                int start = map.getLineStartOffset(line);
                int end = map.getLineEndOffset(line);
                builder.append(this.buffer.getString(start, end - start));
                int last = builder.length() - 1;
                if (builder.charAt(last) == '\n') {
                    builder.setLength(last);
                    --last;
                }
                if (builder.charAt(last) == '\r') {
                    builder.setLength(last);
                }
                if (line != lastLine) continue;
                builder.append("[EOF]");
            }
        }
        finally {
            this.endRead();
        }
        return builder.toString();
    }

    private static class TextLocationShort0
    extends ModelAdapter.LocationShort {
        TextLocationShort0(TextFileModelAdapter model, short offset, short length) {
            super(model, offset, length);
        }

        @Override
        public int getOffset() {
            int offset = super.getOffset();
            return offset + ((TextFileModelAdapter)this.getModel()).getDeltaOffset(offset, 0);
        }

        @Override
        public int getLength() {
            int offset = super.getOffset();
            int length = super.getLength();
            return length + ((TextFileModelAdapter)this.getModel()).getDeltaLength(offset, length, 0);
        }
    }

    private static class TextLocationInt0
    extends ModelAdapter.LocationInt {
        TextLocationInt0(TextFileModelAdapter model, int offset, int length) {
            super(model, offset, length);
        }

        @Override
        public int getOffset() {
            int offset = super.getOffset();
            return offset + ((TextFileModelAdapter)this.getModel()).getDeltaOffset(offset, 0);
        }

        @Override
        public int getLength() {
            int offset = super.getOffset();
            int length = super.getLength();
            return length + ((TextFileModelAdapter)this.getModel()).getDeltaLength(offset, length, 0);
        }
    }

    private static class TextLocationShort
    extends ModelAdapter.LocationShort {
        private int version;

        TextLocationShort(TextFileModelAdapter model, short offset, short length, int version) {
            super(model, offset, length);
            this.version = version;
        }

        @Override
        public int getOffset() {
            int offset = super.getOffset();
            return offset + ((TextFileModelAdapter)this.getModel()).getDeltaOffset(offset, this.version);
        }

        @Override
        public int getLength() {
            int offset = super.getOffset();
            int length = super.getLength();
            return length + ((TextFileModelAdapter)this.getModel()).getDeltaLength(offset, length, this.version);
        }
    }

    private static class TextLocationInt
    extends ModelAdapter.LocationInt {
        private int version;

        TextLocationInt(TextFileModelAdapter model, int offset, int length, int version) {
            super(model, offset, length);
            this.version = version;
        }

        @Override
        public int getOffset() {
            int offset = super.getOffset();
            return offset + ((TextFileModelAdapter)this.getModel()).getDeltaOffset(offset, this.version);
        }

        @Override
        public int getLength() {
            int offset = super.getOffset();
            int length = super.getLength();
            return length + ((TextFileModelAdapter)this.getModel()).getDeltaLength(offset, length, this.version);
        }
    }
}

