/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import oracle.ide.model.DataContainer;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.DependencyStructureListener;

public class StructureDependency
extends Dependency {
    private DataContainer container;
    private static final Log LOG = new Log("dependency");

    public StructureDependency(DataContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("container == null");
        }
        this.container = container;
        LOG.trace("created {0}", (Object)this);
    }

    public DataContainer getContainer() {
        return this.container;
    }

    @Override
    protected void attach() {
        LOG.trace("attaching {0}", (Object)this);
        DependencyStructureListener.addDependency(this, this.container);
    }

    @Override
    protected void detach() {
        LOG.trace("detaching {0}", (Object)this);
        DependencyStructureListener.removeDependency(this, this.container);
    }

    @Override
    protected String getShortDescription() {
        return this.container.getShortLabel();
    }

    @Override
    protected String getLongDescription() {
        return this.container.getLongLabel();
    }
}

