/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.audit.AuditBundle;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.DependencyListener;

public class CompositeDependency
extends Dependency
implements DependencyListener {
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);
    private static final Log LOG = new Log("dependency");

    public CompositeDependency() {
        LOG.trace("created {0}", (Object)this);
    }

    public void addDependency(Dependency dependency) {
        LOG.trace("adding {0} to {1}", (Object)dependency, (Object)this);
        this.dependencies.add(dependency);
        dependency.addChangeListener(this);
        boolean changed = dependency.hasChanged();
        if (changed) {
            this.fireDependencyChanged(this, false);
        }
    }

    public void clear() {
        LOG.trace("clearing {0}", (Object)this);
        this.removeChangeListener(this.getChangeListener());
        this.detach();
        this.dependencies.clear();
    }

    @Override
    public void dependencyChanged(Dependency dependency, boolean possibleSequence) {
        this.fireDependencyChanged(dependency, possibleSequence);
    }

    @Override
    protected void attach() {
        LOG.trace("attaching {0}", (Object)this);
        if (this.hasChanged()) {
            this.fireDependencyChanged(this, false);
        }
    }

    @Override
    protected void detach() {
        LOG.trace("detaching {0}", (Object)this);
        for (Dependency dependency : this.dependencies) {
            dependency.removeChangeListener(this);
        }
    }

    @Override
    protected String getShortDescription() {
        StringBuilder buffer = new StringBuilder();
        for (Dependency dependency : this.dependencies) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(dependency.getShortDescription());
        }
        return BUNDLE.get("composite-dependency-description", new Object[]{buffer});
    }

    @Override
    protected String getLongDescription() {
        StringBuilder buffer = new StringBuilder();
        for (Dependency dependency : this.dependencies) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(dependency.getLongDescription());
        }
        return BUNDLE.get("composite-dependency-description", new Object[]{buffer});
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CompositeDependency[");
        buffer.append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append(", size ");
        buffer.append(this.dependencies.size());
        buffer.append(", listener ");
        buffer.append(this.listenerDescription());
        buffer.append("]");
        return buffer.toString();
    }

    public Object dependencyDescription() {
        return this.dependencies;
    }
}

