/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import oracle.jdeveloper.audit.extension.Converter;

public class BooleanConverter
implements Converter<Boolean> {
    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public String getTypeDescription() {
        return "boolean";
    }

    @Override
    public Boolean toValue(String string, Class<? extends Boolean> type) {
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException("'" + string + "' not \"true\" or \"false\"");
    }

    @Override
    public String toString(Boolean value, Class<? extends Boolean> type) throws Exception {
        return String.valueOf(value);
    }
}

