/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ElementVisitorFactory2;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.UnrecognizedElementException;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.javatools.util.ArrayMap;
import oracle.javatools.util.ArraySortedSet;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import org.xml.sax.Locator;

public class AuditHook
extends ExtensionHook {
    private String extensionId;
    private ClassLoader extensionClassLoader;
    private ExtensionBundle hookBundle;
    private Map<String, TopLevelDefinition> topLevelDefinitions = new HashMap<String, TopLevelDefinition>();
    private UnexpectedElementVisitor unexpectedElementVisitor = new UnexpectedElementVisitor();
    private RsbundleVisitor rsbundleVisitor = new RsbundleVisitor();
    private ProfileDefinitionVisitor profileDefinitionVisitor = new ProfileDefinitionVisitor();
    private CategoryDefinitionVisitor categoryDefinitionVisitor = new CategoryDefinitionVisitor(this.topLevelDefinitions);
    private ModelDefinitionVisitor modelDefinitionVisitor = new ModelDefinitionVisitor(this.categoryDefinitionVisitor);
    private TransformDefinitionVisitor transformDefinitionVisitor = new TransformDefinitionVisitor(this.topLevelDefinitions);
    private RuleDefinitionVisitor ruleDefinitionVisitor = new RuleDefinitionVisitor(this.topLevelDefinitions);
    private TransformBindingVisitor transformBindingVisitor = new TransformBindingVisitor();
    private MetricDefinitionVisitor metricDefinitionVisitor = new MetricDefinitionVisitor(this.topLevelDefinitions);
    private TypesDefinitionVisitor analyzerDefinitionVisitor = new TypesDefinitionVisitor();
    private TypesDefinitionVisitor rootFactoryDefinitionVisitor = new TypesDefinitionVisitor();
    private TypesDefinitionVisitor converterDefinitionVisitor = new TypesDefinitionVisitor();

    private static ElementName newElementName(String name) {
        return new ElementName("http://xmlns.oracle.com/ide/extension", name);
    }

    public static AuditHook getAuditHook() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        return (AuditHook)registry.getHook(AuditHook.newElementName("audit-hook"));
    }

    public Collection<ProfileDefinition> getProfiles() {
        return this.profileDefinitionVisitor.getDefinitions().values();
    }

    public Collection<CategoryDefinition> getCategories() {
        return this.categoryDefinitionVisitor.getDefinitions().values();
    }

    public Collection<TypeDefinition> getModels() {
        return Collections.unmodifiableList(this.modelDefinitionVisitor.getClasses());
    }

    public Map<String, TransformDefinition> getTransforms() {
        return Collections.unmodifiableMap(this.transformDefinitionVisitor.getDefinitions());
    }

    public Collection<RuleDefinition> getRules() {
        return this.ruleDefinitionVisitor.getDefinitions().values();
    }

    public MultiMap<String, TransformBinding> getTransformBindings() {
        return this.transformBindingVisitor.getBindings();
    }

    public Collection<MetricDefinition> getMetrics() {
        return this.metricDefinitionVisitor.getDefinitions().values();
    }

    public Collection<TypeDefinition> getAnalyzers() {
        return Collections.unmodifiableList(this.analyzerDefinitionVisitor.getTypes());
    }

    public Collection<TypeDefinition> getRootFactories() {
        return Collections.unmodifiableList(this.rootFactoryDefinitionVisitor.getTypes());
    }

    public Collection<TypeDefinition> getConverters() {
        return Collections.unmodifiableList(this.converterDefinitionVisitor.getTypes());
    }

    public void start(ElementStartContext context) {
        context.registerVisitorFactory((ElementVisitorFactory)this.unexpectedElementVisitor);
        context.registerChildVisitor(AuditHook.newElementName("rsbundle-class"), (ElementVisitor)this.rsbundleVisitor);
        context.registerChildVisitor(AuditHook.newElementName("profile-definition"), (ElementVisitor)this.profileDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("category-definition"), (ElementVisitor)this.categoryDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("model-definition"), (ElementVisitor)this.modelDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("transform-definition"), (ElementVisitor)this.transformDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("rule-definition"), (ElementVisitor)this.ruleDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("metric-definition"), (ElementVisitor)this.metricDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("analyzer-definition"), (ElementVisitor)this.analyzerDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("root-factory-definition"), (ElementVisitor)this.rootFactoryDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("converter-definition"), (ElementVisitor)this.converterDefinitionVisitor);
        context.registerChildVisitor(AuditHook.newElementName("transform-binding"), (ElementVisitor)this.transformBindingVisitor);
        this.extensionId = context.getExtension().getID();
        this.extensionClassLoader = (ClassLoader)context.getScopeData().get("classLoader");
        this.hookBundle = new ExtensionBundle(AuditHook.getResourceBundle((ElementContext)context), this.extensionId);
    }

    public void end(ElementEndContext context) {
    }

    private class StringVisitor
    extends ElementVisitor {
        private String variant;
        private Map<String, String> strings;

        private StringVisitor() {
        }

        public void reset() {
            this.variant = null;
            this.strings = new ArrayMap();
        }

        public void setVariant(String variant) {
            this.variant = variant;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
        }

        public void end(ElementEndContext context) {
            String key = context.getElementName().getLocalName();
            if (this.variant != null) {
                key = this.variant + "." + key;
            }
            this.strings.put(key, context.getText());
        }

        public Map<String, String> getStrings() {
            return this.strings;
        }
    }

    private class IdrefVisitor
    extends ElementVisitor {
        private String id;

        private IdrefVisitor() {
        }

        public void reset() {
            this.id = null;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
        }

        public void end(ElementEndContext context) {
            this.id = context.getText();
        }

        public String getId() {
            return this.id;
        }
    }

    private class ConditionVisitor
    extends ElementVisitor {
        private Condition condition;

        private ConditionVisitor() {
        }

        public void reset() {
            this.condition = null;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.condition = new Condition((ElementContext)context);
        }

        public void end(ElementEndContext context) {
            String text = context.getText();
            super.end(context);
            if (text != null && (text = text.trim()).length() != 0) {
                this.condition.setText(text);
            } else {
                this.log((ElementContext)context, Level.WARNING, "condition text required");
            }
        }

        public Condition getCondition() {
            return this.condition;
        }
    }

    private class TransformBindingVisitor
    extends ElementVisitor {
        private IdrefVisitor ruleVisitor;
        private IdrefVisitor transformVisitor;
        private ConditionVisitor conditionVisitor;
        private ValueVisitor valueVisitor;
        private ElementName ruleElementName;
        private ElementName transformElementName;
        private ElementName ifElementName;
        private ElementName valueElementName;
        private ElementName propertyElementName;
        private MultiMap<String, TransformBinding> bindings;
        private String rule;
        private TransformBinding binding;

        private TransformBindingVisitor() {
            this.ruleVisitor = new IdrefVisitor();
            this.transformVisitor = new IdrefVisitor();
            this.conditionVisitor = new ConditionVisitor();
            this.valueVisitor = new ValueVisitor();
            this.ruleElementName = AuditHook.newElementName("rule");
            this.transformElementName = AuditHook.newElementName("transform");
            this.ifElementName = AuditHook.newElementName("if");
            this.valueElementName = AuditHook.newElementName("value");
            this.propertyElementName = AuditHook.newElementName("property");
            this.bindings = new MultiMap();
        }

        public void beginRule(String rule) {
            this.rule = rule;
        }

        public void endRule() {
            this.rule = null;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            boolean defaultTransform = Boolean.valueOf(context.getAttributeValue("default"));
            this.binding = new TransformBinding(defaultTransform, AuditHook.this.extensionId, (ElementContext)context);
            if (this.rule == null) {
                context.registerChildVisitor(this.ruleElementName, (ElementVisitor)this.ruleVisitor);
                this.ruleVisitor.reset();
            }
            context.registerChildVisitor(this.transformElementName, (ElementVisitor)this.transformVisitor);
            this.transformVisitor.reset();
            context.registerChildVisitor(this.ifElementName, (ElementVisitor)this.conditionVisitor);
            this.conditionVisitor.reset();
            context.registerChildVisitor(this.valueElementName, (ElementVisitor)this.valueVisitor);
            context.registerChildVisitor(this.propertyElementName, (ElementVisitor)this.valueVisitor);
            this.valueVisitor.reset();
        }

        public void end(ElementEndContext context) {
            this.binding.setRule(this.rule == null ? this.ruleVisitor.getId() : this.rule);
            this.binding.setTransform(this.transformVisitor.getId());
            this.binding.setCondition(this.conditionVisitor.getCondition());
            this.binding.setValues(this.valueVisitor.getValues());
            this.bindings.add((Object)this.binding.getRule(), (Object)this.binding);
        }

        public MultiMap<String, TransformBinding> getBindings() {
            return this.bindings;
        }
    }

    private class ValueVisitor
    extends ElementVisitor {
        private Collection<Value> values;
        private Stack<Value> valueStack = new Stack();

        private ValueVisitor() {
        }

        public void reset() {
            this.values = new ArraySortedSet();
        }

        public void start(ElementStartContext context) {
            String name;
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            if ("property".equals(context.getElementName().getLocalName())) {
                this.log((ElementContext)context, Level.WARNING, "''property'' element deprecated: use ''value'' element instead");
            }
            if ((name = context.getAttributeValue("name")) != null) {
                Value value = new Value(name, (ElementContext)context);
                this.valueStack.push(value);
                context.registerChildVisitor(AuditHook.newElementName("value"), (ElementVisitor)this);
            } else {
                this.log((ElementContext)context, Level.SEVERE, "''name'' attribute required");
                this.valueStack.push(null);
            }
        }

        public void end(ElementEndContext context) {
            Value value = this.valueStack.pop();
            if (value == null) {
                return;
            }
            boolean hasNested = !value.getValues().isEmpty();
            String text = context.getText();
            if (text != null && (text = text.trim()).length() == 0) {
                text = null;
            }
            if (hasNested && text != null) {
                this.log((ElementContext)context, Level.SEVERE, "only one of ''value'' elements or text allowed");
                return;
            }
            if (!hasNested && text == null) {
                this.log((ElementContext)context, Level.SEVERE, "''value'' elements or text required");
                return;
            }
            if (text != null) {
                value.setText(text);
            }
            String name = value.getName();
            boolean added = this.valueStack.isEmpty() ? this.values.add(value) : this.valueStack.peek().addValue(value);
            if (!added) {
                this.log((ElementContext)context, Level.SEVERE, "value ''" + name + "'' redefined");
            }
        }

        public Collection<Value> getValues() {
            return this.values;
        }
    }

    private class MetricDefinitionVisitor
    extends CategoryDefinitionVisitor<MetricDefinition> {
        private TypeDefinitionVisitor valueClassVisitor;
        private ElementName valueClassElementName;

        public MetricDefinitionVisitor(Map<String, TopLevelDefinition> definitionScope) {
            super(definitionScope);
            this.valueClassVisitor = new TypeDefinitionVisitor();
            this.valueClassElementName = AuditHook.newElementName("value-class");
            this.addOptionalStringElements("short-label", "tip");
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            this.setDefinition(new MetricDefinition(AuditHook.this.extensionId, this.getId(), this.getCategory(), AuditHook.this.hookBundle, (ElementContext)context));
            context.registerChildVisitor(this.valueClassElementName, (ElementVisitor)this.valueClassVisitor);
            this.valueClassVisitor.reset();
        }

        @Override
        public void end(ElementEndContext context) {
            MetricDefinition metric = (MetricDefinition)this.getDefinition();
            metric.setValueType(this.valueClassVisitor.getType());
            super.end(context);
        }
    }

    private class RuleDefinitionVisitor
    extends CategoryDefinitionVisitor<RuleDefinition> {
        private SeverityVisitor severityVisitor;
        private ParameterVisitor parameterVisitor;
        private VariationVisitor variationVisitor;
        private ElementName severityElementName;
        private ElementName parameterElementName;
        private ElementName variationElementName;
        private ElementName transformBindingElementName;

        public RuleDefinitionVisitor(Map<String, TopLevelDefinition> definitionScope) {
            super(definitionScope);
            this.severityVisitor = new SeverityVisitor();
            this.parameterVisitor = new ParameterVisitor();
            this.variationVisitor = new VariationVisitor();
            this.severityElementName = AuditHook.newElementName("severity");
            this.parameterElementName = AuditHook.newElementName("parameter");
            this.variationElementName = AuditHook.newElementName("variation");
            this.transformBindingElementName = AuditHook.newElementName("transform-binding");
            this.addAllowedAttributes("id", "name", "category");
            this.addRequiredStringElements("message");
            this.addOptionalStringElements("tip", "html-message");
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            this.setDefinition(new RuleDefinition(AuditHook.this.extensionId, this.getId(), this.getCategory(), AuditHook.this.hookBundle, (ElementContext)context));
            context.registerChildVisitor(this.severityElementName, (ElementVisitor)this.severityVisitor);
            this.severityVisitor.reset();
            context.registerChildVisitor(this.parameterElementName, (ElementVisitor)this.parameterVisitor);
            this.parameterVisitor.reset();
            context.registerChildVisitor(this.variationElementName, (ElementVisitor)this.variationVisitor);
            this.variationVisitor.reset();
            context.registerChildVisitor(this.transformBindingElementName, (ElementVisitor)AuditHook.this.transformBindingVisitor);
            AuditHook.this.transformBindingVisitor.beginRule(this.getId());
        }

        @Override
        public void end(ElementEndContext context) {
            AuditHook.this.transformBindingVisitor.endRule();
            RuleDefinition rule = (RuleDefinition)this.getDefinition();
            String severity = this.severityVisitor.getSeverity();
            if (severity == null) {
                this.log((ElementContext)context, Level.SEVERE, "''severity'' element required");
                severity = "advisory";
            }
            rule.setSeverity(severity);
            rule.setParameters(this.parameterVisitor.getParameters());
            rule.setVariations(this.variationVisitor.getVariations());
            super.end(context);
        }

        private class VariationVisitor
        extends ElementVisitor {
            private ElementName messageElementName = AuditHook.access$1000("message");
            private ElementName htmlMessageElementName = AuditHook.access$1000("html-message");
            private List<String> variations;
            private String name;

            private VariationVisitor() {
            }

            public void reset() {
                this.variations = new ArrayList<String>();
            }

            public void start(ElementStartContext context) {
                super.start(context);
                context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
                this.name = context.getAttributeValue("name");
                if (this.name != null && this.variations.indexOf(this.name) < 0) {
                    RuleDefinitionVisitor.this.stringVisitor.setVariant(this.name);
                    context.registerChildVisitor(this.messageElementName, (ElementVisitor)RuleDefinitionVisitor.this.stringVisitor);
                    context.registerChildVisitor(this.htmlMessageElementName, (ElementVisitor)RuleDefinitionVisitor.this.stringVisitor);
                } else if (this.name != null) {
                    this.log((ElementContext)context, Level.SEVERE, "variation ''" + this.name + "'' redefined");
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "''name'' attribute required");
                }
            }

            public void end(ElementEndContext context) {
                RuleDefinitionVisitor.this.stringVisitor.setVariant(null);
                this.variations.add(this.name);
                super.end(context);
            }

            public List<String> getVariations() {
                return this.variations;
            }
        }

        private class ParameterVisitor
        extends TypeDefinitionVisitor {
            private SortedSet<Parameter> parameters;
            private String name;
            private boolean required;

            private ParameterVisitor() {
            }

            public void reset() {
                this.parameters = new ArraySortedSet();
            }

            @Override
            public void start(ElementStartContext context) {
                super.start(context);
                context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
                this.name = context.getAttributeValue("name");
                if (this.name == null) {
                    this.log((ElementContext)context, Level.SEVERE, "''name'' attribute required");
                }
                this.required = Boolean.valueOf(context.getAttributeValue("required"));
            }

            @Override
            public void end(ElementEndContext context) {
                super.end(context);
                boolean added = this.parameters.add(new Parameter(this.name, this.getType(), this.required, (ElementContext)context));
                if (!added) {
                    this.log((ElementContext)context, Level.SEVERE, "parameter ''" + this.name + "'' redefined");
                    return;
                }
            }

            public Collection<Parameter> getParameters() {
                return this.parameters;
            }
        }

        private class SeverityVisitor
        extends ElementVisitor {
            private String severity;

            private SeverityVisitor() {
            }

            public void reset() {
                this.severity = null;
            }

            public void start(ElementStartContext context) {
                super.start(context);
                context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
                this.severity = null;
            }

            public void end(ElementEndContext context) {
                super.end(context);
                String text = context.getText().trim().toLowerCase();
                if ("error".equals(text) || "warning".equals(text) || "incomplete".equals(text) || "advisory".equals(text) || "assist".equals(text)) {
                    this.severity = text;
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "severity \"" + text + "\" not recognized: expected one of ''error'', ''warning'', ''incomplete'', ''advisory'', ''assist''");
                }
            }

            public String getSeverity() {
                return this.severity;
            }
        }
    }

    private class TransformDefinitionVisitor
    extends CategoryDefinitionVisitor<TransformDefinition> {
        private ComponentTransformVisitor componentTransformVisitor;
        private ElementName componentTransformElementName;

        public TransformDefinitionVisitor(Map<String, TopLevelDefinition> definitionScope) {
            super(definitionScope);
            this.componentTransformVisitor = new ComponentTransformVisitor();
            this.componentTransformElementName = AuditHook.newElementName("component-transform");
            this.addOptionalStringElements("bound-label");
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            this.setDefinition(new TransformDefinition(AuditHook.this.extensionId, this.getId(), this.getCategory(), AuditHook.this.hookBundle, (ElementContext)context));
            context.registerChildVisitor(this.componentTransformElementName, (ElementVisitor)this.componentTransformVisitor);
            this.componentTransformVisitor.reset();
        }

        @Override
        public void end(ElementEndContext context) {
            TransformDefinition definition = (TransformDefinition)this.getDefinition();
            super.end(context);
            Collection<TransformDefinition> components = this.componentTransformVisitor.getComponentTransforms();
            if (this.isError()) {
                return;
            }
            if (definition.getBeanClass() != null || !components.isEmpty()) {
                definition.setTransforms(components);
            } else {
                this.log((ElementContext)context, Level.SEVERE, "''bean-class'' element or ''component-transform'' elements required");
            }
        }

        private class ComponentTransformVisitor
        extends ElementVisitor {
            private TypeDefinitionVisitor beanClassVisitor;
            private ValueVisitor valueVisitor;
            private ElementName beanClassElementName;
            private ElementName valueElementName;
            private Collection<TransformDefinition> componentTransforms;

            private ComponentTransformVisitor() {
                this.beanClassVisitor = new TypeDefinitionVisitor();
                this.valueVisitor = new ValueVisitor();
                this.beanClassElementName = AuditHook.newElementName("bean-class");
                this.valueElementName = AuditHook.newElementName("value");
            }

            public void reset() {
                this.componentTransforms = new ArrayList<TransformDefinition>();
            }

            public void start(ElementStartContext context) {
                super.start(context);
                context.registerChildVisitor(this.beanClassElementName, (ElementVisitor)this.beanClassVisitor);
                this.beanClassVisitor.reset();
                context.registerChildVisitor(this.valueElementName, (ElementVisitor)this.valueVisitor);
                this.valueVisitor.reset();
            }

            public void end(ElementEndContext context) {
                TransformDefinition transform = new TransformDefinition(AuditHook.this.extensionId, TransformDefinitionVisitor.this.getId(), TransformDefinitionVisitor.this.getCategory(), AuditHook.this.hookBundle, (ElementContext)context);
                super.end(context);
                TypeDefinition type = this.beanClassVisitor.getType();
                if (type != null) {
                    transform.setBeanClass(type);
                    transform.setValues(this.valueVisitor.getValues());
                    this.componentTransforms.add(transform);
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "<bean-class> element required");
                }
            }

            public Collection<TransformDefinition> getComponentTransforms() {
                return this.componentTransforms;
            }
        }
    }

    private class ModelDefinitionVisitor
    extends ElementVisitor {
        CategoryDefinitionVisitor categoryVisitor;
        private TypeDefinitionVisitor modelClassVisitor;
        private ElementName modelClassElementName;
        private List<TypeDefinition> classes;

        public ModelDefinitionVisitor(CategoryDefinitionVisitor categoryVisitor) {
            this.modelClassVisitor = new TypeDefinitionVisitor();
            this.modelClassElementName = AuditHook.newElementName("model-class");
            this.classes = new ArrayList<TypeDefinition>();
            this.categoryVisitor = categoryVisitor;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerChildVisitor(this.modelClassElementName, (ElementVisitor)this.modelClassVisitor);
            this.modelClassVisitor.reset();
            this.categoryVisitor.start(context);
        }

        public void end(ElementEndContext context) {
            super.end(context);
            TypeDefinition type = this.modelClassVisitor.getType();
            if (type != null) {
                this.classes.add(type);
            } else {
                this.log((ElementContext)context, Level.WARNING, "''model-class'' element required");
            }
            this.categoryVisitor.end(context);
        }

        public List<TypeDefinition> getClasses() {
            return this.classes;
        }
    }

    private class CategoryDefinitionVisitor<T extends CategoryDefinition>
    extends TopLevelDefinitionVisitor<T> {
        private TypeDefinitionVisitor implementationClassVisitor;
        private ValueVisitor valueVisitor;
        private ElementName implementationClassElementName;
        private ElementName beanClassElementName;
        private ElementName valueElementName;
        private ElementName propertyElementName;

        public CategoryDefinitionVisitor(Map<String, TopLevelDefinition> definitionScope) {
            super(definitionScope);
            this.implementationClassVisitor = new ImplementationClassVisitor();
            this.valueVisitor = new ValueVisitor();
            this.beanClassElementName = AuditHook.newElementName("bean-class");
            this.valueElementName = AuditHook.newElementName("value");
            this.propertyElementName = AuditHook.newElementName("property");
            this.addAllowedAttributes("id", "name", "category");
            this.addRequiredStringElements("label", "description");
            String name = ((Object)((Object)this)).getClass().getName();
            this.implementationClassElementName = AuditHook.newElementName(name.substring(AuditHook.class.getName().length() + 1, name.length() - "DefinitionVisitor".length()).toLowerCase() + "-class");
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            this.setDefinition(new CategoryDefinition(AuditHook.this.extensionId, this.getId(), this.getCategory(), AuditHook.this.hookBundle, (ElementContext)context));
            context.registerChildVisitor(this.beanClassElementName, (ElementVisitor)this.implementationClassVisitor);
            context.registerChildVisitor(this.implementationClassElementName, (ElementVisitor)this.implementationClassVisitor);
            this.implementationClassVisitor.reset();
            context.registerChildVisitor(this.valueElementName, (ElementVisitor)this.valueVisitor);
            context.registerChildVisitor(this.propertyElementName, (ElementVisitor)this.valueVisitor);
            this.valueVisitor.reset();
        }

        @Override
        public void end(ElementEndContext context) {
            CategoryDefinition category = (CategoryDefinition)this.getDefinition();
            super.end(context);
            if (this.isError()) {
                return;
            }
            category.setBeanClass(this.implementationClassVisitor.getType());
            category.setValues(this.valueVisitor.getValues());
        }

        private class ImplementationClassVisitor
        extends TypeDefinitionVisitor {
            private ImplementationClassVisitor() {
            }

            @Override
            public void start(ElementStartContext context) {
                super.start(context);
                if ("bean-class".equals(context.getElementName().getLocalName())) {
                    this.log((ElementContext)context, Level.WARNING, "''bean-class'' element deprecated: use ''" + CategoryDefinitionVisitor.this.implementationClassElementName.getLocalName() + "'' element instead");
                }
            }
        }
    }

    private class ProfileDefinitionVisitor
    extends TopLevelDefinitionVisitor<ProfileDefinition> {
        public ProfileDefinitionVisitor() {
            super(null);
            this.addAllowedAttributes("id");
            this.addRequiredStringElements("label", "description");
        }

        @Override
        public void start(ElementStartContext context) {
            super.start(context);
            this.setDefinition(new ProfileDefinition(AuditHook.this.extensionId, this.getId(), AuditHook.this.hookBundle, (ElementContext)context));
        }

        @Override
        public void end(ElementEndContext context) {
            super.end(context);
        }
    }

    private class TypesDefinitionVisitor
    extends TypeDefinitionVisitor {
        private List<TypeDefinition> types;

        private TypesDefinitionVisitor() {
            this.types = new ArrayList<TypeDefinition>();
        }

        @Override
        public void end(ElementEndContext context) {
            TypeDefinition type = this.getType();
            super.end(context);
            if (type.getName() != null) {
                this.types.add(type);
            }
        }

        public List<TypeDefinition> getTypes() {
            return this.types;
        }
    }

    private class TypeDefinitionVisitor
    extends ElementVisitor {
        private TypeDefinition type;

        private TypeDefinitionVisitor() {
        }

        private void reset() {
            this.type = null;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.type = new TypeDefinition(AuditHook.this.extensionClassLoader, (ElementContext)context);
        }

        public void end(ElementEndContext context) {
            String className = context.getText();
            super.end(context);
            if (className != null && (className = className.trim()).length() != 0) {
                this.type.setName(className);
            } else {
                this.log((ElementContext)context, Level.WARNING, "class name required");
            }
        }

        public TypeDefinition getType() {
            return this.type;
        }
    }

    private abstract class TopLevelDefinitionVisitor<T extends TopLevelDefinition>
    extends ElementVisitor {
        private final Map<String, TopLevelDefinition> definitionScope;
        private Map<String, T> definitions = new LinkedHashMap<String, T>();
        private Set<String> allowedAttributes = new HashSet<String>();
        private boolean idRequired = false;
        private boolean idOrNameRequired = false;
        private List<String> requiredAttributes = new ArrayList<String>();
        private List<ElementName> requiredStringElements = new ArrayList<ElementName>();
        private List<ElementName> optionalStringElements = new ArrayList<ElementName>();
        private String id;
        private String category;
        private String name;
        private T definition;
        private boolean error;
        protected StringVisitor stringVisitor = new StringVisitor();

        protected TopLevelDefinitionVisitor(Map<String, TopLevelDefinition> definitionScope) {
            this.definitionScope = definitionScope != null ? definitionScope : this.definitions;
        }

        protected void addAllowedAttributes(String ... names) {
            for (String name : names) {
                this.allowedAttributes.add(name);
            }
            boolean id = this.allowedAttributes.contains("id");
            boolean name = this.allowedAttributes.contains("name");
            this.idRequired = id && !name;
            boolean bl = this.idOrNameRequired = id && name;
            if (this.idOrNameRequired && !this.allowedAttributes.contains("category")) {
                throw new IllegalArgumentException("''name'' attribute requires ''category'' attribute");
            }
        }

        protected void addRequiredAttributes(String ... names) {
            for (String name : names) {
                this.requiredAttributes.add(name);
                this.allowedAttributes.add(name);
            }
        }

        protected void addRequiredStringElements(String ... names) {
            for (String name : names) {
                this.requiredStringElements.add(AuditHook.newElementName(name));
            }
        }

        protected void addOptionalStringElements(String ... names) {
            for (String name : names) {
                this.optionalStringElements.add(AuditHook.newElementName(name));
            }
        }

        protected String getId() {
            return this.id;
        }

        protected String getCategory() {
            return this.category;
        }

        public T getDefinition() {
            return this.definition;
        }

        public void setDefinition(T definition) {
            this.definition = definition;
        }

        protected void markError() {
            this.error = true;
            this.definitions.remove(this.definition);
        }

        protected boolean isError() {
            return this.error;
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
            this.error = false;
            for (String attributeName : context.getAttributeNames()) {
                if (this.allowedAttributes.contains(attributeName)) continue;
                this.log((ElementContext)context, Level.WARNING, "''" + attributeName + "'' attribute not allowed");
            }
            for (String attributeName : this.requiredAttributes) {
                if (context.getAttributeValue(attributeName) != null) continue;
                this.log((ElementContext)context, Level.SEVERE, "''" + attributeName + "'' attribute required");
                this.error = true;
            }
            this.id = context.getAttributeValue("id");
            this.category = context.getAttributeValue("category");
            this.name = context.getAttributeValue("name");
            if (this.idRequired) {
                if (this.id == null) {
                    this.log((ElementContext)context, Level.SEVERE, "''id'' attribute required");
                    this.error = true;
                }
                this.name = this.id.substring(this.id.lastIndexOf(46) + 1);
            } else if (this.idOrNameRequired) {
                if (this.id != null) {
                    if (this.name != null) {
                        this.log((ElementContext)context, Level.SEVERE, "only one of ''id'' and ''name'' attributes allowed");
                        this.error = true;
                    }
                    this.name = this.id.substring(this.id.lastIndexOf(46) + 1);
                } else if (this.category == null || this.name == null) {
                    this.log((ElementContext)context, Level.SEVERE, "''id'' attribute or ''category'' and ''name'' attributes required");
                    this.error = true;
                } else {
                    this.id = this.category + "." + this.name;
                }
            }
            for (ElementName elementName : this.requiredStringElements) {
                context.registerChildVisitor(elementName, (ElementVisitor)this.stringVisitor);
            }
            for (ElementName elementName : this.optionalStringElements) {
                context.registerChildVisitor(elementName, (ElementVisitor)this.stringVisitor);
            }
            this.stringVisitor.reset();
        }

        public void end(ElementEndContext context) {
            if (this.error) {
                return;
            }
            if (this.definition == null) {
                this.log((ElementContext)context, Level.SEVERE, "internal error: definition null");
                this.error = true;
                return;
            }
            T definition = this.definition;
            this.definition = null;
            if (this.definitionScope.containsKey(this.id)) {
                String previousElementName;
                TopLevelDefinition previousDefinition = this.definitionScope.get(this.id);
                String elementName = ((TopLevelDefinition)definition).getElementName();
                String message = elementName.equals(previousElementName = previousDefinition.getElementName()) ? "<{0}> ''{1}'' already defined in extension {3} ({4}:{5})" : "<{0}> ''{1}'' already defined (as <{2}>) in extension {3} ({4}:{5})";
                ((Definition)definition).log(Level.SEVERE, message, elementName, this.id, previousElementName, previousDefinition.getExtensionId(), previousDefinition.getSystemId(), previousDefinition.getLineNumber());
                this.error = true;
                return;
            }
            this.definitionScope.put(this.id, (TopLevelDefinition)definition);
            ((TopLevelDefinition)definition).setStrings(this.stringVisitor.getStrings());
            for (ElementName elementName : this.requiredStringElements) {
                String localName = elementName.getLocalName();
                if (((TopLevelDefinition)definition).getString(localName) != null) continue;
                ((TopLevelDefinition)definition).getStrings().put(localName, this.name + "." + localName);
            }
            this.definitions.put(this.id, definition);
        }

        public Map<String, T> getDefinitions() {
            return this.definitions;
        }
    }

    private class RsbundleVisitor
    extends ElementVisitor {
        private RsbundleVisitor() {
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerVisitorFactory((ElementVisitorFactory)AuditHook.this.unexpectedElementVisitor);
        }

        public void end(ElementEndContext context) {
            String bundleName = context.getText().trim();
            super.end(context);
            if (bundleName == null || bundleName.length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "bundle name required");
                return;
            }
            AuditHook.this.hookBundle = new ExtensionBundle(AuditHook.this.extensionClassLoader, bundleName, AuditHook.this.extensionId);
        }
    }

    private class UnexpectedElementVisitor
    implements ElementVisitorFactory2 {
        private UnexpectedElementVisitor() {
        }

        public boolean isDescending() {
            return false;
        }

        public ElementVisitor getVisitor(ElementName name) throws UnrecognizedElementException {
            throw new UnrecognizedElementException("element '" + name + "' not expected");
        }

        public ElementVisitor getVisitor(ElementContext context, ElementName name) throws UnrecognizedElementException {
            if (name.getNamespaceURI() == null) {
                AuditHook.this.log(context, Level.WARNING, "element '" + name + "' not expected");
            }
            return null;
        }
    }

    public static class TransformBinding
    extends Definition {
        private String extensionId;
        private String rule;
        private String transform;
        private boolean defaultTransform;
        private Condition condition;
        private Collection<Value> values;

        public TransformBinding(boolean defaultTransform, String extensionId, ElementContext context) {
            super(context);
            this.defaultTransform = defaultTransform;
            this.extensionId = extensionId;
        }

        public boolean isDefault() {
            return this.defaultTransform;
        }

        public String getExtensionId() {
            return this.extensionId;
        }

        public String getRule() {
            return this.rule;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }

        public String getTransform() {
            return this.transform;
        }

        public void setTransform(String transform) {
            this.transform = transform;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public Collection<Value> getValues() {
            return this.values;
        }

        public void setValues(Collection<Value> values) {
            this.values = values;
        }
    }

    public static class Value
    extends Definition
    implements Comparable<Value> {
        private String name;
        private String text;
        private Collection<Value> values = new ArraySortedSet();

        public Value(String name, ElementContext context) {
            super(context);
            this.name = name;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean addValue(Value value) {
            return this.values.add(value);
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public Collection<Value> getValues() {
            return this.values;
        }

        @Override
        public int compareTo(Value that) {
            return this.name.compareTo(that.name);
        }
    }

    public static class Condition
    extends Definition {
        private String text;

        public Condition(ElementContext context) {
            super(context);
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Parameter
    extends Definition
    implements Comparable<Parameter> {
        private String name;
        private TypeDefinition parameterType;
        private boolean required;

        public Parameter(String name, TypeDefinition parameterClass, boolean required, ElementContext context) {
            super(context);
            this.name = name;
            this.parameterType = parameterClass;
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public TypeDefinition getParameterType() {
            return this.parameterType;
        }

        public boolean isRequired() {
            return this.required;
        }

        @Override
        public int compareTo(Parameter that) {
            return this.name.compareTo(that.name);
        }
    }

    public static class MetricDefinition
    extends CategoryDefinition {
        private TypeDefinition valueType;

        public MetricDefinition(String extensionId, String id, String categoryId, ExtensionBundle bundle, ElementContext context) {
            super(extensionId, id, categoryId, bundle, context);
        }

        public void setValueType(TypeDefinition valueType) {
            this.valueType = valueType;
        }

        public TypeDefinition getValueType() {
            return this.valueType;
        }
    }

    public static class RuleDefinition
    extends CategoryDefinition {
        private String severity;
        private Collection<Parameter> parameters;
        private Collection<String> variations;

        public RuleDefinition(String extensionId, String id, String categoryId, ExtensionBundle bundle, ElementContext context) {
            super(extensionId, id, categoryId, bundle, context);
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }

        public Collection<Parameter> getParameters() {
            return this.parameters;
        }

        public void setParameters(Collection<Parameter> parameters) {
            this.parameters = parameters;
        }

        public Collection<String> getVariations() {
            return this.variations;
        }

        public void setVariations(Collection<String> variations) {
            this.variations = variations;
        }
    }

    public static class Variation {
        private String name;
        private Map<String, String> strings;

        public Variation(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getStrings() {
            return this.strings;
        }

        public void setStrings(Map<String, String> strings) {
            this.strings = strings;
        }
    }

    public static class TransformDefinition
    extends CategoryDefinition {
        private Collection<TransformDefinition> transforms;

        public TransformDefinition(String extensionId, String id, String categoryId, ExtensionBundle bundle, ElementContext context) {
            super(extensionId, id, categoryId, bundle, context);
        }

        public boolean isComposite() {
            return !this.transforms.isEmpty();
        }

        public void setTransforms(Collection<TransformDefinition> transforms) {
            this.transforms = transforms;
        }

        public Collection<TransformDefinition> getTransforms() {
            return this.transforms;
        }
    }

    public static class CategoryDefinition
    extends TopLevelDefinition {
        private String categoryId;
        private TypeDefinition beanClass;
        private Collection<Value> values = new ArrayList<Value>();

        public CategoryDefinition(String extensionId, String id, String categoryId, ExtensionBundle bundle, ElementContext context) {
            super(extensionId, id, bundle, context);
            this.categoryId = categoryId;
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public TypeDefinition getBeanClass() {
            return this.beanClass;
        }

        public void setBeanClass(TypeDefinition beanClass) {
            this.beanClass = beanClass;
        }

        public Collection<Value> getValues() {
            return this.values;
        }

        public void setValues(Collection<Value> values) {
            this.values = values;
        }
    }

    public class ProfileDefinition
    extends TopLevelDefinition {
        public ProfileDefinition(String extensionId, String id, ExtensionBundle bundle, ElementContext context) {
            super(extensionId, id, bundle, context);
        }
    }

    public static abstract class TopLevelDefinition
    extends Definition {
        private String extensionId;
        private String id;
        private ExtensionBundle bundle;
        private Map<String, String> strings = new ArrayMap();

        protected TopLevelDefinition(String extensionId, String id, ExtensionBundle bundle, ElementContext context) {
            super(context);
            this.extensionId = extensionId;
            this.id = id;
            this.bundle = bundle;
        }

        public String getExtensionId() {
            return this.extensionId;
        }

        public ExtensionBundle getExtensionBundle() {
            return this.bundle;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, String> getStrings() {
            return this.strings;
        }

        public void setStrings(Map<String, String> strings) {
            this.strings = strings;
        }

        public String getString(String key) {
            return this.strings.get(key);
        }

        public String getElementName() {
            String name = this.getClass().getSimpleName();
            return name.substring(0, name.length() - "Definition".length()).toLowerCase() + "-definition";
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + " " + this.id + " (" + this.getSystemId() + ":" + this.getLineNumber() + ")";
        }
    }

    public static class TypeDefinition
    extends Definition {
        private ClassLoader loader;
        private String name;
        private Class<?> type;

        public TypeDefinition(ClassLoader loader, ElementContext context) {
            super(context);
            this.loader = loader;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class getType() {
            if (this.loader != null) {
                try {
                    if (this.name != null) {
                        if (this.name.endsWith("[]")) {
                            Class componentType = new MetaClass(this.loader, this.name.substring(0, this.name.length() - 2).trim()).toClass();
                            this.type = Array.newInstance(componentType, 1).getClass();
                        } else {
                            this.type = new MetaClass(this.loader, this.name).toClass();
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    this.log(Level.SEVERE, "Class ''{0}'' not found", this.name);
                }
                catch (NegativeArraySizeException negativeArraySizeException) {
                    // empty catch block
                }
                this.loader = null;
            }
            return this.type;
        }

        public Object getInstance() {
            Class type = this.getType();
            if (type != null) {
                try {
                    return type.newInstance();
                }
                catch (InstantiationException e) {
                    this.log(Level.SEVERE, "New ''{0}'' not created: {1}", this.name, e);
                }
                catch (IllegalAccessException e) {
                    this.log(Level.SEVERE, "New ''{0}'' not created: {1}", this.name, e);
                }
            }
            return null;
        }
    }

    public static abstract class Definition
    implements Locator {
        private String systemId;
        private int line;
        private int column;

        protected Definition(ElementContext context) {
            Locator locator = (Locator)context.getScopeData().get("xml.locator");
            this.systemId = locator.getSystemId();
            this.line = locator.getLineNumber();
            this.column = locator.getColumnNumber();
        }

        @Override
        public String getPublicId() {
            return "";
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        public int getColumnNumber() {
            return this.column;
        }

        public void log(Level level, String message, Object ... parameters) {
            ExtensionLogRecord record = new ExtensionLogRecord((Locator)this, level, message);
            if (parameters != null && parameters.length > 0) {
                record.setParameters(parameters);
            }
            ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " (" + this.systemId + ":" + this.line + ")";
        }
    }
}

