/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.analyzer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.util.ArrayIterator;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdeveloper.audit.service.TypeSafeEnumerationFactory;

public class StyleCategory
implements Comparable,
TypeSafeEnumeration {
    public static final StyleCategory ERROR = new StyleCategory("error");
    public static final StyleCategory WARNING = new StyleCategory("warning");
    public static final StyleCategory INCOMPLETE = new StyleCategory("incomplete");
    public static final StyleCategory ADVISORY = new StyleCategory("advisory");
    public static final StyleCategory ASSIST = new StyleCategory("assist");
    public static final StyleCategory DEPRECATED = new StyleCategory("deprecated");
    public static final StyleCategory UNUSED = new StyleCategory("unused");
    public static final StyleCategory CONSTANT = new StyleCategory("constant");
    public static final StyleCategory INTERFACE = new StyleCategory("interface");
    public static final StyleCategory ABSTRACT_CLASS = new StyleCategory("abstract-class");
    public static final StyleCategory CLASS = new StyleCategory("class");
    public static final StyleCategory ANNOTATION = new StyleCategory("annotation");
    public static final StyleCategory ANNOTATION_ELEMENT = new StyleCategory("annotation-element");
    public static final StyleCategory INSTANCE_METHOD = new StyleCategory("instance-method");
    public static final StyleCategory STATIC_METHOD = new StyleCategory("static-method");
    public static final StyleCategory INSTANCE_FIELD = new StyleCategory("instance-field");
    public static final StyleCategory STATIC_FIELD = new StyleCategory("static-field");
    public static final StyleCategory CONSTRUCTOR = new StyleCategory("constructor");
    public static final StyleCategory PARAMETER = new StyleCategory("parameter");
    public static final StyleCategory VARIABLE = new StyleCategory("variable");
    private static int next = 0;
    private static final StyleCategory[] VALUES = new StyleCategory[]{ERROR, WARNING, INCOMPLETE, ADVISORY, ASSIST, DEPRECATED, UNUSED, CONSTANT, INTERFACE, ABSTRACT_CLASS, CLASS, ANNOTATION, ANNOTATION_ELEMENT, INSTANCE_METHOD, STATIC_METHOD, INSTANCE_FIELD, STATIC_FIELD, CONSTRUCTOR, PARAMETER, VARIABLE};
    private static Map<String, StyleCategory> VALUES_BY_NAME;
    private int code;
    private String name;

    private StyleCategory(String name) {
        assert (!name.equalsIgnoreCase("violation"));
        this.code = next++;
        this.name = name;
    }

    public String getHighlightStyleName() {
        return "audit-" + this.name;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object object) {
        return object instanceof StyleCategory && this.code == ((StyleCategory)object).code;
    }

    public int compareTo(Object object) {
        return this.code - ((StyleCategory)object).code;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StyleCategory valueOf(String string) {
        Class<StyleCategory> clazz = StyleCategory.class;
        synchronized (StyleCategory.class) {
            if (VALUES_BY_NAME == null) {
                VALUES_BY_NAME = new HashMap<String, StyleCategory>();
                for (StyleCategory value : VALUES) {
                    VALUES_BY_NAME.put(value.name, value);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return VALUES_BY_NAME.get(string);
        }
    }

    public static Iterator values() {
        return new ArrayIterator((Object[])VALUES);
    }

    static {
        TypeSafeEnumerationFactory.addSubstitution(StyleCategory.class, "violation", "advisory");
        TypeSafeEnumerationFactory.addSubstitution(StyleCategory.class, "convention", "advisory");
        TypeSafeEnumerationFactory.addSubstitution(StyleCategory.class, "suggestion", "assist");
    }
}

