/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.analyzer;

import java.lang.reflect.InvocationTargetException;
import java.util.IdentityHashMap;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.analyzer.StyleCategory;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;

public class Rule
extends ExtensionBean {
    public static final String MESSAGE_KEY = "message";
    public static final String HTML_MESSAGE_KEY = "html-message";
    public static final int MAX_TRANSFORM_COUNT = 15;
    private String[] variations;
    private Severity severity;
    private StyleCategory style;
    private Category category;
    private boolean enabled;
    private Parameter[] parameters;
    private Transform[] transforms;
    private Transform defaultTransform;
    private boolean declarative;
    private static final String[] NO_VARIATIONS = new String[0];
    private static final Transform[] NO_TRANSFORMS = new Transform[0];

    public Rule() {
        this.variations = NO_VARIATIONS;
        this.transforms = NO_TRANSFORMS;
        this.declarative = true;
    }

    public Rule(String name, Category category, Severity severity, Localizer localizer) {
        this(name, category, severity, localizer, null, null);
    }

    public Rule(String name, Category category, Severity severity, Localizer localizer, Transform defaultTransform) {
        this(name, category, severity, localizer, null, defaultTransform);
    }

    public Rule(String name, Category category, Severity severity, Localizer localizer, Transform[] transforms, Transform defaultTransform) {
        this(name, null, category, severity, localizer, transforms, defaultTransform);
    }

    public Rule(String name, String[] variations, Category category, Severity severity, Localizer localizer, Transform[] transforms, Transform defaultTransform) {
        this(name, null, variations, category, severity, localizer, transforms, defaultTransform);
    }

    public Rule(String name, String extensionId, String[] variations, Category category, Severity severity, Localizer localizer, Transform[] transforms, Transform defaultTransform) {
        this(category.id() + "." + name, extensionId, category, variations, transforms, defaultTransform);
        this.setSeverity(severity);
        if (localizer != null) {
            this.setCompatibilityBundle(localizer.getBundle(), "rule." + name);
        }
    }

    public Rule(String id, String extensionId, Category category, String[] variations, Transform[] transforms, Transform defaultTransform) {
        super(id, extensionId);
        if (variations == null) {
            variations = NO_VARIATIONS;
        }
        this.variations = variations;
        this.category = category;
        if (transforms == null && defaultTransform != null) {
            transforms = new Transform[]{defaultTransform};
        }
        this.setTransforms(transforms);
        if (defaultTransform != null) {
            this.setDefaultTransformName(defaultTransform.id());
        }
    }

    @Override
    protected void copyInternalState(ExtensionBean copy, IdentityHashMap<Object, Object> context) throws InvocationTargetException {
        Rule rule = (Rule)copy;
        if (this.category != null) {
            rule.category = (Category)this.category.createCopy(context);
        }
        rule.parameters = this.parameters;
        rule.declarative = this.declarative;
        rule.variations = this.variations;
        rule.transforms = new Transform[this.transforms.length];
        for (int i = 0; i < this.transforms.length; ++i) {
            Transform transform = this.transforms[i];
            rule.transforms[i] = (Transform)transform.createCopy(context);
            if (transform != this.defaultTransform) continue;
            rule.defaultTransform = rule.transforms[i];
        }
    }

    public final boolean declarative() {
        return this.declarative;
    }

    public Category category() {
        return this.category;
    }

    public Parameter[] parameters() {
        return this.parameters;
    }

    public String[] variations() {
        return this.variations;
    }

    public String message(Violation violation) {
        String variation = violation.getVariation();
        String string = this.formattedString(this.variationKey(MESSAGE_KEY, variation), violation);
        if (string == null) {
            string = this.formattedString(this.variationKey(MESSAGE_KEY, null), violation);
        }
        if (string == null) {
            string = this.syntheticMessage(violation);
        }
        return string;
    }

    public String htmlMessage(Violation violation) {
        String variation = violation.getVariation();
        String string = this.formattedString(this.variationKey(HTML_MESSAGE_KEY, variation), violation);
        if (string == null) {
            string = this.formattedString(this.variationKey(MESSAGE_KEY, variation), violation);
        }
        if (string == null) {
            string = this.formattedString(this.variationKey(HTML_MESSAGE_KEY, null), violation);
        }
        if (string == null) {
            string = this.message(violation);
        }
        return string;
    }

    private String variationKey(String key, String variation) {
        return variation != null ? variation + "." + key : key;
    }

    private String syntheticMessage(Violation violation) {
        StringBuilder builder = new StringBuilder();
        builder.append("Rule '");
        builder.append(this.labelOrId());
        builder.append("' violated");
        int count = violation.getParameterCount();
        if (count > 0) {
            builder.append(": ");
            for (int i = 0; i < count; ++i) {
                if (count > 0) {
                    builder.append(", ");
                }
                builder.append(violation.getParameterName(i));
                builder.append("=\"");
                builder.append(violation.getParameterValue(i));
                builder.append("\"");
            }
        }
        return builder.toString();
    }

    public Transform getDefaultTransform() {
        return this.defaultTransform;
    }

    public void setDefaultTransformName(String newName) {
        Transform oldValue = this.defaultTransform;
        Transform newValue = null;
        if (newName != null) {
            boolean found = false;
            for (int i = 0; i < this.transforms.length; ++i) {
                found = newName.equals(this.transforms[i].id());
                if (!found) continue;
                newValue = this.transforms[i];
                break;
            }
            if (!found) {
                newValue = null;
            }
        }
        this.defaultTransform = newValue;
        this.firePropertyChange("defaultTransform", oldValue, newValue);
    }

    public String getDefaultTransformName() {
        return this.defaultTransform != null ? this.defaultTransform.id() : null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity newValue) {
        Severity oldValue = this.severity;
        this.severity = newValue;
        this.firePropertyChange("severity", oldValue, newValue);
    }

    public StyleCategory getStyle() {
        if (this.style == null) {
            this.style = this.severity == Severity.ERROR ? StyleCategory.ERROR : (this.severity == Severity.WARNING ? StyleCategory.WARNING : (this.severity == Severity.INCOMPLETE ? StyleCategory.INCOMPLETE : (this.severity == Severity.ADVISORY ? StyleCategory.ADVISORY : StyleCategory.ASSIST)));
        }
        return this.style;
    }

    public void setStyle(StyleCategory newValue) {
        assert (newValue != null);
        StyleCategory oldValue = this.getStyle();
        this.style = newValue;
        this.firePropertyChange("style", oldValue, newValue);
    }

    public void setStyleCategory(StyleCategory newValue) {
        this.setStyle(newValue);
    }

    public Transform[] getTransforms() {
        return this.transforms;
    }

    protected void setTransforms(Transform[] transforms) {
        Object[] oldValue = this.transforms;
        if (transforms == null) {
            transforms = NO_TRANSFORMS;
        }
        assert (transforms.length <= 15);
        this.transforms = transforms;
        if (this.defaultTransform != null) {
            String defaultName = this.defaultTransform.id();
            boolean found = false;
            for (int i = 0; i < transforms.length && !(found = defaultName.equals(transforms[i].id())); ++i) {
            }
            if (!found) {
                this.setDefaultTransformName(null);
            }
        }
        this.firePropertyChange("transforms", oldValue, transforms);
    }

    public String toString() {
        if (this.isEnabled()) {
            return "rule " + this.id();
        }
        return "rule " + this.id() + " (disabled)";
    }

    public static interface Parameter {
        public String getName();

        public Class<?> getType();

        public boolean isRequired();
    }
}

