/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.recent;

import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.parser.plsql.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.editors.WorksheetEditorPluginRegistry;
import oracle.dbtools.raptor.editors.WorksheetEditorPluginsFactory;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.recent.RecentObjectsWindow;
import oracle.dbtools.raptor.oviewer.recent.Tracker;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.NavigatorManager;
import oracle.javatools.editor.plugins.EditorPlugin;

public class RecentObjectsAddin
implements DockableFactory,
Addin {
    private int _viewActionId;
    static final String VIEW_TYPE = "RECENT_OBJECTS_VIEW_TYPE";
    private static Tracker TRACKER;
    private RecentObjectsWindow _recentObjectsWindow;

    static Tracker getTracker() {
        return TRACKER;
    }

    public void initialize() {
        TRACKER = new Tracker();
        this.createActions();
        try {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.registerDockableFactory(VIEW_TYPE, (DockableFactory)this);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        CodeEditor.registerFactory((EditorPluginsFactory)new EditorPluginsFactory(){

            public List createPlugins(Context context) {
                return Collections.singletonList(new IdentifierDefinitionLookup(context));
            }
        });
        WorksheetEditorPluginRegistry.registerFactory((WorksheetEditorPluginsFactory)new WorksheetEditorPluginsFactory(){

            public List<? extends EditorPlugin> createWorksheetPlugins(Context context) {
                return Collections.singletonList(new IdentifierDefinitionLookup(context));
            }
        });
    }

    private void createActions() {
        if (!RaptorExtensionConstants.isStandAlone()) {
            return;
        }
        this._viewActionId = Ide.findOrCreateCmdID((String)"RecentObjects");
        String string = Messages.getString("_Recent_Objects");
        IdeAction ideAction = IdeAction.get((int)this._viewActionId, null, (String)StringUtils.stripMnemonic((String)string), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (Icon)RaptorImagesArb.getIcon((String)"TELESCOPE"), null, (boolean)true);
        ideAction.addController((Controller)new SController());
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_COMPONENT_PALETTE + 0.001f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"View"));
    }

    public Dockable getDockable(ViewId viewId) {
        return this.getRecentObjectsWindow();
    }

    public void install() {
        if (RaptorExtensionConstants.isStandAlone()) {
            ExplorerManager explorerManager;
            DockingParam dockingParam = new DockingParam();
            NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
            if (navigatorManager.getNavigatorWindow() != null) {
                dockingParam.setPosition((Dockable)navigatorManager.getNavigatorWindow(), 3, 0);
            } else {
                explorerManager = ExplorerManager.getExplorerManager();
                Dockable dockable = null;
                if (explorerManager != null) {
                    ViewId viewId = explorerManager.getDefaultViewId();
                    dockable = DockStation.getDockStation().findDockable(viewId);
                }
                dockingParam.setPosition(dockable, 4, 0);
            }
            explorerManager = DockStation.getDockStation();
            explorerManager.dock((Dockable)this.getRecentObjectsWindow(), dockingParam);
        }
    }

    private RecentObjectsWindow getRecentObjectsWindow() {
        if (this._recentObjectsWindow == null) {
            this._recentObjectsWindow = new RecentObjectsWindow();
        }
        return this._recentObjectsWindow;
    }

    private class SController
    implements Controller {
        private SController() {
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n != RecentObjectsAddin.this._viewActionId) {
                return false;
            }
            DockUtil.showDockableWindow((DockableView)RecentObjectsAddin.this.getRecentObjectsWindow());
            return true;
        }
    }
}

