/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.jsoneditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.ide.net.URIFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.JSONHandler;
import oracle.dbtools.raptor.cloud.connection.JSONNodeHandler;
import oracle.dbtools.raptor.cloud.connection.JSONUtils;
import oracle.dbtools.raptor.cloud.navigator.CloudViewerDetail;
import oracle.dbtools.raptor.cloud.navigator.ExceptionDialogRunnable;
import oracle.dbtools.raptor.cloud.navigator.ViewerStyle;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.oviewer.cloud.BasicCloudEditor;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.rt.json.JSONArray;
import oracle.dbtools.rt.json.JSONEvent;
import oracle.dbtools.rt.json.JSONNode;
import oracle.dbtools.rt.json.JSONObject;
import oracle.dbtools.rt.json.JSONValue;
import oracle.dbtools.util.Logger;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.table.GenericTable;
import org.apache.http.client.ResponseHandler;

class JSONComponent {
    private String _uriString;
    private String _conName;
    private ViewerStyle _style;
    private JComponent _comp;
    protected JScrollPane _sp;
    private GenericTable _table;
    private DefaultTableModel _model;
    MouseListener dblClick;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Row getRowFromArray(Iterator<JSONEvent> iterator) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        JSONEvent jSONEvent = null;
        int n = 0;
        while (iterator.hasNext()) {
            try {
                jSONEvent = iterator.next();
            }
            catch (Exception exception) {
                return new Row(arrayList);
            }
            switch (jSONEvent.type()) {
                case PROPERTY_NAME: {
                    Pair<String, Object> pair = this.getJSONValue(iterator, jSONEvent);
                    arrayList.add(new Column(((String)pair.first()).toUpperCase(), n, pair.second()));
                    break;
                }
                case END_OBJECT: {
                    return new Row(arrayList);
                }
            }
        }
        return new Row(arrayList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Row> getVerticalRowsFromArray(Iterator<JSONEvent> iterator) {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        JSONEvent jSONEvent = null;
        int n = 0;
        while (iterator.hasNext()) {
            ArrayList<Column> arrayList2 = new ArrayList<Column>();
            try {
                jSONEvent = iterator.next();
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (jSONEvent.type()) {
                case PROPERTY_NAME: {
                    Pair<String, Object> pair = this.getJSONValue(iterator, jSONEvent);
                    arrayList2.add(new Column("Name", n, pair.first()));
                    arrayList2.add(new Column("Value", n, pair.second()));
                    ++n;
                    arrayList.add(new Row(arrayList2));
                    break;
                }
                case END_OBJECT: {
                    return arrayList;
                }
            }
        }
        return arrayList;
    }

    private Pair<String, Object> getJSONValue(Iterator<JSONEvent> iterator, JSONEvent jSONEvent) {
        Object object = null;
        String string = jSONEvent.propertyName();
        try {
            jSONEvent = iterator.next();
        }
        catch (Exception exception) {
            return Pair.pair((Object)string, object);
        }
        switch (jSONEvent.type()) {
            case NULL_VALUE: {
                break;
            }
            case BOOLEAN_VALUE: {
                object = jSONEvent.booleanValue();
                break;
            }
            case NUMERIC_VALUE: {
                object = jSONEvent.numberValue();
                break;
            }
            case STRING_VALUE: {
                object = jSONEvent.stringValue();
                break;
            }
        }
        return Pair.pair((Object)string, (Object)object);
    }

    public JSONComponent(CloudViewerDetail cloudViewerDetail, String string) {
        this._uriString = cloudViewerDetail.getUriString();
        this._conName = string;
        this._style = cloudViewerDetail.getStyle();
        this.buildUI();
    }

    public void setDetails(CloudViewerDetail cloudViewerDetail) {
        this._uriString = cloudViewerDetail.getUriString();
        this._style = cloudViewerDetail.getStyle();
    }

    public String getConName() {
        return this._conName;
    }

    public void setConName(String string) {
        this._conName = string;
    }

    public Component getComp() {
        return this._comp;
    }

    JComponent getUI() {
        this.buildUI();
        return this._comp;
    }

    JComponent getDisplayUI() {
        this.buildUI();
        return this._comp instanceof BasicEditorPane ? this.getScrollableUI() : this._comp;
    }

    boolean isScrollable() {
        return !(this._comp instanceof BasicEditorPane);
    }

    JComponent getScrollableUI() {
        if (this._sp == null) {
            this._sp = new JScrollPane(this._comp);
        }
        return this._sp;
    }

    public Component getScrollableLeftMargin() {
        if (this._comp instanceof GenericTable) {
            return ((GenericTable)this._comp).getRowHeader();
        }
        return null;
    }

    public Component getScrollableTopMargin() {
        if (this._comp instanceof GenericTable) {
            return ((GenericTable)this._comp).getTableHeader();
        }
        return null;
    }

    public void refresh() {
        if (this._style == ViewerStyle.TABLE || this._style == ViewerStyle.VTABLE) {
            this._comp = this.buildTable();
        } else if (this._style == ViewerStyle.CODE) {
            ((BasicEditorPane)this._comp).setEditable(true);
            try {
                CConnection cConnection = CConnections.getInstance().getConnection(this._conName, false);
                if (cConnection != null) {
                    String string = (String)cConnection.executeQuery(new URI(this._uriString), (ResponseHandler)new JSONNodeHandler<String>(){

                        protected String build(JSONNode jSONNode) throws IOException {
                            JSONObject jSONObject = (JSONObject)jSONNode;
                            JSONArray jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"items");
                            StringBuilder stringBuilder = new StringBuilder();
                            for (JSONValue jSONValue : jSONArray.values()) {
                                JSONObject jSONObject2 = (JSONObject)jSONValue.value();
                                stringBuilder.append(JSONUtils.getValue((JSONObject)jSONObject2, (String)"ddl"));
                                stringBuilder.append("\n");
                            }
                            return stringBuilder.toString();
                        }
                    });
                    ((BasicEditorPane)this._comp).setText(string);
                }
            }
            catch (CConnectionException cConnectionException) {
                Logger.warn(BasicCloudEditor.class, (String)cConnectionException.getMessage());
                Throwable throwable = cConnectionException.getCause();
                if (throwable == null) {
                    throwable = cConnectionException;
                }
                ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString((String)"CONNECTION_FILTER_CONNECT_ERROR"), throwable);
                if (SwingUtilities.isEventDispatchThread()) {
                    exceptionDialogRunnable.run();
                } else {
                    try {
                        SwingUtilities.invokeLater((Runnable)exceptionDialogRunnable);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.warn(BasicCloudEditor.class, (String)uRISyntaxException.getMessage());
            }
            ((BasicEditorPane)this._comp).setEditable(false);
        }
    }

    private JComponent buildTable() {
        try {
            List list;
            CConnection cConnection;
            this._model = new DefaultTableModel(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            if (this._table == null) {
                this._table = new GenericTable((TableModel)this._model);
            } else {
                this._table.setModel((TableModel)this._model);
            }
            if (this.dblClick == null) {
                this.dblClick = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                            JSONComponent.this.popupCurrentCell(mouseEvent.getPoint());
                        }
                    }
                };
                this._table.addMouseListener(this.dblClick);
            }
            if ((cConnection = CConnections.getInstance().getConnection(this._conName, false)) != null && (list = (List)cConnection.executeQuery(URIFactory.newURI((String)this._uriString), (ResponseHandler)new JSONHandler<List<Row>>(){

                protected List<Row> build(Iterator<JSONEvent> iterator) throws IOException {
                    ArrayList<Row> arrayList = new ArrayList<Row>();
                    boolean bl = true;
                    block12: while (iterator.hasNext()) {
                        JSONEvent jSONEvent = iterator.next();
                        switch (jSONEvent.type()) {
                            case START_OBJECT: {
                                if (bl) {
                                    bl = false;
                                    continue block12;
                                }
                                throw new IOException(new IllegalStateException("Invalid JSON document"));
                            }
                            case PROPERTY_NAME: {
                                Pair pair = JSONComponent.this.getJSONValue(iterator, jSONEvent);
                                if (!"items".equals(pair.first())) continue block12;
                                block13: while (iterator.hasNext()) {
                                    try {
                                        jSONEvent = iterator.next();
                                    }
                                    catch (Exception exception) {
                                        break block12;
                                    }
                                    switch (jSONEvent.type()) {
                                        case START_OBJECT: {
                                            if (JSONComponent.this._style == ViewerStyle.VTABLE) {
                                                for (Row row : JSONComponent.this.getVerticalRowsFromArray(iterator)) {
                                                    arrayList.add(row);
                                                }
                                                continue block13;
                                            }
                                            arrayList.add(JSONComponent.this.getRowFromArray(iterator));
                                            continue block13;
                                        }
                                        case PROPERTY_NAME: {
                                            pair = JSONComponent.this.getJSONValue(iterator, jSONEvent);
                                            continue block13;
                                        }
                                        case END_ARRAY: {
                                            continue block12;
                                        }
                                    }
                                }
                                continue block12;
                            }
                            case END_OBJECT: {
                                break block12;
                            }
                            default: {
                                continue block12;
                            }
                        }
                    }
                    return arrayList;
                }
            })).size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Row row : list) {
                    for (Column column : row.getColumns()) {
                        if (arrayList.contains(column.getName())) continue;
                        arrayList.add(column.getName());
                        this._model.addColumn(column.getName());
                    }
                }
                for (Row row : list) {
                    this._model.addRow(row.getData(arrayList));
                }
                this._model.fireTableDataChanged();
            }
        }
        catch (CConnectionException cConnectionException) {
            Logger.warn(BasicCloudEditor.class, (String)cConnectionException.getMessage());
            Throwable throwable = cConnectionException.getCause();
            if (throwable == null) {
                throwable = cConnectionException;
            }
            ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString((String)"CONNECTION_FILTER_CONNECT_ERROR"), throwable);
            if (SwingUtilities.isEventDispatchThread()) {
                exceptionDialogRunnable.run();
            }
            try {
                SwingUtilities.invokeLater((Runnable)exceptionDialogRunnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._table.setColumnSelectorAvailable(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.setAutoResizeMode(4);
        return this._table;
    }

    private void popupCurrentCell(Point point) {
        int n = this._table.rowAtPoint(point);
        int n2 = this._table.columnAtPoint(point);
        Object object = this._table.getValueAt(n, n2);
        String string = this._table.getColumnName(n2);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(object == null ? "" : object.toString());
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._table, (Component)jPanel, null, (String)string, (int)2);
        jEWTDialog.setMinimumSize(new Dimension(300, 120));
        WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    private void buildUI() {
        if (this._comp != null) {
            return;
        }
        if (this._style == ViewerStyle.TABLE || this._style == ViewerStyle.VTABLE) {
            this._comp = this.buildTable();
        } else if (this._style == ViewerStyle.CODE) {
            this._comp = EditorFactory.createIdeEditorPane();
            ((BasicEditorPane)this._comp).setText("");
            ((BasicEditorPane)this._comp).setDocument((Document)new BasicDocument("foo.plsql"));
            final LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
            HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
            ((BasicEditorPane)this._comp).installPlugin((EditorPlugin)lineGutterPlugin);
            ((BasicEditorPane)this._comp).installPlugin((EditorPlugin)highlightEditorPlugin);
            ((BasicEditorPane)this._comp).setText("");
            ((BasicEditorPane)this._comp).setEditable(false);
            ((BasicEditorPane)this._comp).setBackground(Color.WHITE);
            ((JScrollPane)this.getScrollableUI()).setRowHeaderView((Component)lineGutterPlugin);
            final JPopupMenu jPopupMenu = new JPopupMenu(Messages.getString((String)"DisplayCodeEditor.3"));
            JMenuItem jMenuItem = new JMenuItem(Messages.getString((String)"DisplayCodeEditor.4"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                    editorProperties.putBooleanProperty("show-line-numbers", bl);
                }
            });
            lineGutterPlugin.addGutterClickListener(new GutterClickListener(){

                public void lineClicked(Gutter gutter, int n, MouseEvent mouseEvent) {
                    gutter.hashCode();
                    jPopupMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            });
            ((JScrollPane)this.getScrollableUI()).getRowHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 8) != 0 || (n & 4) != 0) {
                        jPopupMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
    }

    class Column {
        String _name;
        int _seq;
        Object _value;

        public Column(String string, int n, Object object) {
            this._name = string;
            this._seq = n;
            this._value = object;
        }

        public String getName() {
            return this._name;
        }
    }

    class Row {
        List<Column> _cols;

        public Row(List<Column> list) {
            this._cols = list;
        }

        public int getColCount() {
            return this._cols.size();
        }

        public List<Column> getColumns() {
            return this._cols;
        }

        public Object[] getData() {
            Object[] objectArray = new Object[this._cols.size()];
            for (int i = 0; i < this._cols.size(); ++i) {
                objectArray[i] = this._cols.get((int)i)._value;
            }
            return objectArray;
        }

        public Vector<Object> getData(ArrayList<String> arrayList) {
            Vector<Object> vector = new Vector<Object>();
            for (String string : arrayList) {
                boolean bl = false;
                for (Column column : this._cols) {
                    if (!column.getName().equals(string)) continue;
                    vector.add(column._value);
                    bl = true;
                }
                if (bl) continue;
                vector.add("");
            }
            return vector;
        }
    }
}

