/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.editors.DBEditorController;
import oracle.dbtools.raptor.editors.IStatusMessageProvider;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Log;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectListener;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public abstract class ViewerEditor
extends Editor
implements Controller,
IStatusMessageProvider {
    private JComponent _panel;
    protected Toolbar _toolbar;
    private boolean _visible;
    private boolean _inSync;
    private boolean _pinEnabled = true;
    private IdeAction pinAction;
    private IdeAction _toolbarAction;
    private boolean _initActions = false;
    private String _lastStatusbarMessage = "";
    private ToggleToolButton _pinToggle;
    static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");
    protected ViewerObjectActionListener m_actionListener = new ViewerObjectActionListener();
    protected UpdateListener m_updateListener = null;
    private NodeListener m_nl = new NodeListener(){

        public void nodeWillClose(NodeEvent nodeEvent) {
            ViewerEditor.this.cleanUp();
            nodeEvent.getNode().removeNodeListener((NodeListener)this);
        }
    };

    protected abstract JComponent createViewerUI();

    protected abstract void updateContent(boolean var1);

    protected abstract void cleanUp();

    public abstract Object getPrintable();

    public ViewerEditor() {
        this.pinAction = IdeAction.get((int)PIN_EDITOR_CMD_ID, null, (String)IdeArb.getString((int)28), null, null, (Icon)OracleIcons.getIcon((String)"pin.png"), null, (boolean)true).newLocalAction((View)this);
        this.pinAction.addController((Controller)this);
        Log.status((String)"");
        this.addViewListener(new ViewListener(){

            public void viewActivated(ViewEvent viewEvent) {
            }

            public void viewClosed(ViewEvent viewEvent) {
            }

            public void viewDeactivated(ViewEvent viewEvent) {
                ViewerEditor.this._lastStatusbarMessage = Ide.getStatusBar().getText();
            }
        });
        ObjectActionController.addListener((IObjectActionListener)this.m_actionListener);
    }

    public void open() {
        this.getGUI();
    }

    public Component getGUI() {
        if (this._panel == null) {
            this._panel = this.createViewerUI();
            UIUtils.addIdeKeyBindings((JComponent)this._panel, (int)1, (String)"oracle/dbtools/raptor/oviewer/base/accelerators.xml");
            UIUtils.setupAccelerators((Toolbar)this.getToolbar());
        }
        this.checkPin();
        return this._panel;
    }

    public void checkPin() {
        this.pinAction.setState(((ViewerNode)this.getContext().getNode()).getPinned());
    }

    public void addMenuButton() {
        if (this._toolbarAction == null) {
            JPopupMenu jPopupMenu;
            this._toolbarAction = XMLBasedObjectAction.getInstance().getIdeAction().newLocalAction((View)this);
            if (this.getContext().getNode() instanceof ViewerNode && (jPopupMenu = XMLBasedObjectAction.getInstance().getMenu(((ViewerNode)this.getContext().getNode()).getDBObject())).getComponentCount() > 0) {
                ToolButton toolButton = ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._toolbarAction);
                toolButton.setName(this._toolbarAction.getValue("Name").toString());
                toolButton.setText(Messages.getString("ViewerEditor.3"));
                toolButton.setIcon(OracleIcons.getIcon((String)"extras/dropdown.png"));
                toolButton.setToolTipText(Messages.getString("ViewerEditor.4"));
                this._toolbarAction.putValue("BUTTON", (Object)toolButton);
            }
        }
    }

    public void update(Object object, final UpdateMessage updateMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateImpl(updateMessage);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewerEditor.this.updateImpl(updateMessage);
                }
            });
        }
    }

    void updateImpl(UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == ViewerNode.RELATION_NODE_CHANGED_MESSAGE_ID) {
            this.whenDbNodeChanged();
        } else if (n == ViewerNode.RELATION_NODE_MODIFIED_MESSAGE_ID || n == UpdateMessage.OBJECT_RELOADED) {
            if (this.isVisible()) {
                this.updateContent(true);
            } else {
                this._inSync = false;
            }
        }
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            if (this._pinEnabled) {
                this._pinToggle = this._toolbar.addToggleButton((ToggleAction)this.pinAction);
                this._pinToggle.setName(this.pinAction.getValue("Name").toString());
            }
        }
        return this._toolbar;
    }

    public void editorShown() {
        this.whenVisibilityChanges(true);
    }

    public void editorHidden() {
        this.whenVisibilityChanges(false);
    }

    public boolean isVisible() {
        return this._visible;
    }

    private void whenVisibilityChanges(boolean bl) {
        this._visible = bl;
        if (this._visible) {
            if (!this._inSync) {
                this.whenDbNodeChanged();
            }
            if (this._pinEnabled) {
                ViewerNode viewerNode = (ViewerNode)this.getContext().getNode();
                this.pinAction.setState(viewerNode.getPinned());
                if (!viewerNode.getPinned()) {
                    this._pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
                } else {
                    this._pinToggle.setIcon(RaptorImagesArb.getIcon((String)"PINNED"));
                }
            }
            if (!this._initActions) {
                this.addMenuButton();
                this._initActions = true;
            }
            ViewerEditor.updateToolbarActions((Toolbar)this._toolbar);
        }
    }

    protected void whenDbNodeChanged() {
        Context context = this.getContext();
        Node node = context.getNode();
        if (this.isVisible() && node instanceof ViewerNode) {
            node.addNodeListener(this.m_nl);
            ViewerNode viewerNode = this.getViewerNode();
            Node node2 = viewerNode.getBaseNode();
            context.setSelection(new Element[]{node2});
            this.addDbObjectListener();
            this.updateContent(!this._inSync);
            this._inSync = true;
            Database database = ((ViewerNode)node).getDatabase();
            if (database != null) {
                context.setProperty("Connections.db_name", (Object)Connections.getInstance().getConnectionName(database));
            }
        } else {
            this._inSync = false;
        }
    }

    public ViewerNode getViewerNode() {
        return this.getViewerNode(this.getContext());
    }

    private ViewerNode getViewerNode(Context context) {
        if (context.getNode() instanceof ViewerNode) {
            return (ViewerNode)context.getNode();
        }
        return null;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PIN_EDITOR_CMD_ID) {
            ideAction.setEnabled(true);
            if (context.getNode() instanceof ViewerNode) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PIN_EDITOR_CMD_ID && this._pinEnabled) {
            ViewerNode viewerNode;
            viewerNode.setPinned(!(viewerNode = (ViewerNode)context.getNode()).getPinned());
            if (!viewerNode.getPinned()) {
                this._pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
            } else {
                this._pinToggle.setIcon(RaptorImagesArb.getIcon((String)"PINNED"));
            }
            View.updateToolbarActions((Toolbar)context.getView().getToolbar());
            return true;
        }
        return false;
    }

    public boolean isPinEnabled() {
        return this._pinEnabled;
    }

    public void setPinEnabled(boolean bl) {
        this._pinEnabled = bl;
    }

    public void close() {
        ObjectActionController.removeListener((IObjectActionListener)this.m_actionListener);
        if (this.m_updateListener != null) {
            this.m_updateListener.close();
            this.m_updateListener = null;
        }
        super.close();
        this.cleanUp();
    }

    public Controller getController() {
        return DBEditorController.getInstance();
    }

    public String getStatusMessage() {
        return this._lastStatusbarMessage;
    }

    protected void addDbObjectListener() {
        SchemaObject schemaObject;
        DBObject dBObject;
        boolean bl;
        ViewerNode viewerNode = this.getViewerNode();
        if (viewerNode != null && (bl = Connections.getInstance().isOracle(Connections.getInstance().getConnectionName(viewerNode.getDatabase()))) && (dBObject = new DBObject((Element)viewerNode)) != null && (schemaObject = dBObject.getSchemaObject()) != null) {
            if (this.m_updateListener != null) {
                this.m_updateListener.close();
            }
            this.m_updateListener = new UpdateListener(schemaObject);
            schemaObject.addObjectListener((DBObjectListener)this.m_updateListener);
        }
    }

    private class ViewerObjectActionListener
    implements IObjectActionListener {
        private ViewerObjectActionListener() {
        }

        public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        private void closeEditor(DBObject dBObject) {
            URL uRL;
            URL uRL2;
            assert (dBObject != null);
            ViewerNode viewerNode = (ViewerNode)ViewerEditor.this.getContext().getNode();
            DBObject dBObject2 = viewerNode.getDBObject();
            if (dBObject2 != null && ModelUtil.areEqual((Object)(uRL2 = dBObject2.getURL()), (Object)(uRL = dBObject.getURL()))) {
                EditorManager.getEditorManager().closeEditors(Arrays.asList(ViewerEditor.this));
                if (NodeFactory.find((URL)uRL) != null) {
                    NavSelectionListener.getInstance().open(uRL);
                }
            }
        }
    }

    private final class UpdateListener
    extends DBObjectListener {
        private SchemaObject m_so;

        UpdateListener(SchemaObject schemaObject) {
            this.m_so = schemaObject;
        }

        void close() {
            if (this.m_so != null) {
                this.m_so.removeObjectListener((DBObjectListener)this);
                this.m_so = null;
            }
        }

        public void objectUpdated(DBObjectChange dBObjectChange) {
            List list = EditorManager.getEditorManager().getAllEditors();
            for (Editor editor : list) {
                if (editor == null || editor != ViewerEditor.this) continue;
                ViewerEditor.this.updateContent(true);
                break;
            }
        }
    }
}

