/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.plsql.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.IResultSetTableDrillDown;
import oracle.dbtools.raptor.controls.display.AbstractDisplayModelParser;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.DrillToBaseObject;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.oviewer.base.PopupDescribe;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerEditorAddin;
import oracle.dbtools.raptor.oviewer.base.ViewerNavigationPoint;
import oracle.dbtools.raptor.oviewer.base.ViewerPrintFactory;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.util.Resource;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.PrintManager;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ViewerAddin
implements Addin {
    private Logger logger = Logger.getLogger(ViewerAddin.class.getName());
    private static final String CLASS = "class";
    private static List<URL> _registeredEditors = new ArrayList<URL>();
    private static List<String> _registeredPackages = new ArrayList<String>();
    private Map<String, List<ViewerEditorAddin>> _editorsAddins = new HashMap<String, List<ViewerEditorAddin>>();
    private Map<String, List<DisplayModel>> _editors = new HashMap<String, List<DisplayModel>>();
    private static Object __LOCK__ = new Object();
    private static Thread s_loader;
    public static final String LOCAL_ACCELERATORS_FILE = "oracle/dbtools/raptor/oviewer/base/accelerators.xml";
    private Transaction _txn;

    public static synchronized void registerPackage(String string) {
        _registeredPackages.add(string);
    }

    public static synchronized List<String> getRegisteredPackages() {
        return _registeredPackages;
    }

    public static synchronized void registerEditors(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = URLFactory.newFileURL((File)new File(string));
        }
        if (uRL != null) {
            _registeredEditors.add(uRL);
        } else {
            Logger.getLogger(ViewerAddin.class.getName()).warning(Messages.getString("ViewerAddin.3") + URLFileSystem.getSystemDisplayName((URL)uRL));
        }
    }

    public static synchronized List<URL> getRegisteredEditors() {
        return _registeredEditors;
    }

    public void initialize() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), LOCAL_ACCELERATORS_FILE);
        NavSelectionListener.initialize();
        ResultSetTable.setDrillDown((IResultSetTableDrillDown)NavSelectionListener.getInstance());
        ResultSetTable.addGridContextMenu((GridContextMenuItem)DrillToBaseObject.getInstance());
        ViewerAddin.registerPackage("oracle.dbtools.raptor.oviewer.base.xml");
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent ideEvent) {
            }

            public void mainWindowClosing(IdeEvent ideEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mainWindowOpened(IdeEvent ideEvent) {
                Object object = __LOCK__;
                synchronized (object) {
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ViewerAddin.this.loadXMLEditors();
                            Object object = __LOCK__;
                            synchronized (object) {
                                s_loader = null;
                            }
                        }
                    };
                    s_loader = new Thread(runnable, "EditorLoader");
                    s_loader.start();
                }
            }
        });
        PrintManager.getPrintManager().registerDocumentPrintFactory(ViewerEditor.class, ViewerPrintFactory.class);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)PopupDescribe.getInstance());
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.raptor.oviewer.navActions");
        IdentifierDefinitionLookup.init();
        NavigationManager navigationManager = NavigationManager.getNavigationManager();
        if (navigationManager != null) {
            navigationManager.registerEditorNavigationPoint(ViewerNavigationPoint.class, XMLBasedEditor.class);
        }
    }

    public void addTab(String string, String string2, String string3, Class<? extends Editor> clazz, DisplayModel displayModel) {
        ViewerEditorAddin viewerEditorAddin = new ViewerEditorAddin(string, string2, string3, clazz);
        if (displayModel != null) {
            viewerEditorAddin.setModel(displayModel);
        }
        if (XMLBasedEditor.class.isAssignableFrom(clazz)) {
            String string4 = ViewerAddin.getKey(string2, string3);
            this.registerEditor(viewerEditorAddin, string4);
        }
        if (Ide.isRunning() && EditorManager.getEditorManager() != null) {
            EditorManager.getEditorManager().registerDynamic((EditorAddin)viewerEditorAddin);
        }
    }

    private static String getKey(String string, String string2) {
        if (string == null) {
            string = "Oracle";
        }
        return string + "#" + string2;
    }

    private void registerEditor(ViewerEditorAddin viewerEditorAddin, String string) {
        List<ViewerEditorAddin> list = this._editorsAddins.get(string);
        if (list == null) {
            list = new ArrayList<ViewerEditorAddin>();
            this._editorsAddins.put(string, list);
        }
        list.add(viewerEditorAddin);
    }

    public DisplayModel getModel(DBObject dBObject, int n) {
        String string = null;
        string = dBObject.getKey();
        DisplayModel displayModel = null;
        List<ViewerEditorAddin> list = this.getEditorsAddins(string);
        if (list != null && list.size() > n) {
            displayModel = list.get(n).getModel();
        }
        return displayModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ViewerEditorAddin> getEditorsAddins(String string) {
        Object object = __LOCK__;
        synchronized (object) {
            if (s_loader != null) {
                try {
                    s_loader.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this._editorsAddins.get(string);
    }

    public Map<String, List<DisplayModel>> getXMLEditors() {
        return this._editors;
    }

    public void loadXMLEditors() {
        long l = System.currentTimeMillis();
        List list = DBConfig.getInstance().getExtensions("EDITOR");
        if (list != null) {
            for (Iterator<URL> iterator : list) {
                ViewerAddin.registerEditors((String)((Object)iterator));
            }
        }
        this.loadCommonQueries();
        Object object = new XMLParser();
        for (String object2 : ViewerAddin.getRegisteredPackages()) {
            for (URL uRL : FileUtils.getFilesInPackage((String)object2, (String)"xml", (boolean)false)) {
                try {
                    object.processXML(uRL.openStream(), uRL);
                }
                catch (Exception exception) {
                    this.logger.info(Messages.getString("ViewerAddin.11") + URLFileSystem.getSystemDisplayName((URL)uRL));
                }
            }
        }
        if (System.getProperty("raptor.user.editors") != null) {
            try {
                object.processXML(new FileInputStream(System.getProperty("raptor.user.editors")));
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, Messages.getString("ViewerAddin.14") + exception.getMessage());
            }
        }
        for (URL uRL : ViewerAddin.getRegisteredEditors()) {
            try {
                object.processXML(uRL.openStream(), uRL);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, Messages.getString("ViewerAddin.15") + exception.getMessage());
            }
        }
        System.out.print("\n\n LOAD TIME : " + (System.currentTimeMillis() - l));
    }

    private void loadCommonQueries() {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse(Resource.getResourceAsStream(this.getClass(), (String)"commonQueries.xml"));
        }
        catch (XMLParseException xMLParseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, xMLParseException.getStackTrace()[0].toString(), xMLParseException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        NodeList nodeList = xMLDocument.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equals("queries")) {
                Query.getQueries((org.w3c.dom.Node)nodeList.item(i), (Transaction)this._txn);
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("query")) {
                Query.getQuery((org.w3c.dom.Node)nodeList.item(i), null, (Transaction)this._txn);
                continue;
            }
            if (!nodeList.item(i).getNodeName().equals("display")) continue;
            DisplayModel.getDisplayModel((org.w3c.dom.Node)nodeList.item(i), null, (Transaction)this._txn);
        }
    }

    public List<DisplayModel> getModels(Class<? extends Node> clazz) {
        if (!Node.class.isAssignableFrom(clazz)) {
            return null;
        }
        String string = clazz.toString().substring(clazz.toString().lastIndexOf(46) + 1);
        String[] stringArray = AbstractDisplayModelParser.getTypesForNode((String)string);
        String string2 = ViewerAddin.getKey("Oracle", stringArray[0]);
        ArrayList<DisplayModel> arrayList = new ArrayList<DisplayModel>();
        List<ViewerEditorAddin> list = this.getEditorsAddins(string2);
        for (ViewerEditorAddin viewerEditorAddin : list) {
            arrayList.add(viewerEditorAddin.getModel());
        }
        return arrayList;
    }

    public List<DisplayModel> getModels(DBObject dBObject) {
        String string = ViewerAddin.getKey(dBObject.getConnectionType(), dBObject.getObjectType());
        List<ViewerEditorAddin> list = this.getEditorsAddins(string);
        ArrayList<DisplayModel> arrayList = new ArrayList<DisplayModel>();
        if (list != null) {
            for (ViewerEditorAddin viewerEditorAddin : list) {
                arrayList.add(viewerEditorAddin.getModel());
            }
        }
        return arrayList;
    }

    private final class XMLParser
    extends AbstractDisplayModelParser {
        private XMLParser() {
        }

        protected void registerEditor(String string, String string2, DisplayModel displayModel, String string3) {
            String string4 = ViewerAddin.getKey(string, string2);
            if (string4 != null) {
                displayModel.getExtAttributes().put(ViewerAddin.CLASS, string4);
                if (ViewerAddin.this._editors.get(string4) == null) {
                    ViewerAddin.this._editors.put(string4, new ArrayList());
                }
                if (string3 == null) {
                    ((List)ViewerAddin.this._editors.get(string4)).add(displayModel);
                }
                Class<Editor> clazz = null;
                try {
                    if (string3 == null) {
                        int n = ((List)ViewerAddin.this._editors.get(string4)).size() - 1;
                        string3 = "oracle.dbtools.raptor.oviewer.xmleditor.holders.XMLBasedEditor" + n;
                    }
                    clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(string3).asSubclass(Editor.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ViewerAddin.this.logger.severe(Messages.getString("ViewerAddin.51") + classNotFoundException.getMessage());
                }
                ViewerAddin.this.addTab(displayModel.getName(), string, string2, clazz, displayModel);
            }
        }
    }
}

