/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.celleditor.RSTableEditorTextField;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.search.BaseSearchPanel;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class PopupDescribe
implements Controller,
ContextMenuListener {
    static final Logger logger = Logger.getLogger(PopupDescribe.class.getName());
    static final String ACCELERATOR_FILE = "oracle/dbtools/raptor/oviewer/accelerators.xml";
    public static int POPUP_DESCR = Ide.findOrCreateCmdID((String)"popup_describe");
    private IdeAction popupDescr;
    private static PopupDescribe _instance;
    private static DBObject _currentDbObject;

    private PopupDescribe() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), ACCELERATOR_FILE);
        this.createAction();
    }

    public static synchronized PopupDescribe getInstance() {
        if (_instance == null) {
            _instance = new PopupDescribe();
        }
        return _instance;
    }

    public static void showPopup(Context context) {
        if (PopupDescribe.canDescribe(context)) {
            PopupDescribe.showPopup();
        }
    }

    private static void showPopup() {
        PopupDescribe.showPopup(_currentDbObject);
    }

    public static void showPopup(final DBObject dBObject) {
        ViewerAddin viewerAddin = (ViewerAddin)AddinManager.getAddinManager().getAddin(ViewerAddin.class);
        List<DisplayModel> list = viewerAddin.getModels(dBObject);
        if (list.size() == 0) {
            BaseSearchPanel.goTo((URL)dBObject.getURL());
            return;
        }
        if (list != null && list.size() > 0) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NavSelectionListener.getInstance().open(dBObject.getNode(), false);
                }
            };
            final CustomTabbedPane customTabbedPane = new CustomTabbedPane();
            customTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (customTabbedPane.getActivePanel().isShowing()) {
                        DisplayPanel displayPanel = (DisplayPanel)customTabbedPane.getActivePanel();
                        displayPanel.refresh(true, true);
                    }
                }
            });
            HelpSystem.getHelpSystem().registerTopic((JComponent)customTabbedPane, "f1_popupdbobjectoverview_html");
            boolean bl = false;
            for (DisplayModel displayModel : list) {
                if (displayModel.getQuery(dBObject.getConnection()) == null) continue;
                displayModel.setConnection(dBObject.getConnection());
                DisplayPanel displayPanel = new DisplayPanel(displayModel, dBObject.getDictionary(), bl, null);
                customTabbedPane.addTab(null, displayModel.getName(), (Component)displayPanel);
                if (bl) continue;
                bl = true;
            }
            customTabbedPane.setPreferredSize(new Dimension(800, 300));
            customTabbedPane.setMinimumSize(new Dimension(800, 300));
            UIUtils.showPanelAsDialog((JPanel)customTabbedPane, (String)dBObject.getObjectName(), (ActionListener)actionListener, (int)7, (boolean)false);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == POPUP_DESCR) {
            PopupDescribe.showPopup(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (POPUP_DESCR == ideAction.getCommandId()) {
            Serializable serializable;
            String string = null;
            if (context.getView() instanceof DbEditor) {
                string = ((DbEditor)context.getView()).getConnectionName();
            } else {
                try {
                    serializable = context.getNode().getURL();
                    string = DBURLFormatHelper.getConnectionName((URL)serializable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string != null) {
                serializable = Connections.getInstance().getLock(string);
                ideAction.setEnabled(!((ReentrantLock)serializable).isLocked());
                return true;
            }
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (view instanceof Editor && context.getEvent().getSource() instanceof JTextComponent) {
            Object object;
            String string = (String)context.getProperty("Connections.db_name");
            if (string == null) {
                if (view instanceof DbEditor) {
                    string = ((DbEditor)view).getConnectionName();
                } else {
                    object = context.getNode().getURL();
                    if (DBURLFormatHelper.isDBURL((URL)object)) {
                        string = DBURLFormatHelper.getConnectionName((URL)object);
                    }
                }
            }
            if (string == null && (object = context.getNode()) instanceof PlSqlNode) {
                string = ((PlSqlNode)object).getConnectionName();
            }
            if (string != null && Connections.getInstance().isOracle(string)) {
                if (this.popupDescr == null) {
                    this.createAction();
                }
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.popupDescr));
            }
        }
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    private static String scrubDbObjectName(Context context) {
        String string = "";
        if (context.getView() instanceof Editor) {
            Editor editor = (Editor)context.getView();
            Component component = editor.getDefaultFocusComponent();
            if (component instanceof BasicEditorPane) {
                BasicEditorPane basicEditorPane = (BasicEditorPane)editor.getDefaultFocusComponent();
                int n = basicEditorPane.getCaretPosition();
                if (basicEditorPane.getSelectedText() != null) {
                    string = ((BasicEditorPane)editor.getDefaultFocusComponent()).getSelectedText();
                } else {
                    try {
                        String string2 = basicEditorPane.getDocument().getText(0, basicEditorPane.getDocument().getLength());
                        List list = LexerToken.parse((String)string2, (boolean)false);
                        StringBuilder stringBuilder = new StringBuilder();
                        boolean bl = false;
                        for (LexerToken lexerToken : list) {
                            if (n < lexerToken.begin) {
                                if (bl) {
                                    bl = false;
                                    stringBuilder.append(lexerToken.content);
                                    continue;
                                }
                                if (!".".equals(lexerToken.content) && !"@".equals(lexerToken.content)) break;
                                bl = true;
                                stringBuilder.append(lexerToken.content);
                                continue;
                            }
                            if (bl) {
                                stringBuilder.append(lexerToken.content);
                                bl = false;
                                continue;
                            }
                            if (".".equals(lexerToken.content) || "@".equals(lexerToken.content)) {
                                bl = true;
                                stringBuilder.append(lexerToken.content);
                                continue;
                            }
                            if (lexerToken.type != Token.IDENTIFIER) {
                                stringBuilder = new StringBuilder();
                                continue;
                            }
                            stringBuilder = new StringBuilder(lexerToken.content);
                        }
                        string = stringBuilder.toString();
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(PopupDescribe.class.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                    }
                }
            } else if (component instanceof RSTableEditorTextField) {
                return ((RSTableEditorTextField)component).getSelectedText().trim();
            }
        }
        return string;
    }

    private static boolean canDescribe(Context context) {
        if (context.getView() instanceof DbEditor) {
            return PopupDescribe.canDescribe(context, ((DbEditor)context.getView()).getConnectionName());
        }
        try {
            Node node;
            URL uRL = context.getNode().getURL();
            String string = DBURLFormatHelper.getConnectionName((URL)uRL);
            if (string == null && (node = context.getNode()) instanceof PlSqlNode) {
                string = ((PlSqlNode)node).getConnectionName();
            }
            return PopupDescribe.canDescribe(context, string);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private static boolean canDescribe(Context context, String string) {
        if (context.getView() instanceof Editor) {
            return PopupDescribe.canDescribe(PopupDescribe.scrubDbObjectName(context), string);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canDescribe(String string, String string2) {
        if (string != null && !string.equals("")) {
            if (string2 != null) {
                _currentDbObject = null;
                _currentDbObject = PopupDescribe.getDBObjectForName(string, string2);
                if (_currentDbObject != null) return true;
                logger.info(Messages.getString("PopupDescribe.13"));
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)(Messages.getString("PopupDescribe.14") + string), (String)Messages.getString("PopupDescribe.15"), (String)"f1_noobjectfound_html");
                return false;
            } else {
                logger.warning(Messages.getString("PopupDescribe.17"));
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("PopupDescribe.18"), (String)Messages.getString("PopupDescribe.19"), (String)"f1_noConnectionFound_html");
            }
            return false;
        } else {
            logger.info(Messages.getString("PopupDescribe.21"));
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("PopupDescribe.22"), (String)Messages.getString("PopupDescribe.23"), (String)"f1_noobjectselected_html");
        }
        return false;
    }

    private void createAction() {
        if (this.popupDescr == null) {
            this.popupDescr = IdeAction.get((int)POPUP_DESCR, null, (String)Messages.getString("PopupDescribe.0"), null, null, null, null, (boolean)true);
            this.popupDescr.addController((Controller)this);
        }
    }

    private static DBObject getDBObjectForName(String string, String string2) {
        return DBObject.getDBObjectForName((String)string, (String)string2);
    }
}

