/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.dbtools.parser.plsql.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.internal.ObjectMutexRule;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.cloud.navigator.CloudViewerDetail;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.IResultSetTableDrillDown;
import oracle.dbtools.raptor.controls.ViewerOpener;
import oracle.dbtools.raptor.controls.search.BaseSearchPanel;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.ViewableSelectionComponentProvider;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.cloud.CloudEditorUtils;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public class NavSelectionListener
implements ViewSelectionListener,
IResultSetTableDrillDown,
ViewerOpener {
    private ViewableElement _pendingNodeSelectionChange;
    private boolean _hasMousePressed;
    private boolean _hasMouseReleased;
    private boolean _hasSelectionChanged;
    private boolean _inRightClick;
    private static NavSelectionListener _instance;
    private String row;
    private MouseAdapter m_mouseHandler = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            Boolean bl = DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK");
            if (bl.booleanValue() || mouseEvent.getClickCount() == 2) {
                Object object = mouseEvent.getSource();
                ViewableElement viewableElement = null;
                if (object instanceof CustomTree) {
                    CustomTree customTree = (CustomTree)object;
                    TreePath treePath = customTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        viewableElement = NavSelectionListener.this.getLastObject(customTree);
                    }
                } else if (object instanceof JList) {
                    viewableElement = NavSelectionListener.this.getLastObject(mouseEvent.getPoint(), (JList)object);
                }
                if (viewableElement != null) {
                    NavSelectionListener.this.whenDatabaseObjectSelected(viewableElement, bl == false);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            NavSelectionListener.this._inRightClick = mouseEvent.getModifiers() == 4 || mouseEvent.getModifiers() == 8;
            NavSelectionListener.this.cancelPendingChanges();
            NavSelectionListener.this._hasMousePressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            ViewableElement viewableElement = null;
            boolean bl = false;
            if (object instanceof CustomTree) {
                CustomTree customTree = (CustomTree)mouseEvent.getSource();
                viewableElement = NavSelectionListener.this.getLastObject(customTree);
                bl = customTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) != null;
            } else if (object instanceof JList) {
                viewableElement = NavSelectionListener.this.getLastObject(mouseEvent.getPoint(), (JList)object);
                boolean bl2 = bl = viewableElement != null;
            }
            if (viewableElement != null) {
                NavSelectionListener.this._pendingNodeSelectionChange = viewableElement;
            }
            if (NavSelectionListener.this._hasSelectionChanged && bl) {
                NavSelectionListener.this.doPendingChanges();
            } else {
                NavSelectionListener.this._hasMouseReleased = true;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            NavSelectionListener.this.cancelPendingChanges();
            NavSelectionListener.this._hasMousePressed = true;
        }
    };

    private NavSelectionListener() {
    }

    public static NavSelectionListener getInstance() {
        return _instance;
    }

    public static void initialize() {
        _instance = new NavSelectionListener();
        IdentifierDefinitionLookup.registerViewerOpener((ViewerOpener)_instance);
        BaseSearchPanel.registerViewerOpener((ViewerOpener)_instance);
        PlSqlNode.registerViewerOpener((ViewerOpener)_instance);
        Ide.addIdeListener((IdeListener)new L());
    }

    private static void hookNavigator(View view, ViewableSelectionComponentProvider viewableSelectionComponentProvider) {
        view.addViewSelectionListener((ViewSelectionListener)_instance);
        Component component = viewableSelectionComponentProvider.getViewableSelectionComponent();
        boolean bl = true;
        MouseAdapter mouseAdapter = NavSelectionListener._instance.m_mouseHandler;
        for (MouseListener mouseListener : component.getMouseListeners()) {
            if (mouseListener != mouseAdapter) continue;
            bl = false;
            break;
        }
        if (bl) {
            component.addMouseListener(mouseAdapter);
            component.addMouseMotionListener(mouseAdapter);
        }
    }

    public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        Element element;
        Element[] elementArray = viewSelectionEvent.getSelection();
        if (elementArray != null && DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK").booleanValue() && elementArray.length == 1 && this.isObjectNode(element = elementArray[0])) {
            this._pendingNodeSelectionChange = (ViewableElement)element;
            boolean bl = false;
            if (!this._hasSelectionChanged && this._hasMousePressed && (!this._hasMouseReleased || this._inRightClick)) {
                bl = true;
            }
            if (bl) {
                this._hasSelectionChanged = true;
            } else {
                this.doPendingChanges();
            }
        }
    }

    private boolean isObjectNode(Element element) {
        return element instanceof ViewableElement;
    }

    private void whenDatabaseObjectSelected(final ViewableElement viewableElement, final boolean bl) {
        if (this._inRightClick) {
            return;
        }
        RaptorTask<Void> raptorTask = new RaptorTask<Void>("Object Selection", true, IRaptorTaskRunMode.TASKVIEWER){
            private ISchedulingRule m_rule;

            protected Void doWork() throws TaskException {
                if (viewableElement instanceof CloudObject) {
                    CloudObject cloudObject = (CloudObject)viewableElement;
                    LinkedHashMap linkedHashMap = cloudObject.getViewers();
                    CloudEditorUtils cloudEditorUtils = CloudEditorUtils.getInstance();
                    String string = cloudObject.getObjectType();
                    float f = 10000.0f;
                    for (Map.Entry entry : linkedHashMap.entrySet()) {
                        try {
                            CloudViewerDetail cloudViewerDetail = (CloudViewerDetail)entry.getValue();
                            cloudEditorUtils.addTab((String)entry.getKey(), string, null, Float.valueOf(f), cloudViewerDetail.getUriString(), cloudViewerDetail.getStyle());
                            f -= 1.0f;
                        }
                        catch (Exception exception) {
                            Logger.severe(NavSelectionListener.class, (Throwable)exception);
                        }
                    }
                    NavSelectionListener.this.open(viewableElement, bl);
                } else if (viewableElement instanceof PlSqlNode) {
                    int n = 1;
                    try {
                        n = Integer.parseInt(NavSelectionListener.this.row);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    NavSelectionListener.this.open((ViewableElement)((PlSqlNode)viewableElement), n, -1, bl);
                } else if (viewableElement instanceof ObjectFolder) {
                    DatabaseFolder databaseFolder;
                    ObjectFolder objectFolder = (ObjectFolder)viewableElement;
                    DatabaseItem databaseItem = objectFolder.getFolderInstance().getDescriptor();
                    if (databaseItem instanceof DatabaseFolder && (databaseFolder = (DatabaseFolder)databaseItem).isSingleClickOpen()) {
                        NavSelectionListener.this.open(viewableElement, bl);
                    }
                } else if (!(viewableElement instanceof ObjectFolder)) {
                    NavSelectionListener.this.open(viewableElement, bl);
                }
                return null;
            }

            public synchronized ISchedulingRule getSchedulingRule() {
                if (this.m_rule == null) {
                    this.m_rule = new ObjectMutexRule((Object)NavSelectionListener.this);
                }
                return this.m_rule;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void open(URL uRL) {
        this.open(uRL, 0, 0);
    }

    public void open(URL uRL, int n, int n2) {
        this.open(uRL, n, n2, true);
    }

    public boolean waitOnOpen(URL uRL, int n, int n2) {
        return this.open(uRL, n, n2, true);
    }

    private boolean open(URL uRL, int n, int n2, boolean bl) {
        Node node = NodeFactory.find((URL)uRL);
        ViewableElement viewableElement = node instanceof ViewableElement ? (ViewableElement)node : DatabaseNavigatorElementFactory.getObjectNode((URL)uRL);
        return this.open(viewableElement, n, n2, bl);
    }

    public void open(ViewableElement viewableElement, int n, int n2) {
        this.open(viewableElement, n, n2, true);
    }

    private boolean open(final ViewableElement viewableElement, final int n, final int n2, final boolean bl) {
        if (viewableElement instanceof PlSqlNode) {
            final PlSqlNode plSqlNode = (PlSqlNode)viewableElement;
            String string = plSqlNode.getConnectionName();
            if (string != null) {
                Connections connections = Connections.getInstance();
                Connection connection = null;
                try {
                    connection = connections.getConnection(string, false);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (connection == null || !connections.lock(connection, true)) {
                    return false;
                }
                connections.unlock(connection);
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Node node;
                    Context context;
                    EditorManager editorManager = EditorManager.getEditorManager();
                    Context context2 = null;
                    for (Object e : editorManager.getAllEditors()) {
                        context = ((Editor)e).getContext();
                        node = context != null ? context.getNode() : null;
                        if (node != plSqlNode) continue;
                        context2 = context;
                    }
                    WaitCursor waitCursor = null;
                    if (context2 == null) {
                        waitCursor = Ide.getWaitCursor();
                    }
                    try {
                        if (waitCursor != null) {
                            waitCursor.show();
                        }
                        int n3 = 0;
                        if (0 < n) {
                            context = plSqlNode.acquireTextBuffer();
                            node = context.getLineMap();
                            n3 = node.getLineStartOffset(n) + n2 - 1;
                            plSqlNode.releaseTextBuffer();
                        }
                        if (context2 == null) {
                            context2 = Context.newIdeContext((Element)viewableElement);
                        }
                        context = new OpenEditorOptions(context2, CodeEditor.class);
                        context.setFlags(bl ? 5 : 1);
                        node = (CodeEditor)editorManager.openEditor((OpenEditorOptions)context);
                        node.gotoOffset(n3, 0);
                        OutlineWindow.getInstance().refresh((Editor)node);
                    }
                    finally {
                        if (waitCursor != null) {
                            waitCursor.hide();
                        }
                    }
                }
            });
            return true;
        }
        return this.open(viewableElement, bl);
    }

    public void open(Node node) {
        this.open(node, true);
    }

    public void open(Node node, boolean bl) {
        if (node instanceof ViewableElement) {
            this.open((ViewableElement)node, bl);
        }
    }

    private boolean open(ViewableElement viewableElement, boolean bl) {
        ViewerNode viewerNode = ViewerNode.getUnpinnedInstance();
        viewerNode.ensureOpen();
        DBObject dBObject = new DBObject((Element)viewableElement);
        boolean bl2 = DBConfig.getInstance().getBoolean("AUTOPIN");
        if (!this.raiseEditor(viewableElement, bl)) {
            boolean bl3;
            boolean bl4;
            Connections connections;
            EditorManager editorManager = EditorManager.getEditorManager();
            String string = dBObject.getConnectionName();
            if (string != null) {
                connections = Connections.getInstance();
                Connection connection = null;
                try {
                    connection = connections.getConnection(string, false);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (connection == null || !connections.lock(connection, true)) {
                    return false;
                }
                connections.unlock(connection);
            }
            if (viewerNode.getDBObject() == null) {
                bl4 = true;
                bl3 = this.hasViewer(dBObject);
            } else {
                connections = viewerNode.getDBObject();
                boolean bl5 = bl4 = ModelUtil.areDifferent((Object)connections.getObjectType(), (Object)dBObject.getObjectType()) || ModelUtil.areDifferent((Object)connections.getConnectionType(), (Object)dBObject.getConnectionType()) || ModelUtil.areDifferent((Object)connections.getDBVersion(), (Object)dBObject.getDBVersion());
                if (!bl4) {
                    bl4 = "true".equals(connections.getDictionary().get("NEW_OBJECTVIEWER_FLAG"));
                }
                bl3 = bl4 ? this.hasViewer(dBObject) : true;
            }
            if (!bl3) {
                return false;
            }
            if (bl4) {
                this.closeObjectViewer(viewerNode);
            }
            viewerNode.setViewedObject(dBObject);
            connections = Context.newIdeContext((Node)viewerNode);
            SwingUtilities.invokeLater(new Runnable((Context)connections, bl, viewerNode, bl2, editorManager){
                final /* synthetic */ Context val$context;
                final /* synthetic */ boolean val$focusEditor;
                final /* synthetic */ ViewerNode val$viewerNode;
                final /* synthetic */ boolean val$autopin;
                final /* synthetic */ EditorManager val$editorManager;
                {
                    this.val$context = context;
                    this.val$focusEditor = bl;
                    this.val$viewerNode = viewerNode;
                    this.val$autopin = bl2;
                    this.val$editorManager = editorManager;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(this.val$context);
                    openEditorOptions.setFlags(this.val$focusEditor ? 5 : 1);
                    WaitCursor waitCursor = Ide.getWaitCursor();
                    try {
                        this.val$viewerNode.setPinned(this.val$autopin);
                        waitCursor.show();
                        Editor editor = this.val$editorManager.openEditor(openEditorOptions);
                        if (editor != null) {
                            View.updateToolbarActions((Toolbar)editor.getToolbar());
                        }
                    }
                    finally {
                        waitCursor.hide();
                    }
                }
            });
            return true;
        }
        return false;
    }

    protected boolean hasViewer(DBObject dBObject) {
        boolean bl = false;
        ViewerNode viewerNode = ViewerNode.getTestInstance();
        viewerNode.setViewedObject(dBObject);
        EditorManager editorManager = EditorManager.getEditorManager();
        EditorAddin editorAddin = editorManager.getBestEditorAddin((Node)viewerNode);
        if (editorAddin != null) {
            bl = true;
        }
        return bl;
    }

    private void closeObjectViewer(final ViewerNode viewerNode) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                List list = editorManager.getAllEditors();
                for (int i = list.size() - 1; i >= 0; --i) {
                    Editor editor = (Editor)list.get(i);
                    Context context = editor.getContext();
                    Node node = context.getNode();
                    if (viewerNode == node) continue;
                    list.remove(i);
                }
                if (!list.isEmpty()) {
                    editorManager.closeEditors(list);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                Logger.severe(NavSelectionListener.class, (Throwable)exception);
            }
        }
    }

    private ViewableElement getLastObject(CustomTree customTree) {
        Object object;
        ViewableElement viewableElement = null;
        if (customTree.getSelectionCount() > 0 && (object = ((ExplorerNode)customTree.getLastSelectedPathComponent()).getUserObject()) instanceof ViewableElement) {
            viewableElement = (ViewableElement)object;
        }
        return viewableElement;
    }

    private boolean raiseEditor(final ViewableElement viewableElement, final boolean bl) {
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean bl2 = false;
                List list = EditorManager.getEditorManager().getAllEditors();
                for (Editor editor : list) {
                    ViewerNode viewerNode;
                    if (!(editor instanceof ViewerEditor) || (viewerNode = ((ViewerEditor)editor).getViewerNode()) == null || viewerNode.getBaseNode() != viewableElement) continue;
                    final Context context = editor.getContext();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                            openEditorOptions.setFlags(bl ? 5 : 1);
                            EditorManager.getEditorManager().openEditor(openEditorOptions);
                        }
                    });
                    bl2 = true;
                    break;
                }
                return bl2;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                return (Boolean)callable.call();
            }
            catch (Exception exception) {
                Logger.warn(NavSelectionListener.class, (Throwable)exception);
            }
        } else {
            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(callable);
            SwingUtilities.invokeLater(futureTask);
            try {
                return futureTask.get();
            }
            catch (Exception exception) {
                Logger.warn(NavSelectionListener.class, (Throwable)exception);
            }
        }
        return false;
    }

    private void doPendingChanges() {
        ViewableElement viewableElement = this._pendingNodeSelectionChange;
        this.cancelPendingChanges();
        this.whenDatabaseObjectSelected(viewableElement, false);
    }

    private void cancelPendingChanges() {
        this._pendingNodeSelectionChange = null;
        this._hasMousePressed = false;
        this._hasMouseReleased = false;
        this._hasSelectionChanged = false;
    }

    public void performDrill(Element element, String string) {
        this.cancelPendingChanges();
        this._inRightClick = false;
        this.row = string;
        if (element instanceof ViewableElement) {
            this.whenDatabaseObjectSelected((ViewableElement)element, true);
        }
    }

    private ViewableElement getLastObject(Point point, JList jList) {
        Object e;
        Rectangle rectangle;
        ViewableElement viewableElement = null;
        int n = jList.locationToIndex(point);
        if (n != -1 && (rectangle = jList.getCellBounds(n, n)).contains(point) && (e = jList.getModel().getElementAt(n)) instanceof ViewableElement) {
            viewableElement = (ViewableElement)e;
        }
        return viewableElement;
    }

    private static class L
    implements IdeListener {
        private L() {
        }

        public void mainWindowClosing(IdeEvent ideEvent) {
        }

        public void addinsLoaded(IdeEvent ideEvent) {
        }

        public void mainWindowOpened(IdeEvent ideEvent) {
            NavigatorWindow navigatorWindow = DatabaseNavigatorManager.getInstance().getNavigatorWindow();
            NavSelectionListener.hookNavigator((View)navigatorWindow, (ViewableSelectionComponentProvider)navigatorWindow);
            Ide.getMainWindow().addActiveViewListener(new ActiveViewListener(){

                public void activeViewChanged(ActiveViewEvent activeViewEvent) {
                    View view;
                    if (activeViewEvent.getOldView() != null) {
                        activeViewEvent.getOldView().removeViewSelectionListener((ViewSelectionListener)_instance);
                    }
                    if ((view = activeViewEvent.getNewView()) instanceof ViewableSelectionComponentProvider) {
                        NavSelectionListener.hookNavigator(view, (ViewableSelectionComponentProvider)view);
                    }
                }
            });
        }
    }
}

