/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.display.DisplayConstants;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.NameComparator;
import oracle.dbtools.raptor.navigator.plsql.PlsqlStructureParser;
import oracle.dbtools.raptor.oviewer.base.ConnectionExportTask;
import oracle.dbtools.raptor.oviewer.base.Messages;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.util.Logger;
import oracle.dss.graph.Graph;
import oracle.i18n.util.OraLocaleInfo;

public class HTMLTabFormatter {
    public static final String FORMAT_TYPE = "HTML DDL";
    private List<DisplayModel> _models;
    private DBObject _selectedObject;
    private Map<String, Object> _binds;
    private File _baseDir;
    private String _objectName;
    private String _pathPrefix;
    private boolean _includeChildReports;
    private String _filePath;
    private final String tabPad = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static String[] EMPTY_COLS = new String[0];
    private static Set<String> FILTER_COLS = new HashSet<String>(Arrays.asList("SDEV_LINK_NAME", "SDEV_LINK_TYPE", "SDEV_LINK_OWNER"));
    private static final String NULL_DISPLAY_STRING = "null";

    public HTMLTabFormatter(DBObject dBObject, List<DisplayModel> list, Map<String, Object> map, File file) {
        this(dBObject, list, map, file, null, "../", true);
    }

    public HTMLTabFormatter(DBObject dBObject, List<DisplayModel> list, Map<String, Object> map, File file, String string, String string2, boolean bl) {
        this._baseDir = file;
        this._models = list;
        this._selectedObject = dBObject;
        this._binds = map;
        this._objectName = string;
        if (null == this._objectName) {
            this._objectName = dBObject.getObjectName();
        }
        this._pathPrefix = string2;
        this._includeChildReports = bl;
    }

    public boolean start() throws IOException {
        boolean bl = false;
        for (int i = 0; i < this._models.size(); ++i) {
            DisplayModel displayModel = this._models.get(i);
            if (this.isDisplayModelExcluded(displayModel)) continue;
            this._filePath = this.getEncodedFilePath(this._baseDir, this._objectName, i == 0 ? null : displayModel.getName());
            Writer writer = ConnectionExportTask.getFileWriter(this._filePath);
            writer.write("<html>" + this.getLineTerminator());
            ConnectionExportTask.writeStyleSheetTag(writer, this._pathPrefix);
            writer.write("<body class=\"object\">" + this.getLineTerminator());
            writer.write("<div id=\"header\"><h2>" + this._objectName + "</h2>" + this.getLineTerminator());
            writer.write(this.getDivTag(displayModel.getName(), this._models));
            this.print(displayModel, writer);
            writer.write("</body></html>" + this.getLineTerminator());
            writer.flush();
            writer.close();
            bl = true;
        }
        return bl;
    }

    private boolean isDisplayModelExcluded(DisplayModel displayModel) {
        if (displayModel.getExtAttributes() != null && "false".equalsIgnoreCase((String)displayModel.getExtAttributes().get("dbDoc"))) {
            return true;
        }
        return null == displayModel.getQuery();
    }

    private String getEncodedFilePath(File file, String string, String string2) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(file.getAbsolutePath()).append(File.separator);
        String string3 = URLEncoder.encode(string, "UTF-8");
        stringBuffer.append(string3.replace("*", "%2A"));
        if (string2 != null) {
            stringBuffer.append("_").append(string2);
        }
        stringBuffer.append(".html");
        return stringBuffer.toString();
    }

    private void print(DisplayModel displayModel, Writer writer) throws IOException {
        this.printGenericQuery(displayModel, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGenericQuery(DisplayModel displayModel, Writer writer) throws IOException {
        HashMap<String, Object> hashMap;
        boolean bl;
        block61: {
            if (displayModel.getQuery() == null || displayModel.getQuery().getSql() == null) {
                this.printColumn(displayModel, new String[0], writer);
                return;
            }
            bl = false;
            String string = QueryUtils.expandQuery((String)displayModel.getQuery().getSql(), this._binds);
            hashMap = new HashMap<String, Object>();
            ResultSetWrapper resultSetWrapper = null;
            try {
                Connections.getInstance().getLock(this._selectedObject.getConnection()).lock();
                resultSetWrapper = DBUtil.getInstance((Connection)this._selectedObject.getConnection()).executeQuery(string, this._binds);
                if (resultSetWrapper == null) {
                    return;
                }
                try {
                    Object object;
                    Object object2;
                    String string2;
                    String i;
                    boolean entry;
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    if (resultSet == null) break block61;
                    boolean bl2 = false;
                    boolean hTMLTabFormatter = displayModel.hasChildren() && this._includeChildReports;
                    int n = 0;
                    String string3 = displayModel.getStyle();
                    String string4 = (String)displayModel.getExtValues().get("TYPE");
                    if (string4 != null && string4.equalsIgnoreCase("vertical")) {
                        entry = true;
                    }
                    if (string3 != null && string3.toLowerCase().endsWith("doc")) {
                        StringBuilder bl4 = new StringBuilder();
                        while (resultSet.next()) {
                            bl4.append(resultSet.getString(1));
                        }
                        this.generateDoc(bl4, writer);
                        return;
                    }
                    boolean bl3 = "Chart".equals(displayModel.getStyle());
                    String[] stringArray = bl3 ? this.getColumnsFromResultSet(resultSet.getMetaData()) : this.printTabColumns(resultSet, displayModel, entry, writer);
                    boolean bl4 = false;
                    for (int stringArray2 = 0; stringArray2 < resultSet.getMetaData().getColumnCount(); ++stringArray2) {
                        i = resultSet.getMetaData().getColumnName(stringArray2 + 1).toUpperCase();
                        if (!i.equals("SDEV_LINK_NAME") && !i.equals("SDEV_LINK_TYPE") && !i.equals(Messages.getString("HTMLTabFormatter.14"))) continue;
                        bl4 = true;
                    }
                    if (string3 != null && string3.toLowerCase().equals("code")) {
                        writer.write("\t<tr><td><pre>" + this.getLineTerminator());
                        while (resultSet.next()) {
                            writer.write(HTMLTabFormatter.escape(resultSet.getString(1)));
                        }
                        writer.write("</pre>\t</td></tr>" + this.getLineTerminator());
                    } else if (entry && resultSet.next()) {
                        String[] graph = this.getColumnsFromResultSet(resultSet.getMetaData());
                        for (int exception = 0; exception < graph.length; ++exception) {
                            writer.write("\t<tr>" + this.getLineTerminator());
                            this.printRow(null, graph[exception], writer);
                            this.printRow(null, resultSet.getObject(graph[exception]), writer);
                            writer.write("\t</tr>" + this.getLineTerminator());
                        }
                    } else if (bl3) {
                        int n2;
                        Graph objectArray = new Graph();
                        objectArray.setVisible(false);
                        try {
                            if (this.getChartStyle(displayModel) != null) {
                                objectArray.setStylePath(this.getChartStyle(displayModel));
                            }
                        }
                        catch (Exception n3) {
                            Logger.warn(this.getClass(), (Throwable)n3);
                        }
                        objectArray.getLegendArea().setVisible(this.getBoolean(displayModel, "LEGEND").booleanValue());
                        int i2 = this.getBoolean(displayModel, "GRID") != false ? 0 : 6;
                        objectArray.getX1MajorTick().setTickStyle(i2);
                        objectArray.getY1MajorTick().setTickStyle(i2);
                        objectArray.getY2MajorTick().setTickStyle(i2);
                        objectArray.set3DEffect(this.getBoolean(displayModel, "THREED").booleanValue());
                        String i22 = (String)displayModel.getExtValues().get("TYPE");
                        if (i22.equals("PIE_MULTI")) {
                            objectArray.setGraphType(57);
                        } else if (i22.equals("BAR_HORIZ_CLUST")) {
                            objectArray.setGraphType(24);
                        } else if (i22.equals("BAR_VERT_CLUST")) {
                            objectArray.setGraphType(17);
                        } else if (i22.equals("BAR_VERT_STACK")) {
                            objectArray.setGraphType(18);
                        } else if (i22.equals("BAR_HORIZ_STACK")) {
                            objectArray.setGraphType(25);
                        }
                        string2 = OraLocaleInfo.getInstance((String)DBConfig.getInstance().getString("NLS_LANG"), (String)DBConfig.getInstance().getString("NLS_TERR"));
                        object2 = string2.getLocale();
                        objectArray.setLocale((Locale)object2);
                        object = objectArray.getMarkerText();
                        object.getViewFormat(0).setDecimalDigit(2);
                        object.getViewFormat(1).setDecimalDigit(2);
                        object.getViewFormat(2).setDecimalDigit(2);
                        object.getViewFormat(3).setDecimalDigit(2);
                        object.getViewFormat(4).setDecimalDigit(2);
                        Object[] i3 = null;
                        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                        String string5 = "Graph:" + this.getLineTerminator();
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            if (n2 > 0) {
                                string5 = string5 + '\t';
                            }
                            string5 = string5 + stringArray[n2];
                        }
                        string5 = string5 + this.getLineTerminator();
                        while (resultSet.next()) {
                            i3 = new Object[resultSet.getMetaData().getColumnCount()];
                            for (n2 = 0; n2 < resultSet.getMetaData().getColumnCount(); ++n2) {
                                int string8 = n2 + 1;
                                if (n2 > 0) {
                                    string5 = string5 + '\t';
                                }
                                i3[n2] = string8 > 2 ? resultSet.getBigDecimal(string8) : resultSet.getString(string8);
                                string5 = string5 + i3[n2].toString();
                            }
                            arrayList.add(i3);
                            string5 = string5 + this.getLineTerminator();
                        }
                        if (arrayList.size() > 0) {
                            objectArray.setDataRowShownAsASeries(true);
                        }
                        n2 = objectArray.setTabularData(arrayList) ? 1 : 0;
                        writer.write(this.getLineTerminator() + "<div id=\"" + displayModel.getName() + " Graph" + "\"> <table cellpadding=\"0\" cellspacing=\"0\" cellspacing=\"0\" summary=\"\">" + this.getLineTerminator());
                        writer.write("\t<tr><td>" + this.getLineTerminator());
                        if (n2 != 0) {
                            objectArray.getO1TickLabel().setHorizontalAlignment(0);
                            objectArray.setImageSize(new Dimension(800, 300));
                            String string6 = this._filePath + ".png";
                            Object[] objectArray2 = new FileOutputStream(string6);
                            BufferedOutputStream i4 = new BufferedOutputStream((OutputStream)objectArray2);
                            objectArray.setScaleFontSizeForGIF(-1);
                            objectArray.exportToPNG((OutputStream)i4);
                            String string7 = string6.substring(this._baseDir.getPath().length() + 1);
                            writer.write("\t\t<img src=\"" + string7 + "\" alt=\"" + string5 + "\" />" + this.getLineTerminator());
                        } else {
                            writer.write(string5);
                        }
                        writer.write("\t</td></tr>" + this.getLineTerminator());
                        writer.write("</table></div>" + this.getLineTerminator());
                        this.printTabColumns(resultSet, displayModel, entry, writer);
                        for (Object[] objectArray2 : arrayList) {
                            writer.write("\t<tr>" + this.getLineTerminator());
                            for (int j = 0; j < stringArray.length; ++j) {
                                this.printRow(null, objectArray2[j], writer);
                            }
                            writer.write("\t</tr>" + this.getLineTerminator());
                        }
                    } else {
                        while (resultSet.next()) {
                            ++n;
                            Object[] objectArray = new Object[stringArray.length];
                            for (int j = 0; j < stringArray.length; ++j) {
                                try {
                                    objectArray[j] = resultSet.getObject(stringArray[j]);
                                    continue;
                                }
                                catch (SQLException string10) {
                                    Logger.severe(this.getClass(), (String)("Error fetching: " + stringArray[j]), (Throwable)string10);
                                    throw string10;
                                }
                            }
                            i = null;
                            if (bl4) {
                                String string11 = resultSet.getString("SDEV_LINK_NAME");
                                string2 = resultSet.getString("SDEV_LINK_TYPE").toLowerCase();
                                object2 = resultSet.getString("SDEV_LINK_OWNER");
                                if (!"package body".equalsIgnoreCase(string2) && this._selectedObject.getSchemaName().equals(object2)) {
                                    object = ConnectionExportTask.getEncodedURLName(string11);
                                    i = "../" + string2 + "/" + (String)object + ".html";
                                }
                            }
                            writer.write("\t<tr>" + this.getLineTerminator());
                            if (hTMLTabFormatter) {
                                String string8 = this._objectName + "_" + displayModel.getName() + "_Row" + n;
                                string2 = ConnectionExportTask.getEncodedURLName(string8);
                                object2 = string2 + ".html\" target=\"ObjectDetailsChildrenFrame";
                                this.printRow((String)object2, n, writer);
                                object = new HashMap<String, Object>(this._binds);
                                for (int j = 0; j < stringArray.length; ++j) {
                                    object.put(stringArray[j].toUpperCase(), objectArray[j]);
                                }
                                hashMap.put(string8, object);
                            }
                            for (int sQLException = 0; sQLException < stringArray.length; ++sQLException) {
                                this.printRow(i, objectArray[sQLException], writer);
                            }
                            writer.write("\t</tr>" + this.getLineTerminator());
                        }
                    }
                    writer.write("</table></div>");
                    bl = true;
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                }
                finally {
                    if (resultSetWrapper != null) {
                        resultSetWrapper.close();
                    }
                }
            }
            finally {
                Connections.getInstance().getLock(this._selectedObject.getConnection()).unlock();
            }
        }
        if (!bl) {
            this.printColumn(displayModel, new String[0], writer);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            try {
                HTMLTabFormatter exception = new HTMLTabFormatter(this._selectedObject, displayModel.getChildren(), (Map)entry.getValue(), this._baseDir, (String)entry.getKey(), this._pathPrefix, this._includeChildReports);
                exception.start();
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (String)("Problem creating child reports for " + (String)entry.getKey()), (Throwable)exception);
            }
        }
    }

    private Boolean getBoolean(DisplayModel displayModel, String string) {
        try {
            String string2 = (String)displayModel.getExtValues().get(string);
            if (Boolean.parseBoolean(string2)) {
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getChartStyle(DisplayModel displayModel) {
        String string = null;
        String string2 = (String)displayModel.getExtValues().get("STYLE");
        if (string2 == null) {
            return null;
        }
        String string3 = string2.toUpperCase().replace(" ", "_");
        try {
            string = DisplayConstants.CHART_STYLES.valueOf((String)string3).getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void generateDoc(StringBuilder stringBuilder, Writer writer) throws IOException {
        LexerToken lexerToken2;
        String string = stringBuilder.toString();
        List list = LexerToken.parse((String)string, (boolean)true);
        LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
        for (LexerToken lexerToken2 : list) {
            if (lexerToken2.type == Token.WS || lexerToken2.type == Token.COMMENT || lexerToken2.type == Token.LINE_COMMENT) continue;
            linkedList.add(lexerToken2);
        }
        PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
        plsqlStructureParser.parse(linkedList, (Comparator)new NameComparator());
        this.links(writer);
        writer.write("<HR><P>");
        lexerToken2 = this.projectHeader(writer, list);
        if (lexerToken2 != null) {
            Iterator iterator = lexerToken2.content.substring(2);
            if (lexerToken2.type == Token.COMMENT) {
                iterator = ((String)((Object)iterator)).substring(0, ((String)((Object)iterator)).length() - 2);
            }
            writer.write(((String)((Object)iterator)).replace("\n", "<BR>").replace('*', ' '));
        }
        writer.write("</P><HR>");
        if (this.hasTypes(plsqlStructureParser)) {
            this.summaryHeader(writer, "Type Summary");
            for (Member member : plsqlStructureParser.children) {
                this.generateTypeSummary(writer, member, this.priorComment(list, member, plsqlStructureParser.children, lexerToken2));
            }
            writer.write("</TABLE>");
        }
        if (this.hasMethods(plsqlStructureParser)) {
            this.summaryHeader(writer, "Method Summary");
            for (Member member : plsqlStructureParser.children) {
                this.generateMethodSummary(writer, member, this.priorComment(list, member, plsqlStructureParser.children, lexerToken2));
            }
            writer.write("</TABLE>\n");
        }
        if (this.hasTypes(plsqlStructureParser)) {
            this.detailHeader(writer, "Type Detail");
            for (Member member : plsqlStructureParser.children) {
                this.generateTypeDetail(writer, member, this.priorComment(list, member, plsqlStructureParser.children, lexerToken2));
            }
        }
        if (this.hasMethods(plsqlStructureParser)) {
            this.detailHeader(writer, "Method Detail");
            for (Member member : plsqlStructureParser.children) {
                this.generateMethodDetail(writer, member, this.priorComment(list, member, plsqlStructureParser.children, lexerToken2));
            }
        }
        this.links(writer);
    }

    private void detailHeader(Writer writer, String string) throws IOException {
        this.summaryHeader(writer, string);
        writer.write("</TABLE>");
    }

    public void links(Writer writer) throws IOException {
        writer.write("<TABLE CELLSPACING=\"0\" CELLPADDING=\"1\" WIDTH=\"100%\" BORDER=\"0\">\n<TR><TD CLASS=\"NavBarRow3\" VALIGN=\"top\"><FONT SIZE=\"-2\">      SUMMARY:  <A HREF=\"#field_summary\">FIELD</A> | <A HREF=\"#type_summary\">TYPE</A> | <A HREF=\"#method_summary\">METHOD</A></FONT></TD><TD CLASS=\"NavBarRow3\" VALIGN=\"top\"><FONT SIZE=\"-2\"></TR></TABLE>");
    }

    public void summaryHeader(Writer writer, String string) throws IOException {
        writer.write("<P></P><A NAME=\"" + string.toLowerCase().replace(' ', '_') + "\"></A>" + "<TABLE WIDTH=\"100%\" CELLSPACING=\"0\" CELLPADDING=\"3\" BORDER=\"1\">" + "<TR CLASS=\"TableHeadingColor\">" + "<TD COLSPAN=\"2\"><FONT SIZE=\"+2\"><B>" + string + "</B></FONT></TD>");
    }

    private boolean hasTypes(PlsqlStructureParser plsqlStructureParser) {
        for (Member member : plsqlStructureParser.children) {
            if (!"TYPE".equals(member.type)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMethods(PlsqlStructureParser plsqlStructureParser) {
        for (Member member : plsqlStructureParser.children) {
            if (!"PROCEDURE".equals(member.type) && !"FUNCTION".equals(member.type)) continue;
            return true;
        }
        return false;
    }

    private LexerToken projectHeader(Writer writer, List<LexerToken> list) throws IOException {
        LexerToken lexerToken = null;
        LexerToken lexerToken2 = null;
        for (LexerToken lexerToken3 : list) {
            if (lexerToken3.type == Token.COMMENT || lexerToken3.type == Token.LINE_COMMENT) {
                lexerToken2 = lexerToken3;
            } else if (lexerToken3.type == Token.WS) continue;
            if (lexerToken != null) {
                if ("procedure".equalsIgnoreCase(lexerToken.content) || "function".equalsIgnoreCase(lexerToken.content) || "trigger".equalsIgnoreCase(lexerToken.content)) {
                    return null;
                }
                if ("as".equalsIgnoreCase(lexerToken.content) || "is".equalsIgnoreCase(lexerToken.content)) break;
            }
            lexerToken = lexerToken3;
        }
        return lexerToken2;
    }

    private LexerToken priorComment(List<LexerToken> list, Member member, Set<Member> set, LexerToken lexerToken) {
        LexerToken lexerToken2 = null;
        for (LexerToken lexerToken3 : list) {
            if (lexerToken3.type == Token.COMMENT || lexerToken3.type == Token.LINE_COMMENT) {
                lexerToken2 = lexerToken3;
                continue;
            }
            if (member.codeOffset == lexerToken3.begin) {
                for (Member member2 : set) {
                    if (member2 == member || member2.codeOffset >= member.codeOffset || lexerToken2 == null || lexerToken2.begin >= member2.codeOffset) continue;
                    return null;
                }
                if (lexerToken2 == null) continue;
                if (lexerToken2 == lexerToken) {
                    return null;
                }
                return lexerToken2;
            }
            if (member.codeOffset >= lexerToken3.begin || !";".equals(lexerToken3.content) && !"is".equalsIgnoreCase(lexerToken3.content) && !"as".equalsIgnoreCase(lexerToken3.content)) continue;
            return lexerToken2;
        }
        return null;
    }

    private void generateMethodSummary(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        if (!"FUNCTION".equals(member.type) && !"PROCEDURE".equals(member.type)) {
            return;
        }
        this.generateSummary(writer, member, lexerToken);
    }

    private void generateTypeSummary(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        if (!"TYPE".equals(member.type)) {
            return;
        }
        this.generateSummary(writer, member, lexerToken);
    }

    public void generateSummary(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        String string = this.extractComment(lexerToken);
        String string2 = this.extractParams(member);
        writer.write("<TR CLASS=\"TableRowColor\"><TD WIDTH=\"1%\" VALIGN=\"top\" ALIGN=\"right\"><FONT SIZE=\"-1\"><CODE>&nbsp;</CODE></FONT></TD><TD><CODE><B><A HREF=\"#" + member.name + "\">" + member.name + "</A></B>" + string2 + "</CODE><BR>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + string + "</TD>" + "</TR>\n");
    }

    private void generateTypeDetail(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        if (!"TYPE".equals(member.type)) {
            return;
        }
        this.generateDetail(writer, member, lexerToken);
    }

    private void generateMethodDetail(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        if (!"FUNCTION".equals(member.type) && !"PROCEDURE".equals(member.type)) {
            return;
        }
        this.generateDetail(writer, member, lexerToken);
    }

    public void generateDetail(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        String string = this.extractComment(lexerToken);
        String string2 = this.extractParams(member);
        List<String> list = this.extractParams(lexerToken);
        List<String> list2 = this.extractExc(lexerToken);
        List<String> list3 = this.extractRet(lexerToken);
        writer.write("<A NAME=\"" + member.name + "\"></A>\n" + "<H3>" + member.name + "</H3>" + "<PRE>" + "          " + "<B>" + member.name + "</B>" + string2 + "</PRE>" + "<DL>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + string + "<DD>" + "<DL>");
        if (0 < list.size()) {
            writer.write("<DT><B>Parameters:</B>");
            for (String string3 : list) {
                writer.write(string3);
            }
            writer.write("</DT>");
        }
        if (0 < list3.size()) {
            writer.write("<DT><B>Returns:</B>");
            for (String string3 : list3) {
                writer.write(string3);
            }
            writer.write("</DT>");
        }
        if (0 < list2.size()) {
            writer.write("<DT><B>Throws:</B>");
            for (String string3 : list2) {
                writer.write(string3);
            }
            writer.write("</DT>");
        }
        writer.write("</DL></DD></DL><HR>");
    }

    private List<String> extractParams(LexerToken lexerToken) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (lexerToken != null) {
            int n = 0;
            while ((n = lexerToken.content.indexOf("@param", n)) >= 0) {
                String string;
                int n2;
                int n3 = lexerToken.content.indexOf("@param", n + 1);
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@throws", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@return", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf(10, n);
                }
                if ((n2 = (string = lexerToken.content.substring(n + "@param".length(), n3)).lastIndexOf(10)) > 0) {
                    string = string.substring(0, n2);
                }
                List list = LexerToken.parse((String)string);
                linkedList.add("<DD><CODE>" + ((LexerToken)list.get((int)0)).content + "</CODE> - " + string.substring(((LexerToken)list.get((int)0)).end + 1) + "</DD>");
                n = n3;
            }
        }
        return linkedList;
    }

    private List<String> extractRet(LexerToken lexerToken) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (lexerToken != null) {
            int n = 0;
            while ((n = lexerToken.content.indexOf("@return", n)) >= 0) {
                String string;
                int n2;
                int n3 = lexerToken.content.indexOf("@return", n + 1);
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@throws", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf(10, n);
                }
                if ((n2 = (string = lexerToken.content.substring(n + "@return".length() + 1, n3)).lastIndexOf(10)) > 0) {
                    string = string.substring(0, n2);
                }
                List list = LexerToken.parse((String)string);
                linkedList.add("<DD>" + string + "</DD>");
                n = n3;
            }
        }
        return linkedList;
    }

    private List<String> extractExc(LexerToken lexerToken) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (lexerToken != null) {
            int n = 0;
            while ((n = lexerToken.content.indexOf("@throws", n)) >= 0) {
                String string;
                int n2;
                int n3 = lexerToken.content.indexOf("@throws", n + 1);
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@return", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf(10, n);
                }
                if ((n2 = (string = lexerToken.content.substring(n + "@throws".length(), n3)).lastIndexOf(10)) > 0) {
                    string = string.substring(0, n2);
                }
                List list = LexerToken.parse((String)string);
                linkedList.add("<DD><CODE>" + ((LexerToken)list.get((int)0)).content + "</CODE> - " + string.substring(((LexerToken)list.get((int)0)).end + 1) + "</DD>");
                n = n3;
            }
        }
        return linkedList;
    }

    private String extractComment(LexerToken lexerToken) {
        String string = "";
        if (lexerToken != null) {
            int n = lexerToken.content.indexOf("@param");
            if (n < 0) {
                n = lexerToken.content.indexOf("@return");
            }
            if (n < 0 && lexerToken.type == Token.LINE_COMMENT) {
                n = lexerToken.content.length();
            }
            if (n < 0 && lexerToken.type == Token.COMMENT) {
                n = lexerToken.content.length() - 2;
            }
            string = lexerToken.content.substring(2, n);
            string = string.replace('*', ' ');
        }
        return string.replace("\n", "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    private String extractParams(Member member) {
        String string = "";
        int n = member.tooltip.indexOf("(");
        if (0 < n) {
            string = member.tooltip.substring(n);
        }
        return string;
    }

    private static String escape(String string) {
        if (string != null) {
            return string.replaceAll("<", "&lt;");
        }
        return string;
    }

    private String[] printTabColumns(ResultSet resultSet, DisplayModel displayModel, boolean bl, Writer writer) throws SQLException, IOException {
        String[] stringArray = new String[]{};
        if (resultSet != null) {
            stringArray = bl ? new String[]{"Name", "Value"} : this.getColumnsFromResultSet(resultSet.getMetaData());
            this.printColumn(displayModel, stringArray, writer);
        }
        return stringArray;
    }

    private String[] getColumnsFromResultSet(ResultSetMetaData resultSetMetaData) throws SQLException {
        String[] stringArray = EMPTY_COLS;
        if (resultSetMetaData != null) {
            int n = resultSetMetaData.getColumnCount();
            stringArray = new String[n];
            int n2 = 0;
            for (int i = 1; i <= n; ++i) {
                String string = resultSetMetaData.getColumnName(i);
                if (FILTER_COLS.contains(string.toUpperCase())) continue;
                stringArray[n2++] = string;
            }
            if (n2 < n) {
                String[] stringArray2 = stringArray;
                stringArray = new String[n2];
                System.arraycopy(stringArray2, 0, stringArray, 0, n2);
            }
        }
        return stringArray;
    }

    private void printRow(String string, Object object, Writer writer) throws IOException {
        writer.write("<td>");
        if (string != null) {
            writer.write("<a href=\"" + string + "\">");
            writer.write(this.getDisplayValue(object));
            writer.write("</a>");
        } else {
            writer.write(this.getDisplayValue(object));
        }
        writer.write("</td>" + this.getLineTerminator());
    }

    private String getDisplayValue(Object object) {
        if (null == object) {
            return NULL_DISPLAY_STRING;
        }
        String string = ":";
        String string2 = DataTypesUtil.stringValue((Object)object, (Connection)this._selectedObject.getConnection());
        if (string2.startsWith("SQLDEV:LINK")) {
            if (string2.startsWith("SQLDEV:LINK{")) {
                string = string2.substring(string2.indexOf("{") + 1, string2.indexOf("}"));
                string2 = string2.substring(string2.indexOf("}") + 1);
            } else if (string2.startsWith("SQLDEV:LINK:")) {
                string2 = string2.substring(string2.indexOf("LINK:") + 5);
            }
            String[] stringArray = string2.split(string);
            string2 = stringArray[stringArray.length - 2];
        }
        return HTMLTabFormatter.escape(string2);
    }

    private void printColumn(DisplayModel displayModel, String[] stringArray, Writer writer) throws IOException {
        writer.write(this.getLineTerminator() + "<div id=\"" + displayModel.getName() + "\"> <table cellpadding=\"0\" cellspacing=\"0\" cellspacing=\"0\" summary=\"\"><tr>" + this.getLineTerminator());
        if (displayModel.hasChildren() && this._includeChildReports) {
            writer.write("\t<th> </th>" + this.getLineTerminator());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            writer.write("\t<th>" + stringArray[i] + "</th>" + this.getLineTerminator());
        }
        writer.write("</tr>" + this.getLineTerminator());
    }

    private String getLineTerminator() {
        return System.getProperty("line.separator");
    }

    private String getDivTag(String string, List<DisplayModel> list) {
        StringBuffer stringBuffer = new StringBuffer("<div class=\"tabs clearfix\">" + this.getLineTerminator());
        for (int i = 0; i < list.size(); ++i) {
            if (this.isDisplayModelExcluded(list.get(i))) continue;
            stringBuffer.append(this.getLineTerminator());
            String string2 = list.get(i).getName();
            stringBuffer.append("<div class=\"tab\"");
            if (string2.equals(string)) {
                stringBuffer.append(" id=\"current\"");
            }
            String string3 = this._objectName;
            try {
                string3 = ConnectionExportTask.getEncodedURLName(this._objectName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.warn(this.getClass(), (Throwable)unsupportedEncodingException);
            }
            if (i == 0) {
                stringBuffer.append("><div><a href=\"" + string3 + ".html\">" + string2 + "</a></div></div>");
                continue;
            }
            stringBuffer.append("><div><a href=\"" + string3 + "_" + string2 + ".html\">" + string2 + "</a></div></div>");
        }
        stringBuffer.append(this.getLineTerminator() + "</div></div><br/>" + this.getLineTerminator() + "<div class=\"tab-panes\">");
        return stringBuffer.toString();
    }
}

