/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.dbtools.parser.plsql.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.controls.display.DrillObject;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;

public class DrillToBaseObject
extends GridContextMenuItem {
    private static DrillToBaseObject _instance = null;
    private static String _drillCmdName = "TABLE_DRILL_TO";
    private static int _drillCmdId = Ide.findOrCreateCmdID((String)_drillCmdName);
    private IdeAction _action = null;
    private static final String URL = "DRILL_RO_URL";

    private DrillToBaseObject() {
        this.initAction();
    }

    private void initAction() {
        if (this._action == null) {
            this._action = this.createAction(_drillCmdId, Messages.getString("RSTableDrillToBaseObject.2"), null);
        }
    }

    public static DrillToBaseObject getInstance() {
        if (_instance == null) {
            _instance = new DrillToBaseObject();
        }
        return _instance;
    }

    protected boolean canShow(ContextMenu contextMenu) {
        return this._table != null;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        try {
            if (this._table != null) {
                List list;
                int n = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
                n = this._table.convertRowIndexToModel(n);
                if (!(!(this._table.getModel() instanceof ResultSetTableModel) || (list = ((ResultSetTableModel)this._table.getModel()).getDrillUrls()).size() <= n || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("JAVA") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("LOB") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("INDEX PARTITION") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("TABLE PARTITION") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("CLUSTER") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("CONSUMER GROUP") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("CONTEXT") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("DIRECTORY") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("EDITION") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("EVALUATION CONTEXT") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("XML SCHEMA") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("WINDOW GROUP") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("WINDOW") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("JOB") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("JOB CLASS") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("LIBRARY") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("OPERATOR") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("PROGRAM") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("RULE") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("RULE SET") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("SCHEDULE") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("INDEXTYPE") || DBURLFormatHelper.getBaseType((URL)((DrillObject)list.get(n)).getUrl()).contains("TABLE SUBPARTITION"))) {
                    JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this._action);
                    jMenuItem.setText(MessageFormat.format(Messages.getString("RSTableDrillToBaseObject.3"), DBURLFormatHelper.getName((URL)((DrillObject)list.get(n)).getUrl())));
                    this._action.putValue(URL, list.get(n));
                    contextMenu.add((Component)jMenuItem);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == _drillCmdId) {
            DrillObject drillObject = (DrillObject)ideAction.getValue(URL);
            URL uRL = drillObject.getUrl();
            if (DBURLFormatHelper.getBaseType((URL)uRL).contains("PACKAGE") || DBURLFormatHelper.getBaseType((URL)uRL).equals("PROCEDURE") || DBURLFormatHelper.getBaseType((URL)uRL).equals("FUNCTION")) {
                try {
                    String string = drillObject.getRow();
                    int n = Integer.parseInt(string);
                    NavSelectionListener.getInstance().open(uRL, n + 1, 0);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            IdentifierDefinitionLookup.goTo((URL)uRL, (boolean)false);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }
}

