/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver7;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.GenerateDSMLFormattedFiles;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.MetadataFileParser;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.OracleDatatypeIdentifiers;

public class SQLServer7DoOfflineCaptureLoad
implements OracleDatatypeIdentifiers {
    private HashMap<File, ArrayList<File>> _dbXMLMetadataList = new HashMap();
    private HashMap<File, ObjectStatusList> m_dSMLMap = null;
    private String _currentTableName = null;
    private int _currentDbId = 0;
    public String currValue = "";
    private HashMap<String, String[]> m_tableTypes = new HashMap();
    private Connection conn = null;
    private static String m_encoding = null;

    public SQLServer7DoOfflineCaptureLoad(Connection connection) {
        this.conn = connection;
        this.populateTableTypes();
    }

    private void errorIfFilesAreMissing(HashMap<File, ObjectStatusList> hashMap) {
    }

    public void convertBcpDumpToXML(HashMap<File, ObjectStatusList> hashMap) throws OfflineCaptureException {
        this.m_dSMLMap = hashMap;
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.conn;
            statement = connection.createStatement();
            GenerateDSMLFormattedFiles generateDSMLFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap, SQLServer7DoOfflineCaptureLoad.getEncoding());
            this._dbXMLMetadataList = generateDSMLFormattedFiles.getDSMLFormattedFilesTable();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)sQLException);
        }
        catch (Exception exception) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new OfflineCaptureException(exception);
        }
    }

    public void loadSourceModel(HashMap<File, ObjectStatusList> hashMap) throws OfflineCaptureException {
        this.m_dSMLMap = hashMap;
        Statement statement = null;
        Connection connection = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        this.errorIfFilesAreMissing(hashMap);
        try {
            connection = this.conn;
            statement = connection.createStatement();
            GenerateDSMLFormattedFiles generateDSMLFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap, SQLServer7DoOfflineCaptureLoad.getEncoding());
            this._dbXMLMetadataList = generateDSMLFormattedFiles.getDSMLFormattedFilesTable();
            File file = this.getDbFile("MASTER");
            if (file == null) {
                throw new OfflineCaptureException(new Exception());
            }
            this._currentDbId = 1;
            this.populateSourceModel(connection, file, 1);
            for (File file2 : this._dbXMLMetadataList.keySet()) {
                int n;
                if (file2.getName().equalsIgnoreCase("MASTER")) continue;
                this._currentDbId = n = this.getDbId(connection, file2.getName());
                if (n == 0) continue;
                this.populateSourceModel(connection, file2, n);
            }
            this.sourceModelIndexCreate(connection);
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)sQLException);
        }
        catch (Exception exception) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new OfflineCaptureException(exception);
        }
    }

    public File getDbFile(String string) {
        File file = null;
        for (File file2 : this.m_dSMLMap.keySet()) {
            String string2 = file2.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            file = file2;
            break;
        }
        return file;
    }

    public int getDbId(Connection connection, String string) throws OfflineCaptureException {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            String string2 = " SELECT DBID FROM SS7_SYSDATABASES  WHERE UPPER(NAME) = '" + string.toUpperCase() + "' ";
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
    }

    public void populateSourceModel(Connection connection, File file, int n) throws OfflineCaptureException {
        try {
            ArrayList<File> arrayList = this._dbXMLMetadataList.get(file);
            Iterator<File> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file2;
                File file3 = file2 = iterator.next();
                this._currentTableName = GenerateDSMLFormattedFiles.getUnqualifiedName(file3.getName());
                String[] stringArray = this.getFieldTypes(this._currentTableName);
                if (stringArray == null) continue;
                MetadataFileParser metadataFileParser = new MetadataFileParser(n, SQLServer7DoOfflineCaptureLoad.fileToURL(file3), this._currentTableName);
                metadataFileParser.createPrepardStatement(connection, stringArray);
                int n2 = metadataFileParser.loadData();
            }
        }
        catch (Exception exception) {
            throw new OfflineCaptureException(exception);
        }
    }

    private String[] getFieldTypes(String string) {
        String[] stringArray = null;
        for (String string2 : this.m_tableTypes.keySet()) {
            if (!string.equalsIgnoreCase(string2)) continue;
            stringArray = this.m_tableTypes.get(string2.toUpperCase());
            break;
        }
        return stringArray;
    }

    private void populateTableTypes() {
        String[] stringArray = new String[]{"3", "3", "6", "3", "5", "5", "5", "3", "3", "3", "3", "3", "1", "1", "1", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1"};
        this.m_tableTypes.put("SS7_SYSLOGINS", stringArray);
        String[] stringArray2 = new String[]{"3", "1", "3", "6", "3", "3", "3", "5", "5", "3", "3", "1", "3", "3"};
        this.m_tableTypes.put("SS7_SYSDATABASES", stringArray2);
        String[] stringArray3 = new String[]{"3", "3", "3", "1", "6", "7", "5", "5", "3", "6", "3", "3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSUSERS", stringArray3);
        String[] stringArray4 = new String[]{"3", "3", "3", "3", "3", "3", "6", "6", "6", "6", "6", "6"};
        this.m_tableTypes.put("SS7_SYSPERMISSIONS", stringArray4);
        String[] stringArray5 = new String[]{"3", "3", "3", "3", "3", "6", "3"};
        this.m_tableTypes.put("SS7_SYSPROTECTS", stringArray5);
        String[] stringArray6 = new String[]{"3", "1", "3", "8", "3", "3", "3", "3", "3", "3", "5", "3", "3", "3", "8", "3", "3", "3", "5", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSOBJECTS", stringArray6);
        String[] stringArray7 = new String[]{"3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "6", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSCOLUMNS", stringArray7);
        String[] stringArray8 = new String[]{"3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "3", "3"};
        this.m_tableTypes.put("SS7_SYSTYPES", stringArray8);
        String[] stringArray9 = new String[]{"3", "3", "3", "6", "3", "6", "3", "3", "3", "3", "3", "3", "6", "3", "3", "3", "3", "3", "3", "3", "3", "6", "3", "3", "3", "6", "1", "3", "3"};
        this.m_tableTypes.put("SS7_SYSINDEXES", stringArray9);
        String[] stringArray10 = new String[]{"3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSINDEXKEYS", stringArray10);
        String[] stringArray11 = new String[]{"3", "3", "3", "3", "3", "3", "6", "6", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSREFERENCES", stringArray11);
        String[] stringArray12 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSCONSTRAINTS", stringArray12);
        String[] stringArray13 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "3", "4"};
        this.m_tableTypes.put("SS7_SYSCOMMENTS", stringArray13);
        String[] stringArray14 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SS7_SYSFILES", stringArray14);
        String[] stringArray15 = new String[]{"3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSMEMBERS", stringArray15);
        String[] stringArray16 = new String[]{"3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS7_SYSFOREIGNKEYS", stringArray16);
        String[] stringArray17 = new String[]{"3", "3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SS7_SYSPROPERTIES", stringArray17);
    }

    private static URL fileToURL(File file) {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        if (string2 != null && string2.length() == 1) {
            string = string.replace(string2.charAt(0), '/');
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            return new URL("file", null, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Exception :SQLServer7DisconnSourceModelLoad.fileToURL(): " + malformedURLException.toString());
            throw new Error("Unexpected MalformedURLException");
        }
    }

    private void sourceModelIndexCreate(Connection connection) throws OfflineCaptureException {
        Statement statement = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            arrayList.add("CREATE INDEX SS7_syslogins_sid on SS7_syslogins (\"SID\")");
            arrayList.add("CREATE INDEX SS7_sysdatabases_db_id on SS7_sysdatabases (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_sysdatabases_name on SS7_sysdatabases (\"NAME\")");
            arrayList.add("CREATE INDEX SS7_sysdatabases_dbid on SS7_sysdatabases (\"DBID\")");
            arrayList.add("CREATE INDEX SS7_sysusers_uid on SS7_sysusers (\"UID\")");
            arrayList.add("CREATE INDEX SS7_sysusers_suid on SS7_sysusers (\"SUID\")");
            arrayList.add("CREATE INDEX SS7_sysusers_gid on SS7_sysusers (\"GID\")");
            arrayList.add("CREATE INDEX SS7_sysusers_db_id on SS7_sysusers (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_permissions_db_id on SS7_syspermissions (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_permissions_id on SS7_syspermissions (\"ID\")");
            arrayList.add("CREATE INDEX SS7_sysprotects_db_id on SS7_sysprotects (DB_ID)");
            arrayList.add("CREATE INDEX SS7_sysprotects_id on SS7_sysprotects (\"ID\")");
            arrayList.add("CREATE INDEX SS7_sysprotects_uid on SS7_sysprotects (\"UID\")");
            arrayList.add("CREATE INDEX SS7_sysprotects_action on SS7_sysprotects (\"ACTION\")");
            arrayList.add("CREATE INDEX SS7_sysprotects_protecttype on SS7_sysprotects (\"PROTECTTYPE\")");
            arrayList.add("CREATE INDEX SS7_sysobj_db_id on SS7_sysobjects (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_sysobj_id on SS7_sysobjects (\"ID\")");
            arrayList.add("CREATE INDEX SS7_sysobj_name on SS7_sysobjects (\"NAME\")");
            arrayList.add("CREATE INDEX SS7_sysobj_xtype on SS7_sysobjects (\"XTYPE\")");
            arrayList.add("CREATE INDEX SS7_sysobj_uid on SS7_sysobjects (\"UID\")");
            arrayList.add("CREATE INDEX SS7_syscol_id on SS7_syscolumns (\"ID\")");
            arrayList.add("CREATE INDEX SS7_syscol_db_id on SS7_syscolumns (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_systypes_xutype on SS7_systypes (\"XUSERTYPE\")");
            arrayList.add("CREATE INDEX SS7_systypes_db_id on SS7_systypes (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_systypes_name on SS7_systypes (\"NAME\")");
            arrayList.add("CREATE INDEX SS7_sysindex_db_id on SS7_sysindexes (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_sysindex_id on SS7_sysindexes (\"ID\")");
            arrayList.add("CREATE INDEX SS7_sysindex_indid on SS7_sysindexes (\"INDID\")");
            arrayList.add("CREATE INDEX SS7_sysindexkeys_db_id on SS7_sysindexkeys (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_sysindexkeys_id on SS7_sysindexkeys (\"ID\")");
            arrayList.add("CREATE INDEX SS7_sysindexkeys_indid on SS7_sysindexkeys (\"INDID\")");
            arrayList.add("CREATE INDEX SS7_sysreferences_rkeyid on SS7_sysreferences (\"RKEYID\")");
            arrayList.add("CREATE INDEX SS7_sysreferences_Fkeyid on SS7_sysreferences (\"FKEYID\")");
            arrayList.add("CREATE INDEX SS7_sysreferences_constid on SS7_sysreferences (\"CONSTID\")");
            arrayList.add("CREATE INDEX SS7_sysreferences_db_id on SS7_sysreferences (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_sysconstraints_constid on SS7_sysconstraints (\"CONSTID\")");
            arrayList.add("CREATE INDEX SS7_sysconstraints_db_id on SS7_sysconstraints (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_sysconstraints_id on SS7_sysconstraints (\"ID\")");
            arrayList.add("CREATE INDEX SS7_syscomments_dbid on SS7_syscomments (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_syscomments_id on SS7_syscomments (\"ID\")");
            arrayList.add("CREATE INDEX SS7_syscomments_colid on SS7_syscomments (\"COLID\")");
            arrayList.add("CREATE INDEX SS7_sysfiles_db_id on SS7_sysfiles (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_sysfiles_fileid on SS7_sysfiles (\"FILEID\")");
            arrayList.add("CREATE INDEX SS7_sysmembers_db_id on SS7_sysmembers (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_sysmembers_memberuid on SS7_sysmembers (\"MEMBERUID\")");
            arrayList.add("CREATE INDEX SS7_sysmembers_groupuid on SS7_sysmembers (\"GROUPUID\")");
            arrayList.add("CREATE INDEX SS7_sysforeignkeys_db_id on SS7_sysforeignkeys (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS7_sysforeignkeys_constid on SS7_sysforeignkeys (\"CONSTID\")");
            arrayList.add("CREATE INDEX SS7_sysforeignkeys_fkeyid on SS7_sysforeignkeys (\"FKEYID\")");
            arrayList.add("CREATE INDEX SS7_sysforeignkeys_rkeyid on SS7_sysforeignkeys (\"RKEYID\")");
            statement = connection.createStatement();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = (String)iterator.next();
                try {
                    statement.execute(string2);
                }
                catch (SQLException sQLException) {
                    throw new OfflineCaptureException((Exception)sQLException);
                }
            }
            statement.close();
            arrayList.clear();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)sQLException);
        }
    }

    private void sourceModelIndexDrop(Connection connection) throws OfflineCaptureException {
        Statement statement = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            statement = connection.createStatement();
            arrayList.add("DROP INDEX SS7_syslogins_sid");
            arrayList.add("DROP INDEX SS7_sysdatabases_db_id");
            arrayList.add("DROP INDEX SS7_sysdatabases_name");
            arrayList.add("DROP INDEX SS7_sysdatabases_dbid");
            arrayList.add("DROP INDEX SS7_sysusers_uid");
            arrayList.add("DROP INDEX SS7_sysusers_suid");
            arrayList.add("DROP INDEX SS7_sysusers_gid");
            arrayList.add("DROP INDEX SS7_sysusers_db_id");
            arrayList.add("DROP INDEX SS7_permissions_db_id");
            arrayList.add("DROP INDEX SS7_permissions_id");
            arrayList.add("DROP INDEX SS7_sysprotects_db_id");
            arrayList.add("DROP INDEX SS7_sysprotects_id");
            arrayList.add("DROP INDEX SS7_sysprotects_uid");
            arrayList.add("DROP INDEX SS7_sysprotects_action");
            arrayList.add("DROP INDEX SS7_sysprotects_protecttype");
            arrayList.add("DROP INDEX SS7_sysobj_db_id");
            arrayList.add("DROP INDEX SS7_sysobj_id");
            arrayList.add("DROP INDEX SS7_sysobj_xtype");
            arrayList.add("DROP INDEX SS7_sysobj_name");
            arrayList.add("DROP INDEX SS7_sysobj_uid");
            arrayList.add("DROP INDEX SS7_syscol_id");
            arrayList.add("DROP INDEX SS7_syscol_db_id");
            arrayList.add("DROP INDEX SS7_systypes_xutype");
            arrayList.add("DROP INDEX SS7_systypes_db_id");
            arrayList.add("DROP INDEX SS7_systypes_name");
            arrayList.add("DROP INDEX SS7_sysindex_db_id");
            arrayList.add("DROP INDEX SS7_sysindex_id");
            arrayList.add("DROP INDEX SS7_sysindex_indid");
            arrayList.add("DROP INDEX SS7_sysindexkeys_db_id");
            arrayList.add("DROP INDEX SS7_sysindexkeys_id");
            arrayList.add("DROP INDEX SS7_sysindexkeys_indid");
            arrayList.add("DROP INDEX SS7_sysreferences_rkeyid");
            arrayList.add("DROP INDEX SS7_sysreferences_fkeyid");
            arrayList.add("DROP INDEX SS7_sysreferences_constid");
            arrayList.add("DROP INDEX SS7_sysreferences_db_id");
            arrayList.add("DROP INDEX SS7_sysconstraints_constid");
            arrayList.add("DROP INDEX SS7_sysconstraints_db_id");
            arrayList.add("DROP INDEX SS7_sysconstraints_id");
            arrayList.add("DROP INDEX SS7_syscomments_dbid");
            arrayList.add("DROP INDEX SS7_syscomments_id");
            arrayList.add("DROP INDEX SS7_syscomments_colid");
            arrayList.add("DROP INDEX SS7_sysfiles_db_id");
            arrayList.add("DROP INDEX SS7_sysfiles_fileid");
            arrayList.add("DROP INDEX SS7_sysmembers_db_id");
            arrayList.add("DROP INDEX SS7_sysmembers_memberuid");
            arrayList.add("DROP INDEX SS7_sysmembers_groupuid");
            arrayList.add("DROP INDEX SS7_sysforeignkeys_db_id");
            arrayList.add("DROP INDEX SS7_sysforeignkeys_constid");
            arrayList.add("DROP INDEX SS7_sysforeignkeys_fkeyid");
            arrayList.add("DROP INDEX SS7_sysforeignkeys_rkeyid");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = (String)iterator.next();
                try {
                    statement.execute(string2);
                }
                catch (SQLException sQLException) {
                    throw new OfflineCaptureException((Exception)sQLException);
                }
            }
            statement.close();
            arrayList = new ArrayList();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                throw new OfflineCaptureException((Exception)sQLException2);
            }
            throw new OfflineCaptureException((Exception)sQLException);
        }
    }

    public static void setEncoding(String string) {
        m_encoding = string;
    }

    public static String getEncoding() {
        return m_encoding;
    }
}

