/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver7;

import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.convert.AbstractConverter;
import oracle.dbtools.migration.convert.ConvertException;
import oracle.dbtools.migration.convert.ConvertResult;
import oracle.dbtools.migration.convert.ConvertResultImpl;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.ObjectTranslationList;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.translation.api.ITranslator;

public class SQLServer7Converter
extends AbstractConverter {
    private static final String GUID_TRIGGER_BODY = "create or replace TRIGGER %s BEFORE INSERT ON %s\nFOR EACH ROW\nDECLARE\nv_guid RAW(16) := SYS_GUID;\nbegin\n  if :new.%s is null then\n    :new.%s := substr(v_guid,1,8) || '-' || substr(v_guid,9,4) || '-' || substr(v_guid,13,4) || '-' || substr(v_guid,17,4) || '-' || substr(v_guid, 21);\n  end if;\nend;\n";

    public ITranslator getPlaformTranslator() {
        return ParserFactory.getParser((String)"oracle.dbtools.migration.parser.tsql.TSQLParserMain");
    }

    public String getDefaultValueMappingXML() {
        return "SQLServerDefaultValuesMappingRules.xml";
    }

    public ConvertResult convertObject(PersistableObject persistableObject, String string, PersistenceManager persistenceManager) throws ConvertException {
        ConvertResultImpl convertResultImpl = null;
        if (string.equals("(newid())")) {
            MdColumn mdColumn = (MdColumn)persistableObject;
            convertResultImpl = new ConvertResultImpl(persistableObject);
            mdColumn.setDefaultValue(null);
            try {
                MdTable mdTable = MdTable.retrieveExistingInstance((PersistenceManager)persistenceManager, (DBObjectId)mdColumn.getTableId());
                MdTrigger mdTrigger = new MdTrigger(mdTable.getKey(), "T", "OracleSQL");
                String string2 = ConvertUtils.generateName((String)(mdTable.getTableName() + "_" + mdColumn.getColumnName() + "_GUIDTRG"));
                String string3 = String.format(GUID_TRIGGER_BODY, string2, mdTable.getTableName(), mdColumn.getColumnName(), mdColumn.getColumnName());
                mdTrigger.setTriggerName(string2);
                mdTrigger.setNativeSql(string3);
                convertResultImpl.addNewDerivedObject((PersistableObject)mdTrigger);
            }
            catch (PersistenceException persistenceException) {
                throw new ConvertException((Exception)((Object)persistenceException));
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new ConvertException((Exception)((Object)noSuchObjectException));
            }
        }
        return convertResultImpl;
    }

    public String[] getPropertyKeyList() {
        return new String[]{"(newid())"};
    }

    public String getEmulationPkgName() {
        return "utils";
    }

    public ObjectTranslationList getSupportedTranslationObjects() {
        return null;
    }
}

