/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.core.AbstractMigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7Converter;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7DbProvider;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7OfflineCapturer;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServerQuoter;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;

public class SQLServer7Plugin
extends AbstractMigrationPlugin {
    protected Converter m_converter;
    public static final String DRIVER_CLASS = "net.sourceforge.jtds.jdbc.Driver";
    protected static boolean s_driverLoaded = false;

    public String getPlatformName() {
        return "Microsoft SQL Server";
    }

    public String getPluginName() {
        return this.getPlatformName() + " " + this.getVersionNumber();
    }

    public String getVersionNumber() {
        return "7.0.0";
    }

    public ThirdPartyDbProvider getProvider(String string) throws MigrationPluginException {
        try {
            SQLServer7Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string);
            return new SQLServer7DbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(String string, Properties properties) throws MigrationPluginException {
        try {
            SQLServer7Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, properties);
            return new SQLServer7DbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(String string, String string2, String string3) throws MigrationPluginException {
        try {
            SQLServer7Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, string2, string3);
            return new SQLServer7DbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection connection) throws MigrationPluginException {
        return new SQLServer7DbProvider(connection);
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Class.forName(DRIVER_CLASS).newInstance();
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MigrationPluginException((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new MigrationPluginException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MigrationPluginException((Throwable)illegalAccessException);
            }
        }
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public String getPublishedVersion() {
        return "7";
    }

    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new SQLServer7Converter();
        }
        return this.m_converter;
    }

    protected String getSupportedMapsXMLFileName() {
        return "/oracle/dbtools/migration/workbench/sqlserver7/SQLServer7SupportedDataTypesMap.xml";
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.equals(this.getPlatformName()) && n == 7) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    public String getIconFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/mssql/images/microsoftsqlserver.png";
    }

    public void registerMenuItems() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.plugin.mssql");
    }

    public Quoter getQuoter() {
        return new SQLServerQuoter();
    }

    public final boolean getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        offline3rdPartyPrintStream.startTable(string);
        try {
            String string3 = "bcp \"" + this.StripString(string, "[]") + "\" out \"" + "data\\" + string2 + "\"";
            string3 = string3 + " -q -c -CRAW -t \"" + migrationConfig.getEndColumnDelimiter() + "\" -r \"" + migrationConfig.getEndRowDelimiter();
            string3 = string3 + "\" -U%2 -P%3 -S%1";
            offline3rdPartyPrintStream.println(string3);
            offline3rdPartyPrintStream.endTable();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public final String StripString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public boolean usesClobToBlob() {
        return true;
    }

    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = "";
        String string2 = mdColumn.getColumnType();
        String string3 = mdColumn2.getColumnName();
        String string4 = mdColumn.getColumnType();
        String string5 = mdColumn2.getColumnType();
        Integer n = mdColumn2.getPrecision();
        int n2 = 0;
        n2 = n == null ? 0 : n;
        if (string5.equalsIgnoreCase("CHAR") || string5.equalsIgnoreCase("NCHAR") || string5.equalsIgnoreCase("VARCHAR2") || string5.equalsIgnoreCase("NVARCHAR2") || string5.equalsIgnoreCase("CLOB") || string5.equalsIgnoreCase("NCLOB")) {
            if (n2 >= 255) {
                string = "CHAR(" + n2 + ")";
            }
            if (string5.equalsIgnoreCase("VARCHAR2") || string5.equalsIgnoreCase("NVARCHAR2") || string5.equalsIgnoreCase("CHAR") || string5.equalsIgnoreCase("NCHAR")) {
                string = MigrationAddin.getMigrationConfig().getEmptyStringIsSpace() ? string + " \"DECODE(:" + string3 + ", CHR(00), ' ', :" + string3 + ")\"" : string + " \"DECODE(:" + string3 + ", CHR(00), NULL, :" + string3 + ")\"";
            }
            if (string5.equalsIgnoreCase("CLOB") || string5.equalsIgnoreCase("NCLOB")) {
                string = string + "CHAR(2000000)";
            }
        } else if (string5.equalsIgnoreCase("RAW")) {
            string = "CHAR(" + n2 * 2 + ")";
        } else if (string2.equalsIgnoreCase("DATETIME")) {
            string = "\"TO_TIMESTAMP(:" + string3 + ", '" + MigrationAddin.getMigrationConfig().getTimeStampOfflineDateMask() + "')\"";
        } else if (string2.equalsIgnoreCase("SMALLDATETIME") || string2.equalsIgnoreCase("DATE")) {
            string = "\"TO_DATE(:" + string3 + ", '" + MigrationAddin.getMigrationConfig().getDateOfflineDateMask() + "')\"";
        } else if (string4.equalsIgnoreCase("MONEY") || string4.equalsIgnoreCase("MONEYN")) {
            string = "\"TRANSLATE (:" + string3 + ",'1,','1')\"";
        } else if (string4.equalsIgnoreCase("IMAGE")) {
            string = this.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob() ? " CHAR(2000000) " : " CHAR(2000000) \"HEXTORAW (:" + string3 + ")\"";
        }
        return string;
    }

    public String getDatafileExtension() {
        return "dat";
    }

    public int getPlatformMask() {
        return 16;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new SQLServer7OfflineCapturer(null, null);
    }

    public String getPlatformNameforNavigator() {
        return "Microsoft SQL Server";
    }
}

