/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.tsql;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.migration.parser.defaults.DefaultTranslationContext;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;

public class TSQLTranslationContext
extends DefaultTranslationContext {
    private static HashMap<String, TranslationDataType> dataTypeMap = new HashMap();
    private static HashMap<String, String> dataTypeMaxValueMap;
    private static ArrayList<String> parameterizedTypeList;
    private static final String[] oracleReservedWords;

    public TranslationDataType getTargetDataType(TranslationDataType translationDataType, Object object) {
        TranslationDataType translationDataType2;
        Object object2;
        if (translationDataType == null) {
            return null;
        }
        String string = translationDataType.getDataType().trim().toLowerCase();
        if ((string = TSQLTranslationContext.removeQuoteCharacters((String)string)).equalsIgnoreCase("varchar") && Integer.parseInt(translationDataType.getPrecision()) > 4000) {
            string = "text";
        }
        if (dataTypeMap.containsKey(string)) {
            object2 = dataTypeMap.get(string);
            translationDataType2 = new TranslationDataType(object2.getDataType());
            translationDataType2.setPrecision(object2.getPrecision());
            translationDataType2.setScale(object2.getScale());
        } else {
            translationDataType2 = new TranslationDataType(string);
        }
        object2 = translationDataType2.getPrecision();
        if (object2 == null) {
            object2 = translationDataType.getPrecision();
            if (object2 != null && ((String)object2).equalsIgnoreCase("max")) {
                object2 = dataTypeMaxValueMap.get(translationDataType2.getDataType());
            }
            if (parameterizedTypeList.contains(translationDataType2.getDataType())) {
                if (object2 != null) {
                    int n = 0;
                    try {
                        Integer.parseInt((String)object2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String string2 = dataTypeMaxValueMap.get(translationDataType2.getDataType());
                    if (string2 != null) {
                        int n2 = Integer.parseInt(string2);
                        if (n <= n2) {
                            translationDataType2.setPrecision((String)object2);
                        } else {
                            translationDataType2.setPrecision(string2);
                        }
                    } else {
                        translationDataType2.setPrecision((String)object2);
                    }
                } else if (!translationDataType2.getDataType().equalsIgnoreCase("NUMBER") && !translationDataType2.getDataType().equalsIgnoreCase("RAW")) {
                    translationDataType2.setPrecision(dataTypeMaxValueMap.get(translationDataType2.getDataType()));
                } else if (translationDataType2.getDataType().equalsIgnoreCase("RAW")) {
                    translationDataType2.setPrecision("128");
                }
            }
        }
        if (string.equals("real")) {
            translationDataType2.setPrecision("24");
        } else if (string.equals("double")) {
            translationDataType2.setPrecision("53");
        } else if (string.equals("float")) {
            if (translationDataType.getPrecision() == null) {
                translationDataType2.setPrecision("53");
            } else {
                object2 = translationDataType.getPrecision();
                translationDataType2.setPrecision(Integer.parseInt((String)object2) <= 24 ? "24" : "53");
            }
        }
        if (translationDataType2.getScale() == null) {
            translationDataType2.setScale(translationDataType.getScale());
        }
        return translationDataType2;
    }

    public ArrayList<String> getEmulationFuncsForSchema(Object object) {
        return null;
    }

    public ArrayList<String> getEmulationFuncsForConnection(Object object) {
        return null;
    }

    static {
        TranslationDataType translationDataType = new TranslationDataType("NUMBER");
        translationDataType.setPrecision("19");
        translationDataType.setScale("0");
        dataTypeMap.put("bigint", translationDataType);
        translationDataType = new TranslationDataType("NUMBER");
        translationDataType.setPrecision("10");
        translationDataType.setScale("0");
        dataTypeMap.put("integer", translationDataType);
        dataTypeMap.put("int", translationDataType);
        translationDataType = new TranslationDataType("NUMBER");
        translationDataType.setPrecision("5");
        translationDataType.setScale("0");
        dataTypeMap.put("smallint", translationDataType);
        translationDataType = new TranslationDataType("NUMBER");
        translationDataType.setPrecision("3");
        translationDataType.setScale("0");
        dataTypeMap.put("tinyint", translationDataType);
        translationDataType = new TranslationDataType("NUMBER");
        translationDataType.setPrecision("1");
        translationDataType.setScale("0");
        dataTypeMap.put("bit", translationDataType);
        translationDataType = new TranslationDataType("NUMBER");
        translationDataType.setPrecision("19");
        translationDataType.setScale("2");
        dataTypeMap.put("money", translationDataType);
        translationDataType = new TranslationDataType("NUMBER");
        translationDataType.setPrecision("10");
        translationDataType.setScale("2");
        dataTypeMap.put("smallmoney", translationDataType);
        translationDataType = new TranslationDataType("FLOAT");
        dataTypeMap.put("float", translationDataType);
        dataTypeMap.put("double", translationDataType);
        dataTypeMap.put("real", translationDataType);
        translationDataType = new TranslationDataType("NUMBER");
        dataTypeMap.put("dec", translationDataType);
        dataTypeMap.put("decimal", translationDataType);
        dataTypeMap.put("numeric", translationDataType);
        dataTypeMap.put("timestamp", translationDataType);
        translationDataType = new TranslationDataType("DATE");
        dataTypeMap.put("datetime", translationDataType);
        dataTypeMap.put("smalldatetime", translationDataType);
        translationDataType = new TranslationDataType("CHAR");
        dataTypeMap.put("char", translationDataType);
        dataTypeMap.put("character", translationDataType);
        dataTypeMap.put("character", translationDataType);
        translationDataType = new TranslationDataType("NCHAR");
        dataTypeMap.put("nchar", translationDataType);
        dataTypeMap.put("national char", translationDataType);
        dataTypeMap.put("national character", translationDataType);
        translationDataType = new TranslationDataType("VARCHAR2");
        dataTypeMap.put("char varying", translationDataType);
        dataTypeMap.put("character varying", translationDataType);
        dataTypeMap.put("varchar", translationDataType);
        translationDataType = new TranslationDataType("NVARCHAR2");
        dataTypeMap.put("nvarchar", translationDataType);
        dataTypeMap.put("national char varying", translationDataType);
        dataTypeMap.put("national character varying", translationDataType);
        translationDataType = new TranslationDataType("VARCHAR2");
        translationDataType.setPrecision("128");
        dataTypeMap.put("sysname", translationDataType);
        translationDataType = new TranslationDataType("CLOB");
        dataTypeMap.put("text", translationDataType);
        dataTypeMap.put("ntext", translationDataType);
        dataTypeMap.put("national text", translationDataType);
        translationDataType = new TranslationDataType("BLOB");
        dataTypeMap.put("binary", translationDataType);
        dataTypeMap.put("binary varying", translationDataType);
        dataTypeMap.put("varbinary", translationDataType);
        dataTypeMap.put("image", translationDataType);
        dataTypeMap.put("cursor", new TranslationDataType("SYS_REFCURSOR"));
        translationDataType = new TranslationDataType("RAW");
        translationDataType.setPrecision("128");
        dataTypeMap.put("sql_variant", translationDataType);
        translationDataType = new TranslationDataType("RAW");
        translationDataType.setPrecision("16");
        dataTypeMap.put("uniqueidentifier", translationDataType);
        dataTypeMap.put("xml", new TranslationDataType("XMLTYPE"));
        dataTypeMaxValueMap = new HashMap();
        dataTypeMaxValueMap.put("CHAR", "2000");
        dataTypeMaxValueMap.put("VARCHAR2", "4000");
        dataTypeMaxValueMap.put("NCHAR", "1000");
        dataTypeMaxValueMap.put("NVARCHAR2", "4000");
        parameterizedTypeList = new ArrayList();
        parameterizedTypeList.add("NUMBER");
        parameterizedTypeList.add("VARCHAR2");
        parameterizedTypeList.add("NVARCHAR2");
        parameterizedTypeList.add("CHAR");
        parameterizedTypeList.add("NCHAR");
        parameterizedTypeList.add("RAW");
        oracleReservedWords = new String[]{"access", "add", "all", "alter", "and", "any", "as", "asc", "audit", "between", "by", "char", "check", "cluster", "column", "comment", "compress", "connect", "create", "current", "date", "decimal", "default", "delete", "desc", "distinct", "drop", "else", "exclusive", "exists", "file", "float", "for", "from", "grant", "group", "having", "identified", "immediate", "in", "increment", "index", "initial", "insert", "integer", "intersect", "into", "is", "level", "like", "lock", "long", "maxextents", "minus", "mlslabel", "mode", "modify", "nodaudit", "nocompress", "not", "nowait", "null", "number", "of", "offline", "on", "online", "option", "or", "order", "pctfree", "prior", "privileges", "public", "raw", "rename", "resource", "revoke", "row", "rowid", "rownum", "rows", "select", "session", "set", "share", "size", "smallint", "start", "successful", "synonym", "sysdate", "table", "then", "to", "trigger", "uid", "union", "unique", "update", "user", "validate", "values", "varchar", "varchar2", "view", "whenever", "where", "with"};
    }
}

