/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.Referenceable;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBLog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionTypeUIRegistry;
import oracle.jdeveloper.db.Connections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DBConnArb;
import oracle.jdevimpl.db.panels.ConnectionEditorPanel;

public class ManageConnectionsPanel
extends DefaultTraversablePanel
implements ListSelectionListener,
ListCellRenderer {
    private DefaultListModel m_connectionListModel = new DefaultListModel();
    private JList m_connectionsList = new JList(this.m_connectionListModel){

        @Override
        public String getToolTipText(MouseEvent e) {
            int row = this.locationToIndex(e.getPoint());
            if (row != this.getSelectedIndex()) {
                String connName = this.getModel().getElementAt(row).toString();
                ConnectionDetail cd = (ConnectionDetail)ManageConnectionsPanel.this.m_connectionDetails.get(connName);
                if (cd != null) {
                    String connType = (String)cd.m_updProps.get("subtype");
                    ConnectionTypeUIRegistry.ConnectionTooltipProvider ttp = ConnectionTypeUIRegistry.getTooltipProvider(connType);
                    return ttp.getTooltip(cd.m_updProps);
                }
            }
            return null;
        }
    };
    private DefaultListCellRenderer _delegate = new DefaultListCellRenderer();
    private ListButtons m_listButtons = new ListButtons(this.m_connectionsList, (ListButtons.Controller)new ButtonsHelper());
    private ConnectionEditorPanel m_connTypePanel = new ConnectionEditorPanel(this);
    private TraversableContext m_childContext = new TraversableContext(new Namespace(), 0);
    private int m_currentListSelection = -1;
    private Connections m_connectionsInstance;
    private HashMap<String, ConnectionDetail> m_connectionDetails = new HashMap();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)this._delegate.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String connName = (String)value;
        this.useConnectionDetail(connName);
        ConnectionDetail cd = this.m_connectionDetails.get(connName);
        if (cd == null || cd.m_origName == null || !cd.m_origName.equals(cd.m_updName) || !cd.m_origProps.equals(cd.m_updProps)) {
            Font f = label.getFont();
            f = new Font(f.getFamily(), 2, f.getSize());
            label.setFont(f);
        }
        return label;
    }

    private void initialiseConnectionDetail() {
        this.m_connectionsList.removeListSelectionListener(this);
        this.m_connectionListModel.removeAllElements();
        this.m_connectionDetails.clear();
        for (String connName : this.m_connectionsInstance.listConnections()) {
            ConnectionDetail cd = new ConnectionDetail();
            cd.m_origName = connName;
            cd.m_updName = connName;
            cd.m_origProps = null;
            cd.m_updProps = null;
            cd.m_used = false;
            this.m_connectionDetails.put(connName, cd);
            this.m_connectionListModel.addElement(connName);
        }
        this.m_connectionsList.addListSelectionListener(this);
    }

    private void useConnectionDetail(String connName) {
        ConnectionDetail cd = this.m_connectionDetails.get(connName);
        if (!cd.m_used) {
            Referenceable ref = null;
            try {
                ref = this.m_connectionsInstance.getReferenceable(connName);
            }
            catch (ConnectionException e) {
                // empty catch block
            }
            if (ref != null) {
                cd.m_origProps = ((DatabaseProvider)ref).getProperties();
            } else {
                cd.m_origProps = new Properties();
            }
            cd.m_updProps = (Properties)cd.m_origProps.clone();
            cd.m_used = true;
        }
    }

    private void newConnectionDetail() {
        Properties newProps = new Properties();
        newProps.put("subtype", "oraJDBC");
        boolean nameUnique = false;
        int suffix = 1;
        String basename = "Connection";
        String name = basename + suffix;
        while (!nameUnique) {
            boolean found = false;
            for (String key : this.m_connectionDetails.keySet()) {
                ConnectionDetail cd = this.m_connectionDetails.get(key);
                if (!cd.m_updName.equals(name)) continue;
                found = true;
                break;
            }
            if (!found) {
                nameUnique = true;
                continue;
            }
            name = basename + ++suffix;
        }
        ConnectionDetail cd = new ConnectionDetail();
        cd.m_origName = null;
        cd.m_updName = name;
        cd.m_origProps = null;
        cd.m_updProps = newProps;
        cd.m_used = true;
        this.m_connectionDetails.put(name, cd);
        this.m_connectionsList.removeListSelectionListener(this);
        this.m_connectionListModel.addElement(name);
        this.m_connectionsList.addListSelectionListener(this);
        this.m_connectionsList.setSelectedValue(name, true);
    }

    private void removeSelectedConnection() {
        int selIdx = this.m_connectionsList.getSelectedIndex();
        String connName = (String)this.m_connectionsList.getSelectedValue();
        this.m_connectionDetails.remove(connName);
        this.m_connectionsList.removeListSelectionListener(this);
        this.m_connectionListModel.removeElement(connName);
        this.m_connectionsList.addListSelectionListener(this);
        this.m_currentListSelection = -1;
        if (this.m_connectionListModel.size() == 0) {
            this.m_childContext.remove("ConnectionNameKey");
            this.m_childContext.remove("OriginalObject");
            this.m_childContext.remove("NewObject");
            this.m_connTypePanel.onEntry(this.m_childContext);
        } else if (selIdx >= this.m_connectionListModel.size()) {
            this.m_connectionsList.setSelectedIndex(selIdx - 1);
        } else {
            this.m_connectionsList.setSelectedIndex(selIdx);
        }
    }

    private void setupChildContext(String connName) {
        ConnectionDetail cd = this.m_connectionDetails.get(connName);
        this.m_childContext.remove("ConnectionNameKey");
        this.m_childContext.put("ConnectionNameKey", (Object)connName);
        this.m_childContext.remove("OriginalObject");
        this.m_childContext.put("OriginalObject", (Object)cd.m_origProps);
        this.m_childContext.remove("NewObject");
        this.m_childContext.put("NewObject", (Object)cd.m_updProps);
        this.m_childContext.remove("ConnectionsInstanceKey");
        this.m_childContext.put("ConnectionsInstanceKey", (Object)this.m_connectionsInstance);
    }

    public ManageConnectionsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JScrollPane scrConnections = new JScrollPane();
        scrConnections.setVerticalScrollBarPolicy(20);
        this.m_connectionsList.setSelectionMode(0);
        this.m_connectionsList.setCellRenderer(this);
        this.m_connectionsList.addListSelectionListener(this);
        scrConnections.getViewport().add((Component)this.m_connectionsList, null);
        JPanel pnlList = new JPanel(new GridBagLayout());
        pnlList.add((Component)scrConnections, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        pnlList.add(Box.createHorizontalStrut(120), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlList.add((Component)this.m_listButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlList.add((Component)((Object)this.m_connTypePanel), new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(0, 0));
        this.add(pnlList, "Center");
        this.setHelpID("f1_dbconnection_html");
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_connectionsInstance = (Connections)dataContext.get("ConnectionsInstanceKey");
        this.initialiseConnectionDetail();
        String connName = (String)dataContext.get("ConnectionNameKey");
        if (connName == null) {
            this.newConnectionDetail();
        } else {
            this.m_connectionsList.setSelectedValue(connName, true);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.saveCurrentConnectionDetails();
        Collection<String> currentList = this.m_connectionsInstance.listConnections();
        for (String conn : currentList) {
            String connName = conn;
            ConnectionDetail cd = this.m_connectionDetails.get(connName);
            if (cd == null) {
                try {
                    this.m_connectionsInstance.removeConnection(connName);
                    continue;
                }
                catch (ConnectionException e) {
                    DBLog.getLogger().log(Level.WARNING, "error removing connection " + connName, e);
                    throw new TraversalException(e.getMessage());
                }
            }
            if (cd.m_origProps.equals(cd.m_updProps)) continue;
            try {
                this.m_connectionsInstance.updateConnection(connName, null, cd.m_updProps);
            }
            catch (ConnectionException e) {
                DBLog.getLogger().log(Level.WARNING, "error updating connection " + connName, e);
                throw new TraversalException(e.getMessage());
            }
        }
        for (String connName : this.m_connectionDetails.keySet()) {
            if (currentList.contains(connName)) continue;
            ConnectionDetail cd = this.m_connectionDetails.get(connName);
            try {
                this.m_connectionsInstance.addConnection(connName, cd.m_updProps);
            }
            catch (ConnectionException e) {
                DBLog.getLogger().log(Level.WARNING, "error adding connection " + connName, e);
                throw new TraversalException(e.getMessage());
            }
        }
        try {
            this.m_connectionsInstance.saveConnections();
        }
        catch (ConnectionException e) {
            DBLog.getLogger().log(Level.WARNING, "error saving connections", e);
            throw new TraversalException(e.getMessage());
        }
        dataContext.put("ConnectionNameKey", this.m_connectionsList.getSelectedValue());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.currentSelectionOK()) {
            return;
        }
        if (this.m_currentListSelection != this.m_connectionsList.getSelectedIndex()) {
            String connName = (String)this.m_connectionsList.getSelectedValue();
            this.useConnectionDetail(connName);
            this.setupChildContext(connName);
            this.m_connTypePanel.onEntry(this.m_childContext);
            this.m_currentListSelection = this.m_connectionsList.getSelectedIndex();
        }
    }

    void saveCurrentConnectionDetails() throws TraversalException {
        if (this.m_currentListSelection != -1) {
            this.m_connTypePanel.onExit(this.m_childContext);
            String currName = (String)this.m_connectionListModel.get(this.m_currentListSelection);
            String newName = (String)this.m_childContext.get("ConnectionNameKey");
            if (!currName.equals(newName)) {
                if (!ModelUtil.hasLength((String)newName)) {
                    MessageDialog.error((Component)((Object)this), (Object)DBConnArb.getString(63), null, null);
                    throw new TraversalException(DBConnArb.getString(63));
                }
                if (this.m_connectionDetails.containsKey(newName)) {
                    MessageDialog.error((Component)((Object)this), (Object)DBConnArb.format(64, newName), null, null);
                    throw new TraversalException(DBConnArb.format(64, newName));
                }
                ConnectionDetail cd = this.m_connectionDetails.get(currName);
                this.m_connectionDetails.remove(currName);
                this.m_connectionDetails.put(newName, cd);
                cd.m_updName = newName;
                this.m_connectionsList.removeListSelectionListener(this);
                int i = this.m_connectionListModel.indexOf(currName);
                this.m_connectionListModel.setElementAt(newName, i);
                this.m_connectionsList.addListSelectionListener(this);
            }
        }
    }

    private boolean currentSelectionOK() {
        try {
            this.saveCurrentConnectionDetails();
            return true;
        }
        catch (TraversalException e) {
            e.showMessageDialog((Component)((Object)this));
            this.m_connectionsList.removeListSelectionListener(this);
            this.m_connectionsList.setSelectedIndex(this.m_currentListSelection);
            this.m_connectionsList.addListSelectionListener(this);
            return false;
        }
    }

    public Component getDefaultFocusComponent() {
        return this.m_connTypePanel.getDefaultFocusComponent();
    }

    public static final String manageConnections(Connections conns) {
        ManageConnectionsPanel panel = new ManageConnectionsPanel();
        Component defaultComp = panel.getDefaultFocusComponent();
        Namespace data = new Namespace();
        data.put("ConnectionsInstanceKey", (Object)conns);
        Collection<String> allconns = conns.listConnections();
        if (allconns.size() > 0) {
            data.put("ConnectionNameKey", (Object)allconns.iterator().next());
        }
        Frame parent = IdeUtil.getMainWindow();
        TDialogLauncher launcher = new TDialogLauncher((Component)parent, DBConnArb.getString(57), (Traversable)panel, data, (DialogRunnerCallback)new SizeKeeperCallback("edit.object"));
        DialogHeader header = new DialogHeader(DBConnArb.getString(58), OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/database.png")));
        launcher.setDialogHeader(header);
        launcher.initDialog().setInitialFocus(defaultComp);
        launcher.showDialog();
        return (String)data.get("ConnectionNameKey");
    }

    private class ButtonsHelper
    extends ListButtons.Controller {
        private ButtonsHelper() {
        }

        public void addToList() {
            if (ManageConnectionsPanel.this.currentSelectionOK()) {
                ManageConnectionsPanel.this.newConnectionDetail();
            }
        }

        public void removeFromList() {
            ManageConnectionsPanel.this.removeSelectedConnection();
        }

        public boolean includeReorderButtons() {
            return false;
        }

        public boolean canRemove() {
            return !ManageConnectionsPanel.this.m_connectionsList.isSelectionEmpty() && ManageConnectionsPanel.this.m_connectionListModel.size() > 0;
        }

        public boolean canRemove(Object val) {
            return this.canRemove();
        }
    }

    private static class ConnectionDetail {
        private String m_origName;
        private String m_updName;
        private Properties m_origProps;
        private Properties m_updProps;
        private boolean m_used;

        private ConnectionDetail() {
        }
    }
}

