/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.controls.ReadOnlyScrollPane;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionTypeUIRegistry;
import oracle.jdeveloper.db.Connections;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdevimpl.db.DBConnArb;
import oracle.jdevimpl.db.panels.ManageConnectionsPanel;

public class ConnectionEditorPanel
extends DefaultTraversablePanel
implements ActionListener,
FocusListener,
ItemListener {
    private JPanel m_headerPanel = new JPanel(new GridBagLayout());
    private JPanel m_customPanelContainer = new JPanel(new BorderLayout());
    private JLabel m_connNameLbl = new JLabel();
    private JLabel m_connTypeLbl = new JLabel();
    private JTextField m_connTypeFld = new JTextField();
    private JLabel m_usernameLbl = new JLabel();
    private JLabel m_passwordLbl = new JLabel();
    private JLabel m_roleLbl = new JLabel();
    private JTextField m_connNameFld = new JTextField();
    private DefaultComboBoxModel m_connTypeListModel = new NonNullableComboBoxModel();
    private JComboBox m_connTypeCmb = new JComboBox(this.m_connTypeListModel);
    private JTextField m_usernameFld = new JTextField();
    private JComboBox m_roleCmb = new JComboBox(new DefaultComboBoxModel());
    private JTextField m_roleFld = new JTextField();
    private String[] m_preSetRoleList;
    private JPasswordField m_passwordPwd = new JPasswordField();
    private JCheckBox m_savePasswordChk = new JCheckBox();
    private JCheckBox m_deployPasswordChk = new JCheckBox();
    private Traversable m_customConnTypeSubPanel;
    private Properties m_connectionProps = null;
    private TraversableContext m_dataContext;
    private ManageConnectionsPanel m_parentPanel = null;
    private String m_connNameBefore = null;
    private boolean m_saveAndDeployShown = false;
    private boolean m_errorOnEntry;
    private ReadOnlyScrollPane m_feedback = new ReadOnlyScrollPane((Component)((Object)this));
    private JButton m_testBut = new JButton();
    private Connections m_connectionsInstance;

    public ConnectionEditorPanel(ManageConnectionsPanel parent) {
        this.m_parentPanel = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        ResourceUtils.resLabel((JLabel)this.m_connNameLbl, (Component)this.m_connNameFld, (String)DBConnArb.getString(67));
        ResourceUtils.resLabel((JLabel)this.m_connTypeLbl, (Component)this.m_connTypeCmb, (String)DBConnArb.getString(68));
        ResourceUtils.resLabel((JLabel)this.m_usernameLbl, (Component)this.m_usernameFld, (String)DBConnArb.getString(76));
        ResourceUtils.resLabel((JLabel)this.m_passwordLbl, (Component)this.m_passwordPwd, (String)DBConnArb.getString(77));
        ResourceUtils.resButton((AbstractButton)this.m_savePasswordChk, (String)DBConnArb.getString(78));
        ResourceUtils.resButton((AbstractButton)this.m_deployPasswordChk, (String)DBConnArb.getString(79));
        ResourceUtils.resButton((AbstractButton)this.m_testBut, (String)DBConnArb.getString(81));
        this.m_feedback.getAccessibleContext().setAccessibleName(DBConnArb.getString(48));
        String pnlName = "ConnectionEditorPanel.";
        this.m_connNameFld.setName("ConnectionEditorPanel.ConnectionName");
        this.m_connTypeCmb.setName("ConnectionEditorPanel.ConnectionType");
        this.m_usernameFld.setName("ConnectionEditorPanel.Username");
        this.m_passwordPwd.setName("ConnectionEditorPanel.Password");
        this.m_roleCmb.setName("ConnectionEditorPanel.Role");
        this.m_roleFld.setName("ConnectionEditorPanel.Role");
        this.m_savePasswordChk.setName("ConnectionEditorPanel.SavePassword");
        this.m_deployPasswordChk.setName("ConnectionEditorPanel.DeployPassword");
        this.m_testBut.setName("ConnectionEditorPanel.Test");
        this.m_feedback.getTextArea().setName("ConnectionEditorPanel.TestResults");
        this.m_connTypeFld.setEditable(false);
        this.m_connTypeCmb.addItemListener(this);
        this.m_connNameFld.addFocusListener(this);
        this.setLayout(new GridBagLayout());
        this.add(this.m_headerPanel, this.gbc(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0)));
        this.add(this.m_customPanelContainer, this.gbc(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(15, 0, 0, 0)));
        this.m_testBut.addActionListener(this);
        this.add(this.m_testBut, this.gbc(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 5, 0, 5)));
        this.add((Component)this.m_feedback, this.gbc(0, 3, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 5)));
        this.add(Box.createVerticalStrut(60), this.gbc(3, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0)));
        this.setHelpID("f1_dbconnection_html");
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_connectionProps = (Properties)dataContext.get("NewObject");
        this.m_connectionsInstance = (Connections)dataContext.get("ConnectionsInstanceKey");
        String connName = (String)dataContext.get("ConnectionNameKey");
        if (ModelUtil.hasLength((String)connName)) {
            this.m_connNameFld.setText(connName);
            this.m_connNameFld.setEditable(dataContext.get("ConnectionOrigNameKey") == null);
            String connType = (String)this.m_connectionProps.get("subtype");
            String displayName = ConnectionTypeUIRegistry.getDisplayName(connType);
            this.m_connTypeCmb.removeItemListener(this);
            this.m_connTypeListModel.removeAllElements();
            if (dataContext.get("OriginalObject") == null) {
                for (String ct : ConnectionTypeUIRegistry.getConnectionTypes()) {
                    this.m_connTypeListModel.addElement(ConnectionTypeUIRegistry.getDisplayName(ct));
                }
            } else {
                this.m_connTypeListModel.addElement(ConnectionTypeUIRegistry.getDisplayName(connType));
            }
            this.m_connTypeCmb.setSelectedItem(displayName);
            this.m_connTypeCmb.addItemListener(this);
            this.m_dataContext = dataContext;
            this.m_connNameFld.setEnabled(true);
            this.m_connTypeCmb.setEnabled(true);
        }
        this.initialiseUI();
        this.m_connNameFld.requestFocusInWindow();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit();
        if (!this.m_errorOnEntry) {
            this.m_customConnTypeSubPanel.onExit(this.m_dataContext);
        }
    }

    private void initialiseUI() {
        if (this.m_saveAndDeployShown) {
            this.m_savePasswordChk.removeActionListener(this);
            this.m_saveAndDeployShown = false;
        }
        boolean saveAndDeployShown = false;
        this.m_headerPanel.removeAll();
        this.m_customPanelContainer.removeAll();
        String displayName = (String)this.m_connTypeCmb.getSelectedItem();
        String connType = ConnectionTypeUIRegistry.getSubTypeFromDisplayName(displayName);
        this.m_headerPanel.add((Component)this.m_connNameLbl, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0)));
        this.m_headerPanel.add((Component)this.m_connNameFld, this.gbc(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 12, 0, 0)));
        this.m_headerPanel.add((Component)this.m_connTypeLbl, this.gbc(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0)));
        this.m_headerPanel.add((Component)this.m_connTypeCmb, this.gbc(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0)));
        if (this.m_connectionProps != null) {
            saveAndDeployShown = this.addUserNamePasswordPanel(connType, false);
            this.addCustomPanel(connType);
        } else {
            this.m_connNameFld.setEnabled(false);
            this.m_connNameFld.setText("");
            this.m_connTypeCmb.setEnabled(false);
        }
        this.m_feedback.setText("", false);
        this.updateTestConnection(connType);
        this.repaint();
        this.validate();
        if (saveAndDeployShown) {
            this.m_savePasswordChk.addActionListener(this);
            this.m_saveAndDeployShown = true;
        }
    }

    private void addCustomPanel(String connType) {
        this.m_customConnTypeSubPanel = null;
        if (ModelUtil.hasLength((String)connType)) {
            Class clz = ConnectionTypeUIRegistry.getPanelClass(connType);
            try {
                this.m_customConnTypeSubPanel = (Traversable)clz.newInstance();
            }
            catch (IllegalAccessException e) {
                FeedbackManager.reportException((String)"Failed to instantiate panel:", (Throwable)e);
            }
            catch (InstantiationException e) {
                FeedbackManager.reportException((String)"Failed to instantiate panel:", (Throwable)e);
            }
        }
        if (this.m_customConnTypeSubPanel != null) {
            StringBuilder sb = new StringBuilder(" ");
            sb.append(DBConnArb.format(85, (String)this.m_connTypeCmb.getSelectedItem()));
            sb.append(" ");
            MatteBorder empty = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY);
            TitledBorder border = BorderFactory.createTitledBorder(empty, sb.toString());
            this.m_customPanelContainer.setBorder(border);
            this.m_customPanelContainer.add(this.m_customConnTypeSubPanel.getComponent(), "Center");
            try {
                this.m_customConnTypeSubPanel.onEntry(this.m_dataContext);
                this.m_errorOnEntry = false;
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
                this.m_errorOnEntry = true;
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                JTextArea errorText = new JTextArea(sw.getBuffer().toString());
                errorText.setEditable(false);
                this.m_customPanelContainer.add((Component)new JScrollPane(errorText), "Center");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (e.getSource() == this.m_savePasswordChk) {
            this.m_deployPasswordChk.setSelected(false);
            this.m_deployPasswordChk.setEnabled(this.m_savePasswordChk.isSelected());
        } else if (src == this.m_testBut) {
            try {
                if (this.m_parentPanel != null) {
                    this.m_parentPanel.saveCurrentConnectionDetails();
                } else {
                    this.onExit(this.m_dataContext);
                }
                this.m_feedback.setText(DBConnArb.getString(82), false);
                ConnectionTester ct = new ConnectionTester(this.m_connNameFld.getText());
                ct.testConnection(this.m_connectionsInstance, this.m_connectionProps);
            }
            catch (TraversalException te) {
                String title = null;
                title = te instanceof MissingDBConnValueException ? DBConnArb.getString(65) : StringUtils.stripMnemonic((String)DBConnArb.getString(81));
                MessageDialog.error((Component)((Object)this), (Object)te.getMessage(), (String)title, null);
                this.m_feedback.setText(DBConnArb.getString(84), true);
            }
        }
    }

    private void commit() throws MissingDBConnValueException {
        MissingDBConnValueException.check(this.m_connNameFld.getText(), this.m_connNameLbl);
        this.m_dataContext.put("ConnectionNameKey", (Object)this.m_connNameFld.getText());
        String displayName = (String)this.m_connTypeCmb.getSelectedItem();
        String connType = ConnectionTypeUIRegistry.getSubTypeFromDisplayName(displayName);
        if (ModelUtil.areDifferent((Object)connType, (Object)this.m_connectionProps.getProperty("subtype"))) {
            this.commitConnectionType();
        }
        if (ConnectionTypeUIRegistry.getUsernameKey(connType) != null) {
            if (connType != "thirdParty") {
                MissingDBConnValueException.check(this.m_usernameFld.getText(), this.m_usernameLbl);
            }
            this.m_connectionProps.remove(ConnectionTypeUIRegistry.getUsernameKey(connType));
            this.m_connectionProps.put(ConnectionTypeUIRegistry.getUsernameKey(connType), this.m_usernameFld.getText());
        }
        if (ConnectionTypeUIRegistry.getRoleKey(connType) != null) {
            this.m_connectionProps.remove(ConnectionTypeUIRegistry.getRoleKey(connType));
            String roleName = null;
            roleName = this.m_preSetRoleList == null ? this.m_roleFld.getText() : (this.m_roleCmb.isEditable() ? (String)this.m_roleCmb.getEditor().getItem() : (String)this.m_roleCmb.getSelectedItem());
            if (ModelUtil.hasLength((String)roleName)) {
                this.m_connectionProps.put(ConnectionTypeUIRegistry.getRoleKey(connType), roleName);
            }
        }
        if (ConnectionTypeUIRegistry.getPasswordKey(connType) != null) {
            this.m_connectionProps.remove(ConnectionTypeUIRegistry.getPasswordKey(connType));
            String passwd = this.m_passwordPwd.getText();
            if (passwd != null && passwd.length() > 0) {
                this.m_connectionProps.put(ConnectionTypeUIRegistry.getPasswordKey(connType), passwd);
            }
            if (ConnectionTypeUIRegistry.getSavePasswordKey(connType) != null) {
                this.m_connectionProps.remove(ConnectionTypeUIRegistry.getSavePasswordKey(connType));
                String saveValue = null;
                if (ConnectionTypeUIRegistry.getSavePassword(connType) == ConnectionTypeUIRegistry.AlwaysNeverAsk.ASK) {
                    saveValue = Boolean.valueOf(this.m_savePasswordChk.isSelected()).toString();
                } else if (ConnectionTypeUIRegistry.getSavePassword(connType) == ConnectionTypeUIRegistry.AlwaysNeverAsk.NEVER) {
                    saveValue = Boolean.FALSE.toString();
                }
                if (saveValue != null && saveValue.equals(Boolean.FALSE.toString())) {
                    this.m_connectionProps.put(ConnectionTypeUIRegistry.getSavePasswordKey(connType), saveValue);
                }
                if (ConnectionTypeUIRegistry.getDeployPasswordKey(connType) != null) {
                    this.m_connectionProps.remove(ConnectionTypeUIRegistry.getDeployPasswordKey(connType));
                    String deployValue = null;
                    if (ConnectionTypeUIRegistry.getDeployPassword(connType) == ConnectionTypeUIRegistry.AlwaysNeverAsk.ASK) {
                        deployValue = Boolean.valueOf(this.m_deployPasswordChk.isSelected()).toString();
                    } else if (ConnectionTypeUIRegistry.getDeployPassword(connType) == ConnectionTypeUIRegistry.AlwaysNeverAsk.ALWAYS) {
                        deployValue = Boolean.TRUE.toString();
                    }
                    if (deployValue == null) {
                        deployValue = Boolean.FALSE.toString();
                    }
                    this.m_connectionProps.put(ConnectionTypeUIRegistry.getDeployPasswordKey(connType), deployValue);
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.m_connNameFld) {
            this.m_connNameBefore = this.m_connNameFld.getText();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.m_connNameFld && ModelUtil.areDifferent((Object)this.m_connNameBefore, (Object)this.m_connNameFld.getText()) && this.m_parentPanel != null) {
            try {
                this.m_parentPanel.saveCurrentConnectionDetails();
            }
            catch (TraversalException f) {
                this.m_connNameFld.setText(this.m_connNameBefore);
            }
        }
    }

    private void commitConnectionType() {
        String displayName = (String)this.m_connTypeCmb.getSelectedItem();
        String connType = ConnectionTypeUIRegistry.getSubTypeFromDisplayName(displayName);
        String username = null;
        if (ConnectionTypeUIRegistry.getUsernameKey(connType) != null) {
            username = (String)this.m_connectionProps.get(ConnectionTypeUIRegistry.getUsernameKey(connType));
        }
        String password = null;
        if (ConnectionTypeUIRegistry.getPasswordKey(connType) != null) {
            password = (String)this.m_connectionProps.get(ConnectionTypeUIRegistry.getPasswordKey(connType));
        }
        this.m_connectionProps.clear();
        this.m_connectionProps.put("subtype", connType);
        if (ConnectionTypeUIRegistry.getUsernameKey(connType) != null && username != null) {
            this.m_connectionProps.put(ConnectionTypeUIRegistry.getUsernameKey(connType), username);
        }
        if (ConnectionTypeUIRegistry.getPasswordKey(connType) != null && password != null) {
            this.m_connectionProps.put(ConnectionTypeUIRegistry.getPasswordKey(connType), password);
        }
    }

    private boolean addUserNamePasswordPanel(String connType, boolean remove) {
        boolean saveShown = false;
        boolean deployShown = false;
        if (remove) {
            Component[] comp = this.m_headerPanel.getComponents();
            int i = this.m_headerPanel.getComponentCount();
            while (--i >= 0) {
                if (comp[i] == this.m_connNameFld || comp[i] == this.m_connNameLbl || comp[i] == this.m_connTypeCmb || comp[i] == this.m_connTypeLbl) continue;
                this.m_headerPanel.remove(i);
            }
        }
        JPanel usernameAndPasswordPanel = new JPanel();
        usernameAndPasswordPanel.setLayout(new GridBagLayout());
        int unpwSize = 1;
        if (ConnectionTypeUIRegistry.getUsernameKey(connType) != null) {
            this.m_usernameFld.setText((String)this.m_connectionProps.get(ConnectionTypeUIRegistry.getUsernameKey(connType)));
            this.m_headerPanel.add((Component)this.m_usernameLbl, this.gbc(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0)));
            usernameAndPasswordPanel.add((Component)this.m_usernameFld, this.gbc(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0)));
        }
        if (ConnectionTypeUIRegistry.getPasswordKey(connType) != null) {
            this.m_passwordPwd.setText((String)this.m_connectionProps.get(ConnectionTypeUIRegistry.getPasswordKey(connType)));
            this.m_headerPanel.add((Component)this.m_passwordLbl, this.gbc(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0)));
            usernameAndPasswordPanel.add((Component)this.m_passwordPwd, this.gbc(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0)));
            unpwSize = 2;
            JPanel pnlPasswdCheckBoxes = new JPanel(new GridBagLayout());
            if (ConnectionTypeUIRegistry.getSavePasswordKey(connType) != null) {
                String saveValue = null;
                if (ConnectionTypeUIRegistry.getSavePassword(connType) == ConnectionTypeUIRegistry.AlwaysNeverAsk.ASK) {
                    saveValue = (String)this.m_connectionProps.get(ConnectionTypeUIRegistry.getSavePasswordKey(connType));
                    pnlPasswdCheckBoxes.add((Component)this.m_savePasswordChk, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0)));
                    saveShown = true;
                } else if (ConnectionTypeUIRegistry.getSavePassword(connType) == ConnectionTypeUIRegistry.AlwaysNeverAsk.ALWAYS) {
                    saveValue = Boolean.TRUE.toString();
                }
                if (saveValue == null) {
                    saveValue = Boolean.TRUE.toString();
                }
                this.m_savePasswordChk.setSelected(Boolean.valueOf(saveValue));
                if (ConnectionTypeUIRegistry.getDeployPasswordKey(connType) != null) {
                    String deployValue = null;
                    if (ConnectionTypeUIRegistry.getDeployPassword(connType) == ConnectionTypeUIRegistry.AlwaysNeverAsk.ASK) {
                        deployValue = (String)this.m_connectionProps.get(ConnectionTypeUIRegistry.getDeployPasswordKey(connType));
                        pnlPasswdCheckBoxes.add((Component)this.m_deployPasswordChk, this.gbc(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 0, 0)));
                        deployShown = true;
                        this.m_deployPasswordChk.setEnabled(Boolean.valueOf(saveValue));
                    } else if (ConnectionTypeUIRegistry.getDeployPassword(connType) == ConnectionTypeUIRegistry.AlwaysNeverAsk.ALWAYS) {
                        deployValue = Boolean.TRUE.toString();
                    }
                    if (deployValue == null) {
                        deployValue = Boolean.FALSE.toString();
                    }
                    this.m_deployPasswordChk.setSelected(Boolean.valueOf(deployValue));
                }
            }
            if (saveShown || deployShown) {
                pnlPasswdCheckBoxes.add(Box.createHorizontalGlue(), this.gbc(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0)));
                this.m_headerPanel.add((Component)pnlPasswdCheckBoxes, this.gbc(2, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 24, 0, 5)));
            }
            this.m_headerPanel.add((Component)usernameAndPasswordPanel, this.gbc(1, 3, 1, unpwSize, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0)));
        }
        if (ConnectionTypeUIRegistry.getRoleKey(connType) != null) {
            this.m_preSetRoleList = ConnectionTypeUIRegistry.getPreSetRoleList(connType);
            String roleValue = (String)this.m_connectionProps.get(ConnectionTypeUIRegistry.getRoleKey(connType));
            this.m_headerPanel.add((Component)this.m_roleLbl, this.gbc(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0)));
            double roleWeight = saveShown && deployShown ? 0.0 : 1.0;
            GridBagConstraints roleCons = this.gbc(3, 3, 1, 1, roleWeight, 0.0, 17, 2, new Insets(5, 12, 0, 5));
            if (this.m_preSetRoleList == null) {
                this.m_headerPanel.add((Component)this.m_roleFld, roleCons);
                ResourceUtils.resLabel((JLabel)this.m_roleLbl, (Component)this.m_roleFld, (String)DBConnArb.getString(80));
                this.m_roleFld.setText(roleValue);
            } else {
                this.m_headerPanel.add((Component)this.m_roleCmb, roleCons);
                ResourceUtils.resLabel((JLabel)this.m_roleLbl, (Component)this.m_roleCmb, (String)DBConnArb.getString(80));
                this.m_roleCmb.setEditable(false);
                ((DefaultComboBoxModel)this.m_roleCmb.getModel()).removeAllElements();
                for (int i = 0; i < this.m_preSetRoleList.length; ++i) {
                    if (this.m_preSetRoleList[i] != null) {
                        ((DefaultComboBoxModel)this.m_roleCmb.getModel()).addElement(this.m_preSetRoleList[i]);
                        continue;
                    }
                    this.m_roleCmb.setEditable(true);
                }
                if (this.m_roleCmb.isEditable()) {
                    this.m_roleCmb.getEditor().setItem(roleValue);
                } else {
                    this.m_roleCmb.setSelectedItem(roleValue);
                }
            }
        }
        return saveShown && deployShown;
    }

    private void updateTestConnection(String connType) {
        boolean showConnectionTest = ConnectionTypeUIRegistry.getShowConnectionTest(connType);
        this.m_testBut.setVisible(showConnectionTest);
        this.m_feedback.setVisible(showConnectionTest);
    }

    private void updateUI(String item) {
        String connType = ConnectionTypeUIRegistry.getSubTypeFromDisplayName(item);
        this.updateTestConnection(connType);
        boolean isSaveAndDeployShown = this.addUserNamePasswordPanel(connType, true);
        this.m_customPanelContainer.removeAll();
        this.addCustomPanel(connType);
        this.repaint();
        this.validate();
        if (isSaveAndDeployShown) {
            this.m_savePasswordChk.addActionListener(this);
            this.m_saveAndDeployShown = true;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == this.m_connTypeCmb) {
            this.commitConnectionType();
            this.updateUI((String)this.m_connTypeCmb.getSelectedItem());
        }
    }

    public Component getDefaultFocusComponent() {
        return this.m_connNameFld;
    }

    private class ConnectionTester
    extends ProgressRunnable {
        private Connections m_connectionsInstance;
        private Properties m_connectionProperties;
        private String m_message = null;

        public ConnectionTester(String connName) {
            this.setTitle(DBConnArb.getString(14));
            this.setMessage(DBConnArb.format(15, connName));
        }

        protected Object doWork() throws ConnectionException {
            this.m_connectionsInstance.testConnection(this.m_connectionProperties);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void testConnection(Connections connectionsInstance, Properties connectionProperties) {
            this.m_connectionsInstance = connectionsInstance;
            this.m_connectionProperties = connectionProperties;
            this.m_message = DBConnArb.getString(83);
            try {
                this.start(SwingUtilities.isEventDispatchThread());
            }
            catch (ProgressException e) {
                Exception ex = (Exception)e.getCause();
                while (ex instanceof DBException) {
                    Throwable cause = ex.getCause();
                    if (cause == null || !(cause instanceof Exception)) continue;
                    ex = (Exception)cause;
                }
                this.m_message = ex.getMessage();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionEditorPanel.this.m_feedback.setText(ConnectionTester.this.m_message, true);
                    }
                });
            }
            catch (Exception e2) {
                this.m_message = e2.getMessage();
                {
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        protected void doCancel() {
            super.doCancel();
            this.m_message = DBConnArb.getString(84);
        }
    }
}

