/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.migration;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.migration.AbstractConnMigrator;

public class CAConnMigrator
extends AbstractConnMigrator {
    private static final String CONNECTIONS_FILE_NAME = "connections.xml";

    @Override
    protected String getExtensionID() {
        return "oracle.jdeveloper.db.connection";
    }

    public String[] migrate(File sourceDir, File destDir) {
        String[] result = new String[]{};
        File src = this.findExtensionFile(sourceDir, CONNECTIONS_FILE_NAME);
        if (src == null) {
            this.getLogger().fine("No database connections found to migrate");
        } else {
            this.migrateAfterAddinsLoaded(src);
        }
        return result;
    }

    @Override
    protected void migrateConnections() {
        URL srcURL = URLFactory.newFileURL((File)this.m_srcFile);
        this.getLogger().fine("Migrating connections from " + srcURL.toExternalForm());
        DatabaseConnections srcConns = DatabaseConnections.getPrivateInstance(srcURL);
        for (String name : srcConns.listConnections()) {
            try {
                this.addConnection(name, srcConns.getReferenceable(name));
            }
            catch (ConnectionException ce) {
                this.getLogger().log(Level.WARNING, "Couldn't access connection {0} to migrate: {1}", new Object[]{name, ce.getMessage()});
            }
        }
    }

    public boolean canMigrate(int category, File sourceDir) {
        return this.findExtensionFile(sourceDir, CONNECTIONS_FILE_NAME) != null;
    }
}

