/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.sql.SQLException;
import java.util.Properties;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionTypeUIRegistry;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class DefaultTooltipProvider
implements ConnectionTypeUIRegistry.ConnectionTooltipProvider {
    @Override
    public String getTooltip(Properties props) {
        StringBuilder sb = null;
        if (props != null) {
            String connType = (String)props.get("subtype");
            if ("oraJDBC".equals(connType)) {
                String username = (String)props.get(ConnectionTypeUIRegistry.getUsernameKey(connType));
                String hostname = (String)props.get("hostname");
                String sid = (String)props.get("sid");
                if (sid == null) {
                    sid = (String)props.get("serviceName");
                }
                if (ModelUtil.hasLength((String)username) && ModelUtil.hasLength((String)hostname) && ModelUtil.hasLength((String)sid)) {
                    sb = new StringBuilder();
                    sb.append(ConnectionTypeUIRegistry.getDisplayName(connType)).append(": ").append(username).append("@").append(hostname).append(":").append(sid);
                }
            } else if (connType != null) {
                String username = (String)props.get(ConnectionTypeUIRegistry.getUsernameKey(connType));
                String connUrl = null;
                DatabaseProvider dp = new DatabaseProvider(props);
                if (dp != null) {
                    try {
                        connUrl = dp.getConnectionURL();
                    }
                    catch (SQLException e) {
                        connUrl = null;
                    }
                }
                if (ModelUtil.hasLength((String)username) && ModelUtil.hasLength((String)connUrl)) {
                    sb = new StringBuilder();
                    sb.append(ConnectionTypeUIRegistry.getDisplayName(connType)).append(": ").append(username).append(": ").append(connUrl);
                }
            }
        }
        return sb == null ? null : sb.toString();
    }
}

