/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.Connections;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.DBConnArb;
import oracle.jdevimpl.db.panels.ConnectionEditorPanel;

public class DefaultEditor
extends DatabaseConnectionEditorLauncher {
    private static Class<? extends DefaultEditor> s_override;

    protected DatabaseConnections getConnections() {
        return DatabaseConnectionStores.getInstance().getCurrentStore(this.getContext());
    }

    protected String getDefaultSubtype() {
        String type;
        Properties defaultProps = this.getDefaultProperties();
        if (defaultProps != null && ModelUtil.hasLength((String)(type = defaultProps.getProperty("subtype")))) {
            return type;
        }
        return "oraJDBC";
    }

    protected Traversable getPanel() {
        return new ConnectionEditorPanel(null);
    }

    protected Component getDefaultFocusComponent(Traversable panel) {
        return ((ConnectionEditorPanel)panel).getDefaultFocusComponent();
    }

    protected String getTitle(boolean edit) {
        return edit ? DBConnArb.getString(59) : DBConnArb.getString(61);
    }

    protected String getHeaderText(boolean edit) {
        return edit ? DBConnArb.getString(60) : DBConnArb.getString(62);
    }

    protected void setupNamespace(Namespace data) {
    }

    private Properties newConnectionProperties() {
        Properties props = new Properties();
        props.put("subtype", this.getDefaultSubtype());
        Properties defaultProps = this.getDefaultProperties();
        if (defaultProps != null) {
            for (String prop : defaultProps.stringPropertyNames()) {
                props.setProperty(prop, defaultProps.getProperty(prop));
            }
        }
        return props;
    }

    @Override
    public final ConnectionInfo launchEditor(DatabaseConnections conns, String connName) {
        Traversable panel = this.getPanel();
        Component parent = DBMessageDialog.getDialogParent();
        Component defaultComp = this.getDefaultFocusComponent(panel);
        if (conns == null) {
            conns = this.getConnections();
        }
        Properties props = null;
        if (ModelUtil.hasLength((String)connName)) {
            try {
                props = conns.getProperties(connName);
            }
            catch (ConnectionException ce) {
                DBLog.getLogger().log(Level.WARNING, "Cannot retrieve connection " + connName, ce);
                MessageDialog.error((Component)parent, (Object)ce.getMessage(), (String)this.getTitle(true), null);
                return null;
            }
        }
        boolean edit = props != null;
        String originalName = edit ? connName : null;
        boolean newConn = false;
        if (props == null) {
            newConn = true;
            props = this.newConnectionProperties();
            if (!ModelUtil.hasLength((String)connName)) {
                connName = DBUtil.getUniqueName(conns.listConnections(), (String)this.getConnectionBaseName());
            }
        }
        Namespace data = new Namespace();
        data.put("ConnectionsInstanceKey", (Object)conns);
        data.put("ConnectionNameKey", (Object)connName);
        data.put("ConnectionOrigNameKey", (Object)originalName);
        data.put("NewObject", (Object)props);
        data.put(DatabaseConnectionEditorLauncher.StoreChoice.class.getName(), (Object)this.getStoreChoice());
        this.setupNamespace(data);
        TDialogLauncher launcher = new TDialogLauncher(parent, this.getTitle(edit), panel, data);
        DialogHeader header = new DialogHeader(this.getHeaderText(edit), OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/dbconn_lg_qualifier.png")));
        launcher.setDialogHeader(header);
        launcher.setInitialSize(560, 560);
        JEWTDialog dialog = launcher.initDialog();
        dialog.setInitialFocus(defaultComp);
        dialog.addVetoableChangeListener((VetoableChangeListener)new CommitListener(data));
        dialog.setName(newConn ? "CreateDatabaseConnectionDialog" : "EditDatabaseConnectionDialog");
        if (launcher.showDialog()) {
            String name = (String)data.get("ConnectionNameKey");
            DatabaseConnections store = (DatabaseConnections)data.get("ConnectionsInstanceKey");
            return new ConnectionInfo(store == null ? null : store.getStoreName(), name);
        }
        return null;
    }

    protected void doCommit(Connections conns, String originalName, String newName, Properties props, Namespace data) throws ConnectionException {
        if (originalName != null) {
            conns.updateConnection(originalName, newName, props);
        } else {
            conns.addConnection(newName, props);
        }
    }

    static void overrideDefaultEditor(Class<? extends DefaultEditor> clz) {
        s_override = clz;
    }

    public static DefaultEditor createDefaultEditor() {
        if (s_override != null) {
            try {
                return s_override.newInstance();
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.SEVERE, "cannot create db connection editor", e);
            }
        }
        return new DefaultEditor();
    }

    private class CommitListener
    implements VetoableChangeListener {
        private Namespace data;

        private CommitListener(Namespace d) {
            this.data = d;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                String newName = (String)this.data.get("ConnectionNameKey");
                Properties props = (Properties)this.data.get("NewObject");
                DatabaseConnections conns = (DatabaseConnections)this.data.get("ConnectionsInstanceKey");
                String originalName = (String)this.data.get("ConnectionOrigNameKey");
                try {
                    DefaultEditor.this.doCommit(conns, originalName, newName, props, this.data);
                }
                catch (ConnectionException ce) {
                    MessageDialog.error((Component)DBMessageDialog.getDialogParent(), (Object)ce.getMessage(), (String)DefaultEditor.this.getTitle(originalName != null), null);
                    throw new PropertyVetoException(ce.getMessage(), evt);
                }
            }
        }
    }
}

