/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.controls.ConnectionPickerButton;
import oracle.jdeveloper.db.panels.AbstractConnectionPanelUI;
import oracle.jdevimpl.db.DBConnArb;

public class GlobalConnectionPanelUI
extends AbstractConnectionPanelUI {
    private Collection<ItemListener> m_listeners;
    private Picker m_picker;

    public GlobalConnectionPanelUI() {
        super(true);
    }

    public GlobalConnectionPanelUI(boolean oracleOnly) {
        super(oracleOnly, true);
    }

    public GlobalConnectionPanelUI(String[] subTypes) {
        super(subTypes, true);
    }

    public GlobalConnectionPanelUI(String[] subTypes, boolean showDetails) {
        super(subTypes, showDetails);
    }

    @Override
    protected String getComponentNamePrefix() {
        return "GlobalConnectionPanelUI";
    }

    @Override
    public final ConnectionInfo getConnectionInfo() {
        return this.m_picker.getConnectionInfo();
    }

    public final void setConnectionInfo(ConnectionInfo info) {
        this.m_picker.setConnectionInfo(info);
    }

    public final void setContext(Context ideContext) {
        this.m_picker.setContext(ideContext);
    }

    @Override
    public final Component getPicker() {
        if (this.m_picker == null) {
            this.m_picker = new Picker();
        }
        return this.m_picker;
    }

    @Override
    protected final void launchConnectionDialog(boolean edit) {
        boolean allStores;
        ConnectionInfo info = this.m_picker.getConnectionInfo();
        String storeName = info.getStoreName();
        boolean bl = allStores = this.m_picker.listStores().size() > 2;
        if (edit) {
            DatabaseConnectionEditor.editConnection(storeName, info.getConnectionName(), allStores);
        } else {
            String newConn = DatabaseConnectionEditor.editConnection(storeName, null, allStores);
            this.m_picker.resetPicker();
            if (newConn != null) {
                info.setConnectionName(newConn);
                this.m_picker.setConnectionInfo(info);
            }
        }
    }

    @Override
    public void addComboListener(ItemListener itemListener) {
        if (itemListener != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new ArrayList<ItemListener>();
            }
            if (!this.m_listeners.contains(itemListener)) {
                this.m_listeners.add(itemListener);
            }
        }
    }

    @Override
    public void removeComboListener(ItemListener itemListener) {
        if (this.m_listeners != null && itemListener != null) {
            this.m_listeners.remove(itemListener);
        }
    }

    private void fireEvent(ConnectionInfo info) {
        if (this.m_listeners != null) {
            for (ItemListener l : this.m_listeners) {
                l.itemStateChanged(new ItemEvent((ItemSelectable)((Object)this.m_picker), 0, (Object)info, 1));
            }
        }
    }

    @Deprecated
    public static ConnectionInfo getConnection(String title, String prompt, String storeName, String connName) {
        return GlobalConnectionPanelUI.getConnection(title, prompt, new ConnectionInfo(storeName, connName), false, null);
    }

    @Deprecated
    public static ConnectionInfo getConnection(String title, String prompt, String storeName, String connName, boolean oraOnly) {
        return GlobalConnectionPanelUI.getConnection(title, prompt, new ConnectionInfo(storeName, connName), oraOnly, null);
    }

    public static ConnectionInfo getConnection(ConnectionInfo connInfo) {
        return GlobalConnectionPanelUI.getConnection(connInfo, false, null);
    }

    public static ConnectionInfo getConnection(ConnectionInfo connInfo, boolean oraOnly, Context context) {
        return GlobalConnectionPanelUI.getConnection(DBConnArb.getString(12), DBConnArb.getString(8), connInfo, oraOnly, context);
    }

    public static ConnectionInfo getConnection(String title, String prompt, ConnectionInfo connInfo, boolean oraOnly, Context ideContext) {
        if (connInfo == null) {
            connInfo = new ConnectionInfo(null, null);
        }
        if (ideContext == null) {
            ideContext = Context.newIdeContext();
        }
        GlobalConnectionPanelUI panel = new GlobalConnectionPanelUI(oraOnly);
        panel.setConnectionPrompt(prompt);
        panel.setConnectionInfo(connInfo);
        panel.setContext(ideContext);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_odbselectconnection_html");
        final JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultFocusComponent(), (String)title);
        final Picker picker = panel.m_picker;
        picker.addConnectionListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                dlg.setOKButtonEnabled(picker.getConnectionInfo().isValid());
            }
        });
        Dimension dim = new Dimension(400, 200);
        dlg.setMinimumSize(dim);
        dlg.setOKButtonEnabled(picker.getConnectionInfo().isValid());
        dlg.setName(panel.getComponentNamePrefix() + "Dialog");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return connInfo;
        }
        return null;
    }

    @Deprecated
    public static class ChosenConnection
    extends ConnectionInfo {
        public ChosenConnection(String storeName, String connName) {
            super(storeName, connName);
        }
    }

    private class Picker
    extends ConnectionPickerButton {
        Picker() {
            super(null);
        }

        @Override
        protected void connectionSelected(ConnectionInfo info) {
            super.connectionSelected(info);
            if (GlobalConnectionPanelUI.this.m_picker != null) {
                GlobalConnectionPanelUI.this.checkConnection();
            }
            GlobalConnectionPanelUI.this.fireEvent(info);
        }

        @Override
        protected Collection<String> listConnections(DatabaseConnections dc) {
            return dc.listConnections(GlobalConnectionPanelUI.this.getSubTypes());
        }

        @Override
        protected Collection<String> listStores() {
            return super.listStores();
        }

        private void resetPicker() {
            this.resetConnections();
        }
    }
}

