/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.Component;
import java.sql.SQLException;
import javax.swing.SwingUtilities;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.db.DBConnArb;

public class DatabaseFinder
extends ProgressRunnable {
    private String _cName;
    private Database _db;

    public static Database findDatabase(String connName) {
        Database db = (Database)DBObjectProviderFactory.findProvider((Object)connName);
        if (db != null) {
            return db;
        }
        DatabaseFinder c = new DatabaseFinder(connName);
        return c.getDatabase();
    }

    private DatabaseFinder(String connName) {
        this.setTitle(DBConnArb.getString(14));
        this.setMessage(DBConnArb.format(15, connName));
        this._cName = connName;
    }

    protected Object doWork() throws DBException {
        return DBObjectProviderFactory.findOrCreateProvider((Object)this._cName);
    }

    protected void finish(Object result) {
        this._db = (Database)result;
    }

    private Database getDatabase() {
        if (this._db == null) {
            try {
                this.start(SwingUtilities.isEventDispatchThread());
            }
            catch (ProgressException e) {
                Exception ex = (Exception)e.getCause();
                while (ex instanceof DBException) {
                    Throwable cause = ex.getCause();
                    if (cause == null || !(cause instanceof Exception)) continue;
                    ex = (Exception)cause;
                }
                this._reportError(ex);
            }
        }
        return this._db;
    }

    private void _reportError(final Exception ex) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String title = DBConnArb.getString(16);
                Component parent = DBMessageDialog.getDialogParent();
                if (ex instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog((Component)parent, (String)title, (SQLException)((SQLException)ex));
                } else if (ex instanceof DBException) {
                    DBExceptionDialog.showErrorDialog((Component)parent, (String)title, (DBException)((DBException)((Object)ex)));
                } else {
                    ExceptionDialog.showExceptionDialog((Component)parent, (Throwable)ex, (String)title, (String)ex.getLocalizedMessage(), null);
                }
            }
        });
    }
}

