/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.controls.ConnectionDetails;
import oracle.jdevimpl.db.DBConnArb;

abstract class AbstractConnectionPanelUI
extends JPanel
implements ActionListener {
    private boolean m_showDetails;
    private String[] m_subTypes;
    private JWrappedLabel m_promptLabel;
    private JLabel m_connectionsLabel;
    private JButton m_btnNew;
    private JButton m_btnEdit;
    private JPanel m_detailsPanel;
    private final DBUIResourceHelper m_reshelp;

    protected AbstractConnectionPanelUI(boolean showDetails) {
        this(false, showDetails);
    }

    protected AbstractConnectionPanelUI(boolean oracleOnly, boolean showDetails) {
        String[] stringArray;
        if (oracleOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        this(stringArray, showDetails);
    }

    protected AbstractConnectionPanelUI(String[] dbSubTypes, boolean showDetails) {
        this.m_showDetails = true;
        this.m_connectionsLabel = new JLabel();
        this.m_btnNew = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.m_btnEdit = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this.m_reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
        this.m_subTypes = dbSubTypes;
        this.m_showDetails = showDetails;
        this.initialise();
    }

    protected String[] getSubTypes() {
        return this.m_subTypes;
    }

    protected void initialise() {
        this.setLayout(new BorderLayout(0, 15));
        this.setConnectionPrompt(this.getPromptText());
        JPanel center = new JPanel();
        this.layoutComponents(center);
        this.add((Component)center, "Center");
    }

    protected DBUIResourceHelper getResourceHelper() {
        return this.m_reshelp;
    }

    private void layoutComponents(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0);
        panel.add((Component)this.m_connectionsLabel, gbc);
        ++gbc.gridx;
        GridBagConstraints gbcpicker = (GridBagConstraints)gbc.clone();
        gbcpicker.weightx = 1.0;
        gbcpicker.fill = 2;
        ++gbc.gridx;
        this.addButtons(panel, gbc);
        if (this.m_showDetails) {
            this.m_detailsPanel = this.getDetailsPanel();
            GridBagConstraints gbcdetails = new GridBagConstraints(0, ++y, gbc.gridx - 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 24, 0, 24), 0, 0);
            panel.add((Component)this.m_detailsPanel, gbcdetails);
        }
        Component picker = this.getPicker();
        this.m_reshelp.setName(picker, "Connection");
        panel.add(picker, gbcpicker);
        this.setConnectionLabel(DBConnArb.getString(7));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 10, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addButtons(JPanel panel, GridBagConstraints gbc) {
        gbc.insets.right = 5;
        this.m_btnNew.addActionListener(this);
        this.addButton(panel, this.m_btnNew, gbc, DBConnArb.getString(2), DBConnArb.getString(0), "New");
        ++gbc.gridx;
        this.m_btnEdit.addActionListener(this);
        this.addButton(panel, this.m_btnEdit, gbc, DBConnArb.getString(3), DBConnArb.getString(1), "Edit");
        ++gbc.gridx;
    }

    protected void addButton(JPanel panel, JButton button, GridBagConstraints gbc, String tooltip, String mnemonicText, String name) {
        this.m_reshelp.setName((Component)button, name);
        button.setToolTipText(tooltip);
        if (ModelUtil.hasLength((String)mnemonicText)) {
            button.setMnemonic(StringUtils.getMnemonicKeyCode((String)mnemonicText));
        }
        IconicButtonUI.install((AbstractButton)button);
        panel.add((Component)button, gbc);
    }

    protected JPanel getDetailsPanel() {
        ConnectionDetails detailsPanel = new ConnectionDetails();
        return detailsPanel;
    }

    protected void enableButtons(boolean validConn) {
        if (this.isEnabled()) {
            this.m_btnEdit.setEnabled(validConn);
        }
    }

    public void enableActiveComponents(boolean boo) {
        this.m_btnNew.setEnabled(boo);
        if (boo) {
            this.checkConnection();
        } else {
            this.m_btnEdit.setEnabled(false);
            this.disableDetails();
        }
    }

    @Override
    public void setEnabled(boolean boo) {
        super.setEnabled(boo);
        if (this.m_promptLabel != null) {
            this.m_promptLabel.setEnabled(boo);
        }
        this.m_connectionsLabel.setEnabled(boo);
        this.enableActiveComponents(boo);
    }

    protected void checkConnection() {
        ConnectionInfo connInfo = this.getConnectionInfo();
        if (connInfo != null && connInfo.isValid()) {
            this.enableButtons(true);
        } else {
            this.enableButtons(false);
        }
        if (this.m_showDetails) {
            this.populateDetails(connInfo);
        }
    }

    protected void disableDetails() {
        if (this.m_showDetails) {
            this.m_detailsPanel.setEnabled(false);
        }
    }

    protected void populateDetails(ConnectionInfo connInfo) {
        if (this.m_detailsPanel instanceof ConnectionDetails) {
            ((ConnectionDetails)this.m_detailsPanel).populateDetails(connInfo);
        }
    }

    @Deprecated
    protected String getPromptText() {
        return DBConnArb.getString(8);
    }

    public void setConnectionLabel(String label) {
        ResourceUtils.resLabel((JLabel)this.m_connectionsLabel, (Component)this.getPicker(), (String)label);
        this.validate();
    }

    public void setConnectionPrompt(String prompt) {
        if (ModelUtil.hasLength((String)prompt)) {
            this.m_promptLabel = new JWrappedLabel(prompt);
            this.add((Component)this.m_promptLabel, "North");
        } else if (this.m_promptLabel != null) {
            this.remove((Component)this.m_promptLabel);
            this.m_promptLabel = null;
        }
        this.validate();
    }

    public Component getDefaultFocusComponent() {
        return this.m_btnNew;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_btnNew) {
            this.launchConnectionDialog(false);
        } else if (source == this.m_btnEdit) {
            this.launchConnectionDialog(true);
        }
    }

    protected abstract String getComponentNamePrefix();

    protected abstract ConnectionInfo getConnectionInfo();

    protected abstract Component getPicker();

    protected abstract void launchConnectionDialog(boolean var1);

    public abstract void addComboListener(ItemListener var1);

    public abstract void removeComboListener(ItemListener var1);
}

