/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.StoreListener;
import oracle.jdeveloper.db.StoreProvider;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DBConnArb;
import oracle.jdevimpl.db.StoreContext;

public final class DatabaseConnectionStores {
    public static final String CENTRAL_STORE = "IdeConnections";
    private static DatabaseConnectionStores s_instance;
    private List<StoreProvider> m_providers = new ArrayList<StoreProvider>();
    private Collection<StoreListener> m_listeners = new HashSet<StoreListener>();

    public static final DatabaseConnectionStores getInstance() {
        if (s_instance == null) {
            s_instance = new DatabaseConnectionStores();
        }
        return s_instance;
    }

    private DatabaseConnectionStores() {
        this.registerStoreProvider(new CentralStoreProvider());
    }

    private Collection<StoreListener> getListeners() {
        return Collections.unmodifiableCollection(new HashSet<StoreListener>(this.m_listeners));
    }

    void fireStoreAdded(String storeName) {
        for (StoreListener l : this.getListeners()) {
            try {
                l.storeAdded(storeName);
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.WARNING, "DatabaseConnectionStores listener error", e);
            }
        }
        this.printStores();
    }

    void fireStoreRemoved(String storeName) {
        for (StoreListener l : this.getListeners()) {
            try {
                l.storeRemoved(storeName);
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.WARNING, "DatabaseConnectionStores listener error", e);
            }
        }
        this.printStores();
    }

    public void addStoreListener(StoreListener l) {
        this.m_listeners.add(l);
    }

    public void removeStoreListener(StoreListener l) {
        this.m_listeners.remove(l);
    }

    public Collection<String> listStores() {
        ArrayList<String> retval = new ArrayList<String>();
        for (StoreProvider provider : this.m_providers) {
            retval.addAll(provider.listStores());
        }
        return retval;
    }

    public Collection<String> listStores(Context ideContext) {
        if (ideContext == null) {
            return this.listStores();
        }
        return StoreContext.getContext().listStores(ideContext);
    }

    public DatabaseConnections getCurrentStore() {
        if (Ide.isRunning()) {
            return this.getCurrentStore(Context.newIdeContext());
        }
        return DatabaseConnections.getInstance();
    }

    public DatabaseConnections getCurrentStore(Context ideContext) {
        if (ideContext != null) {
            for (StoreProvider provider : this.m_providers) {
                String storeName = provider.getCurrentStore(ideContext);
                if (!ModelUtil.hasLength((String)storeName)) continue;
                return this.getStore(storeName);
            }
        }
        return DatabaseConnections.getInstance();
    }

    public String getCurrentConnection(Context ideContext) {
        ConnectionInfo ci = this.getCurrentConnectionInfo(ideContext);
        return ci == null ? null : ci.getConnectionName();
    }

    public ConnectionInfo getCurrentConnectionInfo(Context ideContext) {
        if (ideContext != null) {
            for (StoreProvider provider : this.m_providers) {
                String connName;
                String storeName = provider.getCurrentStore(ideContext);
                if (!ModelUtil.hasLength((String)storeName) || !ModelUtil.hasLength((String)(connName = provider.getCurrentConnection(ideContext)))) continue;
                return new ConnectionInfo(storeName, connName);
            }
        }
        return null;
    }

    public Database getCurrentDatabase(Context ideContext) {
        if (ideContext != null) {
            for (StoreProvider provider : this.m_providers) {
                String storeName = provider.getCurrentStore(ideContext);
                DatabaseConnections store = this.getStore(storeName);
                if (store == null) continue;
                String connName = provider.getCurrentConnection(ideContext);
                try {
                    return store.getDatabase(connName);
                }
                catch (DBException dbe) {
                    DBLog.getLogger().log(Level.FINE, "failed to open database " + connName, dbe);
                }
            }
        }
        return null;
    }

    public DatabaseConnections getStore(String storeName) {
        if (storeName == null) {
            return null;
        }
        for (StoreProvider provider : this.m_providers) {
            DatabaseConnections store = provider.getStore(storeName);
            if (store == null) continue;
            return store;
        }
        return null;
    }

    private StoreProvider findProvider(String storeName) {
        StoreProvider retval = null;
        if (storeName != null) {
            for (StoreProvider provider : this.m_providers) {
                Collection<String> names = provider.listStores();
                if (names == null || !names.contains(storeName)) continue;
                retval = provider;
                break;
            }
        }
        return retval;
    }

    public String getShortLabel(String storeName) {
        String shortLabel = null;
        StoreProvider provider = this.findProvider(storeName);
        if (provider != null) {
            shortLabel = provider.getShortLabel(storeName);
        }
        return shortLabel;
    }

    public Icon getIcon(String storeName) {
        Icon icon = null;
        StoreProvider provider = this.findProvider(storeName);
        if (provider != null) {
            icon = provider.getIcon(storeName);
        }
        return icon;
    }

    public String getToolTipText(String storeName) {
        String ttt = null;
        StoreProvider provider = this.findProvider(storeName);
        if (provider != null) {
            ttt = provider.getToolTipText(storeName);
        }
        return ttt;
    }

    public void registerStoreProvider(StoreProvider provider) {
        this.m_providers.add(0, provider);
        DBLog.getLogger().log(Level.FINE, "Registered new database connection store provider: " + provider.getClass().getName());
        this.printStores();
    }

    private void printStores() {
        Logger logger = DBLog.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            Collection<String> stores = this.listStores();
            if (stores.size() > 0) {
                StringBuilder buff = new StringBuilder();
                buff.append("Available database connection stores: \n");
                for (String name : stores) {
                    buff.append(name).append("\n");
                }
                logger.log(Level.FINE, buff.toString());
            } else {
                logger.log(Level.FINE, "There are no available database connection stores.");
            }
        }
    }

    public static DatabaseProvider getReferenceable(String storeName, String connName) {
        DatabaseConnections chosen;
        if (storeName != null && (chosen = DatabaseConnectionStores.getInstance().getStore(storeName)) != null) {
            try {
                return (DatabaseProvider)chosen.getReferenceable(connName);
            }
            catch (ConnectionException ce) {
                DBLog.getLogger().log(Level.WARNING, "cannot get connection " + connName + " from store " + storeName, ce);
            }
        }
        return null;
    }

    private class CentralStoreProvider
    extends StoreProvider {
        private CentralStoreProvider() {
        }

        @Override
        public DatabaseConnections getStore(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return DatabaseConnections.getInstance();
            }
            return null;
        }

        @Override
        public String getShortLabel(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return DBConnArb.getString(50);
            }
            return null;
        }

        @Override
        public Icon getIcon(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return OracleIcons.getIcon((String)"dbconn.png");
            }
            return null;
        }

        @Override
        public String getToolTipText(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return DBConnArb.getString(51);
            }
            return null;
        }

        @Override
        public Collection<String> listStores() {
            return Arrays.asList(DatabaseConnectionStores.CENTRAL_STORE);
        }

        @Override
        protected String getCurrentStore(Context ideContext) {
            return DatabaseConnectionStores.CENTRAL_STORE;
        }
    }
}

