/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.logging.Level;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.DefaultEditor;

public final class DatabaseConnectionEditor {
    private static Class<? extends ConnectionEditor> s_editor;
    private static Class<? extends DatabaseConnectionEditorLauncher> s_launcher;

    private DatabaseConnectionEditor() {
    }

    private static ConnectionInfo launchEditor(String storeName, String connName, boolean allowAllStores) {
        ConnectionEditor ce = DatabaseConnectionEditor.getEditor();
        if (ce != null) {
            String newConnName = ce.launchEditor(storeName, connName);
            return newConnName == null ? null : new ConnectionInfo(storeName, newConnName);
        }
        DatabaseConnectionEditorLauncher launcher = DatabaseConnectionEditor.createLauncher();
        if (allowAllStores) {
            launcher.setStoreChoice(DatabaseConnectionEditorLauncher.StoreChoice.ALL);
        }
        DatabaseConnections conns = ModelUtil.hasLength((String)storeName) ? DatabaseConnectionStores.getInstance().getStore(storeName) : null;
        return launcher.launchEditor(conns, connName);
    }

    @Deprecated
    public static void setEditor(Class<? extends ConnectionEditor> ed) {
        if (Product.isJDeveloper()) {
            DBLog.log((String)("Ignoring attempt to set database connection editor to " + ed.getName()), (Object[])new Object[0]);
        } else {
            s_editor = ed;
        }
    }

    public static void setLauncher(Class<? extends DatabaseConnectionEditorLauncher> clz) {
        if (clz != null) {
            if (Product.isJDeveloper()) {
                DBLog.log((String)("Ignoring attempt to set database connection editor launcher to " + clz.getName()), (Object[])new Object[0]);
            } else {
                s_launcher = clz;
            }
        }
    }

    public static DatabaseConnectionEditorLauncher createLauncher() {
        if (s_launcher != null) {
            try {
                return s_launcher.newInstance();
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.SEVERE, "Cannot create db connection editor", e);
            }
        }
        return DefaultEditor.createDefaultEditor();
    }

    private static ConnectionEditor getEditor() {
        if (s_editor != null) {
            try {
                return s_editor.newInstance();
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.SEVERE, "cannot create db connection editor", e);
            }
        }
        return null;
    }

    @Deprecated
    public static String editConnection(String connName) {
        String store;
        String string = store = connName == null ? null : DBObjectNodeUtil.decode((String)connName, (boolean)true);
        if (store != null) {
            connName = DBObjectNodeUtil.decode((String)connName, (boolean)false);
        }
        return DatabaseConnectionEditor.editConnection(store, connName);
    }

    public static String editConnection(String storeName, String connName) {
        return DatabaseConnectionEditor.editConnection(storeName, connName, false);
    }

    public static String editConnection(String storeName, String connName, boolean allowAllStores) {
        ConnectionInfo info = DatabaseConnectionEditor.launchEditor(storeName, connName, allowAllStores);
        return info == null ? null : info.getConnectionName();
    }

    public static interface ConnectionEditor {
        public String launchEditor(String var1);

        public String launchEditor(String var1, String var2);
    }
}

