/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SharedCodeSourceURL;
import oracle.classloader.SharedDirectory;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.FileUtils;

public final class CachingSharedDirectory
extends SharedDirectory {
    private final File m_Directory;
    private static final boolean FILE_SCHEME_URLS = ClassLoadEnvironment.useFileSchemeForDirectoryURLs();
    private final ConcurrentHashMap<File, Boolean> m_ParentPathToExistsMap = new ConcurrentHashMap();

    public CachingSharedDirectory(File dir, URL location) {
        super(dir, location);
        this.m_Directory = dir;
    }

    @Override
    protected RecoverableByteBuffer doGetResourceBytes(int currentMaintenanceTick, String relativePath, RecoverableByteBuffer buffer) throws IOException {
        File file = new File(this.m_Directory, relativePath);
        if (this.cachedFileExists(file)) {
            FileInputStream stream = new FileInputStream(file);
            int size = ((InputStream)stream).available();
            if (buffer == null) {
                buffer = new RecoverableByteBuffer(size);
            }
            buffer.read(this, currentMaintenanceTick, stream, size);
            return buffer;
        }
        return null;
    }

    @Override
    protected boolean doContainsResource(String relativePath) {
        File file = new File(this.m_Directory, relativePath);
        return this.cachedFileExists(file);
    }

    @Override
    protected URL doGetResource(String relativePath) throws IOException {
        File file = new File(this.m_Directory, relativePath);
        if (this.cachedFileExists(file)) {
            if (FILE_SCHEME_URLS) {
                return FileUtils.toURL(file);
            }
            return SharedCodeSourceURL.create(this.getLocation(), relativePath);
        }
        return null;
    }

    @Override
    protected long doGetLastModifiedTime(String relativePath) throws IOException {
        File file = new File(this.m_Directory, relativePath);
        if (this.cachedFileExists(file)) {
            return file.lastModified();
        }
        return 0L;
    }

    @Override
    protected long doGetLength(String relativePath) {
        File file;
        if (relativePath != null && this.cachedFileExists(file = new File(this.m_Directory, relativePath))) {
            return file.length();
        }
        return -1L;
    }

    @Override
    protected File doGetFile(String relativePath) {
        if (relativePath == null) {
            return this.m_Directory;
        }
        File result = new File(this.m_Directory, relativePath);
        if (result.exists()) {
            return result;
        }
        return null;
    }

    private boolean cachedFileExists(File file) {
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            Boolean exists = this.m_ParentPathToExistsMap.get(parentFile);
            if (exists == null) {
                exists = parentFile.exists();
                this.m_ParentPathToExistsMap.put(parentFile, exists);
            }
            if (!exists.booleanValue()) {
                return false;
            }
        }
        return file.exists();
    }
}

