/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SharedJar;
import oracle.ide.boot.JarDirs;

final class SharedJarByPackage
extends SharedJar {
    private final int[] _hashes;

    SharedJarByPackage(File existingCanonicalFile, URL location) {
        super(existingCanonicalFile, location);
        JarDirs jarDirs = new JarDirs(existingCanonicalFile);
        this._hashes = jarDirs.getHashes();
    }

    @Override
    protected boolean doContainsResource(String relPath) throws IOException {
        if (this.isPotentiallySelected(relPath)) {
            return super.doContainsResource(relPath);
        }
        return false;
    }

    @Override
    protected File doGetFile(String relPath) {
        if (this.isPotentiallySelected(relPath)) {
            return super.doGetFile(relPath);
        }
        return null;
    }

    @Override
    protected URL doGetResource(String relPath) {
        if (this.isPotentiallySelected(relPath)) {
            try {
                return super.doGetResource(relPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    protected RecoverableByteBuffer doGetResourceBytes(int currentMaintenanceTick, String relPath, RecoverableByteBuffer buffer) throws IOException {
        if (this.isPotentiallySelected(relPath)) {
            return super.doGetResourceBytes(currentMaintenanceTick, relPath, buffer);
        }
        return null;
    }

    @Override
    protected InputStream doGetStream(String relPath) throws IOException {
        if (this.isPotentiallySelected(relPath)) {
            return super.doGetStream(relPath);
        }
        throw new FileNotFoundException(relPath);
    }

    private boolean isPotentiallySelected(String relPath) {
        if (this._hashes != null && relPath != null) {
            int hash;
            int lastSlash = relPath.lastIndexOf(47);
            int n = hash = lastSlash > 0 ? relPath.substring(0, lastSlash).hashCode() : relPath.hashCode();
            if (hash == JarDirs.META_INF_HASHCODE && lastSlash == 8) {
                hash = relPath.hashCode();
            }
            return Arrays.binarySearch(this._hashes, hash) >= 0;
        }
        return true;
    }
}

