/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class Launcher {
    public static void main(String[] args) {
        Launcher launcher = new Launcher();
        launcher.launch(args);
    }

    public final void launch(String[] args) {
        try {
            this.launchImpl(args);
        }
        catch (Throwable t) {
            System.err.println("Boot startup failed.");
            t.printStackTrace(System.err);
        }
    }

    public static final String getOracleHome() {
        Launcher launcher = new Launcher();
        try {
            return launcher.initOracleHomeImpl();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void launchImpl(String[] args) throws Exception {
        this.checkLaunchPrerequisites();
        this.initBootstrapStartTime();
        this.initOracleHome();
        this.loadProductProperties();
        this.throttleLocale();
        this.initUserDir(args);
        this.invokeMain(args);
    }

    private void throttleLocale() {
        if (!Boolean.valueOf(System.getProperty("ide.throttleLocale", "false")).booleanValue()) {
            return;
        }
        String supportedLanguages = System.getProperty("ide.supportedLocales", "en,ja");
        String language = System.getProperty("user.language");
        String country = System.getProperty("user.country");
        if (Arrays.asList(supportedLanguages.split(",")).contains(language)) {
            return;
        }
        Logger.getLogger(this.getClass().getName()).info("Locale " + language + "_" + country + " is not supported by this product. Forcing locale to en_US.");
        System.setProperty("ide.old.user.country", country);
        System.setProperty("ide.old.user.language", language);
        System.setProperty("user.country", "US");
        System.setProperty("user.language", "en");
        Locale.setDefault(new Locale("en", "US"));
    }

    protected void initBootstrapStartTime() {
        long start = System.nanoTime();
        System.setProperty("ide.bootstrap.start", Long.toString(start));
    }

    private void setPrefAndWorkDirs(String prefDir, String workDir) {
        System.setProperty("ide.pref.dir", prefDir);
        System.setProperty("ide.work.dir", workDir);
        System.setProperty("ide.user.dir", prefDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getVersionProperties() {
        File confFile = new File(this.getConfFilePath());
        File vp = new File(confFile.getParentFile(), "version.properties");
        Properties p = new Properties();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(vp));
            p.load(is);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return p;
    }

    private String getVendorName() {
        return this.getVersionProperties().getProperty("COMPANY", "Oracle");
    }

    private String getApplicationName() {
        String confName = new File(this.getConfFilePath()).getName();
        if (confName.length() > 5) {
            confName = confName.substring(0, confName.length() - 5);
        }
        return this.getVersionProperties().getProperty("PRODUCT", confName);
    }

    protected void initUserDir(String[] args) {
        boolean singleUser = false;
        for (String arg : args) {
            if (!"-su".equalsIgnoreCase(arg) && !"-singleuser".equalsIgnoreCase(arg)) continue;
            singleUser = true;
            break;
        }
        if (singleUser) {
            String oracleHome = System.getProperty("oracle.home");
            this.setPrefAndWorkDirs(oracleHome, oracleHome);
            return;
        }
        String ideUserDir = System.getProperty("ide.user.dir");
        if (ideUserDir != null && ideUserDir.length() > 0) {
            this.setPrefAndWorkDirs(ideUserDir, ideUserDir);
            return;
        }
        String ideUserDirVar = System.getProperty("ide.user.dir.var");
        if (ideUserDirVar != null && ideUserDirVar.length() > 0) {
            StringTokenizer st = new StringTokenizer(ideUserDirVar, ",");
            while (st.hasMoreTokens()) {
                String varName = st.nextToken();
                String ideUserDir2 = System.getenv(varName);
                if (ideUserDir2 == null || ideUserDir2.length() <= 0) continue;
                this.setPrefAndWorkDirs(ideUserDir2, ideUserDir2);
                return;
            }
        }
        String app = this.getApplicationName();
        String prefDirBase = System.getProperty("ide.pref.dir.base");
        String workDirBase = System.getProperty("ide.work.dir.base");
        if (prefDirBase != null && prefDirBase.length() > 0 && workDirBase != null && workDirBase.length() > 0) {
            if ("oracle.jdeveloper".equals(System.getProperty("ide.product")) && !Boolean.getBoolean("ide.mydocs") && !"6.0".equals(System.getProperty("os.version"))) {
                File baseDir = new File(workDirBase);
                File parent = baseDir.getParentFile();
                while (parent != null) {
                    baseDir = parent;
                    parent = baseDir.getParentFile();
                }
                workDirBase = baseDir.getAbsolutePath();
            }
            this.setPrefAndWorkDirs(prefDirBase + File.separator + app, workDirBase + File.separator + app);
            return;
        }
        String userHome = System.getProperty("user.home");
        StringBuilder dirname = new StringBuilder();
        for (int i = 0; i < app.length(); ++i) {
            char c = app.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (Character.isUpperCase(c)) {
                dirname.append(Character.toLowerCase(c));
                continue;
            }
            dirname.append(c);
        }
        this.setPrefAndWorkDirs(userHome + File.separator + "." + dirname, userHome + File.separator + dirname);
    }

    protected String initOracleHome() {
        String oracleHome = this.initOracleHomeImpl();
        if (oracleHome == null) {
            System.out.println("**** WARNING: could not determine oracle.home automatically.  This means the IDE bootstrap could not recognize the build configuration.  Launcher.class location is " + this.getBootCodeSource());
        }
        return oracleHome;
    }

    protected String initOracleHomeImpl() {
        URL url;
        String oracleHome = System.getProperty("oracle.home");
        if (oracleHome == null && (url = this.getBootCodeSource()) != null) {
            String protocol;
            URI uri = null;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            String string = protocol = uri != null ? uri.getScheme() : url.getProtocol();
            if ("file".equals(protocol)) {
                String path = uri != null ? uri.getPath() : url.getPath();
                String suffixToRemove = "/ide/lib/ide-boot.jar";
                if (!(path.endsWith(suffixToRemove) || path.endsWith(suffixToRemove = "/built/ide-boot/classes/") || path.endsWith(suffixToRemove = "/jdev/lib/jdev-loader.jar"))) {
                    suffixToRemove = null;
                }
                if (suffixToRemove != null) {
                    int oracleHomeEnd = path.length() - suffixToRemove.length();
                    String oracleHomeStr = path.substring(0, oracleHomeEnd);
                    if (uri == null && oracleHomeStr.indexOf(37) >= 0) {
                        System.out.println("**** WARNING: Possible under-decoded pathname for Oracle Home: " + oracleHomeStr);
                    }
                    File oracleHomeDir = new File(oracleHomeStr + File.separatorChar);
                    oracleHome = oracleHomeDir.getAbsolutePath();
                }
            }
            if (oracleHome != null) {
                System.setProperty("oracle.home", oracleHome);
            }
        }
        return oracleHome;
    }

    protected URL getBootCodeSource() {
        return Launcher.class.getProtectionDomain().getCodeSource().getLocation();
    }

    protected void loadProductProperties() {
        String confFilePath = this.getConfFilePath();
        if (confFilePath != null) {
            this.loadBootProperties(this.getBootFileName(confFilePath, ""));
        }
        Properties versionProperties = this.getVersionProperties();
        System.setProperty("ide.debugbuild", String.valueOf("1".equals(versionProperties.getProperty("DEBUG_BUILD"))));
        if (!Boolean.getBoolean("ide.AssertTracingDisabled") && Boolean.getBoolean("ide.debugbuild")) {
            System.out.println("Oracle IDE is in DEBUG mode. Class loading optimizations are switched off.");
        }
        if (confFilePath != null && Boolean.getBoolean("ide.debugbuild")) {
            this.loadBootProperties(this.getBootFileName(confFilePath, "-debug"));
        }
    }

    protected String getConfFilePath() {
        Properties systemProperties = System.getProperties();
        String confFilePath = systemProperties.getProperty("ide.conf");
        if (confFilePath == null) {
            confFilePath = systemProperties.getProperty("ide.config_pathname");
            if (confFilePath == null) {
                return null;
            }
            systemProperties.setProperty("ide.conf", confFilePath);
        } else {
            systemProperties.setProperty("ide.config_pathname", confFilePath);
        }
        confFilePath = confFilePath.replaceFirst("^[\\\"\\']+", "");
        confFilePath = confFilePath.replaceFirst("[\\\"\\']+$", "");
        System.setProperty("ide.conf", confFilePath);
        return confFilePath;
    }

    protected String getBootFileName(String confFilePath, String suffix) {
        return confFilePath.replaceFirst("(.conf)?$", suffix + ".boot");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBootProperties(String bootFilePath) {
        Properties props;
        File bootFile = new File(bootFilePath);
        if (!bootFile.isFile()) {
            return;
        }
        HashSet<File> seen = new HashSet<File>();
        LinkedList<File> queue = new LinkedList<File>();
        LinkedList<Properties> result = new LinkedList<Properties>();
        queue.add(bootFile);
        while (!queue.isEmpty()) {
            File propsFile = (File)queue.removeFirst();
            if (seen.contains(propsFile)) continue;
            seen.add(propsFile);
            props = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(propsFile);
                props.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            result.add(props);
            String includes = props.getProperty("include");
            if (includes == null) continue;
            props.remove("include");
            StringTokenizer st = new StringTokenizer(includes, ",");
            File relativeTo = propsFile.getParentFile();
            while (st.hasMoreTokens()) {
                File nextFile = new File(relativeTo, st.nextToken());
                if (!nextFile.isFile()) continue;
                queue.add(nextFile);
            }
        }
        Properties allProps = new Properties();
        while (!result.isEmpty()) {
            props = (Properties)result.removeLast();
            allProps.putAll((Map<?, ?>)props);
        }
        Properties systemProperties = System.getProperties();
        allProps.putAll((Map<?, ?>)systemProperties);
        systemProperties.putAll((Map<?, ?>)allProps);
    }

    protected void invokeMain(String[] args) throws Exception {
        String mainClassName = System.getProperty("ide.main.class");
        if (mainClassName != null) {
            Class<?> mainClass = Class.forName(mainClassName);
            Method main = mainClass.getMethod("main", String[].class);
            main.setAccessible(true);
            main.invoke(null, new Object[]{args});
        } else {
            System.out.println("**** Warning: No ide.main.class specified");
        }
    }

    private void checkLaunchPrerequisites() {
        try {
            Class.forName("java.lang.Enum");
        }
        catch (ClassNotFoundException cnfe) {
            String javaVersion = System.getProperty("java.runtime.version");
            String javaHome = System.getProperty("java.home");
            System.err.println("Error: This product requires a Java(TM) Platform 5.0 runtime.");
            System.err.print("You are using ");
            System.err.print(javaVersion);
            System.err.print(" from ");
            System.err.println(javaHome);
            System.exit(1);
        }
    }
}

