/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;

final class JarDirs {
    private static final int BUFFER_SIZE = 1024;
    private static final CharsetDecoder _decoder;
    static final int META_INF_HASHCODE;
    private int _numEntries;
    private int _centralDirSize;
    private long _centralDirOffset;
    private int[] _dirHashes;
    private int _numHashes;

    JarDirs(File jarFile) {
        this.getDirsImpl(jarFile);
    }

    int[] getHashes() {
        return this._dirHashes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDirsImpl(File jarFile) {
        RandomAccessFile jar = null;
        try {
            int numLoops;
            jar = new RandomAccessFile(jarFile, "r");
            if (this._centralDirSize == 0 && !this.findCDIR(jar, jarFile)) {
                return;
            }
            byte[] cdir = new byte[this._centralDirSize];
            jar.seek(this._centralDirOffset);
            jar.readFully(cdir);
            char[] chars = new char[1024];
            this._dirHashes = new int[this._numEntries];
            this._numHashes = 0;
            if (_decoder == null) {
                int j = 0;
                for (numLoops = 0; j < this._centralDirSize && numLoops < this._numEntries; ++numLoops) {
                    int filenameLen = JarDirs.get2LE(cdir, j + 28);
                    int extraFieldLen = JarDirs.get2LE(cdir, j + 30);
                    int commentLen = JarDirs.get2LE(cdir, j + 32);
                    int entryNameOffset = j + 46;
                    for (int i = filenameLen - 1; i >= 0; --i) {
                        chars[i] = (char)(cdir[entryNameOffset + i] & 0xFF);
                    }
                    this.recordDir(chars, filenameLen);
                    j = entryNameOffset + filenameLen + extraFieldLen + commentLen;
                }
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                CharBuffer charBuffer = CharBuffer.wrap(chars);
                int j = 0;
                while (j < this._centralDirSize && numLoops < this._numEntries) {
                    int filenameLen = JarDirs.get2LE(cdir, j + 28);
                    int extraFieldLen = JarDirs.get2LE(cdir, j + 30);
                    int commentLen = JarDirs.get2LE(cdir, j + 32);
                    int entryNameOffset = j + 46;
                    byteBuffer.put(cdir, entryNameOffset, filenameLen);
                    byteBuffer.flip();
                    _decoder.decode(byteBuffer, charBuffer, true);
                    byteBuffer.clear();
                    charBuffer.flip();
                    this.recordDir(chars, filenameLen);
                    charBuffer.clear();
                    j = entryNameOffset + filenameLen + extraFieldLen + commentLen;
                    ++numLoops;
                }
            }
            this._dirHashes = JarDirs.sortAndTrim(this._numHashes, this._dirHashes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static int[] sortAndTrim(int numHashes, int[] dirHashes) {
        int numUniqueHashes = 0;
        if (numHashes > 0) {
            Arrays.sort(dirHashes, 0, numHashes);
            int lastHash = dirHashes[0];
            ++numUniqueHashes;
            for (int i = 1; i < numHashes; ++i) {
                int curHash = dirHashes[i];
                if (curHash == lastHash) continue;
                dirHashes[numUniqueHashes++] = curHash;
                lastHash = curHash;
            }
        }
        int[] trimmedHashes = new int[numUniqueHashes];
        System.arraycopy(dirHashes, 0, trimmedHashes, 0, numUniqueHashes);
        return trimmedHashes;
    }

    private static final int get2LE(byte[] b, int i) {
        return (b[i] & 0xFF) + ((b[i + 1] & 0xFF) << 8);
    }

    private static final int get4LE(byte[] b, int i) {
        return (b[i] & 0xFF) + ((b[i + 1] & 0xFF) << 8) + ((b[i + 2] & 0xFF) << 16) + (b[i + 3] << 24);
    }

    private boolean findCDIR(RandomAccessFile jar, File jarFile) throws IOException {
        long length = jar.length();
        long seek = length - 22L;
        byte[] bytes = new byte[22];
        boolean centralDirectoryFound = false;
        for (int remainingZipCommentLength = 65535; seek >= 0L && remainingZipCommentLength > 0; --seek, --remainingZipCommentLength) {
            jar.seek(seek);
            jar.readFully(bytes);
            if (bytes[0] != 80 || bytes[1] != 75 || bytes[2] != 5 || bytes[3] != 6) continue;
            this._numEntries = JarDirs.get2LE(bytes, 10);
            this._centralDirSize = JarDirs.get4LE(bytes, 12);
            this._centralDirOffset = JarDirs.get4LE(bytes, 16);
            int actualCommentLength = 65535 - remainingZipCommentLength;
            if (actualCommentLength > 0) {
                int commentLength = JarDirs.get2LE(bytes, 20);
                if (commentLength != actualCommentLength) break;
                centralDirectoryFound = true;
                break;
            }
            centralDirectoryFound = true;
            break;
        }
        if (!centralDirectoryFound) {
            System.err.println("****  WARNING -- Unable to find central directory for " + jarFile.getAbsolutePath());
        } else if (this._centralDirSize <= 0 || (long)this._centralDirSize >= length) {
            System.err.println("****  WARNING -- Bad central directory size (" + this._centralDirSize + ") for " + jarFile.getAbsolutePath());
        }
        return centralDirectoryFound;
    }

    private void recordDir(char[] chars, int len) {
        int i;
        int lastSlash = len;
        for (int i2 = len - 1; i2 >= 0; --i2) {
            if (chars[i2] != '/') continue;
            lastSlash = i2;
            break;
        }
        int hash = 0;
        for (i = 0; i < lastSlash; ++i) {
            hash = 31 * hash + chars[i];
        }
        if (hash == META_INF_HASHCODE && lastSlash == 8) {
            for (i = 8; i < len; ++i) {
                hash = 31 * hash + chars[i];
            }
        }
        this._dirHashes[this._numHashes++] = hash;
    }

    static {
        META_INF_HASHCODE = "META-INF".hashCode();
        CharsetDecoder decoder = null;
        try {
            Charset charset;
            InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(new byte[0]));
            String defaultEncoding = isr.getEncoding();
            if (!"Cp1252".equals(defaultEncoding) && (charset = Charset.forName(defaultEncoding)) != null) {
                decoder = charset.newDecoder();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        _decoder = decoder;
    }
}

